/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.jfr;

import jdk.jfr.consumer.RecordedEvent;
import jdk.test.lib.jfr.Events;

public abstract class EventVerifier {
    protected final RecordedEvent event;

    public EventVerifier(RecordedEvent event) {
        this.event = event;
    }

    public <T extends Comparable<T>> void verifyEquals(String name, T value) {
        Events.assertField(this.event, name).equal(value);
    }

    public void verifyContains(String name, String value) {
        Events.assertField(this.event, name).containsAny(value);
    }

    protected long gigabytes(int num) {
        return (long)num * 1024L * 1024L * 1024L;
    }

    protected long megabytes(int num) {
        return (long)num * 1024L * 1024L;
    }

    public abstract void verify() throws Exception;
}

