/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.parser;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import jdk.test.lib.hprof.model.ArrayTypeCodes;
import jdk.test.lib.hprof.model.JavaBoolean;
import jdk.test.lib.hprof.model.JavaByte;
import jdk.test.lib.hprof.model.JavaChar;
import jdk.test.lib.hprof.model.JavaClass;
import jdk.test.lib.hprof.model.JavaDouble;
import jdk.test.lib.hprof.model.JavaField;
import jdk.test.lib.hprof.model.JavaFloat;
import jdk.test.lib.hprof.model.JavaInt;
import jdk.test.lib.hprof.model.JavaLong;
import jdk.test.lib.hprof.model.JavaObject;
import jdk.test.lib.hprof.model.JavaObjectArray;
import jdk.test.lib.hprof.model.JavaObjectRef;
import jdk.test.lib.hprof.model.JavaShort;
import jdk.test.lib.hprof.model.JavaStatic;
import jdk.test.lib.hprof.model.JavaThing;
import jdk.test.lib.hprof.model.JavaValueArray;
import jdk.test.lib.hprof.model.Root;
import jdk.test.lib.hprof.model.Snapshot;
import jdk.test.lib.hprof.model.StackFrame;
import jdk.test.lib.hprof.model.StackTrace;
import jdk.test.lib.hprof.model.ThreadObject;
import jdk.test.lib.hprof.parser.MappedReadBuffer;
import jdk.test.lib.hprof.parser.PositionDataInputStream;
import jdk.test.lib.hprof.parser.ReadBuffer;
import jdk.test.lib.hprof.parser.Reader;
import jdk.test.lib.hprof.util.Misc;

public class HprofReader
extends Reader
implements ArrayTypeCodes {
    static final int MAGIC_NUMBER = 1245795905;
    private static final String[] VERSIONS = new String[]{" PROFILE 1.0\u0000", " PROFILE 1.0.1\u0000", " PROFILE 1.0.2\u0000"};
    private static final int VERSION_JDK12BETA3 = 0;
    private static final int VERSION_JDK12BETA4 = 1;
    private static final int VERSION_JDK6 = 2;
    static final int HPROF_UTF8 = 1;
    static final int HPROF_LOAD_CLASS = 2;
    static final int HPROF_UNLOAD_CLASS = 3;
    static final int HPROF_FRAME = 4;
    static final int HPROF_TRACE = 5;
    static final int HPROF_ALLOC_SITES = 6;
    static final int HPROF_HEAP_SUMMARY = 7;
    static final int HPROF_START_THREAD = 10;
    static final int HPROF_END_THREAD = 11;
    static final int HPROF_HEAP_DUMP = 12;
    static final int HPROF_CPU_SAMPLES = 13;
    static final int HPROF_CONTROL_SETTINGS = 14;
    static final int HPROF_LOCKSTATS_WAIT_TIME = 16;
    static final int HPROF_LOCKSTATS_HOLD_TIME = 17;
    static final int HPROF_GC_ROOT_UNKNOWN = 255;
    static final int HPROF_GC_ROOT_JNI_GLOBAL = 1;
    static final int HPROF_GC_ROOT_JNI_LOCAL = 2;
    static final int HPROF_GC_ROOT_JAVA_FRAME = 3;
    static final int HPROF_GC_ROOT_NATIVE_STACK = 4;
    static final int HPROF_GC_ROOT_STICKY_CLASS = 5;
    static final int HPROF_GC_ROOT_THREAD_BLOCK = 6;
    static final int HPROF_GC_ROOT_MONITOR_USED = 7;
    static final int HPROF_GC_ROOT_THREAD_OBJ = 8;
    static final int HPROF_GC_CLASS_DUMP = 32;
    static final int HPROF_GC_INSTANCE_DUMP = 33;
    static final int HPROF_GC_OBJ_ARRAY_DUMP = 34;
    static final int HPROF_GC_PRIM_ARRAY_DUMP = 35;
    static final int HPROF_HEAP_DUMP_SEGMENT = 28;
    static final int HPROF_HEAP_DUMP_END = 44;
    private static final int T_CLASS = 2;
    private int version;
    private int debugLevel;
    private long currPos;
    private int dumpsToSkip;
    private boolean callStack;
    private int identifierSize;
    private Hashtable<Long, String> names;
    private Hashtable<Integer, ThreadObject> threadObjects;
    private Hashtable<Long, String> classNameFromObjectID;
    private Hashtable<Integer, String> classNameFromSerialNo;
    private Hashtable<Long, StackFrame> stackFrames;
    private Hashtable<Integer, StackTrace> stackTraces;
    private Snapshot snapshot;

    public static boolean verifyMagicNumber(int numberRead) {
        return numberRead == 1245795905;
    }

    public HprofReader(ReadBuffer readBuffer, PositionDataInputStream in, int dumpNumber, boolean callStack, int debugLevel) throws IOException {
        super(in);
        this.snapshot = new Snapshot(readBuffer);
        this.dumpsToSkip = dumpNumber - 1;
        this.callStack = callStack;
        this.debugLevel = debugLevel;
        this.names = new Hashtable();
        this.threadObjects = new Hashtable(43);
        this.classNameFromObjectID = new Hashtable();
        if (callStack) {
            this.stackFrames = new Hashtable(43);
            this.stackTraces = new Hashtable(43);
            this.classNameFromSerialNo = new Hashtable();
        }
    }

    public HprofReader(String fileName, PositionDataInputStream in, int dumpNumber, boolean callStack, int debugLevel) throws IOException {
        this(MappedReadBuffer.create(new RandomAccessFile(fileName, "r")), in, dumpNumber, callStack, debugLevel);
    }

    @Override
    public Snapshot read() throws IOException {
        this.currPos = 4L;
        this.version = this.readVersionHeader();
        this.identifierSize = this.in.readInt();
        this.snapshot.setIdentifierSize(this.identifierSize);
        if (this.version >= 1) {
            this.snapshot.setNewStyleArrayClass(true);
        } else {
            this.snapshot.setNewStyleArrayClass(false);
        }
        this.currPos += 4L;
        if (this.identifierSize != 4 && this.identifierSize != 8) {
            throw new IOException("I'm sorry, but I can't deal with an identifier size of " + this.identifierSize + ".  I can only deal with 4 or 8.");
        }
        System.out.println("Dump file created " + String.valueOf(new Date(this.in.readLong())));
        this.currPos += 8L;
        block16: while (true) {
            int type;
            try {
                type = this.in.readUnsignedByte();
            }
            catch (EOFException ignored) {
                break;
            }
            this.in.readInt();
            long length = (long)this.in.readInt() & 0xFFFFFFFFL;
            if (this.debugLevel > 0) {
                System.out.println("Read record type " + type + ", length " + length + " at position " + this.toHex(this.currPos));
            }
            if (length < 0L) {
                throw new IOException("Bad record length of " + length + " at byte " + this.toHex(this.currPos + 5L) + " of file.");
            }
            this.currPos += 9L + length;
            switch (type) {
                case 1: {
                    long id = this.readID();
                    byte[] chars = new byte[(int)length - this.identifierSize];
                    this.in.readFully(chars);
                    this.names.put(id, new String(chars));
                    continue block16;
                }
                case 2: {
                    int serialNo = this.in.readInt();
                    long classID = this.readID();
                    int stackTraceSerialNo = this.in.readInt();
                    long classNameID = this.readID();
                    Long classIdI = classID;
                    String nm = this.getNameFromID(classNameID).replace('/', '.');
                    this.classNameFromObjectID.put(classIdI, nm);
                    if (this.classNameFromSerialNo == null) continue block16;
                    this.classNameFromSerialNo.put(serialNo, nm);
                    continue block16;
                }
                case 12: {
                    if (this.dumpsToSkip <= 0) {
                        try {
                            this.readHeapDump(length, this.currPos);
                        }
                        catch (EOFException exp) {
                            this.handleEOF(exp, this.snapshot);
                        }
                        if (this.debugLevel > 0) {
                            System.out.println("    Finished processing instances in heap dump.");
                        }
                        return this.snapshot;
                    }
                    --this.dumpsToSkip;
                    this.skipBytes(length);
                    continue block16;
                }
                case 44: {
                    if (this.version >= 2) {
                        if (this.dumpsToSkip <= 0) {
                            this.skipBytes(length);
                            return this.snapshot;
                        }
                        --this.dumpsToSkip;
                    } else {
                        this.warn("Ignoring unrecognized record type " + type);
                    }
                    this.skipBytes(length);
                    continue block16;
                }
                case 28: {
                    if (this.version >= 2) {
                        if (this.dumpsToSkip <= 0) {
                            try {
                                this.readHeapDump(length, this.currPos);
                            }
                            catch (EOFException exp) {
                                this.handleEOF(exp, this.snapshot);
                            }
                            continue block16;
                        }
                        this.skipBytes(length);
                        continue block16;
                    }
                    this.warn("Ignoring unrecognized record type " + type);
                    this.skipBytes(length);
                    continue block16;
                }
                case 4: {
                    if (this.stackFrames == null) {
                        this.skipBytes(length);
                        continue block16;
                    }
                    long id = this.readID();
                    String methodName = this.getNameFromID(this.readID());
                    String methodSig = this.getNameFromID(this.readID());
                    String sourceFile = this.getNameFromID(this.readID());
                    int classSer = this.in.readInt();
                    String className = this.classNameFromSerialNo.get(classSer);
                    int lineNumber = this.in.readInt();
                    if (lineNumber < -3) {
                        this.warn("Weird stack frame line number:  " + lineNumber);
                        lineNumber = -1;
                    }
                    this.stackFrames.put(id, new StackFrame(methodName, methodSig, className, sourceFile, lineNumber));
                    continue block16;
                }
                case 5: {
                    if (this.stackTraces == null) {
                        this.skipBytes(length);
                        continue block16;
                    }
                    int serialNo = this.in.readInt();
                    int threadSeq = this.in.readInt();
                    StackFrame[] frames = new StackFrame[this.in.readInt()];
                    for (int i = 0; i < frames.length; ++i) {
                        long fid = this.readID();
                        frames[i] = this.stackFrames.get(fid);
                        if (frames[i] != null) continue;
                        throw new IOException("Stack frame " + this.toHex(fid) + " not found");
                    }
                    this.stackTraces.put(serialNo, new StackTrace(frames));
                    continue block16;
                }
                case 3: 
                case 6: 
                case 7: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 16: 
                case 17: {
                    this.skipBytes(length);
                    continue block16;
                }
            }
            this.skipBytes(length);
            this.warn("Ignoring unrecognized record type " + type);
        }
        return this.snapshot;
    }

    public String printStackTraces() {
        StringBuffer output = new StringBuffer();
        for (Map.Entry<Integer, StackTrace> entry : this.stackTraces.entrySet()) {
            StackFrame[] frames = entry.getValue().getFrames();
            output.append("SerialNo " + String.valueOf(entry.getKey()) + "\n");
            for (int i = 0; i < frames.length; ++i) {
                output.append("  " + frames[i].getClassName() + "." + frames[i].getMethodName() + frames[i].getMethodSignature() + " (" + frames[i].getSourceFileName() + ":" + frames[i].getLineNumber() + ")\n");
            }
        }
        System.out.println(output);
        return output.toString();
    }

    private void skipBytes(long length) throws IOException {
        while (length > 0L) {
            long skipped = this.in.skip(length);
            if (skipped == 0L) {
                throw new EOFException("Couldn't skip enough bytes");
            }
            length -= skipped;
        }
    }

    private int readVersionHeader() throws IOException {
        int candidatesLeft = VERSIONS.length;
        boolean[] matched = new boolean[VERSIONS.length];
        for (int i = 0; i < candidatesLeft; ++i) {
            matched[i] = true;
        }
        int pos = 0;
        while (candidatesLeft > 0) {
            char c = (char)this.in.readByte();
            ++this.currPos;
            for (int i = 0; i < VERSIONS.length; ++i) {
                if (!matched[i]) continue;
                if (c != VERSIONS[i].charAt(pos)) {
                    matched[i] = false;
                    --candidatesLeft;
                    continue;
                }
                if (pos != VERSIONS[i].length() - 1) continue;
                return i;
            }
            ++pos;
        }
        throw new IOException("Version string not recognized at byte " + (pos + 3));
    }

    private void readHeapDump(long bytesLeft, long posAtEnd) throws IOException {
        block15: while (bytesLeft > 0L) {
            int type = this.in.readUnsignedByte();
            if (this.debugLevel > 0) {
                System.out.println("    Read heap sub-record type " + type + " at position " + this.toHex(posAtEnd - bytesLeft));
            }
            --bytesLeft;
            switch (type) {
                case 255: {
                    long id = this.readID();
                    bytesLeft -= (long)this.identifierSize;
                    this.snapshot.addRoot(new Root(id, 0L, 1, ""));
                    continue block15;
                }
                case 8: {
                    long id = this.readID();
                    int threadSeq = this.in.readInt();
                    int stackSeq = this.in.readInt();
                    bytesLeft -= (long)(this.identifierSize + 8);
                    StackTrace st = this.getStackTraceFromSerial(stackSeq);
                    ThreadObject threadObj = new ThreadObject(id, st);
                    this.threadObjects.put(threadSeq, threadObj);
                    this.snapshot.addThreadObject(threadObj);
                    continue block15;
                }
                case 1: {
                    long id = this.readID();
                    long globalRefId = this.readID();
                    bytesLeft -= (long)(2 * this.identifierSize);
                    this.snapshot.addRoot(new Root(id, 0L, 4, ""));
                    continue block15;
                }
                case 2: {
                    long id = this.readID();
                    int threadSeq = this.in.readInt();
                    int depth = this.in.readInt();
                    bytesLeft -= (long)(this.identifierSize + 8);
                    ThreadObject to = this.getThreadObjectFromSequence(threadSeq);
                    StackTrace st = to.getStackTrace();
                    if (st != null) {
                        st = st.traceForDepth(depth + 1);
                    }
                    this.snapshot.addRoot(new Root(id, to.getId(), 3, "", st));
                    continue block15;
                }
                case 3: {
                    long id = this.readID();
                    int threadSeq = this.in.readInt();
                    int depth = this.in.readInt();
                    bytesLeft -= (long)(this.identifierSize + 8);
                    ThreadObject to = this.getThreadObjectFromSequence(threadSeq);
                    StackTrace st = to.getStackTrace();
                    if (st != null) {
                        st = st.traceForDepth(depth + 1);
                    }
                    this.snapshot.addRoot(new Root(id, to.getId(), 7, "", st));
                    continue block15;
                }
                case 4: {
                    long id = this.readID();
                    int threadSeq = this.in.readInt();
                    bytesLeft -= (long)(this.identifierSize + 4);
                    ThreadObject to = this.getThreadObjectFromSequence(threadSeq);
                    StackTrace st = to.getStackTrace();
                    this.snapshot.addRoot(new Root(id, to.getId(), 8, "", st));
                    continue block15;
                }
                case 5: {
                    long id = this.readID();
                    bytesLeft -= (long)this.identifierSize;
                    this.snapshot.addRoot(new Root(id, 0L, 2, ""));
                    continue block15;
                }
                case 6: {
                    long id = this.readID();
                    int threadSeq = this.in.readInt();
                    bytesLeft -= (long)(this.identifierSize + 4);
                    ThreadObject to = this.getThreadObjectFromSequence(threadSeq);
                    StackTrace st = to.getStackTrace();
                    this.snapshot.addRoot(new Root(id, to.getId(), 5, "", st));
                    continue block15;
                }
                case 7: {
                    long id = this.readID();
                    bytesLeft -= (long)this.identifierSize;
                    this.snapshot.addRoot(new Root(id, 0L, 6, ""));
                    continue block15;
                }
                case 32: {
                    int bytesRead = this.readClass();
                    bytesLeft -= (long)bytesRead;
                    continue block15;
                }
                case 33: {
                    int bytesRead = this.readInstance();
                    bytesLeft -= (long)bytesRead;
                    continue block15;
                }
                case 34: {
                    long bytesRead = this.readArray(false);
                    bytesLeft -= bytesRead;
                    continue block15;
                }
                case 35: {
                    long bytesRead = this.readArray(true);
                    bytesLeft -= bytesRead;
                    continue block15;
                }
            }
            throw new IOException("Unrecognized heap dump sub-record type:  " + type);
        }
        if (bytesLeft != 0L) {
            this.warn("Error reading heap dump or heap dump segment:  Byte count is " + bytesLeft + " instead of 0");
            this.skipBytes(bytesLeft);
        }
        if (this.debugLevel > 0) {
            System.out.println("    Finished heap sub-records.");
        }
    }

    private long readID() throws IOException {
        return this.identifierSize == 4 ? 0xFFFFFFFFL & (long)this.in.readInt() : this.in.readLong();
    }

    private int readValue(JavaThing[] resultArr) throws IOException {
        byte type = this.in.readByte();
        return 1 + this.readValueForType(type, resultArr);
    }

    private int readValueForType(byte type, JavaThing[] resultArr) throws IOException {
        if (this.version >= 1) {
            type = this.signatureFromTypeId(type);
        }
        return this.readValueForTypeSignature(type, resultArr);
    }

    private int readValueForTypeSignature(byte type, JavaThing[] resultArr) throws IOException {
        switch (type) {
            case 76: 
            case 91: {
                long id = this.readID();
                if (resultArr != null) {
                    resultArr[0] = new JavaObjectRef(id);
                }
                return this.identifierSize;
            }
            case 90: {
                byte b = this.in.readByte();
                if (b != 0 && b != 1) {
                    this.warn("Illegal boolean value read");
                }
                if (resultArr != null) {
                    resultArr[0] = new JavaBoolean(b != 0);
                }
                return 1;
            }
            case 66: {
                byte b = this.in.readByte();
                if (resultArr != null) {
                    resultArr[0] = new JavaByte(b);
                }
                return 1;
            }
            case 83: {
                short s = this.in.readShort();
                if (resultArr != null) {
                    resultArr[0] = new JavaShort(s);
                }
                return 2;
            }
            case 67: {
                char ch = this.in.readChar();
                if (resultArr != null) {
                    resultArr[0] = new JavaChar(ch);
                }
                return 2;
            }
            case 73: {
                int val = this.in.readInt();
                if (resultArr != null) {
                    resultArr[0] = new JavaInt(val);
                }
                return 4;
            }
            case 74: {
                long val = this.in.readLong();
                if (resultArr != null) {
                    resultArr[0] = new JavaLong(val);
                }
                return 8;
            }
            case 70: {
                float val = this.in.readFloat();
                if (resultArr != null) {
                    resultArr[0] = new JavaFloat(val);
                }
                return 4;
            }
            case 68: {
                double val = this.in.readDouble();
                if (resultArr != null) {
                    resultArr[0] = new JavaDouble(val);
                }
                return 8;
            }
        }
        throw new IOException("Bad value signature:  " + type);
    }

    private ThreadObject getThreadObjectFromSequence(int threadSeq) throws IOException {
        ThreadObject to = this.threadObjects.get(threadSeq);
        if (to == null) {
            throw new IOException("Thread " + threadSeq + " not found for JNI local ref");
        }
        return to;
    }

    private String getNameFromID(long id) throws IOException {
        return this.getNameFromID((Long)id);
    }

    private String getNameFromID(Long id) throws IOException {
        if (id == 0L) {
            return "";
        }
        String result = this.names.get(id);
        if (result == null) {
            this.warn("Name not found at " + this.toHex(id));
            return "unresolved name " + this.toHex(id);
        }
        return result;
    }

    private StackTrace getStackTraceFromSerial(int ser) throws IOException {
        if (this.stackTraces == null) {
            return null;
        }
        StackTrace result = this.stackTraces.get(ser);
        if (result == null) {
            this.warn("Stack trace not found for serial # " + ser);
        }
        return result;
    }

    private int readClass() throws IOException {
        long id = this.readID();
        StackTrace stackTrace = this.getStackTraceFromSerial(this.in.readInt());
        long superId = this.readID();
        long classLoaderId = this.readID();
        long signersId = this.readID();
        long protDomainId = this.readID();
        long reserved1 = this.readID();
        long reserved2 = this.readID();
        int instanceSize = this.in.readInt();
        int bytesRead = 7 * this.identifierSize + 8;
        int numConstPoolEntries = this.in.readUnsignedShort();
        bytesRead += 2;
        for (int i = 0; i < numConstPoolEntries; ++i) {
            int index = this.in.readUnsignedShort();
            bytesRead += 2;
            bytesRead += this.readValue(null);
        }
        int numStatics = this.in.readUnsignedShort();
        bytesRead += 2;
        JavaThing[] valueBin = new JavaThing[1];
        JavaStatic[] statics = new JavaStatic[numStatics];
        for (int i = 0; i < numStatics; ++i) {
            long nameId = this.readID();
            bytesRead += this.identifierSize;
            byte type = this.in.readByte();
            ++bytesRead;
            bytesRead += this.readValueForType(type, valueBin);
            String fieldName = this.getNameFromID(nameId);
            if (this.version >= 1) {
                type = this.signatureFromTypeId(type);
            }
            String signature = "" + (char)type;
            JavaField f = new JavaField(fieldName, signature);
            statics[i] = new JavaStatic(f, valueBin[0]);
        }
        int numFields = this.in.readUnsignedShort();
        bytesRead += 2;
        JavaField[] fields = new JavaField[numFields];
        for (int i = 0; i < numFields; ++i) {
            long nameId = this.readID();
            bytesRead += this.identifierSize;
            byte type = this.in.readByte();
            ++bytesRead;
            String fieldName = this.getNameFromID(nameId);
            if (this.version >= 1) {
                type = this.signatureFromTypeId(type);
            }
            String signature = "" + (char)type;
            fields[i] = new JavaField(fieldName, signature);
        }
        Object name = this.classNameFromObjectID.get(id);
        if (name == null) {
            this.warn("Class name not found for " + this.toHex(id));
            name = "unknown-name@" + this.toHex(id);
        }
        JavaClass c = new JavaClass(id, (String)name, superId, classLoaderId, signersId, protDomainId, fields, statics, instanceSize);
        this.snapshot.addClass(id, c);
        this.snapshot.setSiteTrace(c, stackTrace);
        return bytesRead;
    }

    private String toHex(long addr) {
        return Misc.toHex(addr);
    }

    private int readInstance() throws IOException {
        long start = this.in.position();
        long id = this.readID();
        StackTrace stackTrace = this.getStackTraceFromSerial(this.in.readInt());
        long classID = this.readID();
        JavaClass searchedClass = this.snapshot.findClass("0x" + Long.toHexString(classID));
        if (searchedClass == null) {
            throw new IOException("Class Record for 0x" + Long.toHexString(classID) + " not found");
        }
        int bytesFollowing = this.in.readInt();
        int bytesRead = 2 * this.identifierSize + 8 + bytesFollowing;
        JavaObject jobj = new JavaObject(classID, start);
        this.skipBytes(bytesFollowing);
        this.snapshot.addHeapObject(id, jobj);
        this.snapshot.setSiteTrace(jobj, stackTrace);
        return bytesRead;
    }

    private long readArray(boolean isPrimitive) throws IOException {
        long elementClassID;
        long start = this.in.position();
        long id = this.readID();
        StackTrace stackTrace = this.getStackTraceFromSerial(this.in.readInt());
        int num = this.in.readInt();
        long bytesRead = this.identifierSize + 8;
        if (isPrimitive) {
            elementClassID = this.in.readByte();
            ++bytesRead;
        } else {
            elementClassID = this.readID();
            bytesRead += (long)this.identifierSize;
        }
        byte primitiveSignature = 0;
        int elSize = 0;
        if (isPrimitive || this.version < 1) {
            switch ((int)elementClassID) {
                case 4: {
                    primitiveSignature = 90;
                    elSize = 1;
                    break;
                }
                case 5: {
                    primitiveSignature = 67;
                    elSize = 2;
                    break;
                }
                case 6: {
                    primitiveSignature = 70;
                    elSize = 4;
                    break;
                }
                case 7: {
                    primitiveSignature = 68;
                    elSize = 8;
                    break;
                }
                case 8: {
                    primitiveSignature = 66;
                    elSize = 1;
                    break;
                }
                case 9: {
                    primitiveSignature = 83;
                    elSize = 2;
                    break;
                }
                case 10: {
                    primitiveSignature = 73;
                    elSize = 4;
                    break;
                }
                case 11: {
                    primitiveSignature = 74;
                    elSize = 8;
                }
            }
            if (this.version >= 1 && primitiveSignature == 0) {
                throw new IOException("Unrecognized typecode:  " + elementClassID);
            }
        }
        if (primitiveSignature != 0) {
            long size = (long)elSize * (long)num;
            bytesRead += size;
            JavaValueArray va = new JavaValueArray(primitiveSignature, start);
            this.skipBytes(size);
            this.snapshot.addHeapObject(id, va);
            this.snapshot.setSiteTrace(va, stackTrace);
        } else {
            long sz = (long)num * (long)this.identifierSize;
            bytesRead += sz;
            JavaObjectArray arr = new JavaObjectArray(elementClassID, start);
            this.skipBytes(sz);
            this.snapshot.addHeapObject(id, arr);
            this.snapshot.setSiteTrace(arr, stackTrace);
        }
        return bytesRead;
    }

    private byte signatureFromTypeId(byte typeId) throws IOException {
        switch (typeId) {
            case 2: {
                return 76;
            }
            case 4: {
                return 90;
            }
            case 5: {
                return 67;
            }
            case 6: {
                return 70;
            }
            case 7: {
                return 68;
            }
            case 8: {
                return 66;
            }
            case 9: {
                return 83;
            }
            case 10: {
                return 73;
            }
            case 11: {
                return 74;
            }
        }
        throw new IOException("Invalid type id of " + typeId);
    }

    private void handleEOF(EOFException exp, Snapshot snapshot) {
        if (this.debugLevel > 0) {
            exp.printStackTrace();
        }
        this.warn("Unexpected EOF. Will miss information...");
        snapshot.setUnresolvedObjectsOK(true);
    }

    private void warn(String msg) {
        System.out.println("WARNING: " + msg);
    }
}

