/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.cds;

import java.io.File;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import jdk.test.lib.StringArrayUtils;
import jdk.test.lib.cds.CDSAppTester;
import jdk.test.lib.process.OutputAnalyzer;

public class SimpleCDSAppTester {
    private String name;
    private BiConsumer<OutputAnalyzer, CDSAppTester.RunMode> trainingChecker;
    private BiConsumer<OutputAnalyzer, CDSAppTester.RunMode> assemblyChecker;
    private BiConsumer<OutputAnalyzer, CDSAppTester.RunMode> productionChecker;
    private String classpath;
    private String modulepath;
    private String[] appCommandLine;
    private String[] vmArgs = new String[0];

    private SimpleCDSAppTester(String name) {
        this.name = name;
    }

    public static SimpleCDSAppTester of(String name) {
        return new SimpleCDSAppTester(name);
    }

    public SimpleCDSAppTester classpath(String ... paths) {
        this.classpath = null;
        for (String p : paths) {
            this.classpath = this.classpath == null ? p : this.classpath + File.pathSeparator + p;
        }
        return this;
    }

    public SimpleCDSAppTester modulepath(String ... paths) {
        this.modulepath = null;
        for (String p : paths) {
            this.modulepath = this.modulepath == null ? p : this.modulepath + File.pathSeparator + p;
        }
        return this;
    }

    public SimpleCDSAppTester addVmArgs(String ... args) {
        this.vmArgs = StringArrayUtils.concat(this.vmArgs, args);
        return this;
    }

    public SimpleCDSAppTester appCommandLine(String ... args) {
        this.appCommandLine = args;
        return this;
    }

    public SimpleCDSAppTester setTrainingChecker(BiConsumer<OutputAnalyzer, CDSAppTester.RunMode> checker) {
        this.trainingChecker = checker;
        return this;
    }

    public SimpleCDSAppTester setAssemblyChecker(BiConsumer<OutputAnalyzer, CDSAppTester.RunMode> checker) {
        this.assemblyChecker = checker;
        return this;
    }

    public SimpleCDSAppTester setProductionChecker(BiConsumer<OutputAnalyzer, CDSAppTester.RunMode> checker) {
        this.productionChecker = checker;
        return this;
    }

    public SimpleCDSAppTester setTrainingChecker(Consumer<OutputAnalyzer> checker) {
        this.trainingChecker = (out, runMode) -> checker.accept((OutputAnalyzer)out);
        return this;
    }

    public SimpleCDSAppTester setAssemblyChecker(Consumer<OutputAnalyzer> checker) {
        this.assemblyChecker = (out, runMode) -> checker.accept((OutputAnalyzer)out);
        return this;
    }

    public SimpleCDSAppTester setProductionChecker(Consumer<OutputAnalyzer> checker) {
        this.productionChecker = (out, runMode) -> checker.accept((OutputAnalyzer)out);
        return this;
    }

    public SimpleCDSAppTester runStaticWorkflow() throws Exception {
        new Tester(this, this.name).runStaticWorkflow();
        return this;
    }

    public SimpleCDSAppTester runAOTWorkflow() throws Exception {
        new Tester(this, this.name).runAOTWorkflow(new String[0]);
        return this;
    }

    public SimpleCDSAppTester run(String[] args) throws Exception {
        new Tester(this, this.name).run(args);
        return this;
    }

    class Tester
    extends CDSAppTester {
        final /* synthetic */ SimpleCDSAppTester this$0;

        public Tester(SimpleCDSAppTester this$0, String name) {
            SimpleCDSAppTester simpleCDSAppTester = this$0;
            Objects.requireNonNull(simpleCDSAppTester);
            this.this$0 = simpleCDSAppTester;
            super(name);
        }

        @Override
        public String classpath(CDSAppTester.RunMode runMode) {
            return this.this$0.classpath;
        }

        @Override
        public String modulepath(CDSAppTester.RunMode runMode) {
            return this.this$0.modulepath;
        }

        @Override
        public String[] vmArgs(CDSAppTester.RunMode runMode) {
            return this.this$0.vmArgs;
        }

        @Override
        public String[] appCommandLine(CDSAppTester.RunMode runMode) {
            return this.this$0.appCommandLine;
        }

        @Override
        public void checkExecution(OutputAnalyzer out, CDSAppTester.RunMode runMode) throws Exception {
            if (runMode == CDSAppTester.RunMode.TRAINING) {
                if (this.this$0.trainingChecker != null) {
                    this.this$0.trainingChecker.accept(out, runMode);
                }
            } else if (this.isDumping(runMode)) {
                if (this.this$0.assemblyChecker != null) {
                    this.this$0.assemblyChecker.accept(out, runMode);
                }
            } else if (runMode.isProductionRun() && this.this$0.productionChecker != null) {
                this.this$0.productionChecker.accept(out, runMode);
            }
        }
    }
}

