/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security.timestamp;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Objects;
import jdk.test.lib.hexdump.HexPrinter;
import jdk.test.lib.security.timestamp.DefaultRespInterceptor;
import jdk.test.lib.security.timestamp.RespInterceptor;
import jdk.test.lib.security.timestamp.SignerEntry;
import jdk.test.lib.security.timestamp.TsaParam;
import sun.security.pkcs.ContentInfo;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;
import sun.security.util.SignatureUtil;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;

public class TsaSigner {
    private static final boolean DEBUG = Boolean.getBoolean("test.debug");
    private static final HexPrinter HEX_PRINTER = HexPrinter.simple();
    protected final SignerEntry signerEntry;
    protected final byte[] requestData;
    private final RespInterceptor interceptor;

    public TsaSigner(SignerEntry signerEntry, byte[] requestData, RespInterceptor interceptor) {
        Objects.requireNonNull(signerEntry);
        Objects.requireNonNull(interceptor);
        this.signerEntry = signerEntry;
        this.requestData = requestData;
        this.interceptor = interceptor;
    }

    public TsaSigner(SignerEntry signerEntry, byte[] requestData, TsaParam param) {
        this(signerEntry, requestData, new DefaultRespInterceptor<TsaParam>(param));
    }

    public byte[] sign() throws Exception {
        TsaParam requestParam = this.parseRequestParam();
        byte[] responseSeqData = this.createResponse(requestParam);
        return responseSeqData;
    }

    private TsaParam parseRequestParam() throws Exception {
        TsaParam param = TsaParam.newInstance();
        if (this.requestData == null) {
            return param;
        }
        System.out.println("===== Request ====");
        TsaSigner.debug("Request", this.requestData);
        DerValue request = new DerValue(this.requestData);
        param.version(request.data.getInteger());
        TsaSigner.print("reqVersion", param.version());
        DerValue messageImprintValue = request.data.getDerValue();
        TsaSigner.debug("messageImprintValue", messageImprintValue.toByteArray());
        DerValue digestAlgoValue = messageImprintValue.data.getDerValue();
        TsaSigner.debug("digestAlgoValue", digestAlgoValue.toByteArray());
        param.digestAlgo(AlgorithmId.parse(digestAlgoValue).getName());
        TsaSigner.print("reqDigestAlgo", param.digestAlgo());
        param.hashedMessage(messageImprintValue.data.getOctetString());
        TsaSigner.debug("reqHashedMessage", param.hashedMessage());
        while (request.data.available() > 0) {
            DerValue value = request.data.getDerValue();
            if (value.tag == 2) {
                param.nonce(value.getBigInteger());
                TsaSigner.print("reqNonce", param.nonce());
                continue;
            }
            if (value.tag == 1) {
                param.certReq(value.getBoolean());
                TsaSigner.print("certReq", param.certReq());
                continue;
            }
            if (value.tag != 6) continue;
            param.policyId(value.getOID().toString());
            TsaSigner.print("reqPolicyId", param.policyId());
        }
        return param;
    }

    private byte[] createResponse(TsaParam requestParam) throws Exception {
        System.out.println("===== Response ====");
        TsaParam respParam = this.interceptor.getRespParam(requestParam);
        DerOutputStream statusInfoOut = new DerOutputStream();
        int status = respParam.status();
        TsaSigner.print("Status", status);
        statusInfoOut.putInteger(status);
        DerOutputStream responseOut = new DerOutputStream();
        responseOut.write((byte)48, statusInfoOut);
        TsaSigner.debug("Status info", statusInfoOut.toByteArray());
        System.out.println("Generated status info");
        if (status == 0 || status == 1) {
            System.out.println("Signer: " + this.signerEntry.cert.getSubjectX500Principal().getName());
            String issuerName = this.signerEntry.cert.getIssuerX500Principal().getName();
            TsaSigner.print("Issuer", issuerName);
            DerOutputStream tstInfoOut = new DerOutputStream();
            int version = respParam.version();
            TsaSigner.print("version", version);
            tstInfoOut.putInteger(version);
            String policyId = respParam.policyId();
            TsaSigner.print("policyId", policyId);
            tstInfoOut.putOID(ObjectIdentifier.of(policyId));
            String digestAlgo = respParam.digestAlgo();
            TsaSigner.print("digestAlgo", digestAlgo);
            DerOutputStream digestAlgoOut = new DerOutputStream();
            AlgorithmId digestAlgoId = AlgorithmId.get(digestAlgo);
            digestAlgoId.encode(digestAlgoOut);
            byte[] hashedMessage = respParam.hashedMessage();
            TsaSigner.debug("hashedMessage", hashedMessage);
            digestAlgoOut.putOctetString(hashedMessage);
            tstInfoOut.write((byte)48, digestAlgoOut);
            BigInteger serialNumber = respParam.serialNumber();
            TsaSigner.print("serialNumber", serialNumber);
            tstInfoOut.putInteger(serialNumber);
            Date genTime = respParam.genTime();
            TsaSigner.print("genTime", genTime);
            tstInfoOut.putGeneralizedTime(genTime);
            BigInteger nonce = respParam.nonce();
            if (nonce != null) {
                tstInfoOut.putInteger(nonce);
            }
            DerOutputStream tstInfoSeqOut = new DerOutputStream();
            tstInfoSeqOut.write((byte)48, tstInfoOut);
            byte[] tstInfoSeqData = tstInfoSeqOut.toByteArray();
            TsaSigner.debug("TST Info", tstInfoSeqData);
            DerOutputStream eContentOut = new DerOutputStream();
            eContentOut.putOctetString(tstInfoSeqData);
            ContentInfo eContentInfo = new ContentInfo(ObjectIdentifier.of(KnownOIDs.TimeStampTokenInfo), new DerValue(eContentOut.toByteArray()));
            String defaultSigAlgo = SignatureUtil.getDefaultSigAlgForKey(this.signerEntry.privateKey);
            String sigAlgo = this.interceptor.getSigAlgo(defaultSigAlgo);
            Signature signature = Signature.getInstance(sigAlgo);
            System.out.println("Signature algorithm: " + signature.getAlgorithm());
            signature.initSign(this.signerEntry.privateKey);
            signature.update(tstInfoSeqData);
            SignerInfo signerInfo = new SignerInfo(new X500Name(issuerName), this.signerEntry.cert.getSerialNumber(), SignatureUtil.getDigestAlgInPkcs7SignerInfo((Signature)signature, (String)sigAlgo, (PrivateKey)this.signerEntry.privateKey, (PublicKey)this.signerEntry.cert.getPublicKey(), (boolean)false), AlgorithmId.get(sigAlgo), signature.sign());
            X509Certificate[] signerCertChain = this.interceptor.getSignerCertChain(this.signerEntry.certChain, requestParam.certReq());
            PKCS7 p7 = new PKCS7(new AlgorithmId[]{digestAlgoId}, eContentInfo, signerCertChain, new SignerInfo[]{signerInfo});
            DerOutputStream signedDataOut = new DerOutputStream();
            p7.encodeSignedData(signedDataOut);
            byte[] signedData = signedDataOut.toByteArray();
            TsaSigner.debug("Signed data", signedData);
            responseOut.putDerValue(new DerValue(signedData));
            System.out.println("Generated signed data");
        }
        DerOutputStream responseSeqOut = new DerOutputStream();
        responseSeqOut.write((byte)48, responseOut);
        byte[] responseSeqData = responseSeqOut.toByteArray();
        TsaSigner.debug("Response", responseSeqData);
        System.out.println("Generated response");
        return responseSeqData;
    }

    private static void print(String name, Object value) {
        System.out.println(name + ": " + String.valueOf(value));
    }

    private static void debug(String name, byte[] bytes) {
        if (DEBUG) {
            System.out.println(name + ":");
            HEX_PRINTER.format(bytes);
        }
    }
}

