/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hexdump;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import jdk.test.lib.hexdump.HexPrinter;

public class ASN1Formatter
implements HexPrinter.Formatter {
    private static final int TAG_UNIVERSAL = 0;
    private static final int TAG_APPLICATION = 64;
    private static final int TAG_CONTEXT = 128;
    private static final int TAG_PRIVATE = 192;
    private static final byte TAG_MASK = 31;
    private static final byte TAG_EndOfContent = 0;
    private static final byte TAG_Boolean = 1;
    private static final byte TAG_Integer = 2;
    private static final byte TAG_BitString = 3;
    private static final byte TAG_OctetString = 4;
    private static final byte TAG_Null = 5;
    private static final byte TAG_ObjectId = 6;
    private static final byte TAG_Enumerated = 10;
    private static final byte TAG_UTF8String = 12;
    private static final byte TAG_PrintableString = 19;
    private static final byte TAG_T61String = 20;
    private static final byte TAG_IA5String = 22;
    private static final byte TAG_UtcTime = 23;
    private static final byte TAG_GeneralizedTime = 24;
    private static final byte TAG_GeneralString = 27;
    private static final byte TAG_UniversalString = 28;
    private static final byte TAG_BMPString = 30;
    private static final byte TAG_Sequence = 48;
    private static final byte TAG_Set = 49;
    private static final String[] tagNames = new String[]{"ANY", "BOOLEAN", "INTEGER", "BIT STRING", "OCTET STRING", "NULL", "OBJECT ID", "OBJECT DESCRIPTION", "EXTERNAL", "REAL", "ENUMERATION", "u11", "UTF8 STRING", "u13", "u14", "u15", "SEQUENCE", "SET", "NUMERIC STRING", "STRING", "T61", "VIDEOTEXT", "IA5", "UTCTIME", "GENERAL TIME", "GRAPHIC STRING", "ISO64STRING", "GENERAL STRING", "UNIVERSAL STRING", "u29", "BMP STRING", "MULTIBYTE TAG"};

    public static ASN1Formatter formatter() {
        return new ASN1Formatter();
    }

    private ASN1Formatter() {
    }

    public String annotate(DataInputStream in) {
        StringBuilder sb = new StringBuilder();
        try {
            this.annotate(in, sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    @Override
    public void annotate(DataInputStream in, Appendable out) throws IOException {
        this.annotate(in, out, -1, "");
    }

    private int annotate(DataInputStream in, Appendable out, int available, String prefix) throws IOException {
        int origAvailable = available;
        block19: while (available != 0 || origAvailable < 0) {
            int tag = in.readByte() & 0xFF;
            --available;
            if (this.tagType(tag) == 31) {
                byte tagbits;
                tag = 0;
                do {
                    tagbits = in.readByte();
                    --available;
                    tag = tag << 7 | tagbits & 0x7F;
                } while ((tagbits & 0x80) == 128);
            }
            int len = in.readByte() & 0xFF;
            --available;
            if (len > 128) {
                int nbytes = len & 0x7F;
                if (nbytes > 4) {
                    out.append("***** Tag: ").append(this.tagName(tag)).append(", Range of length error: ").append(Integer.toString(len)).append(" bytes");
                    out.append(System.lineSeparator());
                    return available;
                }
                len = 0;
                while (nbytes > 0) {
                    int inc = in.readByte() & 0xFF;
                    len = len << 8 | inc;
                    --available;
                    --nbytes;
                }
            } else if (len == 128) {
                len = -1;
            } else if (available < 0 && origAvailable < 0) {
                available = len;
            }
            out.append(prefix);
            block0 : switch (tag) {
                case 0: {
                    out.append("END-OF-CONTENT");
                    out.append(System.lineSeparator());
                    return 0;
                }
                case 2: 
                case 10: {
                    switch (len) {
                        case 1: {
                            out.append(String.format("BYTE %d. ", in.readByte()));
                            --available;
                            break block0;
                        }
                        case 2: {
                            out.append(String.format("SHORT %d. ", in.readShort()));
                            available -= 2;
                            break block0;
                        }
                        case 4: {
                            out.append(String.format("INTEGER %d. ", in.readInt()));
                            available -= 4;
                            break block0;
                        }
                        case 8: {
                            out.append(String.format("LONG %d. ", in.readLong()));
                            available -= 8;
                            break block0;
                        }
                    }
                    byte[] bytes = new byte[len];
                    int l = in.read(bytes);
                    BigInteger big = new BigInteger(bytes);
                    out.append("BIG INTEGER [" + len + "] ");
                    out.append(big.toString());
                    out.append(".");
                    available -= len;
                    break;
                }
                case 6: {
                    byte[] oid = new byte[len];
                    int l1 = in.read(oid);
                    available -= l1;
                    String s = ASN1Formatter.oidName(oid);
                    out.append(this.tagName(tag) + " [" + len + "] ");
                    out.append(s);
                    out.append(' ');
                    break;
                }
                case 4: 
                case 23: 
                case 24: {
                    out.append(this.tagName(tag) + " [" + len + "] ");
                }
                case 19: 
                case 22: 
                case 27: {
                    byte[] buf = new byte[Math.min(32, len)];
                    int l = in.read(buf, 0, buf.length);
                    if (ASN1Formatter.countPrintable(buf, l) > l / 2) {
                        out.append("'");
                        for (int i = 0; i < l; ++i) {
                            char c = ASN1Formatter.toASNPrintable((char)buf[i]);
                            out.append(c > '\u0000' ? c : (char)'.');
                        }
                        out.append("'");
                        if (l < len) {
                            out.append("...");
                        }
                        out.append(' ');
                    } else {
                        out.append("<Unprintable> ");
                    }
                    while (l < len) {
                        l += (int)in.skip(len - l);
                    }
                    available -= len;
                    break;
                }
                case 5: {
                    out.append("NULL ");
                    break;
                }
                case 1: {
                    byte b = in.readByte();
                    --available;
                    out.append(b == 0 ? "FALSE " : "TRUE ");
                    break;
                }
                case 12: {
                    out.append(this.getString(in, len, StandardCharsets.UTF_8));
                    out.append(' ');
                    available -= len;
                    break;
                }
                case 20: {
                    out.append(this.getString(in, len, StandardCharsets.ISO_8859_1));
                    out.append(' ');
                    available -= len;
                    break;
                }
                case 28: 
                case 30: {
                    out.append(this.getString(in, len, StandardCharsets.UTF_16BE));
                    out.append(' ');
                    available -= len;
                    break;
                }
                case 3: {
                    int skipped;
                    out.append(String.format("%s [%d]", this.tagName(tag), len));
                    do {
                        skipped = (int)in.skip(len);
                        available -= skipped;
                    } while ((len -= skipped) > 0);
                    break;
                }
                default: {
                    if (tag == 48 || tag == 49 || this.isApplication(tag) || this.isConstructed(tag)) {
                        String lenStr;
                        String string = lenStr = len < 0 ? "INDEFINITE" : Integer.toString(len);
                        if (this.isApplication(tag)) {
                            out.append(String.format("APPLICATION %d. [%s] {%n", this.tagType(tag), lenStr));
                        } else {
                            out.append(String.format("%s [%s]%n", this.tagName(tag), lenStr));
                        }
                        int remaining = this.annotate(in, out, len, prefix + "  ");
                        if (len <= 0) continue block19;
                        available -= len - remaining;
                        continue block19;
                    }
                    out.append(String.format("%s[%d]: ", this.tagName(tag), len));
                    this.formatBytes(in, out, len);
                    available -= len;
                }
            }
            out.append(System.lineSeparator());
        }
        return available;
    }

    private void formatBytes(DataInputStream in, Appendable out, int len) throws IOException {
        int b = in.readByte() & 0xFF;
        out.append(String.format("%02x", b));
        for (int i = 1; i < len; ++i) {
            b = in.readByte() & 0xFF;
            out.append(String.format(",%02x", b));
        }
    }

    private String getString(DataInputStream in, int len, Charset charset) throws IOException {
        byte[] bytes = new byte[len];
        int l = in.read(bytes);
        return new String(bytes, charset);
    }

    private String tagName(int tag) {
        String tagString = (this.isConstructed(tag) ? "CONSTRUCTED " : "") + tagNames[this.tagType(tag)];
        switch (tag & 0xC0) {
            case 64: {
                return "APPLICATION " + tagString;
            }
            case 192: {
                return "PRIVATE " + tagString;
            }
            case 128: {
                return tagString;
            }
            case 0: {
                if (tag > 0 && tag < tagNames.length) {
                    return tagNames[tag];
                }
                if (tag == 49) {
                    return "SET";
                }
                if (tag == 48) {
                    return "SEQUENCE";
                }
                return "UNIVERSAL " + tagString;
            }
        }
        return "TAG__" + (tag & 0xC0);
    }

    private static String oidName(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 4);
        int first = bytes[0] / 40;
        int second = bytes[0] % 40;
        sb.append(first).append('.').append(second);
        int valn = 0;
        for (int i = 1; i < bytes.length; ++i) {
            valn = valn * 128 + (bytes[i] & 0x7F);
            if ((bytes[i] & 0x80) != 0) continue;
            sb.append('.');
            sb.append(valn);
            valn = 0;
        }
        String noid = sb.toString();
        try {
            Class<?> cl = Class.forName("sun.security.util.KnownOIDs");
            Method findMatch = cl.getDeclaredMethod("findMatch", String.class);
            Object oid = findMatch.invoke(null, noid);
            return oid == null ? noid : noid + " (" + oid.toString() + ")";
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return noid;
        }
    }

    private static char toASNPrintable(char ch) {
        if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
            return ch;
        }
        switch (ch) {
            case ' ': 
            case '\'': 
            case '(': 
            case ')': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '=': 
            case '?': {
                return ch;
            }
        }
        return '\u0000';
    }

    private static int countPrintable(byte[] bytes, int len) {
        int count = 0;
        for (int i = 0; i < len; ++i) {
            count += ASN1Formatter.toASNPrintable((char)bytes[i]) > '\u0000' ? 1 : 0;
        }
        return count;
    }

    private int tagType(int tag) {
        return tag & 0x1F;
    }

    private boolean isUniversal(int tag) {
        return (tag & 0xC0) == 0;
    }

    private boolean isApplication(int tag) {
        return (tag & 0xC0) == 64;
    }

    private boolean isConstructed(int tag) {
        return (tag & 0x20) == 32;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage:  <asn.1 files>");
            return;
        }
        ASN1Formatter fmt = ASN1Formatter.formatter();
        for (String file : args) {
            System.out.printf("%s%n", file);
            try (InputStream fis = Files.newInputStream(Path.of(file, new String[0]), new OpenOption[0]);
                 BufferedInputStream is = new BufferedInputStream(fis);
                 InputStream in = ASN1Formatter.wrapIfBase64Mime(is);){
                DataInputStream dis = new DataInputStream(in);
                HexPrinter p = HexPrinter.simple().dest(System.out).formatter(ASN1Formatter.formatter(), "; ", 100);
                p.format(dis);
            }
            catch (EOFException eof) {
                System.out.println();
            }
            catch (IOException ioe) {
                System.out.printf("%s: %s%n", file, ioe);
            }
        }
    }

    private static InputStream wrapIfBase64Mime(BufferedInputStream bis) throws IOException {
        bis.mark(256);
        DataInputStream dis = new DataInputStream(bis);
        String line1 = dis.readLine();
        if (line1.startsWith("-----") && line1.endsWith("-----")) {
            return Base64.getMimeDecoder().wrap(bis);
        }
        bis.reset();
        return bis;
    }
}

