/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.bmp;

import com.sun.imageio.plugins.bmp.BMPImageWriter;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;

public class BMPImageWriterSpi
extends ImageWriterSpi {
    private static String[] readerSpiNames = new String[]{"com.sun.imageio.plugins.bmp.BMPImageReaderSpi"};
    private static String[] formatNames = new String[]{"bmp", "BMP"};
    private static String[] entensions = new String[]{"bmp"};
    private static String[] mimeType = new String[]{"image/bmp"};
    private boolean registered = false;

    public BMPImageWriterSpi() {
        super("Oracle Corporation", "1.0", formatNames, entensions, mimeType, "com.sun.imageio.plugins.bmp.BMPImageWriter", new Class[]{ImageOutputStream.class}, readerSpiNames, false, null, null, null, null, true, "javax_imageio_bmp_1.0", "com.sun.imageio.plugins.bmp.BMPMetadataFormat", null, null);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Standard BMP Image Writer";
    }

    @Override
    public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
        if (this.registered) {
            return;
        }
        this.registered = true;
    }

    @Override
    public boolean canEncodeImage(ImageTypeSpecifier imageTypeSpecifier) {
        int n = imageTypeSpecifier.getSampleModel().getDataType();
        if (n < 0 || n > 3) {
            return false;
        }
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        int n2 = sampleModel.getNumBands();
        if (n2 != 1 && n2 != 3) {
            return false;
        }
        if (n2 == 1 && n != 0) {
            return false;
        }
        return n <= 0 || sampleModel instanceof SinglePixelPackedSampleModel;
    }

    @Override
    public ImageWriter createWriterInstance(Object object) throws IIOException {
        return new BMPImageWriter(this);
    }
}

