/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.text.Bidi;
import sun.font.CoreMetrics;
import sun.font.Decoration;
import sun.font.ExtendedTextLabel;
import sun.font.ExtendedTextSourceLabel;
import sun.font.StandardTextSource;
import sun.font.TextLabel;
import sun.font.TextSourceLabel;

public final class TextLabelFactory {
    private final FontRenderContext frc;
    private final char[] text;
    private final Bidi bidi;
    private Bidi lineBidi;
    private final int flags;
    private int lineStart;
    private int lineLimit;

    public TextLabelFactory(FontRenderContext fontRenderContext, char[] cArray, Bidi bidi, int n) {
        this.frc = fontRenderContext;
        this.text = (char[])cArray.clone();
        this.bidi = bidi;
        this.flags = n;
        this.lineBidi = bidi;
        this.lineStart = 0;
        this.lineLimit = cArray.length;
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public Bidi getLineBidi() {
        return this.lineBidi;
    }

    public void setLineContext(int n, int n2) {
        this.lineStart = n;
        this.lineLimit = n2;
        if (this.bidi != null) {
            this.lineBidi = this.bidi.createLineBidi(n, n2);
        }
    }

    public ExtendedTextLabel createExtended(Font font, CoreMetrics coreMetrics, Decoration decoration, int n, int n2) {
        if (n >= n2 || n < this.lineStart || n2 > this.lineLimit) {
            throw new IllegalArgumentException("bad start: " + n + " or limit: " + n2);
        }
        int n3 = this.lineBidi == null ? 0 : this.lineBidi.getLevelAt(n - this.lineStart);
        boolean bl = this.lineBidi != null && !this.lineBidi.baseIsLeftToRight();
        int n4 = this.flags & 0xFFFFFFF6;
        if ((n3 & 1) != 0) {
            n4 |= 1;
        }
        if (bl & true) {
            n4 |= 8;
        }
        StandardTextSource standardTextSource = new StandardTextSource(this.text, n, n2 - n, this.lineStart, this.lineLimit - this.lineStart, n3, n4, font, this.frc, coreMetrics);
        return new ExtendedTextSourceLabel(standardTextSource, decoration);
    }

    public TextLabel createSimple(Font font, CoreMetrics coreMetrics, int n, int n2) {
        if (n >= n2 || n < this.lineStart || n2 > this.lineLimit) {
            throw new IllegalArgumentException("bad start: " + n + " or limit: " + n2);
        }
        int n3 = this.lineBidi == null ? 0 : this.lineBidi.getLevelAt(n - this.lineStart);
        boolean bl = this.lineBidi != null && !this.lineBidi.baseIsLeftToRight();
        int n4 = this.flags & 0xFFFFFFF6;
        if ((n3 & 1) != 0) {
            n4 |= 1;
        }
        if (bl & true) {
            n4 |= 8;
        }
        StandardTextSource standardTextSource = new StandardTextSource(this.text, n, n2 - n, this.lineStart, this.lineLimit - this.lineStart, n3, n4, font, this.frc, coreMetrics);
        return new TextSourceLabel(standardTextSource);
    }
}

