/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util.math.intpoly;

import java.math.BigInteger;
import sun.security.util.math.intpoly.IntegerPolynomial;

public class P521OrderField
extends IntegerPolynomial {
    private static final int BITS_PER_LIMB = 28;
    private static final int NUM_LIMBS = 19;
    private static final int MAX_ADDS = 1;
    public static final BigInteger MODULUS = P521OrderField.evaluateModulus();
    private static final long CARRY_ADD = 0x8000000L;
    private static final int LIMB_MASK = 0xFFFFFFF;

    public P521OrderField() {
        super(28, 19, 1, MODULUS);
    }

    private static BigInteger evaluateModulus() {
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(521);
        bigInteger = bigInteger.add(BigInteger.valueOf(20472841L));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(28).multiply(BigInteger.valueOf(117141993L)));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(56).multiply(BigInteger.valueOf(62411077L)));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(84).multiply(BigInteger.valueOf(56915814L)));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(112).multiply(BigInteger.valueOf(97532854L)));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(140).multiply(BigInteger.valueOf(76509338L)));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(168).multiply(BigInteger.valueOf(75510783L)));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(196).multiply(BigInteger.valueOf(67962521L)));
        bigInteger = bigInteger.add(BigInteger.valueOf(2L).pow(224).multiply(BigInteger.valueOf(25593732L)));
        bigInteger = bigInteger.subtract(BigInteger.valueOf(2L).pow(252).multiply(BigInteger.valueOf(91L)));
        return bigInteger;
    }

    @Override
    protected void finalCarryReduceLast(long[] lArray) {
        long l = lArray[18] >> 17;
        lArray[18] = lArray[18] - (l << 17);
        long l2 = -20472841L * l;
        lArray[0] = lArray[0] + l2;
        l2 = -117141993L * l;
        lArray[1] = lArray[1] + l2;
        l2 = 62411077L * l;
        lArray[2] = lArray[2] + l2;
        l2 = 56915814L * l;
        lArray[3] = lArray[3] + l2;
        l2 = -97532854L * l;
        lArray[4] = lArray[4] + l2;
        l2 = -76509338L * l;
        lArray[5] = lArray[5] + l2;
        l2 = 75510783L * l;
        lArray[6] = lArray[6] + l2;
        l2 = 67962521L * l;
        lArray[7] = lArray[7] + l2;
        l2 = -25593732L * l;
        lArray[8] = lArray[8] + l2;
        l2 = 91L * l;
        lArray[9] = lArray[9] + l2;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28, long l29, long l30, long l31, long l32, long l33, long l34, long l35, long l36, long l37) {
        long l38 = 0L;
        long l39 = l + 0x8000000L >> 28;
        l -= l39 << 28;
        l2 += l39;
        l39 = l2 + 0x8000000L >> 28;
        l2 -= l39 << 28;
        l3 += l39;
        l39 = l3 + 0x8000000L >> 28;
        l3 -= l39 << 28;
        l4 += l39;
        l39 = l4 + 0x8000000L >> 28;
        l4 -= l39 << 28;
        l5 += l39;
        l39 = l5 + 0x8000000L >> 28;
        l5 -= l39 << 28;
        l6 += l39;
        l39 = l6 + 0x8000000L >> 28;
        l6 -= l39 << 28;
        l7 += l39;
        l39 = l7 + 0x8000000L >> 28;
        l7 -= l39 << 28;
        l8 += l39;
        l39 = l8 + 0x8000000L >> 28;
        l8 -= l39 << 28;
        l9 += l39;
        l39 = l9 + 0x8000000L >> 28;
        l9 -= l39 << 28;
        l10 += l39;
        l39 = l10 + 0x8000000L >> 28;
        l10 -= l39 << 28;
        l11 += l39;
        l39 = l11 + 0x8000000L >> 28;
        l11 -= l39 << 28;
        l12 += l39;
        l39 = l12 + 0x8000000L >> 28;
        l12 -= l39 << 28;
        l13 += l39;
        l39 = l13 + 0x8000000L >> 28;
        l13 -= l39 << 28;
        l14 += l39;
        l39 = l14 + 0x8000000L >> 28;
        l14 -= l39 << 28;
        l15 += l39;
        l39 = l15 + 0x8000000L >> 28;
        l15 -= l39 << 28;
        l16 += l39;
        l39 = l16 + 0x8000000L >> 28;
        l16 -= l39 << 28;
        l17 += l39;
        l39 = l17 + 0x8000000L >> 28;
        l17 -= l39 << 28;
        l18 += l39;
        l39 = l18 + 0x8000000L >> 28;
        l18 -= l39 << 28;
        l19 += l39;
        l39 = l19 + 0x8000000L >> 28;
        l19 -= l39 << 28;
        l20 += l39;
        l39 = l20 + 0x8000000L >> 28;
        l20 -= l39 << 28;
        l21 += l39;
        l39 = l21 + 0x8000000L >> 28;
        l21 -= l39 << 28;
        l22 += l39;
        l39 = l22 + 0x8000000L >> 28;
        l22 -= l39 << 28;
        l23 += l39;
        l39 = l23 + 0x8000000L >> 28;
        l23 -= l39 << 28;
        l24 += l39;
        l39 = l24 + 0x8000000L >> 28;
        l24 -= l39 << 28;
        l25 += l39;
        l39 = l25 + 0x8000000L >> 28;
        l25 -= l39 << 28;
        l26 += l39;
        l39 = l26 + 0x8000000L >> 28;
        l26 -= l39 << 28;
        l27 += l39;
        l39 = l27 + 0x8000000L >> 28;
        l27 -= l39 << 28;
        l28 += l39;
        l39 = l28 + 0x8000000L >> 28;
        l28 -= l39 << 28;
        l29 += l39;
        l39 = l29 + 0x8000000L >> 28;
        l29 -= l39 << 28;
        l30 += l39;
        l39 = l30 + 0x8000000L >> 28;
        l30 -= l39 << 28;
        l31 += l39;
        l39 = l31 + 0x8000000L >> 28;
        l31 -= l39 << 28;
        l32 += l39;
        l39 = l32 + 0x8000000L >> 28;
        l32 -= l39 << 28;
        l33 += l39;
        l39 = l33 + 0x8000000L >> 28;
        l33 -= l39 << 28;
        l34 += l39;
        l39 = l34 + 0x8000000L >> 28;
        l34 -= l39 << 28;
        l35 += l39;
        l39 = l35 + 0x8000000L >> 28;
        l35 -= l39 << 28;
        l36 += l39;
        l39 = l36 + 0x8000000L >> 28;
        l36 -= l39 << 28;
        l37 += l39;
        l39 = l37 + 0x8000000L >> 28;
        this.carryReduce0(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31, l32, l33, l34, l35, l36, l37 -= l39 << 28, l38 += l39);
    }

    void carryReduce0(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28, long l29, long l30, long l31, long l32, long l33, long l34, long l35, long l36, long l37, long l38) {
        long l39 = -20472841L * l38;
        l19 += l39 << 11 & 0xFFFFFFFL;
        l20 += l39 >> 17;
        l39 = -117141993L * l38;
        l20 += l39 << 11 & 0xFFFFFFFL;
        l21 += l39 >> 17;
        l39 = 62411077L * l38;
        l21 += l39 << 11 & 0xFFFFFFFL;
        l22 += l39 >> 17;
        l39 = 56915814L * l38;
        l22 += l39 << 11 & 0xFFFFFFFL;
        l23 += l39 >> 17;
        l39 = -97532854L * l38;
        l23 += l39 << 11 & 0xFFFFFFFL;
        l24 += l39 >> 17;
        l39 = -76509338L * l38;
        l24 += l39 << 11 & 0xFFFFFFFL;
        l25 += l39 >> 17;
        l39 = 75510783L * l38;
        l25 += l39 << 11 & 0xFFFFFFFL;
        l26 += l39 >> 17;
        l39 = 67962521L * l38;
        l26 += l39 << 11 & 0xFFFFFFFL;
        l27 += l39 >> 17;
        l39 = -25593732L * l38;
        l27 += l39 << 11 & 0xFFFFFFFL;
        l28 += l39 >> 17;
        l39 = 91L * l38;
        l28 += l39 << 11 & 0xFFFFFFFL;
        l29 += l39 >> 17;
        l39 = -20472841L * l37;
        l18 += l39 << 11 & 0xFFFFFFFL;
        l19 += l39 >> 17;
        l39 = -117141993L * l37;
        l19 += l39 << 11 & 0xFFFFFFFL;
        l20 += l39 >> 17;
        l39 = 62411077L * l37;
        l20 += l39 << 11 & 0xFFFFFFFL;
        l21 += l39 >> 17;
        l39 = 56915814L * l37;
        l21 += l39 << 11 & 0xFFFFFFFL;
        l22 += l39 >> 17;
        l39 = -97532854L * l37;
        l22 += l39 << 11 & 0xFFFFFFFL;
        l23 += l39 >> 17;
        l39 = -76509338L * l37;
        l23 += l39 << 11 & 0xFFFFFFFL;
        l24 += l39 >> 17;
        l39 = 75510783L * l37;
        l24 += l39 << 11 & 0xFFFFFFFL;
        l25 += l39 >> 17;
        l39 = 67962521L * l37;
        l25 += l39 << 11 & 0xFFFFFFFL;
        l26 += l39 >> 17;
        l39 = -25593732L * l37;
        l26 += l39 << 11 & 0xFFFFFFFL;
        l27 += l39 >> 17;
        l39 = 91L * l37;
        l27 += l39 << 11 & 0xFFFFFFFL;
        l28 += l39 >> 17;
        l39 = -20472841L * l36;
        l17 += l39 << 11 & 0xFFFFFFFL;
        l18 += l39 >> 17;
        l39 = -117141993L * l36;
        l18 += l39 << 11 & 0xFFFFFFFL;
        l19 += l39 >> 17;
        l39 = 62411077L * l36;
        l19 += l39 << 11 & 0xFFFFFFFL;
        l20 += l39 >> 17;
        l39 = 56915814L * l36;
        l20 += l39 << 11 & 0xFFFFFFFL;
        l21 += l39 >> 17;
        l39 = -97532854L * l36;
        l21 += l39 << 11 & 0xFFFFFFFL;
        l22 += l39 >> 17;
        l39 = -76509338L * l36;
        l22 += l39 << 11 & 0xFFFFFFFL;
        l23 += l39 >> 17;
        l39 = 75510783L * l36;
        l23 += l39 << 11 & 0xFFFFFFFL;
        l24 += l39 >> 17;
        l39 = 67962521L * l36;
        l24 += l39 << 11 & 0xFFFFFFFL;
        l25 += l39 >> 17;
        l39 = -25593732L * l36;
        l25 += l39 << 11 & 0xFFFFFFFL;
        l26 += l39 >> 17;
        l39 = 91L * l36;
        l26 += l39 << 11 & 0xFFFFFFFL;
        l27 += l39 >> 17;
        l39 = -20472841L * l35;
        l16 += l39 << 11 & 0xFFFFFFFL;
        l17 += l39 >> 17;
        l39 = -117141993L * l35;
        l17 += l39 << 11 & 0xFFFFFFFL;
        l18 += l39 >> 17;
        l39 = 62411077L * l35;
        l18 += l39 << 11 & 0xFFFFFFFL;
        l19 += l39 >> 17;
        l39 = 56915814L * l35;
        l19 += l39 << 11 & 0xFFFFFFFL;
        l20 += l39 >> 17;
        l39 = -97532854L * l35;
        l20 += l39 << 11 & 0xFFFFFFFL;
        l21 += l39 >> 17;
        l39 = -76509338L * l35;
        l21 += l39 << 11 & 0xFFFFFFFL;
        l22 += l39 >> 17;
        l39 = 75510783L * l35;
        l22 += l39 << 11 & 0xFFFFFFFL;
        l23 += l39 >> 17;
        l39 = 67962521L * l35;
        l23 += l39 << 11 & 0xFFFFFFFL;
        l24 += l39 >> 17;
        l39 = -25593732L * l35;
        l24 += l39 << 11 & 0xFFFFFFFL;
        l25 += l39 >> 17;
        l39 = 91L * l35;
        l25 += l39 << 11 & 0xFFFFFFFL;
        l26 += l39 >> 17;
        l39 = -20472841L * l34;
        l15 += l39 << 11 & 0xFFFFFFFL;
        l16 += l39 >> 17;
        l39 = -117141993L * l34;
        l16 += l39 << 11 & 0xFFFFFFFL;
        l17 += l39 >> 17;
        l39 = 62411077L * l34;
        l17 += l39 << 11 & 0xFFFFFFFL;
        l18 += l39 >> 17;
        l39 = 56915814L * l34;
        l18 += l39 << 11 & 0xFFFFFFFL;
        l19 += l39 >> 17;
        l39 = -97532854L * l34;
        l19 += l39 << 11 & 0xFFFFFFFL;
        l20 += l39 >> 17;
        l39 = -76509338L * l34;
        l20 += l39 << 11 & 0xFFFFFFFL;
        l21 += l39 >> 17;
        l39 = 75510783L * l34;
        l21 += l39 << 11 & 0xFFFFFFFL;
        l22 += l39 >> 17;
        l39 = 67962521L * l34;
        l22 += l39 << 11 & 0xFFFFFFFL;
        l23 += l39 >> 17;
        l39 = -25593732L * l34;
        l23 += l39 << 11 & 0xFFFFFFFL;
        l24 += l39 >> 17;
        l39 = 91L * l34;
        l24 += l39 << 11 & 0xFFFFFFFL;
        l25 += l39 >> 17;
        l39 = -20472841L * l33;
        l14 += l39 << 11 & 0xFFFFFFFL;
        l15 += l39 >> 17;
        l39 = -117141993L * l33;
        l15 += l39 << 11 & 0xFFFFFFFL;
        l16 += l39 >> 17;
        l39 = 62411077L * l33;
        l16 += l39 << 11 & 0xFFFFFFFL;
        l17 += l39 >> 17;
        l39 = 56915814L * l33;
        l17 += l39 << 11 & 0xFFFFFFFL;
        l18 += l39 >> 17;
        l39 = -97532854L * l33;
        l18 += l39 << 11 & 0xFFFFFFFL;
        l19 += l39 >> 17;
        l39 = -76509338L * l33;
        l19 += l39 << 11 & 0xFFFFFFFL;
        l20 += l39 >> 17;
        l39 = 75510783L * l33;
        l20 += l39 << 11 & 0xFFFFFFFL;
        l21 += l39 >> 17;
        l39 = 67962521L * l33;
        l21 += l39 << 11 & 0xFFFFFFFL;
        l22 += l39 >> 17;
        l39 = -25593732L * l33;
        l22 += l39 << 11 & 0xFFFFFFFL;
        l23 += l39 >> 17;
        l39 = 91L * l33;
        l23 += l39 << 11 & 0xFFFFFFFL;
        l24 += l39 >> 17;
        l39 = -20472841L * l32;
        l13 += l39 << 11 & 0xFFFFFFFL;
        l14 += l39 >> 17;
        l39 = -117141993L * l32;
        l14 += l39 << 11 & 0xFFFFFFFL;
        l15 += l39 >> 17;
        l39 = 62411077L * l32;
        l15 += l39 << 11 & 0xFFFFFFFL;
        l16 += l39 >> 17;
        l39 = 56915814L * l32;
        l16 += l39 << 11 & 0xFFFFFFFL;
        l17 += l39 >> 17;
        l39 = -97532854L * l32;
        l17 += l39 << 11 & 0xFFFFFFFL;
        l18 += l39 >> 17;
        l39 = -76509338L * l32;
        l18 += l39 << 11 & 0xFFFFFFFL;
        l19 += l39 >> 17;
        l39 = 75510783L * l32;
        l19 += l39 << 11 & 0xFFFFFFFL;
        l20 += l39 >> 17;
        l39 = 67962521L * l32;
        l20 += l39 << 11 & 0xFFFFFFFL;
        l21 += l39 >> 17;
        l39 = -25593732L * l32;
        l21 += l39 << 11 & 0xFFFFFFFL;
        l22 += l39 >> 17;
        l39 = 91L * l32;
        l22 += l39 << 11 & 0xFFFFFFFL;
        l23 += l39 >> 17;
        l39 = -20472841L * l31;
        l12 += l39 << 11 & 0xFFFFFFFL;
        l13 += l39 >> 17;
        l39 = -117141993L * l31;
        l13 += l39 << 11 & 0xFFFFFFFL;
        l14 += l39 >> 17;
        l39 = 62411077L * l31;
        l14 += l39 << 11 & 0xFFFFFFFL;
        l15 += l39 >> 17;
        l39 = 56915814L * l31;
        l15 += l39 << 11 & 0xFFFFFFFL;
        l16 += l39 >> 17;
        l39 = -97532854L * l31;
        l16 += l39 << 11 & 0xFFFFFFFL;
        l17 += l39 >> 17;
        l39 = -76509338L * l31;
        l17 += l39 << 11 & 0xFFFFFFFL;
        l18 += l39 >> 17;
        l39 = 75510783L * l31;
        l18 += l39 << 11 & 0xFFFFFFFL;
        l19 += l39 >> 17;
        l39 = 67962521L * l31;
        l19 += l39 << 11 & 0xFFFFFFFL;
        l20 += l39 >> 17;
        l39 = -25593732L * l31;
        l20 += l39 << 11 & 0xFFFFFFFL;
        l21 += l39 >> 17;
        l39 = 91L * l31;
        l21 += l39 << 11 & 0xFFFFFFFL;
        l22 += l39 >> 17;
        l39 = -20472841L * l30;
        l11 += l39 << 11 & 0xFFFFFFFL;
        l12 += l39 >> 17;
        l39 = -117141993L * l30;
        l12 += l39 << 11 & 0xFFFFFFFL;
        l13 += l39 >> 17;
        l39 = 62411077L * l30;
        l13 += l39 << 11 & 0xFFFFFFFL;
        l14 += l39 >> 17;
        l39 = 56915814L * l30;
        l14 += l39 << 11 & 0xFFFFFFFL;
        l15 += l39 >> 17;
        l39 = -97532854L * l30;
        l15 += l39 << 11 & 0xFFFFFFFL;
        l16 += l39 >> 17;
        l39 = -76509338L * l30;
        l16 += l39 << 11 & 0xFFFFFFFL;
        l17 += l39 >> 17;
        l39 = 75510783L * l30;
        l17 += l39 << 11 & 0xFFFFFFFL;
        l18 += l39 >> 17;
        l39 = 67962521L * l30;
        l18 += l39 << 11 & 0xFFFFFFFL;
        l19 += l39 >> 17;
        l39 = -25593732L * l30;
        l19 += l39 << 11 & 0xFFFFFFFL;
        l20 += l39 >> 17;
        l39 = 91L * l30;
        l20 += l39 << 11 & 0xFFFFFFFL;
        l21 += l39 >> 17;
        l39 = -20472841L * l29;
        l10 += l39 << 11 & 0xFFFFFFFL;
        l11 += l39 >> 17;
        l39 = -117141993L * l29;
        l11 += l39 << 11 & 0xFFFFFFFL;
        l12 += l39 >> 17;
        l39 = 62411077L * l29;
        l12 += l39 << 11 & 0xFFFFFFFL;
        l13 += l39 >> 17;
        l39 = 56915814L * l29;
        l13 += l39 << 11 & 0xFFFFFFFL;
        l14 += l39 >> 17;
        l39 = -97532854L * l29;
        l14 += l39 << 11 & 0xFFFFFFFL;
        l15 += l39 >> 17;
        l39 = -76509338L * l29;
        l15 += l39 << 11 & 0xFFFFFFFL;
        l16 += l39 >> 17;
        l39 = 75510783L * l29;
        l16 += l39 << 11 & 0xFFFFFFFL;
        l17 += l39 >> 17;
        l39 = 67962521L * l29;
        l17 += l39 << 11 & 0xFFFFFFFL;
        l18 += l39 >> 17;
        l39 = -25593732L * l29;
        l18 += l39 << 11 & 0xFFFFFFFL;
        l19 += l39 >> 17;
        l39 = 91L * l29;
        this.carryReduce1(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19 += l39 << 11 & 0xFFFFFFFL, l20 += l39 >> 17, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31, l32, l33, l34, l35, l36, l37, l38);
    }

    void carryReduce1(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28, long l29, long l30, long l31, long l32, long l33, long l34, long l35, long l36, long l37, long l38) {
        long l39 = l20 + 0x8000000L >> 28;
        l20 -= l39 << 28;
        l21 += l39;
        l39 = l21 + 0x8000000L >> 28;
        l21 -= l39 << 28;
        l22 += l39;
        l39 = l22 + 0x8000000L >> 28;
        l22 -= l39 << 28;
        l23 += l39;
        l39 = l23 + 0x8000000L >> 28;
        l23 -= l39 << 28;
        l24 += l39;
        l39 = l24 + 0x8000000L >> 28;
        l24 -= l39 << 28;
        l25 += l39;
        l39 = l25 + 0x8000000L >> 28;
        l25 -= l39 << 28;
        l26 += l39;
        l39 = l26 + 0x8000000L >> 28;
        l26 -= l39 << 28;
        l27 += l39;
        l39 = l27 + 0x8000000L >> 28;
        l27 -= l39 << 28;
        l28 += l39;
        l39 = -20472841L * l28;
        l9 += l39 << 11 & 0xFFFFFFFL;
        l10 += l39 >> 17;
        l39 = -117141993L * l28;
        l10 += l39 << 11 & 0xFFFFFFFL;
        l11 += l39 >> 17;
        l39 = 62411077L * l28;
        l11 += l39 << 11 & 0xFFFFFFFL;
        l12 += l39 >> 17;
        l39 = 56915814L * l28;
        l12 += l39 << 11 & 0xFFFFFFFL;
        l13 += l39 >> 17;
        l39 = -97532854L * l28;
        l13 += l39 << 11 & 0xFFFFFFFL;
        l14 += l39 >> 17;
        l39 = -76509338L * l28;
        l14 += l39 << 11 & 0xFFFFFFFL;
        l15 += l39 >> 17;
        l39 = 75510783L * l28;
        l15 += l39 << 11 & 0xFFFFFFFL;
        l16 += l39 >> 17;
        l39 = 67962521L * l28;
        l16 += l39 << 11 & 0xFFFFFFFL;
        l17 += l39 >> 17;
        l39 = -25593732L * l28;
        l17 += l39 << 11 & 0xFFFFFFFL;
        l18 += l39 >> 17;
        l39 = 91L * l28;
        l18 += l39 << 11 & 0xFFFFFFFL;
        l19 += l39 >> 17;
        l39 = -20472841L * l27;
        l8 += l39 << 11 & 0xFFFFFFFL;
        l9 += l39 >> 17;
        l39 = -117141993L * l27;
        l9 += l39 << 11 & 0xFFFFFFFL;
        l10 += l39 >> 17;
        l39 = 62411077L * l27;
        l10 += l39 << 11 & 0xFFFFFFFL;
        l11 += l39 >> 17;
        l39 = 56915814L * l27;
        l11 += l39 << 11 & 0xFFFFFFFL;
        l12 += l39 >> 17;
        l39 = -97532854L * l27;
        l12 += l39 << 11 & 0xFFFFFFFL;
        l13 += l39 >> 17;
        l39 = -76509338L * l27;
        l13 += l39 << 11 & 0xFFFFFFFL;
        l14 += l39 >> 17;
        l39 = 75510783L * l27;
        l14 += l39 << 11 & 0xFFFFFFFL;
        l15 += l39 >> 17;
        l39 = 67962521L * l27;
        l15 += l39 << 11 & 0xFFFFFFFL;
        l16 += l39 >> 17;
        l39 = -25593732L * l27;
        l16 += l39 << 11 & 0xFFFFFFFL;
        l17 += l39 >> 17;
        l39 = 91L * l27;
        l17 += l39 << 11 & 0xFFFFFFFL;
        l18 += l39 >> 17;
        l39 = -20472841L * l26;
        l7 += l39 << 11 & 0xFFFFFFFL;
        l8 += l39 >> 17;
        l39 = -117141993L * l26;
        l8 += l39 << 11 & 0xFFFFFFFL;
        l9 += l39 >> 17;
        l39 = 62411077L * l26;
        l9 += l39 << 11 & 0xFFFFFFFL;
        l10 += l39 >> 17;
        l39 = 56915814L * l26;
        l10 += l39 << 11 & 0xFFFFFFFL;
        l11 += l39 >> 17;
        l39 = -97532854L * l26;
        l11 += l39 << 11 & 0xFFFFFFFL;
        l12 += l39 >> 17;
        l39 = -76509338L * l26;
        l12 += l39 << 11 & 0xFFFFFFFL;
        l13 += l39 >> 17;
        l39 = 75510783L * l26;
        l13 += l39 << 11 & 0xFFFFFFFL;
        l14 += l39 >> 17;
        l39 = 67962521L * l26;
        l14 += l39 << 11 & 0xFFFFFFFL;
        l15 += l39 >> 17;
        l39 = -25593732L * l26;
        l15 += l39 << 11 & 0xFFFFFFFL;
        l16 += l39 >> 17;
        l39 = 91L * l26;
        l16 += l39 << 11 & 0xFFFFFFFL;
        l17 += l39 >> 17;
        l39 = -20472841L * l25;
        l6 += l39 << 11 & 0xFFFFFFFL;
        l7 += l39 >> 17;
        l39 = -117141993L * l25;
        l7 += l39 << 11 & 0xFFFFFFFL;
        l8 += l39 >> 17;
        l39 = 62411077L * l25;
        l8 += l39 << 11 & 0xFFFFFFFL;
        l9 += l39 >> 17;
        l39 = 56915814L * l25;
        l9 += l39 << 11 & 0xFFFFFFFL;
        l10 += l39 >> 17;
        l39 = -97532854L * l25;
        l10 += l39 << 11 & 0xFFFFFFFL;
        l11 += l39 >> 17;
        l39 = -76509338L * l25;
        l11 += l39 << 11 & 0xFFFFFFFL;
        l12 += l39 >> 17;
        l39 = 75510783L * l25;
        l12 += l39 << 11 & 0xFFFFFFFL;
        l13 += l39 >> 17;
        l39 = 67962521L * l25;
        l13 += l39 << 11 & 0xFFFFFFFL;
        l14 += l39 >> 17;
        l39 = -25593732L * l25;
        l14 += l39 << 11 & 0xFFFFFFFL;
        l15 += l39 >> 17;
        l39 = 91L * l25;
        l15 += l39 << 11 & 0xFFFFFFFL;
        l16 += l39 >> 17;
        l39 = -20472841L * l24;
        l5 += l39 << 11 & 0xFFFFFFFL;
        l6 += l39 >> 17;
        l39 = -117141993L * l24;
        l6 += l39 << 11 & 0xFFFFFFFL;
        l7 += l39 >> 17;
        l39 = 62411077L * l24;
        l7 += l39 << 11 & 0xFFFFFFFL;
        l8 += l39 >> 17;
        l39 = 56915814L * l24;
        l8 += l39 << 11 & 0xFFFFFFFL;
        l9 += l39 >> 17;
        l39 = -97532854L * l24;
        l9 += l39 << 11 & 0xFFFFFFFL;
        l10 += l39 >> 17;
        l39 = -76509338L * l24;
        l10 += l39 << 11 & 0xFFFFFFFL;
        l11 += l39 >> 17;
        l39 = 75510783L * l24;
        l11 += l39 << 11 & 0xFFFFFFFL;
        l12 += l39 >> 17;
        l39 = 67962521L * l24;
        l12 += l39 << 11 & 0xFFFFFFFL;
        l13 += l39 >> 17;
        l39 = -25593732L * l24;
        l13 += l39 << 11 & 0xFFFFFFFL;
        l14 += l39 >> 17;
        l39 = 91L * l24;
        l14 += l39 << 11 & 0xFFFFFFFL;
        l15 += l39 >> 17;
        l39 = -20472841L * l23;
        l4 += l39 << 11 & 0xFFFFFFFL;
        l5 += l39 >> 17;
        l39 = -117141993L * l23;
        l5 += l39 << 11 & 0xFFFFFFFL;
        l6 += l39 >> 17;
        l39 = 62411077L * l23;
        l6 += l39 << 11 & 0xFFFFFFFL;
        l7 += l39 >> 17;
        l39 = 56915814L * l23;
        l7 += l39 << 11 & 0xFFFFFFFL;
        l8 += l39 >> 17;
        l39 = -97532854L * l23;
        l8 += l39 << 11 & 0xFFFFFFFL;
        l9 += l39 >> 17;
        l39 = -76509338L * l23;
        l9 += l39 << 11 & 0xFFFFFFFL;
        l10 += l39 >> 17;
        l39 = 75510783L * l23;
        l10 += l39 << 11 & 0xFFFFFFFL;
        l11 += l39 >> 17;
        l39 = 67962521L * l23;
        l11 += l39 << 11 & 0xFFFFFFFL;
        l12 += l39 >> 17;
        l39 = -25593732L * l23;
        l12 += l39 << 11 & 0xFFFFFFFL;
        l13 += l39 >> 17;
        l39 = 91L * l23;
        l13 += l39 << 11 & 0xFFFFFFFL;
        l14 += l39 >> 17;
        l39 = -20472841L * l22;
        l3 += l39 << 11 & 0xFFFFFFFL;
        l4 += l39 >> 17;
        l39 = -117141993L * l22;
        l4 += l39 << 11 & 0xFFFFFFFL;
        l5 += l39 >> 17;
        l39 = 62411077L * l22;
        l5 += l39 << 11 & 0xFFFFFFFL;
        l6 += l39 >> 17;
        l39 = 56915814L * l22;
        l6 += l39 << 11 & 0xFFFFFFFL;
        l7 += l39 >> 17;
        l39 = -97532854L * l22;
        l7 += l39 << 11 & 0xFFFFFFFL;
        l8 += l39 >> 17;
        l39 = -76509338L * l22;
        l8 += l39 << 11 & 0xFFFFFFFL;
        l9 += l39 >> 17;
        l39 = 75510783L * l22;
        l9 += l39 << 11 & 0xFFFFFFFL;
        l10 += l39 >> 17;
        l39 = 67962521L * l22;
        l10 += l39 << 11 & 0xFFFFFFFL;
        l11 += l39 >> 17;
        l39 = -25593732L * l22;
        l11 += l39 << 11 & 0xFFFFFFFL;
        l12 += l39 >> 17;
        l39 = 91L * l22;
        l12 += l39 << 11 & 0xFFFFFFFL;
        l13 += l39 >> 17;
        l39 = -20472841L * l21;
        l2 += l39 << 11 & 0xFFFFFFFL;
        l3 += l39 >> 17;
        l39 = -117141993L * l21;
        l3 += l39 << 11 & 0xFFFFFFFL;
        l4 += l39 >> 17;
        l39 = 62411077L * l21;
        l4 += l39 << 11 & 0xFFFFFFFL;
        l5 += l39 >> 17;
        l39 = 56915814L * l21;
        l5 += l39 << 11 & 0xFFFFFFFL;
        l6 += l39 >> 17;
        l39 = -97532854L * l21;
        l6 += l39 << 11 & 0xFFFFFFFL;
        l7 += l39 >> 17;
        l39 = -76509338L * l21;
        l7 += l39 << 11 & 0xFFFFFFFL;
        l8 += l39 >> 17;
        l39 = 75510783L * l21;
        l8 += l39 << 11 & 0xFFFFFFFL;
        l9 += l39 >> 17;
        l39 = 67962521L * l21;
        l9 += l39 << 11 & 0xFFFFFFFL;
        l10 += l39 >> 17;
        l39 = -25593732L * l21;
        l10 += l39 << 11 & 0xFFFFFFFL;
        l11 += l39 >> 17;
        l39 = 91L * l21;
        l11 += l39 << 11 & 0xFFFFFFFL;
        l12 += l39 >> 17;
        l39 = -20472841L * l20;
        l += l39 << 11 & 0xFFFFFFFL;
        l2 += l39 >> 17;
        l39 = -117141993L * l20;
        l2 += l39 << 11 & 0xFFFFFFFL;
        l3 += l39 >> 17;
        l39 = 62411077L * l20;
        l3 += l39 << 11 & 0xFFFFFFFL;
        l4 += l39 >> 17;
        l39 = 56915814L * l20;
        l4 += l39 << 11 & 0xFFFFFFFL;
        l5 += l39 >> 17;
        l39 = -97532854L * l20;
        l5 += l39 << 11 & 0xFFFFFFFL;
        l6 += l39 >> 17;
        l39 = -76509338L * l20;
        l6 += l39 << 11 & 0xFFFFFFFL;
        l7 += l39 >> 17;
        l39 = 75510783L * l20;
        l7 += l39 << 11 & 0xFFFFFFFL;
        l8 += l39 >> 17;
        l39 = 67962521L * l20;
        l8 += l39 << 11 & 0xFFFFFFFL;
        l9 += l39 >> 17;
        l39 = -25593732L * l20;
        l9 += l39 << 11 & 0xFFFFFFFL;
        l10 += l39 >> 17;
        l39 = 91L * l20;
        l20 = 0L;
        this.carryReduce2(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10 += l39 << 11 & 0xFFFFFFFL, l11 += l39 >> 17, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31, l32, l33, l34, l35, l36, l37, l38);
    }

    void carryReduce2(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28, long l29, long l30, long l31, long l32, long l33, long l34, long l35, long l36, long l37, long l38) {
        long l39 = l + 0x8000000L >> 28;
        l -= l39 << 28;
        l2 += l39;
        l39 = l2 + 0x8000000L >> 28;
        l2 -= l39 << 28;
        l3 += l39;
        l39 = l3 + 0x8000000L >> 28;
        l3 -= l39 << 28;
        l4 += l39;
        l39 = l4 + 0x8000000L >> 28;
        l4 -= l39 << 28;
        l5 += l39;
        l39 = l5 + 0x8000000L >> 28;
        l5 -= l39 << 28;
        l6 += l39;
        l39 = l6 + 0x8000000L >> 28;
        l6 -= l39 << 28;
        l7 += l39;
        l39 = l7 + 0x8000000L >> 28;
        l7 -= l39 << 28;
        l8 += l39;
        l39 = l8 + 0x8000000L >> 28;
        l8 -= l39 << 28;
        l9 += l39;
        l39 = l9 + 0x8000000L >> 28;
        l9 -= l39 << 28;
        l10 += l39;
        l39 = l10 + 0x8000000L >> 28;
        l10 -= l39 << 28;
        l11 += l39;
        l39 = l11 + 0x8000000L >> 28;
        l11 -= l39 << 28;
        l12 += l39;
        l39 = l12 + 0x8000000L >> 28;
        l12 -= l39 << 28;
        l13 += l39;
        l39 = l13 + 0x8000000L >> 28;
        l13 -= l39 << 28;
        l14 += l39;
        l39 = l14 + 0x8000000L >> 28;
        l14 -= l39 << 28;
        l15 += l39;
        l39 = l15 + 0x8000000L >> 28;
        l15 -= l39 << 28;
        l16 += l39;
        l39 = l16 + 0x8000000L >> 28;
        l16 -= l39 << 28;
        l17 += l39;
        l39 = l17 + 0x8000000L >> 28;
        l17 -= l39 << 28;
        l18 += l39;
        l39 = l18 + 0x8000000L >> 28;
        l18 -= l39 << 28;
        l19 += l39;
        l39 = l19 + 0x8000000L >> 28;
        this.carryReduce3(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19 -= l39 << 28, l20 += l39, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31, l32, l33, l34, l35, l36, l37, l38);
    }

    void carryReduce3(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20, long l21, long l22, long l23, long l24, long l25, long l26, long l27, long l28, long l29, long l30, long l31, long l32, long l33, long l34, long l35, long l36, long l37, long l38) {
        long l39 = -20472841L * l20;
        l += l39 << 11 & 0xFFFFFFFL;
        l2 += l39 >> 17;
        l39 = -117141993L * l20;
        l2 += l39 << 11 & 0xFFFFFFFL;
        l3 += l39 >> 17;
        l39 = 62411077L * l20;
        l3 += l39 << 11 & 0xFFFFFFFL;
        l4 += l39 >> 17;
        l39 = 56915814L * l20;
        l4 += l39 << 11 & 0xFFFFFFFL;
        l5 += l39 >> 17;
        l39 = -97532854L * l20;
        l5 += l39 << 11 & 0xFFFFFFFL;
        l6 += l39 >> 17;
        l39 = -76509338L * l20;
        l6 += l39 << 11 & 0xFFFFFFFL;
        l7 += l39 >> 17;
        l39 = 75510783L * l20;
        l7 += l39 << 11 & 0xFFFFFFFL;
        l8 += l39 >> 17;
        l39 = 67962521L * l20;
        l8 += l39 << 11 & 0xFFFFFFFL;
        l9 += l39 >> 17;
        l39 = -25593732L * l20;
        l9 += l39 << 11 & 0xFFFFFFFL;
        l10 += l39 >> 17;
        l39 = 91L * l20;
        l10 += l39 << 11 & 0xFFFFFFFL;
        l11 += l39 >> 17;
        l39 = l + 0x8000000L >> 28;
        l -= l39 << 28;
        l2 += l39;
        l39 = l2 + 0x8000000L >> 28;
        l2 -= l39 << 28;
        l3 += l39;
        l39 = l3 + 0x8000000L >> 28;
        l3 -= l39 << 28;
        l4 += l39;
        l39 = l4 + 0x8000000L >> 28;
        l4 -= l39 << 28;
        l5 += l39;
        l39 = l5 + 0x8000000L >> 28;
        l5 -= l39 << 28;
        l6 += l39;
        l39 = l6 + 0x8000000L >> 28;
        l6 -= l39 << 28;
        l7 += l39;
        l39 = l7 + 0x8000000L >> 28;
        l7 -= l39 << 28;
        l8 += l39;
        l39 = l8 + 0x8000000L >> 28;
        l8 -= l39 << 28;
        l9 += l39;
        l39 = l9 + 0x8000000L >> 28;
        l9 -= l39 << 28;
        l10 += l39;
        l39 = l10 + 0x8000000L >> 28;
        l10 -= l39 << 28;
        l11 += l39;
        l39 = l11 + 0x8000000L >> 28;
        l11 -= l39 << 28;
        l12 += l39;
        l39 = l12 + 0x8000000L >> 28;
        l12 -= l39 << 28;
        l13 += l39;
        l39 = l13 + 0x8000000L >> 28;
        l13 -= l39 << 28;
        l14 += l39;
        l39 = l14 + 0x8000000L >> 28;
        l14 -= l39 << 28;
        l15 += l39;
        l39 = l15 + 0x8000000L >> 28;
        l15 -= l39 << 28;
        l16 += l39;
        l39 = l16 + 0x8000000L >> 28;
        l16 -= l39 << 28;
        l17 += l39;
        l39 = l17 + 0x8000000L >> 28;
        l17 -= l39 << 28;
        l18 += l39;
        l39 = l18 + 0x8000000L >> 28;
        l18 -= l39 << 28;
        l19 += l39;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
        lArray[10] = l11;
        lArray[11] = l12;
        lArray[12] = l13;
        lArray[13] = l14;
        lArray[14] = l15;
        lArray[15] = l16;
        lArray[16] = l17;
        lArray[17] = l18;
        lArray[18] = l19;
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19) {
        long l20 = 0L;
        long l21 = l + 0x8000000L >> 28;
        l -= l21 << 28;
        l2 += l21;
        l21 = l2 + 0x8000000L >> 28;
        l2 -= l21 << 28;
        l3 += l21;
        l21 = l3 + 0x8000000L >> 28;
        l3 -= l21 << 28;
        l4 += l21;
        l21 = l4 + 0x8000000L >> 28;
        l4 -= l21 << 28;
        l5 += l21;
        l21 = l5 + 0x8000000L >> 28;
        l5 -= l21 << 28;
        l6 += l21;
        l21 = l6 + 0x8000000L >> 28;
        l6 -= l21 << 28;
        l7 += l21;
        l21 = l7 + 0x8000000L >> 28;
        l7 -= l21 << 28;
        l8 += l21;
        l21 = l8 + 0x8000000L >> 28;
        l8 -= l21 << 28;
        l9 += l21;
        l21 = l9 + 0x8000000L >> 28;
        l9 -= l21 << 28;
        l10 += l21;
        l21 = l10 + 0x8000000L >> 28;
        l10 -= l21 << 28;
        l11 += l21;
        l21 = l11 + 0x8000000L >> 28;
        l11 -= l21 << 28;
        l12 += l21;
        l21 = l12 + 0x8000000L >> 28;
        l12 -= l21 << 28;
        l13 += l21;
        l21 = l13 + 0x8000000L >> 28;
        l13 -= l21 << 28;
        l14 += l21;
        l21 = l14 + 0x8000000L >> 28;
        l14 -= l21 << 28;
        l15 += l21;
        l21 = l15 + 0x8000000L >> 28;
        l15 -= l21 << 28;
        l16 += l21;
        l21 = l16 + 0x8000000L >> 28;
        l16 -= l21 << 28;
        l17 += l21;
        l21 = l17 + 0x8000000L >> 28;
        l17 -= l21 << 28;
        l18 += l21;
        l21 = l18 + 0x8000000L >> 28;
        l18 -= l21 << 28;
        l19 += l21;
        l21 = l19 + 0x8000000L >> 28;
        this.carryReduce0(lArray, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19 -= l21 << 28, l20 += l21);
    }

    void carryReduce0(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, long l13, long l14, long l15, long l16, long l17, long l18, long l19, long l20) {
        long l21 = -20472841L * l20;
        l += l21 << 11 & 0xFFFFFFFL;
        l2 += l21 >> 17;
        l21 = -117141993L * l20;
        l2 += l21 << 11 & 0xFFFFFFFL;
        l3 += l21 >> 17;
        l21 = 62411077L * l20;
        l3 += l21 << 11 & 0xFFFFFFFL;
        l4 += l21 >> 17;
        l21 = 56915814L * l20;
        l4 += l21 << 11 & 0xFFFFFFFL;
        l5 += l21 >> 17;
        l21 = -97532854L * l20;
        l5 += l21 << 11 & 0xFFFFFFFL;
        l6 += l21 >> 17;
        l21 = -76509338L * l20;
        l6 += l21 << 11 & 0xFFFFFFFL;
        l7 += l21 >> 17;
        l21 = 75510783L * l20;
        l7 += l21 << 11 & 0xFFFFFFFL;
        l8 += l21 >> 17;
        l21 = 67962521L * l20;
        l8 += l21 << 11 & 0xFFFFFFFL;
        l9 += l21 >> 17;
        l21 = -25593732L * l20;
        l9 += l21 << 11 & 0xFFFFFFFL;
        l10 += l21 >> 17;
        l21 = 91L * l20;
        l10 += l21 << 11 & 0xFFFFFFFL;
        l11 += l21 >> 17;
        l21 = l + 0x8000000L >> 28;
        l -= l21 << 28;
        l2 += l21;
        l21 = l2 + 0x8000000L >> 28;
        l2 -= l21 << 28;
        l3 += l21;
        l21 = l3 + 0x8000000L >> 28;
        l3 -= l21 << 28;
        l4 += l21;
        l21 = l4 + 0x8000000L >> 28;
        l4 -= l21 << 28;
        l5 += l21;
        l21 = l5 + 0x8000000L >> 28;
        l5 -= l21 << 28;
        l6 += l21;
        l21 = l6 + 0x8000000L >> 28;
        l6 -= l21 << 28;
        l7 += l21;
        l21 = l7 + 0x8000000L >> 28;
        l7 -= l21 << 28;
        l8 += l21;
        l21 = l8 + 0x8000000L >> 28;
        l8 -= l21 << 28;
        l9 += l21;
        l21 = l9 + 0x8000000L >> 28;
        l9 -= l21 << 28;
        l10 += l21;
        l21 = l10 + 0x8000000L >> 28;
        l10 -= l21 << 28;
        l11 += l21;
        l21 = l11 + 0x8000000L >> 28;
        l11 -= l21 << 28;
        l12 += l21;
        l21 = l12 + 0x8000000L >> 28;
        l12 -= l21 << 28;
        l13 += l21;
        l21 = l13 + 0x8000000L >> 28;
        l13 -= l21 << 28;
        l14 += l21;
        l21 = l14 + 0x8000000L >> 28;
        l14 -= l21 << 28;
        l15 += l21;
        l21 = l15 + 0x8000000L >> 28;
        l15 -= l21 << 28;
        l16 += l21;
        l21 = l16 + 0x8000000L >> 28;
        l16 -= l21 << 28;
        l17 += l21;
        l21 = l17 + 0x8000000L >> 28;
        l17 -= l21 << 28;
        l18 += l21;
        l21 = l18 + 0x8000000L >> 28;
        l18 -= l21 << 28;
        l19 += l21;
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        lArray[4] = l5;
        lArray[5] = l6;
        lArray[6] = l7;
        lArray[7] = l8;
        lArray[8] = l9;
        lArray[9] = l10;
        lArray[10] = l11;
        lArray[11] = l12;
        lArray[12] = l13;
        lArray[13] = l14;
        lArray[14] = l15;
        lArray[15] = l16;
        lArray[16] = l17;
        lArray[17] = l18;
        lArray[18] = l19;
    }

    @Override
    protected void mult(long[] lArray, long[] lArray2, long[] lArray3) {
        long l = lArray[0] * lArray2[0];
        long l2 = lArray[0] * lArray2[1] + lArray[1] * lArray2[0];
        long l3 = lArray[0] * lArray2[2] + lArray[1] * lArray2[1] + lArray[2] * lArray2[0];
        long l4 = lArray[0] * lArray2[3] + lArray[1] * lArray2[2] + lArray[2] * lArray2[1] + lArray[3] * lArray2[0];
        long l5 = lArray[0] * lArray2[4] + lArray[1] * lArray2[3] + lArray[2] * lArray2[2] + lArray[3] * lArray2[1] + lArray[4] * lArray2[0];
        long l6 = lArray[0] * lArray2[5] + lArray[1] * lArray2[4] + lArray[2] * lArray2[3] + lArray[3] * lArray2[2] + lArray[4] * lArray2[1] + lArray[5] * lArray2[0];
        long l7 = lArray[0] * lArray2[6] + lArray[1] * lArray2[5] + lArray[2] * lArray2[4] + lArray[3] * lArray2[3] + lArray[4] * lArray2[2] + lArray[5] * lArray2[1] + lArray[6] * lArray2[0];
        long l8 = lArray[0] * lArray2[7] + lArray[1] * lArray2[6] + lArray[2] * lArray2[5] + lArray[3] * lArray2[4] + lArray[4] * lArray2[3] + lArray[5] * lArray2[2] + lArray[6] * lArray2[1] + lArray[7] * lArray2[0];
        long l9 = lArray[0] * lArray2[8] + lArray[1] * lArray2[7] + lArray[2] * lArray2[6] + lArray[3] * lArray2[5] + lArray[4] * lArray2[4] + lArray[5] * lArray2[3] + lArray[6] * lArray2[2] + lArray[7] * lArray2[1] + lArray[8] * lArray2[0];
        long l10 = lArray[0] * lArray2[9] + lArray[1] * lArray2[8] + lArray[2] * lArray2[7] + lArray[3] * lArray2[6] + lArray[4] * lArray2[5] + lArray[5] * lArray2[4] + lArray[6] * lArray2[3] + lArray[7] * lArray2[2] + lArray[8] * lArray2[1] + lArray[9] * lArray2[0];
        long l11 = lArray[0] * lArray2[10] + lArray[1] * lArray2[9] + lArray[2] * lArray2[8] + lArray[3] * lArray2[7] + lArray[4] * lArray2[6] + lArray[5] * lArray2[5] + lArray[6] * lArray2[4] + lArray[7] * lArray2[3] + lArray[8] * lArray2[2] + lArray[9] * lArray2[1] + lArray[10] * lArray2[0];
        long l12 = lArray[0] * lArray2[11] + lArray[1] * lArray2[10] + lArray[2] * lArray2[9] + lArray[3] * lArray2[8] + lArray[4] * lArray2[7] + lArray[5] * lArray2[6] + lArray[6] * lArray2[5] + lArray[7] * lArray2[4] + lArray[8] * lArray2[3] + lArray[9] * lArray2[2] + lArray[10] * lArray2[1] + lArray[11] * lArray2[0];
        long l13 = lArray[0] * lArray2[12] + lArray[1] * lArray2[11] + lArray[2] * lArray2[10] + lArray[3] * lArray2[9] + lArray[4] * lArray2[8] + lArray[5] * lArray2[7] + lArray[6] * lArray2[6] + lArray[7] * lArray2[5] + lArray[8] * lArray2[4] + lArray[9] * lArray2[3] + lArray[10] * lArray2[2] + lArray[11] * lArray2[1] + lArray[12] * lArray2[0];
        long l14 = lArray[0] * lArray2[13] + lArray[1] * lArray2[12] + lArray[2] * lArray2[11] + lArray[3] * lArray2[10] + lArray[4] * lArray2[9] + lArray[5] * lArray2[8] + lArray[6] * lArray2[7] + lArray[7] * lArray2[6] + lArray[8] * lArray2[5] + lArray[9] * lArray2[4] + lArray[10] * lArray2[3] + lArray[11] * lArray2[2] + lArray[12] * lArray2[1] + lArray[13] * lArray2[0];
        long l15 = lArray[0] * lArray2[14] + lArray[1] * lArray2[13] + lArray[2] * lArray2[12] + lArray[3] * lArray2[11] + lArray[4] * lArray2[10] + lArray[5] * lArray2[9] + lArray[6] * lArray2[8] + lArray[7] * lArray2[7] + lArray[8] * lArray2[6] + lArray[9] * lArray2[5] + lArray[10] * lArray2[4] + lArray[11] * lArray2[3] + lArray[12] * lArray2[2] + lArray[13] * lArray2[1] + lArray[14] * lArray2[0];
        long l16 = lArray[0] * lArray2[15] + lArray[1] * lArray2[14] + lArray[2] * lArray2[13] + lArray[3] * lArray2[12] + lArray[4] * lArray2[11] + lArray[5] * lArray2[10] + lArray[6] * lArray2[9] + lArray[7] * lArray2[8] + lArray[8] * lArray2[7] + lArray[9] * lArray2[6] + lArray[10] * lArray2[5] + lArray[11] * lArray2[4] + lArray[12] * lArray2[3] + lArray[13] * lArray2[2] + lArray[14] * lArray2[1] + lArray[15] * lArray2[0];
        long l17 = lArray[0] * lArray2[16] + lArray[1] * lArray2[15] + lArray[2] * lArray2[14] + lArray[3] * lArray2[13] + lArray[4] * lArray2[12] + lArray[5] * lArray2[11] + lArray[6] * lArray2[10] + lArray[7] * lArray2[9] + lArray[8] * lArray2[8] + lArray[9] * lArray2[7] + lArray[10] * lArray2[6] + lArray[11] * lArray2[5] + lArray[12] * lArray2[4] + lArray[13] * lArray2[3] + lArray[14] * lArray2[2] + lArray[15] * lArray2[1] + lArray[16] * lArray2[0];
        long l18 = lArray[0] * lArray2[17] + lArray[1] * lArray2[16] + lArray[2] * lArray2[15] + lArray[3] * lArray2[14] + lArray[4] * lArray2[13] + lArray[5] * lArray2[12] + lArray[6] * lArray2[11] + lArray[7] * lArray2[10] + lArray[8] * lArray2[9] + lArray[9] * lArray2[8] + lArray[10] * lArray2[7] + lArray[11] * lArray2[6] + lArray[12] * lArray2[5] + lArray[13] * lArray2[4] + lArray[14] * lArray2[3] + lArray[15] * lArray2[2] + lArray[16] * lArray2[1] + lArray[17] * lArray2[0];
        long l19 = lArray[0] * lArray2[18] + lArray[1] * lArray2[17] + lArray[2] * lArray2[16] + lArray[3] * lArray2[15] + lArray[4] * lArray2[14] + lArray[5] * lArray2[13] + lArray[6] * lArray2[12] + lArray[7] * lArray2[11] + lArray[8] * lArray2[10] + lArray[9] * lArray2[9] + lArray[10] * lArray2[8] + lArray[11] * lArray2[7] + lArray[12] * lArray2[6] + lArray[13] * lArray2[5] + lArray[14] * lArray2[4] + lArray[15] * lArray2[3] + lArray[16] * lArray2[2] + lArray[17] * lArray2[1] + lArray[18] * lArray2[0];
        long l20 = lArray[1] * lArray2[18] + lArray[2] * lArray2[17] + lArray[3] * lArray2[16] + lArray[4] * lArray2[15] + lArray[5] * lArray2[14] + lArray[6] * lArray2[13] + lArray[7] * lArray2[12] + lArray[8] * lArray2[11] + lArray[9] * lArray2[10] + lArray[10] * lArray2[9] + lArray[11] * lArray2[8] + lArray[12] * lArray2[7] + lArray[13] * lArray2[6] + lArray[14] * lArray2[5] + lArray[15] * lArray2[4] + lArray[16] * lArray2[3] + lArray[17] * lArray2[2] + lArray[18] * lArray2[1];
        long l21 = lArray[2] * lArray2[18] + lArray[3] * lArray2[17] + lArray[4] * lArray2[16] + lArray[5] * lArray2[15] + lArray[6] * lArray2[14] + lArray[7] * lArray2[13] + lArray[8] * lArray2[12] + lArray[9] * lArray2[11] + lArray[10] * lArray2[10] + lArray[11] * lArray2[9] + lArray[12] * lArray2[8] + lArray[13] * lArray2[7] + lArray[14] * lArray2[6] + lArray[15] * lArray2[5] + lArray[16] * lArray2[4] + lArray[17] * lArray2[3] + lArray[18] * lArray2[2];
        long l22 = lArray[3] * lArray2[18] + lArray[4] * lArray2[17] + lArray[5] * lArray2[16] + lArray[6] * lArray2[15] + lArray[7] * lArray2[14] + lArray[8] * lArray2[13] + lArray[9] * lArray2[12] + lArray[10] * lArray2[11] + lArray[11] * lArray2[10] + lArray[12] * lArray2[9] + lArray[13] * lArray2[8] + lArray[14] * lArray2[7] + lArray[15] * lArray2[6] + lArray[16] * lArray2[5] + lArray[17] * lArray2[4] + lArray[18] * lArray2[3];
        long l23 = lArray[4] * lArray2[18] + lArray[5] * lArray2[17] + lArray[6] * lArray2[16] + lArray[7] * lArray2[15] + lArray[8] * lArray2[14] + lArray[9] * lArray2[13] + lArray[10] * lArray2[12] + lArray[11] * lArray2[11] + lArray[12] * lArray2[10] + lArray[13] * lArray2[9] + lArray[14] * lArray2[8] + lArray[15] * lArray2[7] + lArray[16] * lArray2[6] + lArray[17] * lArray2[5] + lArray[18] * lArray2[4];
        long l24 = lArray[5] * lArray2[18] + lArray[6] * lArray2[17] + lArray[7] * lArray2[16] + lArray[8] * lArray2[15] + lArray[9] * lArray2[14] + lArray[10] * lArray2[13] + lArray[11] * lArray2[12] + lArray[12] * lArray2[11] + lArray[13] * lArray2[10] + lArray[14] * lArray2[9] + lArray[15] * lArray2[8] + lArray[16] * lArray2[7] + lArray[17] * lArray2[6] + lArray[18] * lArray2[5];
        long l25 = lArray[6] * lArray2[18] + lArray[7] * lArray2[17] + lArray[8] * lArray2[16] + lArray[9] * lArray2[15] + lArray[10] * lArray2[14] + lArray[11] * lArray2[13] + lArray[12] * lArray2[12] + lArray[13] * lArray2[11] + lArray[14] * lArray2[10] + lArray[15] * lArray2[9] + lArray[16] * lArray2[8] + lArray[17] * lArray2[7] + lArray[18] * lArray2[6];
        long l26 = lArray[7] * lArray2[18] + lArray[8] * lArray2[17] + lArray[9] * lArray2[16] + lArray[10] * lArray2[15] + lArray[11] * lArray2[14] + lArray[12] * lArray2[13] + lArray[13] * lArray2[12] + lArray[14] * lArray2[11] + lArray[15] * lArray2[10] + lArray[16] * lArray2[9] + lArray[17] * lArray2[8] + lArray[18] * lArray2[7];
        long l27 = lArray[8] * lArray2[18] + lArray[9] * lArray2[17] + lArray[10] * lArray2[16] + lArray[11] * lArray2[15] + lArray[12] * lArray2[14] + lArray[13] * lArray2[13] + lArray[14] * lArray2[12] + lArray[15] * lArray2[11] + lArray[16] * lArray2[10] + lArray[17] * lArray2[9] + lArray[18] * lArray2[8];
        long l28 = lArray[9] * lArray2[18] + lArray[10] * lArray2[17] + lArray[11] * lArray2[16] + lArray[12] * lArray2[15] + lArray[13] * lArray2[14] + lArray[14] * lArray2[13] + lArray[15] * lArray2[12] + lArray[16] * lArray2[11] + lArray[17] * lArray2[10] + lArray[18] * lArray2[9];
        long l29 = lArray[10] * lArray2[18] + lArray[11] * lArray2[17] + lArray[12] * lArray2[16] + lArray[13] * lArray2[15] + lArray[14] * lArray2[14] + lArray[15] * lArray2[13] + lArray[16] * lArray2[12] + lArray[17] * lArray2[11] + lArray[18] * lArray2[10];
        long l30 = lArray[11] * lArray2[18] + lArray[12] * lArray2[17] + lArray[13] * lArray2[16] + lArray[14] * lArray2[15] + lArray[15] * lArray2[14] + lArray[16] * lArray2[13] + lArray[17] * lArray2[12] + lArray[18] * lArray2[11];
        long l31 = lArray[12] * lArray2[18] + lArray[13] * lArray2[17] + lArray[14] * lArray2[16] + lArray[15] * lArray2[15] + lArray[16] * lArray2[14] + lArray[17] * lArray2[13] + lArray[18] * lArray2[12];
        long l32 = lArray[13] * lArray2[18] + lArray[14] * lArray2[17] + lArray[15] * lArray2[16] + lArray[16] * lArray2[15] + lArray[17] * lArray2[14] + lArray[18] * lArray2[13];
        long l33 = lArray[14] * lArray2[18] + lArray[15] * lArray2[17] + lArray[16] * lArray2[16] + lArray[17] * lArray2[15] + lArray[18] * lArray2[14];
        long l34 = lArray[15] * lArray2[18] + lArray[16] * lArray2[17] + lArray[17] * lArray2[16] + lArray[18] * lArray2[15];
        long l35 = lArray[16] * lArray2[18] + lArray[17] * lArray2[17] + lArray[18] * lArray2[16];
        long l36 = lArray[17] * lArray2[18] + lArray[18] * lArray2[17];
        long l37 = lArray[18] * lArray2[18];
        this.carryReduce(lArray3, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31, l32, l33, l34, l35, l36, l37);
    }

    @Override
    protected void reduce(long[] lArray) {
        this.carryReduce(lArray, lArray[0], lArray[1], lArray[2], lArray[3], lArray[4], lArray[5], lArray[6], lArray[7], lArray[8], lArray[9], lArray[10], lArray[11], lArray[12], lArray[13], lArray[14], lArray[15], lArray[16], lArray[17], lArray[18]);
    }

    @Override
    protected void square(long[] lArray, long[] lArray2) {
        long l = lArray[0] * lArray[0];
        long l2 = 2L * (lArray[0] * lArray[1]);
        long l3 = 2L * (lArray[0] * lArray[2]) + lArray[1] * lArray[1];
        long l4 = 2L * (lArray[0] * lArray[3] + lArray[1] * lArray[2]);
        long l5 = 2L * (lArray[0] * lArray[4] + lArray[1] * lArray[3]) + lArray[2] * lArray[2];
        long l6 = 2L * (lArray[0] * lArray[5] + lArray[1] * lArray[4] + lArray[2] * lArray[3]);
        long l7 = 2L * (lArray[0] * lArray[6] + lArray[1] * lArray[5] + lArray[2] * lArray[4]) + lArray[3] * lArray[3];
        long l8 = 2L * (lArray[0] * lArray[7] + lArray[1] * lArray[6] + lArray[2] * lArray[5] + lArray[3] * lArray[4]);
        long l9 = 2L * (lArray[0] * lArray[8] + lArray[1] * lArray[7] + lArray[2] * lArray[6] + lArray[3] * lArray[5]) + lArray[4] * lArray[4];
        long l10 = 2L * (lArray[0] * lArray[9] + lArray[1] * lArray[8] + lArray[2] * lArray[7] + lArray[3] * lArray[6] + lArray[4] * lArray[5]);
        long l11 = 2L * (lArray[0] * lArray[10] + lArray[1] * lArray[9] + lArray[2] * lArray[8] + lArray[3] * lArray[7] + lArray[4] * lArray[6]) + lArray[5] * lArray[5];
        long l12 = 2L * (lArray[0] * lArray[11] + lArray[1] * lArray[10] + lArray[2] * lArray[9] + lArray[3] * lArray[8] + lArray[4] * lArray[7] + lArray[5] * lArray[6]);
        long l13 = 2L * (lArray[0] * lArray[12] + lArray[1] * lArray[11] + lArray[2] * lArray[10] + lArray[3] * lArray[9] + lArray[4] * lArray[8] + lArray[5] * lArray[7]) + lArray[6] * lArray[6];
        long l14 = 2L * (lArray[0] * lArray[13] + lArray[1] * lArray[12] + lArray[2] * lArray[11] + lArray[3] * lArray[10] + lArray[4] * lArray[9] + lArray[5] * lArray[8] + lArray[6] * lArray[7]);
        long l15 = 2L * (lArray[0] * lArray[14] + lArray[1] * lArray[13] + lArray[2] * lArray[12] + lArray[3] * lArray[11] + lArray[4] * lArray[10] + lArray[5] * lArray[9] + lArray[6] * lArray[8]) + lArray[7] * lArray[7];
        long l16 = 2L * (lArray[0] * lArray[15] + lArray[1] * lArray[14] + lArray[2] * lArray[13] + lArray[3] * lArray[12] + lArray[4] * lArray[11] + lArray[5] * lArray[10] + lArray[6] * lArray[9] + lArray[7] * lArray[8]);
        long l17 = 2L * (lArray[0] * lArray[16] + lArray[1] * lArray[15] + lArray[2] * lArray[14] + lArray[3] * lArray[13] + lArray[4] * lArray[12] + lArray[5] * lArray[11] + lArray[6] * lArray[10] + lArray[7] * lArray[9]) + lArray[8] * lArray[8];
        long l18 = 2L * (lArray[0] * lArray[17] + lArray[1] * lArray[16] + lArray[2] * lArray[15] + lArray[3] * lArray[14] + lArray[4] * lArray[13] + lArray[5] * lArray[12] + lArray[6] * lArray[11] + lArray[7] * lArray[10] + lArray[8] * lArray[9]);
        long l19 = 2L * (lArray[0] * lArray[18] + lArray[1] * lArray[17] + lArray[2] * lArray[16] + lArray[3] * lArray[15] + lArray[4] * lArray[14] + lArray[5] * lArray[13] + lArray[6] * lArray[12] + lArray[7] * lArray[11] + lArray[8] * lArray[10]) + lArray[9] * lArray[9];
        long l20 = 2L * (lArray[1] * lArray[18] + lArray[2] * lArray[17] + lArray[3] * lArray[16] + lArray[4] * lArray[15] + lArray[5] * lArray[14] + lArray[6] * lArray[13] + lArray[7] * lArray[12] + lArray[8] * lArray[11] + lArray[9] * lArray[10]);
        long l21 = 2L * (lArray[2] * lArray[18] + lArray[3] * lArray[17] + lArray[4] * lArray[16] + lArray[5] * lArray[15] + lArray[6] * lArray[14] + lArray[7] * lArray[13] + lArray[8] * lArray[12] + lArray[9] * lArray[11]) + lArray[10] * lArray[10];
        long l22 = 2L * (lArray[3] * lArray[18] + lArray[4] * lArray[17] + lArray[5] * lArray[16] + lArray[6] * lArray[15] + lArray[7] * lArray[14] + lArray[8] * lArray[13] + lArray[9] * lArray[12] + lArray[10] * lArray[11]);
        long l23 = 2L * (lArray[4] * lArray[18] + lArray[5] * lArray[17] + lArray[6] * lArray[16] + lArray[7] * lArray[15] + lArray[8] * lArray[14] + lArray[9] * lArray[13] + lArray[10] * lArray[12]) + lArray[11] * lArray[11];
        long l24 = 2L * (lArray[5] * lArray[18] + lArray[6] * lArray[17] + lArray[7] * lArray[16] + lArray[8] * lArray[15] + lArray[9] * lArray[14] + lArray[10] * lArray[13] + lArray[11] * lArray[12]);
        long l25 = 2L * (lArray[6] * lArray[18] + lArray[7] * lArray[17] + lArray[8] * lArray[16] + lArray[9] * lArray[15] + lArray[10] * lArray[14] + lArray[11] * lArray[13]) + lArray[12] * lArray[12];
        long l26 = 2L * (lArray[7] * lArray[18] + lArray[8] * lArray[17] + lArray[9] * lArray[16] + lArray[10] * lArray[15] + lArray[11] * lArray[14] + lArray[12] * lArray[13]);
        long l27 = 2L * (lArray[8] * lArray[18] + lArray[9] * lArray[17] + lArray[10] * lArray[16] + lArray[11] * lArray[15] + lArray[12] * lArray[14]) + lArray[13] * lArray[13];
        long l28 = 2L * (lArray[9] * lArray[18] + lArray[10] * lArray[17] + lArray[11] * lArray[16] + lArray[12] * lArray[15] + lArray[13] * lArray[14]);
        long l29 = 2L * (lArray[10] * lArray[18] + lArray[11] * lArray[17] + lArray[12] * lArray[16] + lArray[13] * lArray[15]) + lArray[14] * lArray[14];
        long l30 = 2L * (lArray[11] * lArray[18] + lArray[12] * lArray[17] + lArray[13] * lArray[16] + lArray[14] * lArray[15]);
        long l31 = 2L * (lArray[12] * lArray[18] + lArray[13] * lArray[17] + lArray[14] * lArray[16]) + lArray[15] * lArray[15];
        long l32 = 2L * (lArray[13] * lArray[18] + lArray[14] * lArray[17] + lArray[15] * lArray[16]);
        long l33 = 2L * (lArray[14] * lArray[18] + lArray[15] * lArray[17]) + lArray[16] * lArray[16];
        long l34 = 2L * (lArray[15] * lArray[18] + lArray[16] * lArray[17]);
        long l35 = 2L * (lArray[16] * lArray[18]) + lArray[17] * lArray[17];
        long l36 = 2L * (lArray[17] * lArray[18]);
        long l37 = lArray[18] * lArray[18];
        this.carryReduce(lArray2, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, l14, l15, l16, l17, l18, l19, l20, l21, l22, l23, l24, l25, l26, l27, l28, l29, l30, l31, l32, l33, l34, l35, l36, l37);
    }
}

