/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import sun.awt.CGraphicsConfig;
import sun.awt.CGraphicsEnvironment;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLLayer;
import sun.java2d.opengl.CGLSurfaceData;
import sun.lwawt.LWWindowPeer;
import sun.lwawt.macosx.CFRetainedResource;
import sun.lwawt.macosx.CPlatformResponder;
import sun.lwawt.macosx.CWrapper;
import sun.lwawt.macosx.LWCToolkit;
import sun.lwawt.macosx.NSEvent;

public class CPlatformView
extends CFRetainedResource {
    private LWWindowPeer peer;
    private SurfaceData surfaceData;
    private CGLLayer windowLayer;
    private CPlatformResponder responder;

    private native long nativeCreateView(int var1, int var2, int var3, int var4, long var5);

    private static native void nativeSetAutoResizable(long var0, boolean var2);

    private static native int nativeGetNSViewDisplayID(long var0);

    private static native Rectangle2D nativeGetLocationOnScreen(long var0);

    private static native boolean nativeIsViewUnderMouse(long var0);

    public CPlatformView() {
        super(0L, true);
    }

    public void initialize(LWWindowPeer lWWindowPeer, CPlatformResponder cPlatformResponder) {
        this.initializeBase(lWWindowPeer, cPlatformResponder);
        if (!LWCToolkit.getSunAwtDisableCALayers()) {
            this.windowLayer = this.createCGLayer();
        }
        this.setPtr(this.nativeCreateView(0, 0, 0, 0, this.getWindowLayerPtr()));
    }

    public CGLLayer createCGLayer() {
        return new CGLLayer(this.peer);
    }

    protected void initializeBase(LWWindowPeer lWWindowPeer, CPlatformResponder cPlatformResponder) {
        this.peer = lWWindowPeer;
        this.responder = cPlatformResponder;
    }

    public long getAWTView() {
        return this.ptr;
    }

    public boolean isOpaque() {
        return !this.peer.isTranslucent();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.execute(l -> CWrapper.NSView.setFrame(l, n, n2, n3, n4));
    }

    public Rectangle getBounds() {
        return this.peer.getBounds();
    }

    public Object getDestination() {
        return this.peer;
    }

    public void setToolTip(String string) {
        this.execute(l -> CWrapper.NSView.setToolTip(l, string));
    }

    public SurfaceData replaceSurfaceData() {
        if (!LWCToolkit.getSunAwtDisableCALayers()) {
            this.surfaceData = this.windowLayer.replaceSurfaceData();
        } else if (this.surfaceData == null) {
            CGraphicsConfig cGraphicsConfig = (CGraphicsConfig)this.getGraphicsConfiguration();
            this.surfaceData = cGraphicsConfig.createSurfaceData(this);
        } else {
            this.validateSurface();
        }
        return this.surfaceData;
    }

    private void validateSurface() {
        if (this.surfaceData != null) {
            ((CGLSurfaceData)this.surfaceData).validate();
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.peer.getGraphicsConfiguration();
    }

    public SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    @Override
    public void dispose() {
        if (!LWCToolkit.getSunAwtDisableCALayers()) {
            this.windowLayer.dispose();
        }
        super.dispose();
    }

    public long getWindowLayerPtr() {
        if (!LWCToolkit.getSunAwtDisableCALayers()) {
            return this.windowLayer.getPointer();
        }
        return 0L;
    }

    public void setAutoResizable(boolean bl) {
        this.execute(l -> CPlatformView.nativeSetAutoResizable(l, bl));
    }

    public boolean isUnderMouse() {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        this.execute(l -> atomicBoolean.set(CPlatformView.nativeIsViewUnderMouse(l)));
        return atomicBoolean.get();
    }

    public GraphicsDevice getGraphicsDevice() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        CGraphicsEnvironment cGraphicsEnvironment = (CGraphicsEnvironment)graphicsEnvironment;
        AtomicInteger atomicInteger = new AtomicInteger();
        this.execute(l -> atomicInteger.set(CPlatformView.nativeGetNSViewDisplayID(l)));
        GraphicsDevice graphicsDevice = cGraphicsEnvironment.getScreenDevice(atomicInteger.get());
        if (graphicsDevice == null) {
            graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        }
        return graphicsDevice;
    }

    public Point getLocationOnScreen() {
        AtomicReference atomicReference = new AtomicReference();
        this.execute(l -> atomicReference.set(CPlatformView.nativeGetLocationOnScreen(l).getBounds()));
        Rectangle rectangle = (Rectangle)atomicReference.get();
        if (rectangle != null) {
            return new Point(rectangle.x, rectangle.y);
        }
        return new Point(0, 0);
    }

    private void deliverResize(int n, int n2, int n3, int n4) {
        this.peer.notifyReshape(n, n2, n3, n4);
    }

    private void deliverMouseEvent(NSEvent nSEvent) {
        int n = nSEvent.getX();
        int n2 = this.getBounds().height - nSEvent.getY();
        if (nSEvent.getType() == 22) {
            this.responder.handleScrollEvent(n, n2, nSEvent.getModifierFlags(), nSEvent.getScrollDeltaX(), nSEvent.getScrollDeltaY(), nSEvent.getScrollPhase());
        } else {
            this.responder.handleMouseEvent(nSEvent.getType(), nSEvent.getModifierFlags(), nSEvent.getButtonNumber(), nSEvent.getClickCount(), n, n2, nSEvent.getAbsX(), nSEvent.getAbsY());
        }
    }

    private void deliverKeyEvent(NSEvent nSEvent) {
        this.responder.handleKeyEvent(nSEvent.getType(), nSEvent.getModifierFlags(), nSEvent.getCharacters(), nSEvent.getCharactersIgnoringModifiers(), nSEvent.getKeyCode(), true, false);
    }

    private void deliverWindowDidExposeEvent() {
        this.peer.notifyExpose(this.peer.getSize());
    }
}

