/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import com.sun.jmx.mbeanserver.GetPropertyAction;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;

public abstract class OpenType<T>
implements Serializable {
    static final long serialVersionUID = -9195195325186646468L;
    public static final List<String> ALLOWED_CLASSNAMES_LIST = Collections.unmodifiableList(Arrays.asList("java.lang.Void", "java.lang.Boolean", "java.lang.Character", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.String", "java.math.BigDecimal", "java.math.BigInteger", "java.util.Date", "javax.management.ObjectName", CompositeData.class.getName(), TabularData.class.getName()));
    @Deprecated
    public static final String[] ALLOWED_CLASSNAMES = ALLOWED_CLASSNAMES_LIST.toArray(new String[0]);
    private String className;
    private String description;
    private String typeName;
    private transient boolean isArray = false;
    private transient Descriptor descriptor;

    protected OpenType(String string, String string2, String string3) throws OpenDataException {
        this.checkClassNameOverride();
        this.typeName = OpenType.valid("typeName", string2);
        this.description = OpenType.valid("description", string3);
        this.className = OpenType.validClassName(string);
        this.isArray = this.className != null && this.className.startsWith("[");
    }

    OpenType(String string, String string2, String string3, boolean bl) {
        this.className = OpenType.valid("className", string);
        this.typeName = OpenType.valid("typeName", string2);
        this.description = OpenType.valid("description", string3);
        this.isArray = bl;
    }

    private void checkClassNameOverride() throws SecurityException {
        GetPropertyAction getPropertyAction;
        if (this.getClass().getClassLoader() == null) {
            return;
        }
        if (OpenType.overridesGetClassName(this.getClass()) && AccessController.doPrivileged(getPropertyAction = new GetPropertyAction("jmx.extend.open.types")) == null) {
            throw new SecurityException("Cannot override getClassName() unless -Djmx.extend.open.types");
        }
    }

    private static boolean overridesGetClassName(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    return clazz.getMethod("getClassName", new Class[0]).getDeclaringClass() != OpenType.class;
                }
                catch (Exception exception) {
                    return true;
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String validClassName(String string) throws OpenDataException {
        String string2;
        string = OpenType.valid("className", string);
        int n = 0;
        while (string.startsWith("[", n)) {
            ++n;
        }
        boolean bl = false;
        if (n > 0) {
            if (string.startsWith("L", n) && string.endsWith(";")) {
                string2 = string.substring(n + 1, string.length() - 1);
            } else {
                if (n != string.length() - 1) throw new OpenDataException("Argument className=\"" + string + "\" is not a valid class name");
                string2 = string.substring(n, string.length());
                bl = true;
            }
        } else {
            string2 = string;
        }
        boolean bl2 = false;
        bl2 = bl ? ArrayType.isPrimitiveContentType(string2) : ALLOWED_CLASSNAMES_LIST.contains(string2);
        if (bl2) return string;
        throw new OpenDataException("Argument className=\"" + string + "\" is not one of the allowed Java class names for open data.");
    }

    private static String valid(String string, String string2) {
        if (string2 == null || (string2 = string2.trim()).equals("")) {
            throw new IllegalArgumentException("Argument " + string + " cannot be null or empty");
        }
        return string2;
    }

    synchronized Descriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new ImmutableDescriptor(new String[]{"openType"}, new Object[]{this});
        }
        return this.descriptor;
    }

    public String getClassName() {
        return this.className;
    }

    String safeGetClassName() {
        return this.className;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public abstract boolean isValue(Object var1);

    boolean isAssignableFrom(OpenType<?> openType) {
        return this.equals(openType);
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string;
        String string2;
        String string3;
        this.checkClassNameOverride();
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        try {
            string3 = OpenType.validClassName((String)getField.get("className", null));
            string2 = OpenType.valid("description", (String)getField.get("description", null));
            string = OpenType.valid("typeName", (String)getField.get("typeName", null));
        }
        catch (Exception exception) {
            InvalidObjectException invalidObjectException = new InvalidObjectException(exception.getMessage());
            invalidObjectException.initCause(exception);
            throw invalidObjectException;
        }
        this.className = string3;
        this.description = string2;
        this.typeName = string;
        this.isArray = this.className.startsWith("[");
    }
}

