/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileKey;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixUserPrincipals;

class UnixFileAttributes
implements PosixFileAttributes {
    private int st_mode;
    private long st_ino;
    private long st_dev;
    private long st_rdev;
    private int st_nlink;
    private int st_uid;
    private int st_gid;
    private long st_size;
    private long st_atime_sec;
    private long st_atime_nsec;
    private long st_mtime_sec;
    private long st_mtime_nsec;
    private long st_ctime_sec;
    private long st_ctime_nsec;
    private long st_birthtime_sec;
    private volatile UserPrincipal owner;
    private volatile GroupPrincipal group;
    private volatile UnixFileKey key;

    private UnixFileAttributes() {
    }

    static UnixFileAttributes get(UnixPath unixPath, boolean bl) throws UnixException {
        UnixFileAttributes unixFileAttributes = new UnixFileAttributes();
        if (bl) {
            UnixNativeDispatcher.stat(unixPath, unixFileAttributes);
        } else {
            UnixNativeDispatcher.lstat(unixPath, unixFileAttributes);
        }
        return unixFileAttributes;
    }

    static UnixFileAttributes get(int n) throws UnixException {
        UnixFileAttributes unixFileAttributes = new UnixFileAttributes();
        UnixNativeDispatcher.fstat(n, unixFileAttributes);
        return unixFileAttributes;
    }

    static UnixFileAttributes get(int n, UnixPath unixPath, boolean bl) throws UnixException {
        UnixFileAttributes unixFileAttributes = new UnixFileAttributes();
        int n2 = bl ? 0 : 4096;
        UnixNativeDispatcher.fstatat(n, unixPath.asByteArray(), n2, unixFileAttributes);
        return unixFileAttributes;
    }

    boolean isSameFile(UnixFileAttributes unixFileAttributes) {
        return this.st_ino == unixFileAttributes.st_ino && this.st_dev == unixFileAttributes.st_dev;
    }

    int mode() {
        return this.st_mode;
    }

    long ino() {
        return this.st_ino;
    }

    long dev() {
        return this.st_dev;
    }

    long rdev() {
        return this.st_rdev;
    }

    int nlink() {
        return this.st_nlink;
    }

    int uid() {
        return this.st_uid;
    }

    int gid() {
        return this.st_gid;
    }

    private static FileTime toFileTime(long l, long l2) {
        if (l2 == 0L) {
            return FileTime.from(l, TimeUnit.SECONDS);
        }
        long l3 = l * 1000000L + l2 / 1000L;
        return FileTime.from(l3, TimeUnit.MICROSECONDS);
    }

    FileTime ctime() {
        return UnixFileAttributes.toFileTime(this.st_ctime_sec, this.st_ctime_nsec);
    }

    boolean isDevice() {
        int n = this.st_mode & 0xF000;
        return n == 8192 || n == 24576 || n == 4096;
    }

    @Override
    public FileTime lastModifiedTime() {
        return UnixFileAttributes.toFileTime(this.st_mtime_sec, this.st_mtime_nsec);
    }

    @Override
    public FileTime lastAccessTime() {
        return UnixFileAttributes.toFileTime(this.st_atime_sec, this.st_atime_nsec);
    }

    @Override
    public FileTime creationTime() {
        if (UnixNativeDispatcher.birthtimeSupported()) {
            return FileTime.from(this.st_birthtime_sec, TimeUnit.SECONDS);
        }
        return this.lastModifiedTime();
    }

    @Override
    public boolean isRegularFile() {
        return (this.st_mode & 0xF000) == 32768;
    }

    @Override
    public boolean isDirectory() {
        return (this.st_mode & 0xF000) == 16384;
    }

    @Override
    public boolean isSymbolicLink() {
        return (this.st_mode & 0xF000) == 40960;
    }

    @Override
    public boolean isOther() {
        int n = this.st_mode & 0xF000;
        return n != 32768 && n != 16384 && n != 40960;
    }

    @Override
    public long size() {
        return this.st_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnixFileKey fileKey() {
        if (this.key == null) {
            UnixFileAttributes unixFileAttributes = this;
            synchronized (unixFileAttributes) {
                if (this.key == null) {
                    this.key = new UnixFileKey(this.st_dev, this.st_ino);
                }
            }
        }
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserPrincipal owner() {
        if (this.owner == null) {
            UnixFileAttributes unixFileAttributes = this;
            synchronized (unixFileAttributes) {
                if (this.owner == null) {
                    this.owner = UnixUserPrincipals.fromUid(this.st_uid);
                }
            }
        }
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GroupPrincipal group() {
        if (this.group == null) {
            UnixFileAttributes unixFileAttributes = this;
            synchronized (unixFileAttributes) {
                if (this.group == null) {
                    this.group = UnixUserPrincipals.fromGid(this.st_gid);
                }
            }
        }
        return this.group;
    }

    @Override
    public Set<PosixFilePermission> permissions() {
        int n = this.st_mode & 0x1FF;
        HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>();
        if ((n & 0x100) > 0) {
            hashSet.add(PosixFilePermission.OWNER_READ);
        }
        if ((n & 0x80) > 0) {
            hashSet.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((n & 0x40) > 0) {
            hashSet.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((n & 0x20) > 0) {
            hashSet.add(PosixFilePermission.GROUP_READ);
        }
        if ((n & 0x10) > 0) {
            hashSet.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((n & 8) > 0) {
            hashSet.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((n & 4) > 0) {
            hashSet.add(PosixFilePermission.OTHERS_READ);
        }
        if ((n & 2) > 0) {
            hashSet.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((n & 1) > 0) {
            hashSet.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return hashSet;
    }

    BasicFileAttributes asBasicFileAttributes() {
        return UnixAsBasicFileAttributes.wrap(this);
    }

    static UnixFileAttributes toUnixFileAttributes(BasicFileAttributes basicFileAttributes) {
        if (basicFileAttributes instanceof UnixFileAttributes) {
            return (UnixFileAttributes)basicFileAttributes;
        }
        if (basicFileAttributes instanceof UnixAsBasicFileAttributes) {
            return ((UnixAsBasicFileAttributes)basicFileAttributes).unwrap();
        }
        return null;
    }

    private static class UnixAsBasicFileAttributes
    implements BasicFileAttributes {
        private final UnixFileAttributes attrs;

        private UnixAsBasicFileAttributes(UnixFileAttributes unixFileAttributes) {
            this.attrs = unixFileAttributes;
        }

        static UnixAsBasicFileAttributes wrap(UnixFileAttributes unixFileAttributes) {
            return new UnixAsBasicFileAttributes(unixFileAttributes);
        }

        UnixFileAttributes unwrap() {
            return this.attrs;
        }

        @Override
        public FileTime lastModifiedTime() {
            return this.attrs.lastModifiedTime();
        }

        @Override
        public FileTime lastAccessTime() {
            return this.attrs.lastAccessTime();
        }

        @Override
        public FileTime creationTime() {
            return this.attrs.creationTime();
        }

        @Override
        public boolean isRegularFile() {
            return this.attrs.isRegularFile();
        }

        @Override
        public boolean isDirectory() {
            return this.attrs.isDirectory();
        }

        @Override
        public boolean isSymbolicLink() {
            return this.attrs.isSymbolicLink();
        }

        @Override
        public boolean isOther() {
            return this.attrs.isOther();
        }

        @Override
        public long size() {
            return this.attrs.size();
        }

        @Override
        public Object fileKey() {
            return this.attrs.fileKey();
        }
    }
}

