/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.protocol.giopmsgheaders;

import com.sun.corba.se.impl.encoding.CDRInputStream;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageHandler;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message_1_1;
import com.sun.corba.se.impl.protocol.giopmsgheaders.ReplyMessage;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.IORFactories;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.servicecontext.ServiceContexts;
import java.io.IOException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class ReplyMessage_1_1
extends Message_1_1
implements ReplyMessage {
    private ORB orb = null;
    private ORBUtilSystemException wrapper = null;
    private ServiceContexts service_contexts = null;
    private int request_id = 0;
    private int reply_status = 0;
    private IOR ior = null;
    private String exClassName = null;
    private int minorCode = 0;
    private CompletionStatus completionStatus = null;

    ReplyMessage_1_1(ORB oRB) {
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.protocol");
    }

    ReplyMessage_1_1(ORB oRB, ServiceContexts serviceContexts, int n, int n2, IOR iOR) {
        super(1195986768, GIOPVersion.V1_1, (byte)0, (byte)1, 0);
        this.orb = oRB;
        this.wrapper = ORBUtilSystemException.get(oRB, "rpc.protocol");
        this.service_contexts = serviceContexts;
        this.request_id = n;
        this.reply_status = n2;
        this.ior = iOR;
    }

    @Override
    public int getRequestId() {
        return this.request_id;
    }

    @Override
    public int getReplyStatus() {
        return this.reply_status;
    }

    @Override
    public short getAddrDisposition() {
        return 0;
    }

    @Override
    public ServiceContexts getServiceContexts() {
        return this.service_contexts;
    }

    @Override
    public void setServiceContexts(ServiceContexts serviceContexts) {
        this.service_contexts = serviceContexts;
    }

    @Override
    public SystemException getSystemException(String string) {
        return MessageBase.getSystemException(this.exClassName, this.minorCode, this.completionStatus, string, this.wrapper);
    }

    @Override
    public IOR getIOR() {
        return this.ior;
    }

    @Override
    public void setIOR(IOR iOR) {
        this.ior = iOR;
    }

    @Override
    public void read(org.omg.CORBA.portable.InputStream inputStream) {
        super.read(inputStream);
        this.service_contexts = new ServiceContexts((InputStream)inputStream);
        this.request_id = inputStream.read_ulong();
        this.reply_status = inputStream.read_long();
        ReplyMessage_1_1.isValidReplyStatus(this.reply_status);
        if (this.reply_status == 2) {
            String string = inputStream.read_string();
            this.exClassName = ORBUtility.classNameOf(string);
            this.minorCode = inputStream.read_long();
            int n = inputStream.read_long();
            switch (n) {
                case 0: {
                    this.completionStatus = CompletionStatus.COMPLETED_YES;
                    break;
                }
                case 1: {
                    this.completionStatus = CompletionStatus.COMPLETED_NO;
                    break;
                }
                case 2: {
                    this.completionStatus = CompletionStatus.COMPLETED_MAYBE;
                    break;
                }
                default: {
                    throw this.wrapper.badCompletionStatusInReply(CompletionStatus.COMPLETED_MAYBE, (Object)new Integer(n));
                }
            }
        } else if (this.reply_status != 1 && this.reply_status == 3) {
            CDRInputStream cDRInputStream = (CDRInputStream)inputStream;
            this.ior = IORFactories.makeIOR(cDRInputStream);
        }
    }

    @Override
    public void write(org.omg.CORBA.portable.OutputStream outputStream) {
        super.write(outputStream);
        if (this.service_contexts != null) {
            this.service_contexts.write((OutputStream)outputStream, GIOPVersion.V1_1);
        } else {
            ServiceContexts.writeNullServiceContext((OutputStream)outputStream);
        }
        outputStream.write_ulong(this.request_id);
        outputStream.write_long(this.reply_status);
    }

    public static void isValidReplyStatus(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                ORBUtilSystemException oRBUtilSystemException = ORBUtilSystemException.get("rpc.protocol");
                throw oRBUtilSystemException.illegalReplyStatus(CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    @Override
    public void callback(MessageHandler messageHandler) throws IOException {
        messageHandler.handleInput(this);
    }
}

