"use strict";
/*********************************************************************
 * Copyright (c) 2018 Ericsson and others
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pty = exports.File = void 0;
const file_1 = require("./file");
Object.defineProperty(exports, "File", { enumerable: true, get: function () { return file_1.File; } });
/**
 * Represents the master-side of a pseudo-terminal master/slave pair.
 */
class Pty extends file_1.File {
    constructor() {
        // eslint-disable-next-line @typescript-eslint/no-var-requires
        const pty = require('../../build/Release/pty.node');
        const handles = pty.create_pty();
        super(handles.master_fd);
        this.slave_name = handles.slave_name;
    }
}
exports.Pty = Pty;
//# sourceMappingURL=pty.js.map