/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.DocumentSymbolHandler;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.legacy.typeHierarchy.ResolveTypeHierarchyItemParams;
import org.eclipse.lsp4j.legacy.typeHierarchy.TypeHierarchyDirection;
import org.eclipse.lsp4j.legacy.typeHierarchy.TypeHierarchyItem;
import org.eclipse.lsp4j.legacy.typeHierarchy.TypeHierarchyParams;

public class TypeHierarchyCommand {
    public TypeHierarchyItem typeHierarchy(TypeHierarchyParams params, IProgressMonitor monitor) {
        if (params == null) {
            return null;
        }
        TextDocumentIdentifier textDocument = params.getTextDocument();
        if (textDocument == null) {
            return null;
        }
        Position position = params.getPosition();
        String uri = textDocument.getUri();
        TypeHierarchyDirection direction = params.getDirection();
        int resolve = params.getResolve();
        return this.getTypeHierarchy(uri, position, direction, resolve, null, monitor);
    }

    public TypeHierarchyItem resolveTypeHierarchy(ResolveTypeHierarchyItemParams params, IProgressMonitor monitor) {
        if (params == null) {
            return null;
        }
        TypeHierarchyItem item = params.getItem();
        if (item == null) {
            return null;
        }
        Range range = item.getRange();
        if (range == null) {
            return null;
        }
        Position position = range.getStart();
        String uri = item.getUri();
        TypeHierarchyDirection direction = params.getDirection();
        int resolve = params.getResolve();
        return this.getTypeHierarchy(uri, position, direction, resolve, item, monitor);
    }

    /*
     * WARNING - void declaration
     */
    private TypeHierarchyItem getTypeHierarchy(String uri, Position position, TypeHierarchyDirection direction, int resolve, TypeHierarchyItem itemInput, IProgressMonitor monitor) {
        TypeHierarchyItem item;
        IMethod targetMethod;
        IMember member;
        block11: {
            block10: {
                if (uri == null || position == null || direction == null) {
                    return null;
                }
                try {
                    member = null;
                    targetMethod = null;
                    if (itemInput == null) {
                        member = this.getMember(uri, position, monitor);
                        if (member instanceof IMethod) {
                            targetMethod = (IMethod)member;
                        }
                        break block10;
                    }
                    Map data = JSONUtility.toModel(itemInput.getData(), Map.class);
                    String handleIdentifier = (String)data.get("element");
                    IJavaElement element = JavaCore.create((String)handleIdentifier);
                    String methodIdentifier = (String)data.get("method");
                    if (methodIdentifier != null) {
                        targetMethod = (IMethod)JavaCore.create((String)methodIdentifier);
                    }
                    if (element instanceof IType || element instanceof IMethod) {
                        member = (IMember)element;
                        break block10;
                    }
                    IJavaElement iJavaElement = element;
                    if (iJavaElement instanceof IOrdinaryClassFile) {
                        void classFile;
                        IOrdinaryClassFile iOrdinaryClassFile = (IOrdinaryClassFile)iJavaElement;
                        IOrdinaryClassFile cfr_ignored_0 = (IOrdinaryClassFile)iJavaElement;
                        member = classFile.getType();
                        break block10;
                    }
                    return null;
                }
                catch (JavaModelException e) {
                    return null;
                }
            }
            item = TypeHierarchyCommand.toTypeHierarchyItem(member);
            if (item != null) break block11;
            return null;
        }
        this.resolve(item, member, targetMethod, direction, resolve, monitor);
        return item;
    }

    /*
     * WARNING - void declaration
     */
    private IMember getMember(String uri, Position position, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement typeElement = TypeHierarchyCommand.findTypeElement(JDTUtils.resolveTypeRoot(uri), position, monitor);
        IJavaElement iJavaElement = typeElement;
        if (iJavaElement instanceof IType) {
            void type;
            IType iType = (IType)iJavaElement;
            IType cfr_ignored_0 = (IType)iJavaElement;
            return type;
        }
        IJavaElement iJavaElement2 = typeElement;
        if (iJavaElement2 instanceof IMethod) {
            void method;
            IMethod iMethod = (IMethod)iJavaElement2;
            IMethod cfr_ignored_1 = (IMethod)iJavaElement2;
            return method;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static IJavaElement findTypeElement(ITypeRoot unit, Position position, IProgressMonitor monitor) throws JavaModelException {
        if (unit == null) {
            return null;
        }
        IJavaElement element = JDTUtils.findElementAtSelection(unit, position.getLine(), position.getCharacter(), JavaLanguageServerPlugin.getPreferencesManager(), monitor);
        if (element == null) {
            ITypeRoot iTypeRoot = unit;
            if (iTypeRoot instanceof IOrdinaryClassFile) {
                void classFile;
                IOrdinaryClassFile iOrdinaryClassFile = (IOrdinaryClassFile)iTypeRoot;
                IOrdinaryClassFile cfr_ignored_0 = (IOrdinaryClassFile)iTypeRoot;
                element = classFile.getType();
            } else if (unit instanceof ICompilationUnit) {
                element = unit.findPrimaryType();
            }
        }
        return element;
    }

    private static TypeHierarchyItem toTypeHierarchyItem(IMember member) throws JavaModelException {
        return TypeHierarchyCommand.toTypeHierarchyItem(member, false, null);
    }

    private static TypeHierarchyItem toTypeHierarchyItem(IMember member, boolean excludeMember, IMethod targetMethod) throws JavaModelException {
        if (member == null) {
            return null;
        }
        Location location = TypeHierarchyCommand.getLocation(member, JDTUtils.LocationType.FULL_RANGE);
        Location selectLocation = TypeHierarchyCommand.getLocation(member, JDTUtils.LocationType.NAME_RANGE);
        if (location == null || selectLocation == null) {
            return null;
        }
        TypeHierarchyItem item = new TypeHierarchyItem();
        item.setRange(location.getRange());
        item.setUri(location.getUri());
        item.setSelectionRange(selectLocation.getRange());
        IType type = null;
        type = member instanceof IType ? (IType)member : member.getDeclaringType();
        String fullyQualifiedName = type.getFullyQualifiedName();
        int index = fullyQualifiedName.lastIndexOf(46);
        if (index >= 1 && index < fullyQualifiedName.length() - 1 && !type.isAnonymous()) {
            item.setName(fullyQualifiedName.substring(index + 1));
            item.setDetail(fullyQualifiedName.substring(0, index));
        } else {
            item.setName(JDTUtils.getName((IJavaElement)type));
            IPackageFragment packageFragment = type.getPackageFragment();
            if (packageFragment != null) {
                item.setDetail(packageFragment.getElementName());
            }
        }
        item.setKind(excludeMember ? SymbolKind.Null : DocumentSymbolHandler.mapKind((IJavaElement)type));
        item.setDeprecated(JDTUtils.isDeprecated((IJavaElement)member));
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("element", member.getHandleIdentifier());
        if (targetMethod != null) {
            data.put("method", targetMethod.getHandleIdentifier());
            data.put("method_name", targetMethod.getElementName());
        } else if (member instanceof IMethod) {
            data.put("method", member.getHandleIdentifier());
            data.put("method_name", member.getElementName());
        }
        item.setData(data);
        return item;
    }

    private static Location getLocation(IMember member, JDTUtils.LocationType locationType) throws JavaModelException {
        Location location = locationType.toLocation((IJavaElement)member);
        if (location == null && member.getClassFile() != null) {
            location = JDTUtils.toLocation(member.getClassFile());
        }
        return location;
    }

    private void resolve(TypeHierarchyItem item, IMember member, IMethod targetMethod, TypeHierarchyDirection direction, int resolve, IProgressMonitor monitor) throws JavaModelException {
        boolean excludeMember;
        IMethod[] matches;
        int n;
        int n2;
        IType[] iTypeArray;
        ITypeHierarchy typeHierarchy;
        if (monitor.isCanceled() || resolve <= 0) {
            return;
        }
        IType type = null;
        type = member instanceof IType ? (IType)member : member.getDeclaringType();
        if (direction == TypeHierarchyDirection.Parents) {
            typeHierarchy = type.newSupertypeHierarchy((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, monitor);
        } else {
            ICompilationUnit[] workingCopies = JavaModelManager.getJavaModelManager().getWorkingCopies((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY, true);
            typeHierarchy = type.newTypeHierarchy(workingCopies, monitor);
        }
        if (direction == TypeHierarchyDirection.Children || direction == TypeHierarchyDirection.Both) {
            IType[] children;
            ArrayList<TypeHierarchyItem> childrenItems = new ArrayList<TypeHierarchyItem>();
            iTypeArray = children = typeHierarchy.getSubtypes(type);
            n2 = children.length;
            n = 0;
            while (n < n2) {
                IType childType = iTypeArray[n];
                if (monitor.isCanceled()) {
                    return;
                }
                TypeHierarchyItem childItem = null;
                if (targetMethod != null) {
                    matches = childType.findMethods(targetMethod);
                    excludeMember = matches == null || matches.length == 0;
                    childItem = TypeHierarchyCommand.toTypeHierarchyItem((IMember)(excludeMember ? childType : matches[0]), excludeMember, targetMethod);
                } else {
                    childItem = TypeHierarchyCommand.toTypeHierarchyItem((IMember)childType);
                }
                if (childItem != null) {
                    this.resolve(childItem, (IMember)childType, targetMethod, direction, resolve - 1, monitor);
                    childrenItems.add(childItem);
                }
                ++n;
            }
            item.setChildren(childrenItems);
        }
        if (direction == TypeHierarchyDirection.Parents || direction == TypeHierarchyDirection.Both) {
            ArrayList<TypeHierarchyItem> parentsItems = new ArrayList<TypeHierarchyItem>();
            IType[] parents = typeHierarchy.getSupertypes(type);
            iTypeArray = parents;
            n2 = parents.length;
            n = 0;
            while (n < n2) {
                IType parentType = iTypeArray[n];
                if (monitor.isCanceled()) {
                    return;
                }
                TypeHierarchyItem parentItem = null;
                if (targetMethod != null) {
                    matches = parentType.findMethods(targetMethod);
                    boolean bl = excludeMember = matches == null || matches.length == 0;
                    if (!excludeMember || !"java.lang.Object".equals(parentType.getFullyQualifiedName())) {
                        parentItem = TypeHierarchyCommand.toTypeHierarchyItem((IMember)(excludeMember ? parentType : matches[0]), excludeMember, targetMethod);
                    }
                } else {
                    parentItem = TypeHierarchyCommand.toTypeHierarchyItem((IMember)parentType);
                }
                if (parentItem != null) {
                    this.resolve(parentItem, (IMember)parentType, targetMethod, direction, resolve - 1, monitor);
                    parentsItems.add(parentItem);
                }
                ++n;
            }
            item.setParents(parentsItems);
        }
    }
}

