/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.contentassist.SignatureHelpRequestor;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.handlers.SignatureHelpUtils;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SignatureInformation;

public class SignatureHelpHandler {
    private static final int SEARCH_BOUND = 2000;
    private PreferenceManager preferenceManager;

    public static SignatureHelpOptions createOptions() {
        return new SignatureHelpOptions(Arrays.asList("(", ","));
    }

    public SignatureHelpHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    /*
     * WARNING - void declaration
     */
    public SignatureHelp signatureHelp(SignatureHelpParams position, IProgressMonitor monitor) {
        SignatureHelp help = new SignatureHelp();
        if (!this.preferenceManager.getPreferences().isSignatureHelpEnabled()) {
            return help;
        }
        try {
            ICompilationUnit unit = JDTUtils.resolveCompilationUnit(position.getTextDocument().getUri());
            if (unit == null) {
                return help;
            }
            int offset = JsonRpcHelpers.toOffset(unit.getBuffer(), position.getPosition().getLine(), position.getPosition().getCharacter());
            SignatureHelp helpFromASTNode = SignatureHelpUtils.getSignatureHelpFromASTNode(unit, offset, monitor);
            if (helpFromASTNode != null) {
                return helpFromASTNode;
            }
            if (monitor.isCanceled()) {
                return help;
            }
            int[] contextInfomation = this.getContextInfomation(unit.getBuffer(), offset);
            ASTNode node = this.getNode(unit, contextInfomation, monitor);
            if (node == null) {
                return help;
            }
            IMethod method = this.getMethod(node);
            String name = method != null ? method.getElementName() : this.getMethodName(node, unit, contextInfomation);
            SignatureHelpRequestor collector = new SignatureHelpRequestor(unit, name, null);
            if (offset > -1 && !monitor.isCanceled()) {
                int pos = contextInfomation[0] + 1;
                if (method != null) {
                    int start;
                    ASTNode aSTNode = node;
                    if (aSTNode instanceof MethodInvocation) {
                        void methodInvocation;
                        MethodInvocation methodInvocation2 = (MethodInvocation)aSTNode;
                        MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
                        start = methodInvocation.getName().getStartPosition();
                    } else {
                        ASTNode aSTNode2 = node;
                        if (aSTNode2 instanceof ClassInstanceCreation) {
                            void classInstanceCreation;
                            ClassInstanceCreation classInstanceCreation2 = (ClassInstanceCreation)aSTNode2;
                            ClassInstanceCreation cfr_ignored_1 = (ClassInstanceCreation)aSTNode2;
                            start = classInstanceCreation.getType().getStartPosition();
                        } else {
                            start = node.getStartPosition();
                        }
                    }
                    pos = start + method.getElementName().length();
                }
                unit.codeComplete(pos, (CompletionRequestor)collector, monitor);
                help = collector.getSignatureHelp(monitor);
                if (method != null && method.isConstructor() && help.getSignatures().isEmpty() && node instanceof ClassInstanceCreation) {
                    SignatureHelpUtils.fix2097(help, node, collector, pos);
                }
                if (!monitor.isCanceled() && help != null) {
                    int activeParameter;
                    SignatureHelp help2 = null;
                    SignatureHelpRequestor collector2 = null;
                    if (contextInfomation[0] + 1 != offset) {
                        collector2 = new SignatureHelpRequestor(unit, name, null, true);
                        unit.codeComplete(offset, (CompletionRequestor)collector2, monitor);
                        help2 = collector2.getSignatureHelp(monitor);
                    }
                    int currentParameter = contextInfomation[1];
                    int size = currentParameter + 1;
                    List infos = help.getSignatures();
                    int n = activeParameter = currentParameter < 0 ? 0 : currentParameter;
                    if (node != null) {
                        IMethod m;
                        CompletionProposal proposal;
                        int i;
                        IJavaProject javaProject = unit.getJavaProject();
                        if (help2 != null) {
                            if (method != null) {
                                i = 0;
                                while (i < infos.size()) {
                                    if (((SignatureInformation)infos.get(i)).getParameters().size() >= size) {
                                        proposal = collector.getInfoProposals().get(infos.get(i));
                                        m = JDTUtils.resolveMethod(proposal, javaProject, monitor);
                                        if (!monitor.isCanceled() && JDTUtils.isSameParameters(m, method)) {
                                            help.setActiveSignature(Integer.valueOf(i));
                                            help.setActiveParameter(Integer.valueOf(activeParameter));
                                            return help;
                                        }
                                    }
                                    ++i;
                                }
                            }
                            if (!monitor.isCanceled() && help.getActiveSignature() == null) {
                                i = 0;
                                while (i < infos.size()) {
                                    if (((SignatureInformation)infos.get(i)).getParameters().size() >= size) {
                                        proposal = collector.getInfoProposals().get(infos.get(i));
                                        m = JDTUtils.resolveMethod(proposal, javaProject, monitor);
                                        if (!monitor.isCanceled() && this.isSameParameters(m, help2, collector2, javaProject, monitor)) {
                                            help.setActiveSignature(Integer.valueOf(i));
                                            help.setActiveParameter(Integer.valueOf(activeParameter));
                                            return help;
                                        }
                                        for (CompletionProposal typeProposal : collector2.getTypeProposals()) {
                                            if (!SignatureHelpHandler.isSameParameters(m, method, typeProposal)) continue;
                                            help.setActiveSignature(Integer.valueOf(i));
                                            help.setActiveParameter(Integer.valueOf(activeParameter));
                                            return help;
                                        }
                                    }
                                    ++i;
                                }
                            }
                        }
                        if (!monitor.isCanceled() && help.getActiveSignature() == null && method != null) {
                            i = 0;
                            while (i < infos.size()) {
                                if (((SignatureInformation)infos.get(i)).getParameters().size() >= size) {
                                    proposal = collector.getInfoProposals().get(infos.get(i));
                                    m = JDTUtils.resolveMethod(proposal, javaProject, monitor);
                                    if (!monitor.isCanceled() && JDTUtils.isSameParameters(method, m)) {
                                        help.setActiveSignature(Integer.valueOf(i));
                                        help.setActiveParameter(Integer.valueOf(activeParameter));
                                        return help;
                                    }
                                }
                                ++i;
                            }
                        }
                        if (!monitor.isCanceled() && help.getActiveSignature() == null) {
                            i = 0;
                            while (i < infos.size()) {
                                proposal = collector.getInfoProposals().get(infos.get(i));
                                if (Flags.isVarargs((int)proposal.getFlags())) {
                                    help.setActiveSignature(Integer.valueOf(i));
                                    char[][] infoTypes = Signature.getParameterTypes((char[])SignatureUtil.fix83600((char[])proposal.getSignature()));
                                    if (infoTypes.length <= activeParameter) {
                                        help.setActiveParameter(Integer.valueOf(infoTypes.length - 1));
                                    } else {
                                        help.setActiveParameter(Integer.valueOf(activeParameter));
                                    }
                                    return help;
                                }
                                ++i;
                            }
                        }
                        if (!monitor.isCanceled() && help.getActiveSignature() == null && node instanceof Block) {
                            String methodName = this.getMethodName(node, unit, contextInfomation);
                            int i2 = 0;
                            while (i2 < infos.size()) {
                                if (((SignatureInformation)infos.get(i2)).getParameters().size() >= activeParameter) {
                                    CompletionProposal proposal2 = collector.getInfoProposals().get(infos.get(i2));
                                    IMethod m2 = JDTUtils.resolveMethod(proposal2, javaProject, monitor);
                                    if (!monitor.isCanceled() && m2 != null && m2.getElementName().equals(methodName)) {
                                        help.setActiveSignature(Integer.valueOf(i2));
                                        help.setActiveParameter(Integer.valueOf(activeParameter));
                                        return help;
                                    }
                                }
                                ++i2;
                            }
                        }
                        if (method != null && !monitor.isCanceled() && help.getActiveSignature() == null) {
                            int i3 = 0;
                            while (i3 < infos.size()) {
                                if (((SignatureInformation)infos.get(i3)).getParameters().size() >= size) {
                                    CompletionProposal proposal3 = collector.getInfoProposals().get(infos.get(i3));
                                    m = JDTUtils.resolveMethod(proposal3, javaProject, monitor);
                                    if (!monitor.isCanceled() && SignatureHelpHandler.isSameParameters(m, method, null)) {
                                        help.setActiveSignature(Integer.valueOf(i3));
                                        help.setActiveParameter(Integer.valueOf(activeParameter));
                                        return help;
                                    }
                                }
                                ++i3;
                            }
                        }
                    }
                }
            }
        }
        catch (CoreException ex) {
            JavaLanguageServerPlugin.logException("Find signatureHelp failure ", ex);
        }
        return help;
    }

    private boolean isSameParameters(IMethod m, SignatureHelp help, SignatureHelpRequestor collector, IJavaProject javaProject, IProgressMonitor monitor) throws JavaModelException {
        if (m == null || help == null || javaProject == null) {
            return false;
        }
        List infos = help.getSignatures();
        int i = 0;
        while (i < infos.size()) {
            CompletionProposal proposal = collector.getInfoProposals().get(infos.get(i));
            IMethod method = JDTUtils.resolveMethod(proposal, javaProject, monitor);
            if (m.getElementName().equals(method.getElementName()) && JDTUtils.isSameParameters(method, m)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isSameParameters(IMethod method1, IMethod method2, CompletionProposal typeProposal) {
        if (method1 == null || method2 == null || !method1.getElementName().equals(method2.getElementName())) {
            return false;
        }
        String[] params1 = method1.getParameterTypes();
        String[] params2 = method2.getParameterTypes();
        if (params2.length <= params1.length - 1) {
            int i = 0;
            while (i < params2.length) {
                String t2;
                String t1 = Signature.getSimpleName((String)Signature.toString((String)params2[i]));
                if (!t1.equals(t2 = Signature.getSimpleName((String)Signature.toString((String)params1[i])))) {
                    return false;
                }
                ++i;
            }
        }
        if (typeProposal != null) {
            String param = params1[params1.length - 1];
            String typeSignature = new String(SignatureUtil.fix83600((char[])typeProposal.getSignature()));
            return param.equals(typeSignature);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private IMethod getMethod(ASTNode node) throws JavaModelException {
        IJavaElement javaElement;
        IJavaElement iJavaElement;
        IMethodBinding binding;
        ASTNode aSTNode = node;
        if (aSTNode instanceof MethodInvocation) {
            void methodInvocation;
            MethodInvocation methodInvocation2 = (MethodInvocation)aSTNode;
            MethodInvocation cfr_ignored_0 = (MethodInvocation)aSTNode;
            binding = methodInvocation.resolveMethodBinding();
        } else {
            ASTNode aSTNode2 = node;
            if (aSTNode2 instanceof MethodRef) {
                void methodRef;
                MethodRef methodRef2 = (MethodRef)aSTNode2;
                MethodRef cfr_ignored_1 = (MethodRef)aSTNode2;
                binding = methodRef.resolveBinding();
            } else {
                ASTNode aSTNode3 = node;
                if (aSTNode3 instanceof ClassInstanceCreation) {
                    void classInstanceCreation;
                    ClassInstanceCreation classInstanceCreation2 = (ClassInstanceCreation)aSTNode3;
                    ClassInstanceCreation cfr_ignored_2 = (ClassInstanceCreation)aSTNode3;
                    binding = classInstanceCreation.resolveConstructorBinding();
                } else {
                    binding = null;
                }
            }
        }
        if (binding != null && (iJavaElement = (javaElement = binding.getJavaElement())) instanceof IMethod) {
            void method;
            IMethod iMethod = (IMethod)iJavaElement;
            IMethod cfr_ignored_3 = (IMethod)iJavaElement;
            return method;
        }
        return null;
    }

    private ASTNode getNode(ICompilationUnit unit, int[] contextInfomation, IProgressMonitor monitor) {
        if (contextInfomation[0] != -1) {
            String name;
            CompilationUnit ast = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
            if (ast == null) {
                return null;
            }
            ASTNode node = NodeFinder.perform((ASTNode)ast, (int)contextInfomation[0], (int)1);
            if (node instanceof MethodInvocation || node instanceof ClassInstanceCreation || node instanceof MethodRef) {
                return node;
            }
            if (node instanceof Block && (name = this.getMethodName(node, unit, contextInfomation)) != null) {
                return node;
            }
            if (node instanceof Expression && ((node = node.getParent()) instanceof MethodInvocation || node instanceof ClassInstanceCreation || node instanceof MethodRef)) {
                return node;
            }
        }
        return null;
    }

    private String getMethodName(ASTNode node, ICompilationUnit unit, int[] contextInfomation) {
        if (node instanceof Block) {
            try {
                int pos = contextInfomation[0];
                IBuffer buffer = unit.getBuffer();
                while (pos >= 0) {
                    char ch = buffer.getChar(pos);
                    if (ch != '(' && !Character.isWhitespace(ch)) break;
                    --pos;
                }
                int end = pos + 1;
                while (pos >= 0) {
                    char ch = buffer.getChar(pos);
                    if (!Character.isJavaIdentifierPart(ch)) break;
                    --pos;
                }
                int start = pos + 1;
                String name = unit.getSource().substring(start, end);
                IStatus status = JavaConventionsUtil.validateMethodName((String)name, (IJavaElement)unit);
                if (status.isOK()) {
                    return name;
                }
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        return null;
    }

    private int[] getContextInfomation(IBuffer buffer, int offset) {
        int[] result = new int[2];
        result[1] = -1;
        result[0] = -1;
        int depth = 1;
        int i = offset - 1;
        while (i >= 0 && offset - i < 2000) {
            char c = buffer.getChar(i);
            if (c == '{' || c == '}') {
                result[1] = -1;
                result[0] = -1;
                return result;
            }
            if (c == ')') {
                ++depth;
            }
            if (c == '(') {
                --depth;
            }
            if (c == ',' && depth == 1) {
                result[1] = result[1] + 1;
            }
            if (depth == 0) {
                result[0] = i;
                break;
            }
            --i;
        }
        if (result[0] + 1 != offset) {
            i = 1;
            while (result[0] + i < offset) {
                if (!Character.isWhitespace(buffer.getChar(result[0] + i))) {
                    result[1] = result[1] + 1;
                    break;
                }
                ++i;
            }
        }
        return result;
    }
}

