/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.UsesDirective;
import org.eclipse.jdt.core.manipulation.CUCorrectionProposalCore;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class AddMissingModuleJavadocTagProposalCore
extends CUCorrectionProposalCore {
    private final ModuleDeclaration fDecl;
    private final ASTNode fMissingNode;

    public AddMissingModuleJavadocTagProposalCore(String label, ICompilationUnit cu, ModuleDeclaration decl, ASTNode missingNode, int relevance) {
        super(label, cu, null, relevance);
        this.fDecl = decl;
        this.fMissingNode = missingNode;
    }

    @Override
    public void addEdits(IDocument document, TextEdit rootEdit) throws CoreException {
        try {
            Object comment2;
            Javadoc javadoc = null;
            String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            ICompilationUnit unit = this.getCompilationUnit();
            CompilationUnit cu = (CompilationUnit)this.fDecl.getParent();
            Name name = this.fDecl.getName();
            List comments = cu.getCommentList();
            for (Object comment2 : comments) {
                if (!(comment2 instanceof Javadoc) || comment2.getStartPosition() + comment2.getLength() >= name.getStartPosition()) continue;
                javadoc = (Javadoc)comment2;
            }
            if (javadoc == null) {
                return;
            }
            comment2 = new StringBuilder();
            int insertPosition = AddMissingModuleJavadocTagProposalCore.findInsertPosition(javadoc, this.fMissingNode, document, lineDelimiter);
            if (this.fMissingNode instanceof UsesDirective) {
                directive = (UsesDirective)this.fMissingNode;
                ((StringBuilder)comment2).append(" * ").append("@uses").append(" ").append(directive.getName().getFullyQualifiedName().toString()).append(lineDelimiter);
            } else if (this.fMissingNode instanceof ProvidesDirective) {
                directive = (ProvidesDirective)this.fMissingNode;
                ((StringBuilder)comment2).append(" * ").append("@provides").append(" ").append(directive.getName().getFullyQualifiedName().toString()).append(lineDelimiter);
            }
            IRegion region = document.getLineInformationOfOffset(insertPosition);
            String lineContent = document.get(region.getOffset(), region.getLength());
            String indentString = Strings.getIndentString(lineContent, unit);
            String str = Strings.changeIndent(((StringBuilder)comment2).toString(), 0, unit, indentString, lineDelimiter);
            InsertEdit edit = new InsertEdit(insertPosition, str);
            rootEdit.addChild((TextEdit)edit);
        }
        catch (BadLocationException e) {
            throw new CoreException(JavaUIStatus.createError(4, e));
        }
    }

    public static int findInsertPosition(Javadoc javadoc, ASTNode node, IDocument document, String lineDelimiter) throws BadLocationException {
        String name;
        int position = -1;
        List tags = javadoc.tags();
        TagElement lastTag = null;
        for (TagElement tag : tags) {
            name = tag.getTagName();
            if (!"@provides".equals(name)) continue;
            lastTag = tag;
        }
        if (lastTag == null) {
            for (TagElement tag : tags) {
                name = tag.getTagName();
                if (!"@uses".equals(name)) continue;
                IRegion region = document.getLineInformationOfOffset(tag.getStartPosition());
                return region.getOffset();
            }
        }
        if (lastTag == null && !tags.isEmpty()) {
            lastTag = (TagElement)tags.get(tags.size() - 1);
        }
        if (lastTag != null) {
            region = document.getLineInformationOfOffset(lastTag.getStartPosition());
            position = region.getOffset() + region.getLength() + lineDelimiter.length();
        } else {
            region = document.getLineInformationOfOffset(javadoc.getStartPosition());
            position = region.getOffset() + region.getLength() + lineDelimiter.length();
        }
        return position;
    }
}

