/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code.makestatic;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class FinalConditionsChecker {
    private RefactoringStatus fStatus;

    public FinalConditionsChecker(RefactoringStatus status) {
        this.fStatus = status;
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public void checkMethodIsNotDuplicate(MethodDeclaration methodDeclaration, IMethod imethod) throws JavaModelException {
        ITypeBinding typeBinding;
        IType type;
        IMethod method;
        int parameterAmount = methodDeclaration.parameters().size() + 1;
        String methodName = methodDeclaration.getName().getIdentifier();
        IMethodBinding methodBinding = methodDeclaration.resolveBinding();
        if (methodBinding == null) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_unexpected_binding_error));
        }
        if ((method = Checks.findMethod(methodName, parameterAmount, false, type = (IType)(typeBinding = methodBinding.getDeclaringClass()).getJavaElement())) == null) {
            return;
        }
        String className = ((TypeDeclaration)methodDeclaration.getParent()).getName().toString();
        String extendedClassName = "Q" + className + ";";
        String[] paramTypesOfFoundMethod = method.getParameterTypes();
        String[] paramTypesOfSelectedMethodExtended = new String[parameterAmount];
        paramTypesOfSelectedMethodExtended[0] = extendedClassName;
        String[] paramTypesOfSelectedMethod = imethod.getParameterTypes();
        int parameterNumber = 0;
        while (parameterNumber < paramTypesOfSelectedMethod.length) {
            paramTypesOfSelectedMethodExtended[parameterNumber + 1] = paramTypesOfSelectedMethod[parameterNumber];
            ++parameterNumber;
        }
        parameterNumber = 0;
        while (parameterNumber < paramTypesOfFoundMethod.length) {
            boolean contains = paramTypesOfSelectedMethodExtended[parameterNumber].equals(paramTypesOfFoundMethod[parameterNumber]);
            if (!contains) {
                return;
            }
            ++parameterNumber;
        }
        this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_duplicate_method_signature));
    }

    public void checkMethodWouldHideParentMethod(boolean methodhasInstanceUsage, IMethod iMethod) throws JavaModelException {
        if (!methodhasInstanceUsage && this.isOverriding(iMethod.getDeclaringType(), iMethod)) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_hiding_method_of_parent_type));
        }
    }

    public void checkBoundNotContainingWildCardType(String bound) {
        if (bound.contains("?")) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_not_available_for_wildCardTypes_as_bound));
        }
    }

    public void checkMethodReferenceNotReferingToMethod(MethodReference methodReference, IMethodBinding targetMethodBinding) {
        IMethodBinding methodReferenceBinding = methodReference.resolveMethodBinding();
        ITypeBinding typeBindingOfMethodReference = methodReferenceBinding.getDeclaringClass();
        ITypeBinding typeBindingOfTargetMethod = targetMethodBinding.getDeclaringClass();
        if (targetMethodBinding.isEqualTo((IBinding)methodReferenceBinding) && typeBindingOfMethodReference.isEqualTo((IBinding)typeBindingOfTargetMethod)) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_not_available_for_method_references));
        }
    }

    public void checkNodeIsNoSuperMethodInvocation() {
        this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_explicit_super_method_invocation));
    }

    public void checkMethodNotUsingSuperFieldAccess(ASTNode parent) {
        if (parent instanceof SuperFieldAccess) {
            this.fStatus.merge(RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_selected_method_uses_super_field_access));
        }
    }

    public void checkIsNotRecursive(SimpleName node, MethodDeclaration methodDeclaration) {
        IMethodBinding nodeMethodBinding = (IMethodBinding)node.resolveBinding();
        IMethodBinding outerMethodBinding = methodDeclaration.resolveBinding();
        if (nodeMethodBinding == null || outerMethodBinding == null) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_unexpected_binding_error));
        }
        if (nodeMethodBinding.isEqualTo((IBinding)outerMethodBinding)) {
            this.fStatus.merge(RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MakeStaticRefactoring_not_available_for_recursive_methods));
        }
    }

    private boolean isOverriding(IType type, IMethod iMethod) throws JavaModelException {
        IType[] supertypes;
        ITypeHierarchy hierarchy = type.newTypeHierarchy(null);
        IType[] iTypeArray = supertypes = hierarchy.getAllSupertypes(type);
        int n = supertypes.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod[] methods;
            IType supertype = iTypeArray[n2];
            IMethod[] iMethodArray = methods = supertype.getMethods();
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                IMethod method = iMethodArray[n4];
                if (method.isSimilar(iMethod)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }
}

