/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;

public final class ProjectTestUtils {
    private static final String TEST_SCOPE = "test";
    private static final String MAVEN_SCOPE_ATTRIBUTE = "maven.scope";
    private static final String GRADLE_SCOPE_ATTRIBUTE = "gradle_scope";

    public static List<TestSourcePath> listTestSourcePaths(List<Object> arguments, IProgressMonitor monitor) throws JavaModelException {
        ArrayList<TestSourcePath> resultList = new ArrayList<TestSourcePath>();
        if (arguments == null || arguments.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList uriArray = (ArrayList)arguments.get(0);
        for (String uri : uriArray) {
            Set<IJavaProject> projectSet = ProjectTestUtils.parseProjects(uri);
            for (IJavaProject project : projectSet) {
                resultList.addAll(ProjectTestUtils.getTestSourcePaths(project));
            }
        }
        return resultList;
    }

    public static List<IClasspathEntry> getTestEntries(IJavaProject project) throws JavaModelException {
        return ProjectTestUtils.getClasspathEntries(project, true);
    }

    public static List<IClasspathEntry> getSourceEntries(IJavaProject project) throws JavaModelException {
        return ProjectTestUtils.getClasspathEntries(project, false);
    }

    private static List<IClasspathEntry> getClasspathEntries(IJavaProject project, boolean isTest) throws JavaModelException {
        if ("jdt.ls-java-project".equals(project.getProject().getName())) {
            return Collections.emptyList();
        }
        LinkedList<IClasspathEntry> entries = new LinkedList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                if (isTest == ProjectTestUtils.isTestEntry(entry)) {
                    entries.add(entry);
                } else if (ProjectUtils.isGeneralJavaProject((IProject)project.getProject())) {
                    entries.add(entry);
                }
            }
            ++n2;
        }
        return entries;
    }

    public static List<TestSourcePath> getTestSourcePaths(IJavaProject project) throws JavaModelException {
        if ("jdt.ls-java-project".equals(project.getProject().getName())) {
            return Collections.emptyList();
        }
        LinkedList<TestSourcePath> paths = new LinkedList<TestSourcePath>();
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 3) {
                if (ProjectTestUtils.isTestEntry(entry)) {
                    ProjectTestUtils.addTestSourcePath(paths, project.getProject(), entry, true);
                } else if (ProjectUtils.isGeneralJavaProject((IProject)project.getProject())) {
                    ProjectTestUtils.addTestSourcePath(paths, project.getProject(), entry, false);
                }
            }
            ++n2;
        }
        return paths;
    }

    public static Set<IJavaProject> parseProjects(String uriStr) {
        IPath parentPath = ResourceUtils.filePathFromURI((String)uriStr);
        if (parentPath == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(ProjectUtils.getJavaProjects()).filter(p -> ResourceUtils.isContainedIn((IPath)ProjectUtils.getProjectRealFolder((IProject)p.getProject()), Arrays.asList(parentPath))).collect(Collectors.toSet());
    }

    private static void addTestSourcePath(List<TestSourcePath> paths, IProject project, IClasspathEntry entry, boolean isStrict) {
        IPath relativePath = entry.getPath().makeRelativeTo(project.getFullPath());
        IPath testSourcePath = relativePath.isEmpty() ? project.getLocation() : project.getFolder(relativePath).getLocation();
        if (testSourcePath != null) {
            paths.add(new TestSourcePath(testSourcePath.toOSString(), isStrict));
        }
    }

    public static boolean isTest(IJavaProject project, IPath path, boolean containsGeneral) {
        IClasspathEntry entry;
        block3: {
            try {
                entry = project.getClasspathEntryFor(path);
                if (entry != null) break block3;
                return false;
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        return ProjectTestUtils.isTest(project, entry, containsGeneral);
    }

    public static boolean isTest(IJavaProject project, IClasspathEntry entry, boolean containsGeneral) {
        if ("jdt.ls-java-project".equals(project.getProject().getName())) {
            return false;
        }
        if (entry.getEntryKind() != 3) {
            return false;
        }
        if (ProjectTestUtils.isTestEntry(entry)) {
            return true;
        }
        return containsGeneral && ProjectUtils.isGeneralJavaProject((IProject)project.getProject());
    }

    public static boolean isTestEntry(IClasspathEntry entry) {
        if (entry.isTest()) {
            return true;
        }
        IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            if (MAVEN_SCOPE_ATTRIBUTE.equals(attribute.getName()) || GRADLE_SCOPE_ATTRIBUTE.equals(attribute.getName())) {
                return attribute.getValue() != null && attribute.getValue().toLowerCase().contains(TEST_SCOPE);
            }
            ++n2;
        }
        return false;
    }

    static class TestSourcePath {
        public String testSourcePath;
        public boolean isStrict;

        public TestSourcePath(String testSourcePath, boolean isStrict) {
            this.testSourcePath = testSourcePath;
            this.isStrict = isStrict;
        }
    }
}

