/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.processing;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.jdt.internal.core.util.Messages;
import org.eclipse.jdt.internal.core.util.Util;

public abstract class JobManager {
    private final List<IJob> awaitingJobs = new LinkedList<IJob>();
    private volatile boolean executing;
    private Thread processingThread;
    private volatile Job progressJob;
    private int enableCount = 1;
    public static boolean VERBOSE = false;
    private boolean activated;
    private final AtomicInteger awaitingClients = new AtomicInteger();
    private final Object idleMonitor = new Object();

    private synchronized Thread getProcessingThread() {
        return this.processingThread;
    }

    synchronized void activateProcessing() {
        this.activated = true;
        this.notifyAll();
    }

    public synchronized int awaitingJobsCount() {
        return this.activated ? this.awaitingJobs.size() : 1;
    }

    public synchronized IJob currentJob() {
        if (this.enableCount > 0 && !this.awaitingJobs.isEmpty()) {
            return this.awaitingJobs.get(0);
        }
        return null;
    }

    public synchronized IJob currentJobForced() {
        if (!this.awaitingJobs.isEmpty()) {
            return this.awaitingJobs.get(0);
        }
        return null;
    }

    public synchronized void disable() {
        --this.enableCount;
        if (VERBOSE) {
            JavaModelManager.trace("DISABLING background indexing");
        }
    }

    public synchronized boolean isEnabled() {
        return this.enableCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void discardJobs(String jobFamily) {
        if (VERBOSE) {
            JavaModelManager.trace("DISCARD   background job family - " + jobFamily);
        }
        try {
            IJob currentJob;
            JobManager jobManager = this;
            synchronized (jobManager) {
                currentJob = this.currentJob();
                this.disable();
            }
            if (currentJob != null && (jobFamily == null || currentJob.belongsTo(jobFamily))) {
                currentJob.cancel();
                jobManager = this;
                synchronized (jobManager) {
                    while (this.getProcessingThread() != null && this.executing) {
                        try {
                            if (VERBOSE) {
                                JavaModelManager.trace("-> waiting end of current background job - " + String.valueOf(currentJob));
                            }
                            this.wait(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            jobManager = this;
            synchronized (jobManager) {
                Iterator<IJob> it = this.awaitingJobs.iterator();
                boolean notify = false;
                while (true) {
                    if (!it.hasNext()) {
                        if (notify) {
                            this.notifyAll();
                        }
                        break;
                    }
                    currentJob = it.next();
                    if (jobFamily != null && !currentJob.belongsTo(jobFamily)) continue;
                    if (VERBOSE) {
                        JavaModelManager.trace("-> discarding background job  - " + String.valueOf(currentJob));
                    }
                    currentJob.cancel();
                    it.remove();
                    notify = true;
                }
            }
        }
        finally {
            this.enable();
        }
        if (VERBOSE) {
            JavaModelManager.trace("DISCARD   DONE with background job family - " + jobFamily);
        }
    }

    public synchronized void enable() {
        ++this.enableCount;
        if (VERBOSE) {
            JavaModelManager.trace("ENABLING  background indexing");
        }
        this.notifyAll();
    }

    protected synchronized boolean isJobWaiting(IJob request) {
        if (this.awaitingJobs.size() <= 1) {
            return false;
        }
        return this.hasPendingJobMatching(request::equals);
    }

    protected synchronized boolean hasPendingJobMatching(Predicate<IJob> request) {
        int awaitingJobsCount = this.awaitingJobsCount();
        if (awaitingJobsCount <= 1) {
            return false;
        }
        ListIterator<IJob> iterator = this.awaitingJobs.listIterator(awaitingJobsCount);
        IJob first = this.awaitingJobs.get(0);
        while (iterator.hasPrevious()) {
            IJob job = iterator.previous();
            if (job == first) break;
            if (!request.test(job)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void moveToNextJob() {
        if (!this.awaitingJobs.isEmpty()) {
            this.awaitingJobs.remove(0);
            if (this.awaitingJobsCount() == 0) {
                JobManager jobManager = this;
                synchronized (jobManager) {
                    this.notifyAll();
                }
            }
        }
    }

    protected abstract void notifyIdle(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performConcurrentJob(IJob searchJob, int waitingPolicy, IProgressMonitor monitor) {
        if (VERBOSE) {
            JavaModelManager.trace("STARTING  concurrent job - " + String.valueOf(searchJob));
        }
        searchJob.ensureReadyToRun();
        boolean status = false;
        try {
            SubMonitor subMonitor;
            block41: {
                subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
                if (this.awaitingJobsCount() <= 0) break block41;
                if (VERBOSE) {
                    JavaModelManager.trace("-> NOT READY - " + this.awaitingJobsCount() + " awaiting jobs - " + String.valueOf(searchJob));
                }
                switch (waitingPolicy) {
                    case 1: {
                        if (VERBOSE) {
                            JavaModelManager.trace("-> NOT READY - forcing immediate - " + String.valueOf(searchJob));
                        }
                        try {
                            this.disable();
                            status = searchJob.execute((IProgressMonitor)subMonitor);
                        }
                        finally {
                            this.enable();
                        }
                        if (VERBOSE) {
                            JavaModelManager.trace("FINISHED  concurrent job - " + String.valueOf(searchJob));
                        }
                        boolean bl = status;
                        return bl;
                    }
                    case 2: {
                        if (VERBOSE) {
                            JavaModelManager.trace("-> NOT READY - cancelling - " + String.valueOf(searchJob));
                            JavaModelManager.trace("CANCELED concurrent job - " + String.valueOf(searchJob));
                        }
                        throw new OperationCanceledException();
                    }
                    case 3: {
                        int totalWork = 1000;
                        SubMonitor waitMonitor = subMonitor.setWorkRemaining(10).split(8).setWorkRemaining(totalWork);
                        Thread t = this.getProcessingThread();
                        int originalPriority = t == null ? -1 : t.getPriority();
                        try {
                            int awaitingJobsCount;
                            if (t != null) {
                                t.setPriority(Thread.currentThread().getPriority());
                            }
                            this.awaitingClients.incrementAndGet();
                            IJob previousJob = null;
                            int lastJobsCount = totalWork;
                            float lastWorked = 0.0f;
                            float totalWorked = 0.0f;
                            while ((awaitingJobsCount = this.awaitingJobsCount()) > 0) {
                                Object object;
                                if (waitMonitor.isCanceled() || this.getProcessingThread() == null) {
                                    throw new OperationCanceledException();
                                }
                                boolean shouldDisable = false;
                                IJob currentJob = this.currentJobForced();
                                if (currentJob != null) {
                                    if (!this.isEnabled()) {
                                        if (VERBOSE) {
                                            JavaModelManager.trace("-> NOT READY (" + this.enableCount + ") - enabling indexer to process " + awaitingJobsCount + " jobs - " + String.valueOf(searchJob));
                                        }
                                        this.enable();
                                        shouldDisable = true;
                                    }
                                    object = this.idleMonitor;
                                    synchronized (object) {
                                        this.idleMonitor.notifyAll();
                                    }
                                }
                                if (currentJob != null && currentJob != previousJob) {
                                    float ratio;
                                    if (VERBOSE) {
                                        JavaModelManager.trace("-> NOT READY - waiting until ready  to process " + awaitingJobsCount + " awaiting jobs - " + String.valueOf(searchJob));
                                    }
                                    String indexing = Messages.bind(Messages.jobmanager_filesToIndex, currentJob.getJobFamily(), Integer.toString(awaitingJobsCount));
                                    waitMonitor.subTask(indexing);
                                    float f = ratio = awaitingJobsCount < totalWork ? 1.0f : (float)totalWork / (float)awaitingJobsCount;
                                    totalWorked = lastJobsCount > awaitingJobsCount ? (totalWorked += (float)(lastJobsCount - awaitingJobsCount) * ratio) : (totalWorked += ratio);
                                    if (totalWorked - lastWorked >= 1.0f) {
                                        waitMonitor.worked((int)(totalWorked - lastWorked));
                                        lastWorked = totalWorked;
                                    }
                                    lastJobsCount = awaitingJobsCount;
                                    previousJob = currentJob;
                                }
                                object = this;
                                synchronized (object) {
                                    if (this.awaitingJobsCount() > 0) {
                                        try {
                                            this.wait(50L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (!shouldDisable) continue;
                                if (VERBOSE) {
                                    JavaModelManager.trace("-> NOT READY (" + this.enableCount + ") - disabling indexer again, still awaiting jobs: " + awaitingJobsCount + " - " + String.valueOf(searchJob));
                                }
                                this.disable();
                            }
                        }
                        catch (Throwable throwable) {
                            this.awaitingClients.decrementAndGet();
                            if (t != null && originalPriority > -1 && t.isAlive()) {
                                t.setPriority(originalPriority);
                            }
                            throw throwable;
                        }
                        this.awaitingClients.decrementAndGet();
                        if (t == null || originalPriority <= -1 || !t.isAlive()) break;
                        t.setPriority(originalPriority);
                    }
                }
            }
            status = searchJob.execute((IProgressMonitor)subMonitor);
        }
        finally {
            SubMonitor.done((IProgressMonitor)monitor);
            if (VERBOSE) {
                JavaModelManager.trace("FINISHED  concurrent job - " + String.valueOf(searchJob));
            }
        }
        return status;
    }

    public abstract String processName();

    public synchronized void requestIfNotWaiting(IJob job) {
        if (!this.isJobWaiting(job)) {
            this.request(job);
        }
    }

    public synchronized void request(IJob job) {
        job.ensureReadyToRun();
        this.awaitingJobs.add(job);
        if (VERBOSE) {
            JavaModelManager.trace("REQUEST   background job - " + String.valueOf(job));
            JavaModelManager.trace("AWAITING JOBS count: " + this.awaitingJobsCount());
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Thread thread;
        if (VERBOSE) {
            JavaModelManager.trace("Reset");
        }
        if ((thread = this.getProcessingThread()) != null) {
            this.discardJobs(null);
        } else {
            JobManager jobManager = this;
            synchronized (jobManager) {
                Thread t = new Thread(this::indexerLoop, this.processName());
                t.setDaemon(true);
                t.setPriority(4);
                t.setContextClassLoader(this.getClass().getClassLoader());
                t.start();
                this.processingThread = t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void indexerLoop() {
        boolean cacheZipFiles = false;
        Long idlingStart = null;
        this.activateProcessing();
        try {
            try {
                this.progressJob = null;
                while (this.getProcessingThread() != null) {
                    try {
                        Object object;
                        IJob job;
                        Object object2 = this;
                        synchronized (object2) {
                            if (this.getProcessingThread() == null) {
                                continue;
                            }
                            job = this.currentJob();
                            if (job == null) {
                                Job pJob = this.progressJob;
                                if (pJob != null) {
                                    pJob.cancel();
                                    this.progressJob = null;
                                }
                                if (idlingStart == null) {
                                    idlingStart = System.nanoTime();
                                } else {
                                    this.wait();
                                }
                            }
                        }
                        if (job == null) {
                            this.notifyIdle((System.nanoTime() - idlingStart) / 1000000L);
                            if (this.currentJob() != null) continue;
                            if (cacheZipFiles) {
                                JavaModelManager.getJavaModelManager().flushZipFiles(this);
                                cacheZipFiles = false;
                            }
                            object2 = this.idleMonitor;
                            synchronized (object2) {
                                this.idleMonitor.wait(500L);
                                continue;
                            }
                        }
                        idlingStart = null;
                        if (VERBOSE) {
                            JavaModelManager.trace(this.awaitingJobsCount() + " awaiting jobs");
                            JavaModelManager.trace("STARTING background job - " + String.valueOf(job));
                        }
                        try {
                            this.executing = true;
                            if (this.progressJob == null) {
                                class ProgressJob
                                extends Job {
                                    ProgressJob(String name) {
                                        super(name);
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    protected IStatus run(IProgressMonitor monitor) {
                                        IJob job = JobManager.this.currentJob();
                                        while (!monitor.isCanceled() && job != null) {
                                            String taskName = Messages.jobmanager_indexing + Messages.bind(Messages.jobmanager_filesToIndex, job.getJobFamily(), Integer.toString(JobManager.this.awaitingJobsCount()));
                                            monitor.subTask(taskName);
                                            this.setName(taskName);
                                            JobManager jobManager = JobManager.this;
                                            synchronized (jobManager) {
                                                if (JobManager.this.currentJob() != null) {
                                                    try {
                                                        JobManager.this.wait(500L);
                                                    }
                                                    catch (InterruptedException interruptedException) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                            job = JobManager.this.currentJob();
                                        }
                                        JobManager.this.progressJob = null;
                                        return Status.OK_STATUS;
                                    }
                                }
                                ProgressJob pJob = new ProgressJob(Messages.bind(Messages.jobmanager_indexing, "", ""));
                                pJob.setPriority(30);
                                pJob.setSystem(true);
                                pJob.schedule();
                                this.progressJob = pJob;
                            }
                            if (!cacheZipFiles) {
                                JavaModelManager.getJavaModelManager().cacheZipFiles(this);
                                cacheZipFiles = true;
                            }
                            job.execute(null);
                        }
                        catch (Throwable throwable) {
                            this.executing = false;
                            if (VERBOSE) {
                                JavaModelManager.trace("FINISHED background job - " + String.valueOf(job));
                            }
                            this.moveToNextJob();
                            if (this.awaitingClients.get() == 0 && job.waitNeeded()) {
                                if (VERBOSE) {
                                    JavaModelManager.trace("WAITING after job - " + String.valueOf(job));
                                }
                                object = this.idleMonitor;
                                synchronized (object) {
                                    this.idleMonitor.wait(5L);
                                }
                            }
                            throw throwable;
                        }
                        this.executing = false;
                        if (VERBOSE) {
                            JavaModelManager.trace("FINISHED background job - " + String.valueOf(job));
                        }
                        this.moveToNextJob();
                        if (this.awaitingClients.get() != 0 || !job.waitNeeded()) continue;
                        if (VERBOSE) {
                            JavaModelManager.trace("WAITING after job - " + String.valueOf(job));
                        }
                        object = this.idleMonitor;
                        synchronized (object) {
                            this.idleMonitor.wait(5L);
                        }
                    }
                    catch (InterruptedException job) {
                        // empty catch block
                    }
                }
            }
            catch (ThreadDeath e) {
                throw e;
            }
            catch (Error | RuntimeException e) {
                if (this.getProcessingThread() != null) {
                    Util.log(e, "Background Indexer Crash Recovery");
                    this.discardJobs(null);
                    JobManager jobManager = this;
                    synchronized (jobManager) {
                        this.processingThread = null;
                    }
                    this.reset();
                }
                throw e;
            }
        }
        finally {
            if (cacheZipFiles) {
                JavaModelManager.getJavaModelManager().flushZipFiles(this);
                cacheZipFiles = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (VERBOSE) {
            JavaModelManager.trace("Shutdown");
        }
        this.disable();
        this.discardJobs(null);
        Thread thread = this.getProcessingThread();
        try {
            Job job;
            if (thread != null) {
                JobManager jobManager = this;
                synchronized (jobManager) {
                    this.processingThread = null;
                    this.notifyAll();
                }
                thread.join();
            }
            if ((job = this.progressJob) != null) {
                job.cancel();
                job.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized String toString() {
        StringBuilder buffer = new StringBuilder(10);
        buffer.append("Enable count:").append(this.enableCount).append('\n');
        int numJobs = this.awaitingJobs.size();
        buffer.append("Jobs in queue:").append(numJobs).append('\n');
        int i = 0;
        while (i < numJobs && i < 15) {
            buffer.append(i).append(" - job[" + i + "]: ").append(this.awaitingJobs.get(i)).append('\n');
            ++i;
        }
        return buffer.toString();
    }
}

