/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.function.Function;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.DocumentAdapter;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public final class JsonRpcHelpers {
    private JsonRpcHelpers() {
    }

    public static int toOffset(IOpenable openable, int line, int column) {
        if (openable != null) {
            try {
                return JsonRpcHelpers.convert(openable, document -> JsonRpcHelpers.toOffset(document, line, column));
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.log((CoreException)((Object)e));
            }
        }
        return -1;
    }

    public static int toOffset(IBuffer buffer, int line, int column) {
        if (buffer != null) {
            return JsonRpcHelpers.toOffset(JsonRpcHelpers.toDocument(buffer), line, column);
        }
        return -1;
    }

    public static int toOffset(IDocument document, int line, int column) {
        if (document != null) {
            try {
                return document.getLineOffset(line) + column;
            }
            catch (BadLocationException e) {
                JavaLanguageServerPlugin.debugTrace("toOffset: " + (e.getMessage() == null ? e.toString() : e.getMessage()));
            }
        }
        return -1;
    }

    public static int[] toLine(IBuffer buffer, int offset) {
        return JsonRpcHelpers.toLine(JsonRpcHelpers.toDocument(buffer), offset);
    }

    public static int[] toLine(IOpenable openable, int offset) {
        try {
            return JsonRpcHelpers.convert(openable, document -> JsonRpcHelpers.toLine(document, offset));
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.log((CoreException)((Object)e));
            return null;
        }
    }

    private static <T> T convert(IOpenable openable, Function<IDocument, T> consumer) throws JavaModelException {
        Assert.isNotNull((Object)openable, (String)"openable");
        boolean mustClose = false;
        try {
            if (!openable.isOpen()) {
                openable.open((IProgressMonitor)new NullProgressMonitor());
                mustClose = openable.isOpen();
            }
            IBuffer buffer = openable.getBuffer();
            T t = consumer.apply(JsonRpcHelpers.toDocument(buffer));
            return t;
        }
        finally {
            if (mustClose) {
                try {
                    openable.close();
                }
                catch (JavaModelException e) {
                    JavaLanguageServerPlugin.logException("Error when closing openable: " + String.valueOf(openable), e);
                }
            }
        }
    }

    public static int[] toLine(IDocument document, int offset) {
        if (document != null) {
            try {
                int line = document.getLineOfOffset(offset);
                int column = offset - document.getLineOffset(line);
                return new int[]{line, column};
            }
            catch (BadLocationException e) {
                JavaLanguageServerPlugin.debugTrace("toLine: " + (e.getMessage() == null ? e.toString() : e.getMessage()));
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static IDocument toDocument(IBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        IBuffer iBuffer = buffer;
        if (iBuffer instanceof IDocument) {
            void doc;
            IDocument iDocument = (IDocument)iBuffer;
            IDocument cfr_ignored_0 = (IDocument)iBuffer;
            return doc;
        }
        IBuffer iBuffer2 = buffer;
        if (iBuffer2 instanceof DocumentAdapter) {
            void adapter;
            DocumentAdapter documentAdapter = (DocumentAdapter)iBuffer2;
            DocumentAdapter cfr_ignored_1 = (DocumentAdapter)iBuffer2;
            IDocument document = adapter.getDocument();
            if (document != null) {
                return document;
            }
        }
        return new org.eclipse.jdt.internal.core.DocumentAdapter(buffer);
    }

    public static IDocument toDocument(IFile file) {
        if (file != null && file.isAccessible()) {
            IPath path = file.getFullPath();
            ITextFileBufferManager fileBufferManager = FileBuffers.getTextFileBufferManager();
            LocationKind kind = LocationKind.IFILE;
            try {
                fileBufferManager.connect(path, kind, (IProgressMonitor)new NullProgressMonitor());
                ITextFileBuffer fileBuffer = fileBufferManager.getTextFileBuffer(path, kind);
                if (fileBuffer != null) {
                    IDocument iDocument = fileBuffer.getDocument();
                    return iDocument;
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Failed to convert " + String.valueOf(file) + "  to an IDocument", e);
            }
            finally {
                try {
                    fileBufferManager.disconnect(path, kind, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {}
            }
        }
        return null;
    }
}

