/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.internal.net.ProxySelector;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.core.manipulation.MembersOrderPreferenceCacheCommon;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.ls.core.contentassist.ICompletionContributionService;
import org.eclipse.jdt.ls.core.internal.BaseJDTLanguageServer;
import org.eclipse.jdt.ls.core.internal.ConnectionStreamFactory;
import org.eclipse.jdt.ls.core.internal.DiagnosticsState;
import org.eclipse.jdt.ls.core.internal.JDTEnvironmentUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.LanguageServerApplication;
import org.eclipse.jdt.ls.core.internal.ParentProcessWatcher;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.jdt.ls.core.internal.corext.template.java.JavaContextTypeRegistry;
import org.eclipse.jdt.ls.core.internal.corext.template.java.JavaLanguageServerTemplateStore;
import org.eclipse.jdt.ls.core.internal.handlers.CompletionContributionService;
import org.eclipse.jdt.ls.core.internal.handlers.JDTLanguageServer;
import org.eclipse.jdt.ls.core.internal.handlers.LogHandler;
import org.eclipse.jdt.ls.core.internal.managers.ContentProviderManager;
import org.eclipse.jdt.ls.core.internal.managers.DigestStore;
import org.eclipse.jdt.ls.core.internal.managers.ISourceDownloader;
import org.eclipse.jdt.ls.core.internal.managers.MavenSourceDownloader;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.managers.StandardProjectsManager;
import org.eclipse.jdt.ls.core.internal.managers.TelemetryManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.StandardPreferenceManager;
import org.eclipse.jdt.ls.core.internal.syntaxserver.SyntaxLanguageServer;
import org.eclipse.jdt.ls.core.internal.syntaxserver.SyntaxProjectsManager;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.text.templates.ContextTypeRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;

public class JavaLanguageServerPlugin
extends Plugin {
    public static final String JDT_UI_PLUGIN = "org.eclipse.jdt.ui";
    public static final String MANUAL = "Manual";
    public static final String DIRECT = "Direct";
    public static final String NATIVE = "Native";
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";
    public static final String HTTPS_NON_PROXY_HOSTS = "https.nonProxyHosts";
    public static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    public static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTPS_PROXY_USER = "https.proxyUser";
    public static final String HTTP_PROXY_USER = "http.proxyUser";
    public static final String SERVER_SOURCE_ID = "Java";
    @Deprecated
    public static final String PLUGIN_ID = "org.eclipse.jdt.ls.core";
    public static final String DEFAULT_MEMBER_SORT_ORDER = "T,SF,SI,SM,F,I,C,M";
    public static final String DEFAULT_VISIBILITY_SORT_ORDER = "B,R,D,V";
    private static JavaLanguageServerPlugin pluginInstance;
    private static BundleContext context;
    private ServiceTracker<IProxyService, IProxyService> proxyServiceTracker = null;
    private ISourceDownloader sourceDownloader;
    private LanguageServerApplication languageServer;
    private ProjectsManager projectsManager;
    private DigestStore digestStore;
    private ContentProviderManager contentProviderManager;
    private BaseJDTLanguageServer protocol;
    private PreferenceManager preferenceManager;
    private TypeFilter typeFilter;
    private ContextTypeRegistry fContextTypeRegistry;
    private JavaLanguageServerTemplateStore fTemplateStore;
    private DiagnosticsState nonProjectDiagnosticsState;
    private ExecutorService executorService;
    private CompletionContributionService completionContributionService;
    private LogHandler logHandler;

    public static LanguageServerApplication getLanguageServer() {
        return pluginInstance == null ? null : JavaLanguageServerPlugin.pluginInstance.languageServer;
    }

    public static BundleContext getBundleContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        context = bundleContext;
        pluginInstance = this;
        this.setPreferenceNodeId();
        this.logHandler = new LogHandler();
        this.logHandler.install();
        if (JDTEnvironmentUtils.isSyntaxServer()) {
            this.disableServices();
            this.preferenceManager = new PreferenceManager();
            this.projectsManager = new SyntaxProjectsManager(this.preferenceManager);
        } else {
            this.preferenceManager = new StandardPreferenceManager();
            this.projectsManager = new StandardProjectsManager(this.preferenceManager);
        }
        this.digestStore = new DigestStore(this.getStateLocation().toFile());
        try {
            ResourcesPlugin.getWorkspace().addSaveParticipant(PLUGIN_ID, (ISaveParticipant)this.projectsManager);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
        this.contentProviderManager = new ContentProviderManager(this.preferenceManager);
        this.nonProjectDiagnosticsState = new DiagnosticsState();
        JavaLanguageServerPlugin.logInfo(String.valueOf(((Object)((Object)this)).getClass()) + " is started");
        this.configureProxy();
        if (System.getProperty("jdt.codeCompleteSubstringMatch") == null) {
            System.setProperty("jdt.codeCompleteSubstringMatch", "false");
        }
        Job initializeAfterLoad = new Job("Initialize After Load"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    JavaCore.initializeAfterLoad((IProgressMonitor)monitor);
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException(e);
                    try {
                        JavaCore.rebuildIndex((IProgressMonitor)monitor);
                    }
                    catch (CoreException e1) {
                        JavaLanguageServerPlugin.logException(e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        initializeAfterLoad.setPriority(20);
        initializeAfterLoad.schedule();
    }

    private void disableServices() {
        try {
            ProjectsManager.setAutoBuilding(false);
        }
        catch (CoreException e1) {
            JavaLanguageServerPlugin.logException(e1);
        }
        IndexManager indexManager = JavaModelManager.getIndexManager();
        if (indexManager != null) {
            indexManager.shutdown();
        }
    }

    private void setPreferenceNodeId() {
        Bundle bundle = Platform.getBundle((String)JDT_UI_PLUGIN);
        if (bundle != null && bundle.getState() != 32) {
            try {
                bundle.start();
            }
            catch (BundleException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        JavaManipulation.setPreferenceNodeId(null);
        JavaManipulation.setPreferenceNodeId((String)PLUGIN_ID);
        MembersOrderPreferenceCacheCommon preferenceCache = JavaManipulationPlugin.getDefault().getMembersOrderPreferenceCacheCommon();
        preferenceCache.install();
    }

    private void configureProxy() {
        if (Boolean.getBoolean("jdt.ls.disableProxies")) {
            ProxySelector.setActiveProvider((String)DIRECT);
            return;
        }
        String httpHost = System.getProperty(HTTP_PROXY_HOST);
        String httpPort = System.getProperty(HTTP_PROXY_PORT);
        final String httpUser = System.getProperty(HTTP_PROXY_USER);
        final String httpPassword = System.getProperty(HTTP_PROXY_PASSWORD);
        String httpsHost = System.getProperty(HTTPS_PROXY_HOST);
        String httpsPort = System.getProperty(HTTPS_PROXY_PORT);
        String httpsUser = System.getProperty(HTTPS_PROXY_USER);
        String httpsPassword = System.getProperty(HTTPS_PROXY_PASSWORD);
        String httpsNonProxyHosts = System.getProperty(HTTPS_NON_PROXY_HOSTS);
        String httpNonProxyHosts = System.getProperty(HTTP_NON_PROXY_HOSTS);
        if (StringUtils.isNotBlank((CharSequence)httpUser) || StringUtils.isNotBlank((CharSequence)httpsUser)) {
            IProxyService proxyService;
            try {
                Platform.getBundle((String)"org.eclipse.core.net").start(1);
            }
            catch (BundleException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
            if (StringUtils.isNotBlank((CharSequence)httpUser) && StringUtils.isNotBlank((CharSequence)httpPassword)) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(httpUser, httpPassword.toCharArray());
                    }
                });
            }
            if ((proxyService = this.getProxyService()) != null) {
                IProxyData[] proxies;
                ProxySelector.setActiveProvider((String)MANUAL);
                IProxyData[] iProxyDataArray = proxies = proxyService.getProxyData();
                int n = proxies.length;
                int n2 = 0;
                while (n2 < n) {
                    IProxyData proxy = iProxyDataArray[n2];
                    if ("HTTP".equals(proxy.getType())) {
                        proxy.setHost(httpHost);
                        proxy.setPort(httpPort == null ? -1 : Integer.valueOf(httpPort));
                        proxy.setPassword(httpPassword);
                        proxy.setUserid(httpUser);
                    }
                    if ("HTTPS".equals(proxy.getType())) {
                        proxy.setHost(httpsHost);
                        proxy.setPort(httpsPort == null ? -1 : Integer.valueOf(httpsPort));
                        proxy.setPassword(httpsPassword);
                        proxy.setUserid(httpsUser);
                    }
                    ++n2;
                }
                try {
                    proxyService.setProxyData(proxies);
                    if (httpHost != null) {
                        System.setProperty(HTTP_PROXY_HOST, httpHost);
                    }
                    if (httpPort != null) {
                        System.setProperty(HTTP_PROXY_PORT, httpPort);
                    }
                    if (httpUser != null) {
                        System.setProperty(HTTP_PROXY_USER, httpUser);
                    }
                    if (httpPassword != null) {
                        System.setProperty(HTTP_PROXY_PASSWORD, httpPassword);
                    }
                    if (httpsHost != null) {
                        System.setProperty(HTTPS_PROXY_HOST, httpsHost);
                    }
                    if (httpsPort != null) {
                        System.setProperty(HTTPS_PROXY_PORT, httpsPort);
                    }
                    if (httpsUser != null) {
                        System.setProperty(HTTPS_PROXY_USER, httpsUser);
                    }
                    if (httpsPassword != null) {
                        System.setProperty(HTTPS_PROXY_PASSWORD, httpsPassword);
                    }
                    if (httpsNonProxyHosts != null) {
                        System.setProperty(HTTPS_NON_PROXY_HOSTS, httpsNonProxyHosts);
                    }
                    if (httpNonProxyHosts != null) {
                        System.setProperty(HTTP_NON_PROXY_HOSTS, httpNonProxyHosts);
                    }
                }
                catch (CoreException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
        } else {
            ProxySelector.setActiveProvider((String)NATIVE);
            return;
        }
    }

    public IProxyService getProxyService() {
        try {
            if (this.proxyServiceTracker == null) {
                this.proxyServiceTracker = new ServiceTracker(context, IProxyService.class.getName(), null);
                this.proxyServiceTracker.open();
            }
            return (IProxyService)this.proxyServiceTracker.getService();
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return null;
        }
    }

    private void startConnection() throws IOException {
        Launcher launcher;
        TelemetryManager telemetryManager = new TelemetryManager();
        boolean firstTimeInitialization = ProjectUtils.getAllProjects().length == 0;
        telemetryManager.onLanguageServerStart(System.currentTimeMillis(), firstTimeInitialization);
        ExecutorService executorService = JavaLanguageServerPlugin.getExecutorService();
        this.protocol = JDTEnvironmentUtils.isSyntaxServer() ? new SyntaxLanguageServer(this.contentProviderManager, this.projectsManager, this.preferenceManager) : new JDTLanguageServer(this.projectsManager, this.preferenceManager, telemetryManager);
        if (JDTEnvironmentUtils.inSocketStreamDebugMode()) {
            String host = JDTEnvironmentUtils.getClientHost();
            Integer port = JDTEnvironmentUtils.getClientPort();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(host, (int)port);
            AsynchronousServerSocketChannel serverSocket = AsynchronousServerSocketChannel.open().bind(inetSocketAddress);
            try {
                AsynchronousSocketChannel socketChannel = serverSocket.accept().get();
                InputStream in = Channels.newInputStream(socketChannel);
                OutputStream out = Channels.newOutputStream(socketChannel);
                Function<MessageConsumer, MessageConsumer> messageConsumer = it -> it;
                launcher = Launcher.createIoLauncher((Object)this.protocol, JavaClientConnection.JavaLanguageClient.class, (InputStream)in, (OutputStream)out, (ExecutorService)executorService, messageConsumer);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Error when opening a socket channel at " + host + ":" + String.valueOf(port) + ".", e);
            }
        } else {
            ConnectionStreamFactory connectionFactory = new ConnectionStreamFactory(this.languageServer);
            InputStream in = connectionFactory.getInputStream();
            OutputStream out = connectionFactory.getOutputStream();
            ParentProcessWatcher wrapper = "false".equals(System.getProperty("watchParentProcess")) ? it -> it : new ParentProcessWatcher(this.languageServer);
            launcher = Launcher.createLauncher((Object)this.protocol, JavaClientConnection.JavaLanguageClient.class, (InputStream)in, (OutputStream)out, (ExecutorService)executorService, (Function)wrapper);
        }
        this.protocol.connectClient((JavaClientConnection.JavaLanguageClient)launcher.getRemoteProxy());
        launcher.startListening();
        this.logHandler.setClientConnection(pluginInstance.getClientConnection());
    }

    public void stop(BundleContext bundleContext) throws Exception {
        JavaLanguageServerPlugin.logInfo(String.valueOf(((Object)((Object)this)).getClass()) + " is stopping:");
        pluginInstance = null;
        context = null;
        ResourcesPlugin.getWorkspace().removeSaveParticipant(PLUGIN_ID);
        this.projectsManager = null;
        this.contentProviderManager = null;
        this.languageServer = null;
    }

    public WorkingCopyOwner getWorkingCopyOwner() {
        return this.protocol.getWorkingCopyOwner();
    }

    public static JavaLanguageServerPlugin getInstance() {
        return pluginInstance;
    }

    public static DiagnosticsState getNonProjectDiagnosticsState() {
        return JavaLanguageServerPlugin.pluginInstance.nonProjectDiagnosticsState;
    }

    public static void log(IStatus status) {
        if (context != null) {
            Platform.getLog((Bundle)context.getBundle()).log(status);
        }
    }

    public static void log(CoreException e) {
        JavaLanguageServerPlugin.log(e.getStatus());
    }

    public static void logError(String message) {
        if (context != null) {
            JavaLanguageServerPlugin.log((IStatus)new Status(4, context.getBundle().getSymbolicName(), message));
        }
    }

    public static void logInfo(String message) {
        if (context != null) {
            JavaLanguageServerPlugin.log((IStatus)new Status(1, context.getBundle().getSymbolicName(), message));
        }
    }

    public static void debugTrace(String message) {
        if (context != null && Boolean.getBoolean("jdt.ls.debug")) {
            JavaLanguageServerPlugin.log((IStatus)new Status(1, context.getBundle().getSymbolicName(), message));
        }
    }

    public static void logException(Throwable ex) {
        if (context != null) {
            String message = ex.getMessage();
            if (message == null) {
                message = Throwables.getStackTraceAsString((Throwable)ex);
            }
            JavaLanguageServerPlugin.logException(message, ex);
        }
    }

    public static void logException(String message, Throwable ex) {
        if (context != null) {
            JavaLanguageServerPlugin.log((IStatus)new Status(4, context.getBundle().getSymbolicName(), message, ex));
        }
    }

    public static void sendStatus(ServiceStatus serverStatus, String status) {
        if (pluginInstance != null && JavaLanguageServerPlugin.pluginInstance.protocol != null) {
            JavaLanguageServerPlugin.pluginInstance.protocol.sendStatus(serverStatus, status);
        }
    }

    static void startLanguageServer(LanguageServerApplication newLanguageServer) throws IOException {
        if (pluginInstance != null) {
            JavaLanguageServerPlugin.pluginInstance.languageServer = newLanguageServer;
            pluginInstance.startConnection();
        }
    }

    public static ProjectsManager getProjectsManager() {
        return JavaLanguageServerPlugin.pluginInstance.projectsManager;
    }

    public static DigestStore getDigestStore() {
        return JavaLanguageServerPlugin.pluginInstance.digestStore;
    }

    public static ContentProviderManager getContentProviderManager() {
        return JavaLanguageServerPlugin.pluginInstance.contentProviderManager;
    }

    public static String getVersion() {
        return context == null ? "Unknown" : context.getBundle().getVersion().toString();
    }

    public static PreferenceManager getPreferencesManager() {
        if (pluginInstance != null) {
            return JavaLanguageServerPlugin.pluginInstance.preferenceManager;
        }
        return null;
    }

    public void unregisterCapability(String id, String method) {
        if (this.protocol != null) {
            this.protocol.unregisterCapability(id, method);
        }
    }

    public void registerCapability(String id, String method) {
        this.registerCapability(id, method, null);
    }

    public void registerCapability(String id, String method, Object options) {
        if (this.protocol != null) {
            this.protocol.registerCapability(id, method, options);
        }
    }

    public void setProtocol(JDTLanguageServer protocol) {
        this.protocol = protocol;
    }

    public BaseJDTLanguageServer getProtocol() {
        return this.protocol;
    }

    public JavaClientConnection getClientConnection() {
        if (this.protocol != null) {
            return this.protocol.getClientConnection();
        }
        return null;
    }

    public synchronized ContextTypeRegistry getTemplateContextRegistry() {
        if (this.fContextTypeRegistry == null) {
            this.fContextTypeRegistry = new JavaContextTypeRegistry();
        }
        return this.fContextTypeRegistry;
    }

    public JavaLanguageServerTemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            this.fTemplateStore = new JavaLanguageServerTemplateStore(this.getTemplateContextRegistry(), DefaultScope.INSTANCE.getNode(JavaManipulation.getPreferenceNodeId()), "");
            try {
                this.fTemplateStore.load();
            }
            catch (IOException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        return this.fTemplateStore;
    }

    public static void setPreferencesManager(PreferenceManager preferenceManager) {
        if (pluginInstance != null) {
            JavaLanguageServerPlugin.pluginInstance.preferenceManager = preferenceManager;
        }
    }

    public synchronized TypeFilter getTypeFilter() {
        if (this.typeFilter == null) {
            this.typeFilter = new TypeFilter();
        }
        return this.typeFilter;
    }

    public static synchronized ISourceDownloader getDefaultSourceDownloader() {
        if (JavaLanguageServerPlugin.pluginInstance.sourceDownloader == null) {
            JavaLanguageServerPlugin.pluginInstance.sourceDownloader = new MavenSourceDownloader();
        }
        return JavaLanguageServerPlugin.pluginInstance.sourceDownloader;
    }

    public static synchronized ExecutorService getExecutorService() {
        if (JavaLanguageServerPlugin.pluginInstance.executorService == null || JavaLanguageServerPlugin.pluginInstance.executorService.isShutdown()) {
            JavaLanguageServerPlugin.pluginInstance.executorService = Executors.newCachedThreadPool();
        }
        return JavaLanguageServerPlugin.pluginInstance.executorService;
    }

    public static synchronized ICompletionContributionService getCompletionContributionService() {
        if (JavaLanguageServerPlugin.pluginInstance.completionContributionService == null) {
            JavaLanguageServerPlugin.pluginInstance.completionContributionService = new CompletionContributionService();
        }
        return JavaLanguageServerPlugin.pluginInstance.completionContributionService;
    }
}

