/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.javac;

import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.JavaFileManager;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IDependent;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.javac.JavacClassFile;
import org.eclipse.jdt.internal.javac.JavacConfig;
import org.eclipse.jdt.internal.javac.ProcessorConfig;

public class JavacUtils {
    public static void configureJavacContext(Context context, Map<String, String> compilerOptions, IJavaProject javaProject, boolean isTest) {
        JavacUtils.configureJavacContext(context, compilerOptions, javaProject, null, null, isTest);
    }

    public static void configureJavacContext(Context context, JavacConfig compilerConfig, IJavaProject javaProject, File output, boolean isTest) {
        JavacUtils.configureJavacContext(context, compilerConfig.compilerOptions().getMap(), javaProject, compilerConfig, output, isTest);
    }

    private static void configureJavacContext(Context context, Map<String, String> compilerOptions, IJavaProject javaProject, JavacConfig compilerConfig, File output, boolean isTest) {
        IClasspathEntry[] classpath = new IClasspathEntry[]{};
        if (javaProject != null && javaProject.getProject() != null) {
            try {
                classpath = javaProject.getRawClasspath();
            }
            catch (JavaModelException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)ex);
            }
        }
        String addExports = Arrays.stream(classpath).filter(entry -> entry.getEntryKind() == 5).map(IClasspathEntry::getExtraAttributes).flatMap(Arrays::stream).filter(attribute -> "add-exports".equals(attribute.getName())).map(IClasspathAttribute::getValue).map(value -> value.split(":")).flatMap(Arrays::stream).collect(Collectors.joining("\u0000"));
        JavacUtils.configureOptions(javaProject, context, compilerOptions, addExports);
        if (context.get(JavaFileManager.class) == null) {
            JavacFileManager.preRegister(context);
        }
        if (javaProject instanceof JavaProject) {
            JavaProject internal = (JavaProject)javaProject;
            JavacUtils.configurePaths(internal, context, compilerConfig, output, isTest);
        }
    }

    private static void configureOptions(IJavaProject javaProject, Context context, Map<String, String> compilerOptions, String addExports) {
        Runtime.Version complianceVersion;
        boolean nineOrLater = false;
        Options options = Options.instance(context);
        options.put("allowStringFolding", Boolean.FALSE.toString());
        String compliance = compilerOptions.get("org.eclipse.jdt.core.compiler.compliance");
        if ("1.8".equals(compliance)) {
            compliance = "8";
            nineOrLater = false;
        }
        if ("enabled".equals(compilerOptions.get("org.eclipse.jdt.core.compiler.release")) && compliance != null && !compliance.isEmpty()) {
            complianceVersion = Runtime.Version.parse(compliance);
            options.put(Option.RELEASE, compliance);
            nineOrLater = complianceVersion.compareTo(Runtime.Version.parse("9")) >= 0;
        } else {
            String source = compilerOptions.get("org.eclipse.jdt.core.compiler.source");
            if ("1.8".equals(source)) {
                source = "8";
                nineOrLater = false;
            }
            if (source != null && !source.isBlank()) {
                complianceVersion = Runtime.Version.parse(source);
                if (complianceVersion.compareToIgnoreOptional(Runtime.Version.parse("8")) < 0) {
                    ILog.get().warn("Unsupported source level: " + source + ", using 8 instead");
                    options.put(Option.SOURCE, "8");
                    nineOrLater = false;
                } else {
                    options.put(Option.SOURCE, source);
                    nineOrLater = complianceVersion.compareTo(Runtime.Version.parse("9")) >= 0;
                }
            } else {
                complianceVersion = Runtime.version();
                nineOrLater = true;
            }
            IClasspathEntry[] target = compilerOptions.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform");
            if ("1.8".equals(target)) {
                target = "8";
                nineOrLater = false;
            }
            if (target != null && !target.isEmpty()) {
                Runtime.Version version = Runtime.Version.parse((String)target);
                if (version.compareToIgnoreOptional(Runtime.Version.parse("8")) < 0) {
                    ILog.get().warn("Unsupported target level: " + (String)target + ", using 8 instead");
                    options.put(Option.TARGET, "8");
                    nineOrLater = false;
                } else {
                    if (Integer.parseInt((String)target) < Integer.parseInt(source)) {
                        ILog.get().warn("javac requires the source version to be less than or equal to the target version. Targetting " + source + " instead");
                        target = source;
                    }
                    options.put(Option.TARGET, (String)target);
                }
            }
        }
        if ("enabled".equals(compilerOptions.get("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures")) && Runtime.version().feature() == complianceVersion.feature()) {
            options.put(Option.PREVIEW, Boolean.toString(true));
        }
        options.put(Option.XLINT, Boolean.toString(true));
        options.put(Option.XLINT_CUSTOM, "all");
        options.put(Option.XDOCLINT, Boolean.toString(true));
        options.put(Option.XDOCLINT_CUSTOM, "all");
        if (addExports != null && !addExports.isBlank()) {
            options.put(Option.ADD_EXPORTS, addExports);
        }
        if ("enabled".equals(compilerOptions.get("org.eclipse.jdt.core.compiler.doc.comment.support"))) {
            options.put(Option.XDOCLINT, Boolean.toString(true));
        }
        if (nineOrLater && !options.isSet(Option.RELEASE) && javaProject instanceof JavaProject) {
            JavaProject javaProjectImpl = (JavaProject)javaProject;
            try {
                for (IClasspathEntry entry : javaProject.getRawClasspath()) {
                    if (entry.getPath() == null || !entry.getPath().toString().startsWith("org.eclipse.jdt.launching.JRE_CONTAINER")) continue;
                    for (IClasspathEntry resolved : javaProjectImpl.resolveClasspath(new IClasspathEntry[]{entry})) {
                        options.put(Option.SYSTEM, resolved.getPath().toString());
                    }
                }
            }
            catch (JavaModelException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)ex);
            }
        }
        Map<String, String> processorOptions = ProcessorConfig.getProcessorOptions(javaProject);
        for (Map.Entry<String, String> processorOption : processorOptions.entrySet()) {
            options.put("-A" + processorOption.getKey() + "=" + processorOption.getValue(), Boolean.toString(true));
        }
        JavacUtils.addDebugInfos(compilerOptions, options);
    }

    private static void addDebugInfos(Map<String, String> compilerOptions, Options options) {
        boolean generateVars = "generate".equals(compilerOptions.get("org.eclipse.jdt.core.compiler.debug.localVariable"));
        boolean generateLines = "generate".equals(compilerOptions.get("org.eclipse.jdt.core.compiler.debug.lineNumber"));
        boolean generateSource = "generate".equals(compilerOptions.get("org.eclipse.jdt.core.compiler.debug.sourceFile"));
        if (generateVars && generateLines && generateSource) {
            options.put(Option.G, Boolean.toString(true));
        } else if (!(generateVars || generateLines || generateSource)) {
            options.put(Option.G_CUSTOM, Boolean.toString(true));
            options.put(Option.G_NONE, Boolean.toString(true));
        } else {
            options.put(Option.G_CUSTOM, Boolean.toString(true));
            if (generateVars) {
                options.put("-g:vars", Boolean.toString(true));
            }
            if (generateLines) {
                options.put("-g:lines", Boolean.toString(true));
            }
            if (generateSource) {
                options.put("-g:source", Boolean.toString(true));
            }
        }
    }

    private static void configurePaths(JavaProject javaProject, Context context, JavacConfig compilerConfig, File output, boolean isTest) {
        StandardJavaFileManager fileManager = (StandardJavaFileManager)context.get(JavaFileManager.class);
        try {
            IResource member;
            if (compilerConfig != null && !JavacUtils.isEmpty(compilerConfig.annotationProcessorPaths())) {
                fileManager.setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, compilerConfig.annotationProcessorPaths().stream().map(File::new).toList());
            }
            if (compilerConfig != null && !JavacUtils.isEmpty(compilerConfig.generatedSourcePaths())) {
                fileManager.setLocation(StandardLocation.SOURCE_OUTPUT, compilerConfig.generatedSourcePaths().stream().map(File::new).map(file -> {
                    if (!file.exists() && !file.mkdirs()) {
                        ILog.get().warn("Failed to create generated source file directory: " + String.valueOf(file));
                    }
                    return file;
                }).toList());
            }
            if (output != null) {
                fileManager.setLocation(StandardLocation.CLASS_OUTPUT, List.of(JavacUtils.ensureDirExists(output)));
            } else if (compilerConfig != null && !compilerConfig.sourceOutputMapping().isEmpty()) {
                fileManager.setLocation(StandardLocation.CLASS_OUTPUT, compilerConfig.sourceOutputMapping().values().stream().distinct().map(container -> JavacUtils.ensureDirExists(JavacClassFile.getMappedTempOutput(container).toFile())).toList());
            } else if (javaProject.getProject() != null && (member = javaProject.getProject().getParent().findMember(javaProject.getOutputLocation())) != null) {
                File f = member.getLocation().toFile();
                fileManager.setLocation(StandardLocation.CLASS_OUTPUT, List.of(JavacUtils.ensureDirExists(f)));
            }
            boolean sourcePathEnabled = false;
            if (compilerConfig != null && !JavacUtils.isEmpty(compilerConfig.sourcepaths())) {
                fileManager.setLocation(StandardLocation.SOURCE_PATH, compilerConfig.sourcepaths().stream().map(File::new).toList());
                sourcePathEnabled = true;
            }
            if (compilerConfig != null && !JavacUtils.isEmpty(compilerConfig.moduleSourcepaths())) {
                fileManager.setLocation(StandardLocation.MODULE_SOURCE_PATH, compilerConfig.moduleSourcepaths().stream().map(File::new).toList());
                sourcePathEnabled = true;
            }
            if (!sourcePathEnabled) {
                fileManager.setLocation(StandardLocation.SOURCE_PATH, JavacUtils.classpathEntriesToFiles(javaProject, entry -> entry.getEntryKind() == 3 && (isTest || !entry.isTest())));
            }
            boolean classpathEnabled = false;
            if (compilerConfig != null && !JavacUtils.isEmpty(compilerConfig.classpaths())) {
                fileManager.setLocation(StandardLocation.CLASS_PATH, compilerConfig.classpaths().stream().map(File::new).toList());
                classpathEnabled = true;
            }
            if (compilerConfig != null && !JavacUtils.isEmpty(compilerConfig.modulepaths())) {
                fileManager.setLocation(StandardLocation.MODULE_PATH, compilerConfig.modulepaths().stream().map(File::new).toList());
                classpathEnabled = true;
            }
            if (!classpathEnabled) {
                Set moduleProjects = Stream.of(javaProject.getExpandedClasspath()).filter(classpath -> classpath.getEntryKind() == 2).map(classpath -> javaProject.getJavaModel().getJavaProject(classpath.getPath().lastSegment())).filter(Objects::nonNull).filter(classpathJavaProject -> {
                    try {
                        return classpathJavaProject.getModuleDescription() != null;
                    }
                    catch (JavaModelException e) {
                        return false;
                    }
                }).collect(Collectors.toSet());
                fileManager.setLocation(StandardLocation.CLASS_PATH, JavacUtils.classpathEntriesToFiles(javaProject, entry -> entry.getEntryKind() != 3 && (isTest || !entry.isTest())));
                if (!moduleProjects.isEmpty()) {
                    fileManager.setLocation(StandardLocation.MODULE_PATH, moduleProjects.stream().map(project -> {
                        try {
                            IPath relativeOutputPath = project.getOutputLocation();
                            IPath absPath = javaProject.getProject().getParent().findMember(relativeOutputPath).getLocation();
                            return absPath.toOSString();
                        }
                        catch (JavaModelException e) {
                            return null;
                        }
                    }).filter(Objects::nonNull).map(File::new).toList());
                }
            }
        }
        catch (Exception ex) {
            ILog.get().error(ex.getMessage(), (Throwable)ex);
        }
    }

    public static <T> boolean isEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    private static Collection<File> classpathEntriesToFiles(JavaProject project, Predicate<IClasspathEntry> select) {
        try {
            LinkedHashSet<File> res = new LinkedHashSet<File>();
            LinkedList<IClasspathEntry> toProcess = new LinkedList<IClasspathEntry>();
            toProcess.addAll(Arrays.asList(project.resolveClasspath(project.getExpandedClasspath())));
            while (!toProcess.isEmpty()) {
                IClasspathEntry current = (IClasspathEntry)toProcess.poll();
                if (current.getEntryKind() == 2 && select.test(current)) {
                    IProject referencedProject;
                    JavaProject referencedJavaProject;
                    IResource referencedResource = project.getProject().getParent().findMember(current.getPath());
                    if (!(referencedResource instanceof IProject) || !(referencedJavaProject = (JavaProject)JavaCore.create((IProject)(referencedProject = (IProject)referencedResource))).exists()) continue;
                    IModuleDescription moduleDescription = null;
                    try {
                        moduleDescription = referencedJavaProject.getModuleDescription();
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                    if (moduleDescription != null) continue;
                    IPath path = referencedJavaProject.getOutputLocation();
                    JavacUtils.addPath(referencedJavaProject, path, res);
                    for (IClasspathEntry transitiveEntry : referencedJavaProject.resolveClasspath(referencedJavaProject.getExpandedClasspath())) {
                        if (transitiveEntry.getEntryKind() == 3) {
                            IPath outputLocation = transitiveEntry.getOutputLocation();
                            if (outputLocation == null || !select.test(transitiveEntry)) continue;
                            JavacUtils.addPath(referencedJavaProject, outputLocation, res);
                            continue;
                        }
                        if (!transitiveEntry.isExported()) continue;
                        toProcess.add(transitiveEntry);
                    }
                    continue;
                }
                if (!select.test(current)) continue;
                IPath path = current.getPath();
                JavacUtils.addPath(project, path, res);
            }
            return res;
        }
        catch (JavaModelException ex) {
            ILog.get().error(ex.getMessage(), (Throwable)ex);
            return List.of();
        }
    }

    private static void addPath(JavaProject project, IPath path, LinkedHashSet<File> res) {
        File asFile = path.toFile();
        if (asFile.exists()) {
            res.add(asFile);
        } else {
            IResource asResource = project.getProject().getParent().findMember(path);
            if (asResource != null && asResource.exists()) {
                res.add(asResource.getLocation().toFile());
            }
        }
    }

    private static File ensureDirExists(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static boolean isTest(IJavaProject project, ICompilationUnit[] units) {
        if (units == null || project == null || project.getResource() == null) {
            return false;
        }
        HashSet<IPath> testFolders = new HashSet<IPath>();
        try {
            for (IClasspathEntry entry : project.getResolvedClasspath(false)) {
                if (entry.getEntryKind() != 3 || !entry.isTest()) continue;
                testFolders.add(entry.getPath());
            }
            return Arrays.stream(units).map(IDependent::getFileName).map(String::new).map(Path::new).anyMatch(file -> testFolders.stream().anyMatch(folder -> folder.isPrefixOf((IPath)file)));
        }
        catch (JavaModelException ex) {
            ILog.get().error(ex.getMessage(), (Throwable)ex);
            return true;
        }
    }
}

