/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.Optional;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;

public class DOMASTNodeUtils {
    public static IJavaElement getEnclosingJavaElement(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof AbstractTypeDeclaration || node instanceof MethodDeclaration || node instanceof VariableDeclaration || node instanceof CompilationUnit || node instanceof AnnotationTypeMemberDeclaration) {
            return DOMASTNodeUtils.getDeclaringJavaElement(node);
        }
        return DOMASTNodeUtils.getEnclosingJavaElement(node.getParent());
    }

    public static IJavaElement getDeclaringJavaElement(ASTNode key) {
        if (key instanceof CompilationUnit) {
            CompilationUnit unit = (CompilationUnit)key;
            return unit.getJavaElement();
        }
        return Optional.ofNullable(key).map(DOMASTNodeUtils::getBinding).map(IBinding::getJavaElement).orElse(null);
    }

    private static IBinding getBinding(ASTNode astNode) {
        if (astNode instanceof Name) {
            Name name = (Name)astNode;
            return name.resolveBinding();
        }
        if (astNode instanceof VariableDeclaration) {
            VariableDeclaration variable = (VariableDeclaration)astNode;
            return variable.resolveBinding();
        }
        if (astNode instanceof EnumConstantDeclaration) {
            EnumConstantDeclaration enumConstantDeclaration = (EnumConstantDeclaration)astNode;
            return enumConstantDeclaration.resolveVariable();
        }
        if (astNode instanceof FieldAccess) {
            FieldAccess fieldAcces = (FieldAccess)astNode;
            return fieldAcces.resolveFieldBinding();
        }
        if (astNode instanceof MethodInvocation) {
            MethodInvocation method = (MethodInvocation)astNode;
            return method.resolveMethodBinding();
        }
        if (astNode instanceof Type) {
            Type type = (Type)astNode;
            return type.resolveBinding();
        }
        if (astNode instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration type = (AbstractTypeDeclaration)astNode;
            return type.resolveBinding();
        }
        if (astNode instanceof MethodDeclaration) {
            MethodDeclaration method = (MethodDeclaration)astNode;
            return method.resolveBinding();
        }
        if (astNode instanceof SuperFieldAccess) {
            SuperFieldAccess superField = (SuperFieldAccess)astNode;
            return superField.resolveFieldBinding();
        }
        if (astNode instanceof SuperMethodInvocation) {
            SuperMethodInvocation superMethod = (SuperMethodInvocation)astNode;
            return superMethod.resolveMethodBinding();
        }
        if (astNode instanceof SuperMethodReference) {
            SuperMethodReference superRef = (SuperMethodReference)astNode;
            return superRef.resolveMethodBinding();
        }
        if (astNode instanceof MethodRef) {
            MethodRef methodRef = (MethodRef)astNode;
            return methodRef.resolveBinding();
        }
        if (astNode instanceof MethodReference) {
            MethodReference methodRef = (MethodReference)astNode;
            return methodRef.resolveMethodBinding();
        }
        return null;
    }

    public static boolean insideDocComment(ASTNode node) {
        CompilationUnit unit;
        ASTNode aSTNode = node.getRoot();
        return aSTNode instanceof CompilationUnit && (unit = (CompilationUnit)aSTNode).getCommentList().stream().anyMatch(comment -> comment.getStartPosition() <= node.getStartPosition() && comment.getStartPosition() + comment.getLength() >= node.getStartPosition() + node.getLength());
    }
}

