/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.gson.JsonArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.ImplementationCollector;
import org.eclipse.jdt.ls.core.internal.handlers.ImplementationToLocationMapper;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class CodeLensHandler {
    private static final String JAVA_SHOW_REFERENCES_COMMAND = "java.show.references";
    private static final String JAVA_SHOW_IMPLEMENTATIONS_COMMAND = "java.show.implementations";
    public static final String IMPLEMENTATION_TYPE = "implementations";
    public static final String REFERENCES_TYPE = "references";
    private final PreferenceManager preferenceManager;

    public CodeLensHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public CodeLens resolve(CodeLens lens, IProgressMonitor monitor) {
        if (lens == null) {
            return null;
        }
        JsonArray data = (JsonArray)lens.getData();
        String type = JSONUtility.toModel(data.get(2), String.class);
        Position position = JSONUtility.toModel(data.get(1), Position.class);
        String uri = JSONUtility.toModel(data.get(0), String.class);
        String label = null;
        String command = null;
        List<Object> locations = null;
        if (REFERENCES_TYPE.equals(type)) {
            label = "reference";
            command = JAVA_SHOW_REFERENCES_COMMAND;
        } else if (IMPLEMENTATION_TYPE.equals(type)) {
            label = "implementation";
            command = JAVA_SHOW_IMPLEMENTATIONS_COMMAND;
        }
        try {
            ITypeRoot typeRoot = JDTUtils.resolveTypeRoot(uri);
            if (typeRoot != null) {
                IJavaElement element = JDTUtils.findElementAtSelection(typeRoot, position.getLine(), position.getCharacter(), this.preferenceManager, monitor);
                if (REFERENCES_TYPE.equals(type)) {
                    try {
                        locations = this.findReferences(element, monitor);
                    }
                    catch (CoreException e) {
                        JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    }
                } else if (IMPLEMENTATION_TYPE.equals(type) && (element instanceof IType || element instanceof IMethod)) {
                    try {
                        IDocument document = JsonRpcHelpers.toDocument(typeRoot.getBuffer());
                        int offset = document.getLineOffset(position.getLine()) + position.getCharacter();
                        locations = this.findImplementations(typeRoot, element, offset, monitor);
                    }
                    catch (CoreException | BadLocationException e) {
                        JavaLanguageServerPlugin.logException(e.getMessage(), e);
                    }
                }
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem resolving code lens", e);
        }
        if (locations == null) {
            locations = Collections.emptyList();
        }
        if (label != null && command != null) {
            int size;
            Command c = new Command(size + " " + label + ((size = locations.size()) == 1 ? "" : "s"), command, Arrays.asList(uri, position, locations));
            lens.setCommand(c);
        }
        return lens;
    }

    private List<Location> findImplementations(ITypeRoot root, IJavaElement element, int offset, IProgressMonitor monitor) throws CoreException {
        boolean useDefaultLocation = false;
        if (element instanceof IType) {
            IType type = (IType)element;
            useDefaultLocation = "java.lang.Object".equals(type.getFullyQualifiedName());
        }
        ImplementationToLocationMapper mapper = new ImplementationToLocationMapper(this.preferenceManager.isClientSupportsClassFileContent(), useDefaultLocation);
        ImplementationCollector<Location> searcher = new ImplementationCollector<Location>(root, (IRegion)new Region(offset, 0), element, mapper);
        return searcher.findImplementations(monitor);
    }

    private List<Location> findReferences(IJavaElement element, IProgressMonitor monitor) throws JavaModelException, CoreException {
        if (element == null) {
            return Collections.emptyList();
        }
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)element, (int)2);
        final ArrayList<Location> result = new ArrayList<Location>();
        SearchEngine engine = new SearchEngine();
        engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.createSearchScope(), new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) throws CoreException {
                if (match.getAccuracy() == 1) {
                    return;
                }
                Object o = match.getElement();
                if (o instanceof IJavaElement) {
                    IJavaElement element = (IJavaElement)o;
                    ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
                    if (compilationUnit == null) {
                        return;
                    }
                    Location location = JDTUtils.toLocation(compilationUnit, match.getOffset(), match.getLength());
                    result.add(location);
                }
            }
        }, monitor);
        return result;
    }

    public List<CodeLens> getCodeLensSymbols(String uri, IProgressMonitor monitor) {
        if (!this.preferenceManager.getPreferences().isCodeLensEnabled()) {
            return Collections.emptyList();
        }
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
        IClassFile classFile = null;
        if (unit == null ? (classFile = JDTUtils.resolveClassFile(uri)) == null : !unit.getResource().exists() || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        try {
            ICompilationUnit typeRoot = unit != null ? unit : classFile;
            IJavaElement[] elements = typeRoot.getChildren();
            LinkedHashSet<CodeLens> lenses = new LinkedHashSet<CodeLens>(elements.length);
            this.collectCodeLenses((ITypeRoot)typeRoot, elements, lenses, monitor);
            if (monitor.isCanceled()) {
                lenses.clear();
            }
            return new ArrayList<CodeLens>(lenses);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Problem getting code lenses for" + unit.getElementName(), e);
            return Collections.emptyList();
        }
    }

    private void collectCodeLenses(ITypeRoot typeRoot, IJavaElement[] elements, Collection<CodeLens> lenses, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                CodeLens lens;
                IType parentType;
                IMethod methodElement;
                IJavaElement iJavaElement;
                CodeLens lens2;
                IType type;
                String implementationsPreference;
                CodeLens lens3;
                IJavaElement element;
                block9: {
                    IJavaElement parentType2;
                    block8: {
                        element = iJavaElementArray[n2];
                        if (monitor.isCanceled()) {
                            return;
                        }
                        if (element.getElementType() != 7) break block8;
                        this.collectCodeLenses(typeRoot, ((IType)element).getChildren(), lenses, monitor);
                        break block9;
                    }
                    if (element.getElementType() != 9 || JDTUtils.isHiddenGeneratedElement(element) || (parentType2 = element.getAncestor(7)) != null && !JDTUtils.isUnnamedClass(parentType2) && this.overlaps(((ISourceReference)parentType2).getNameRange(), ((ISourceReference)element).getNameRange())) break block10;
                }
                if (this.preferenceManager.getPreferences().isReferencesCodeLensEnabled() && !JDTUtils.isUnnamedClass(element) && (lens3 = this.getCodeLens(REFERENCES_TYPE, element, typeRoot)) != null) {
                    lenses.add(lens3);
                }
                if (("all".equals(implementationsPreference = this.preferenceManager.getPreferences().getImplementationsCodeLens()) || "types".equals(implementationsPreference)) && element instanceof IType && ((type = (IType)element).isInterface() || Flags.isAbstract((int)type.getFlags())) && (lens2 = this.getCodeLens(IMPLEMENTATION_TYPE, element, typeRoot)) != null) {
                    lenses.add(lens2);
                }
                if (("all".equals(implementationsPreference) || "methods".equals(implementationsPreference)) && element instanceof IMethod && ((iJavaElement = (methodElement = (IMethod)element).getParent()) instanceof IType && (parentType = (IType)iJavaElement).isInterface() || Flags.isAbstract((int)methodElement.getFlags())) && (lens = this.getCodeLens(IMPLEMENTATION_TYPE, element, typeRoot)) != null) {
                    lenses.add(lens);
                }
            }
            ++n2;
        }
    }

    private boolean overlaps(ISourceRange typeRange, ISourceRange methodRange) {
        if (typeRange == null || methodRange == null) {
            return false;
        }
        return methodRange.getOffset() < typeRange.getOffset() || methodRange.getOffset() >= typeRange.getOffset() && methodRange.getOffset() <= typeRange.getOffset() + typeRange.getLength();
    }

    private CodeLens getCodeLens(String type, IJavaElement element, ITypeRoot typeRoot) throws JavaModelException {
        ISourceRange r = ((ISourceReference)element).getNameRange();
        if (r == null) {
            return null;
        }
        CodeLens lens = new CodeLens();
        Range range = JDTUtils.toRange((IOpenable)typeRoot, r.getOffset(), r.getLength());
        lens.setRange(range);
        String uri = ResourceUtils.toClientUri(JDTUtils.toUri(typeRoot));
        lens.setData(Arrays.asList(uri, range.getStart(), type));
        return lens;
    }

    private IJavaSearchScope createSearchScope() throws JavaModelException {
        IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        boolean excludeTestCode = this.preferenceManager.getPreferences().getSearchScope() == Preferences.SearchScope.main;
        return SearchEngine.createJavaSearchScope((boolean)excludeTestCode, (IJavaElement[])projects, (int)1);
    }
}

