/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.codeassist.DOMCodeSelector;
import org.eclipse.jdt.internal.codeassist.DOMCompletionEngine;
import org.eclipse.jdt.internal.codeassist.ExpectedTypes;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.jdt.internal.compiler.parser.RecoveryScanner;

class DOMCompletionContext
extends CompletionContext {
    private final int offset;
    private final char[] token;
    private final IJavaElement enclosingElement;
    private final Supplier<Stream<IBinding>> bindingsAcquirer;
    final ExpectedTypes expectedTypes;
    private boolean inJavadoc = false;
    final ASTNode node;
    private IBuffer cuBuffer;
    private boolean isJustAfterStringLiteral;

    DOMCompletionContext(CompilationUnit domUnit, ICompilationUnit modelUnit, IBuffer cuBuffer, int offset, AssistOptions assistOptions, DOMCompletionEngine.Bindings bindings) {
        ASTNode previousNodeBeforeWhitespaces;
        this.cuBuffer = cuBuffer;
        int adjustedOffset = this.offset = offset;
        if (adjustedOffset >= cuBuffer.getLength()) {
            adjustedOffset = cuBuffer.getLength() - 1;
        }
        if (adjustedOffset + 1 >= cuBuffer.getLength() || !Character.isJavaIdentifierStart(cuBuffer.getChar(adjustedOffset))) {
            while (adjustedOffset > 0 && Character.isWhitespace(cuBuffer.getChar(adjustedOffset - 1))) {
                --adjustedOffset;
            }
        }
        this.node = (previousNodeBeforeWhitespaces = NodeFinder.perform(domUnit, adjustedOffset, 0)) instanceof SimpleName || previousNodeBeforeWhitespaces instanceof StringLiteral || previousNodeBeforeWhitespaces instanceof CharacterLiteral || previousNodeBeforeWhitespaces instanceof NumberLiteral ? NodeFinder.perform(domUnit, this.offset, 0) : previousNodeBeforeWhitespaces;
        this.expectedTypes = new ExpectedTypes(assistOptions, this.node, offset);
        this.token = this.tokenBefore(cuBuffer).toCharArray();
        this.enclosingElement = this.computeEnclosingElement(domUnit, modelUnit);
        this.bindingsAcquirer = bindings::all;
        this.isJustAfterStringLiteral = this.node instanceof StringLiteral && this.node.getLength() > 1 && this.offset >= this.node.getStartPosition() + this.node.getLength() && cuBuffer.getChar(this.offset - 1) == '\"';
    }

    private String tokenBefore(IBuffer buf) {
        int position = Math.min(this.offset, buf.getLength()) - 1;
        StringBuilder builder = new StringBuilder();
        while (position >= 0 && Character.isJavaIdentifierPart(buf.getChar(position))) {
            builder.append(buf.getChar(position));
            --position;
        }
        builder.reverse();
        return builder.toString();
    }

    private IJavaElement computeEnclosingElement(CompilationUnit domUnit, ICompilationUnit modelUnit) {
        IJavaElement enclosingElement1 = modelUnit;
        try {
            enclosingElement1 = modelUnit.getElementAt(this.offset);
        }
        catch (JavaModelException e) {
            ILog.get().error(e.getMessage(), (Throwable)((Object)e));
        }
        if (enclosingElement1 == null) {
            return modelUnit;
        }
        ASTNode node2 = NodeFinder.perform(domUnit, this.offset, 0);
        while (node2 != null) {
            IJavaElement bindingBasedJavaElement;
            IBinding binding = this.resolveBindingForContext(node2);
            if (binding != null && enclosingElement1.equals(bindingBasedJavaElement = binding.getJavaElement())) {
                return bindingBasedJavaElement;
            }
            node2 = node2.getParent();
        }
        return enclosingElement1;
    }

    private IBinding resolveBindingForContext(ASTNode nodep) {
        IBinding res = DOMCodeSelector.resolveBinding(nodep);
        if (res != null) {
            return res;
        }
        if (nodep instanceof TypeDeclaration) {
            TypeDeclaration typeDecl = (TypeDeclaration)nodep;
            return typeDecl.resolveBinding();
        }
        if (nodep instanceof MethodDeclaration) {
            MethodDeclaration methodDecl = (MethodDeclaration)nodep;
            return methodDecl.resolveBinding();
        }
        if (nodep instanceof VariableDeclaration) {
            VariableDeclaration varDecl = (VariableDeclaration)nodep;
            return varDecl.resolveBinding();
        }
        return null;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public char[] getToken() {
        return this.isJustAfterStringLiteral ? null : this.token;
    }

    @Override
    public boolean isInJavadoc() {
        return this.inJavadoc;
    }

    public void setInJavadoc(boolean inJavadoc) {
        this.inJavadoc = inJavadoc;
    }

    @Override
    public IJavaElement getEnclosingElement() {
        return this.enclosingElement;
    }

    @Override
    public IJavaElement[] getVisibleElements(String typeSignature) {
        return (IJavaElement[])this.bindingsAcquirer.get().filter(binding -> DOMCompletionContext.matchesSignature(binding, typeSignature)).map(binding -> binding.getJavaElement()).filter(obj -> obj != null).toArray(IJavaElement[]::new);
    }

    public static boolean matchesSignature(IBinding binding, String typeSignature) {
        if (typeSignature == null) {
            return binding instanceof IVariableBinding || binding instanceof IMethodBinding;
        }
        if (binding instanceof IVariableBinding) {
            IVariableBinding variableBinding = (IVariableBinding)binding;
            return DOMCompletionContext.castCompatable(variableBinding.getType(), typeSignature);
        }
        if (binding instanceof IMethodBinding) {
            IMethodBinding methodBinding = (IMethodBinding)binding;
            return DOMCompletionContext.castCompatable(methodBinding.getReturnType(), typeSignature);
        }
        return false;
    }

    @Override
    public char[][] getExpectedTypesKeys() {
        if (this.isJustAfterStringLiteral) {
            return null;
        }
        char[][] res = (char[][])this.expectedTypes.getExpectedTypes().stream().map(IBinding::getKey).map(String::toCharArray).toArray(n -> new char[n][]);
        return res.length == 0 ? null : res;
    }

    @Override
    public char[][] getExpectedTypesSignatures() {
        if (this.isJustAfterStringLiteral) {
            return null;
        }
        char[][] res = (char[][])this.expectedTypes.getExpectedTypes().stream().map(type -> type.getKey()).map(name -> name.replace('/', '.')).map(String::toCharArray).toArray(n -> new char[n][]);
        return res.length == 0 ? null : res;
    }

    @Override
    public boolean isExtended() {
        return true;
    }

    @Override
    public int getTokenLocation() {
        ASTNode wrappingNode = this.node;
        while (wrappingNode != null) {
            if (wrappingNode instanceof ImportDeclaration) {
                return 8;
            }
            if (wrappingNode instanceof ClassInstanceCreation) {
                ClassInstanceCreation newObj = (ClassInstanceCreation)wrappingNode;
                return this.getTokenStart() <= newObj.getType().getStartPosition() ? 4 : 0;
            }
            if (wrappingNode instanceof Statement) {
                Statement stmt = (Statement)wrappingNode;
                if (this.getTokenStart() == stmt.getStartPosition()) {
                    return this.getTokenStart() == stmt.getStartPosition() ? 2 : 0;
                }
            }
            if (wrappingNode instanceof BodyDeclaration) {
                boolean wrapperNodeIsTypeDecl;
                boolean wrapperParentIsTypeDecl;
                BodyDeclaration member = (BodyDeclaration)wrappingNode;
                boolean bl = wrapperParentIsTypeDecl = member.getParent() instanceof AbstractTypeDeclaration || member.getParent() instanceof AnonymousClassDeclaration;
                if (wrapperParentIsTypeDecl && this.getTokenStart() == member.getStartPosition()) {
                    return 1;
                }
                boolean bl2 = wrapperNodeIsTypeDecl = wrappingNode instanceof AbstractTypeDeclaration || wrappingNode instanceof AnonymousClassDeclaration;
                if (wrapperNodeIsTypeDecl && this.isWithinTypeDeclarationBody(wrappingNode, this.cuBuffer, this.offset)) {
                    return 1;
                }
                return 0;
            }
            if (wrappingNode instanceof Block) {
                Block block = (Block)wrappingNode;
                return block.statements().isEmpty() ? 2 : 0;
            }
            if (wrappingNode instanceof AnonymousClassDeclaration) {
                AnonymousClassDeclaration anon = (AnonymousClassDeclaration)wrappingNode;
                if (this.isWithinTypeDeclarationBody(wrappingNode, this.cuBuffer, this.offset)) {
                    return 1;
                }
            }
            wrappingNode = wrappingNode.getParent();
        }
        return 0;
    }

    private boolean isWithinTypeDeclarationBody(ASTNode n, IBuffer buffer, int offset2) {
        if (buffer != null) {
            if (n instanceof AbstractTypeDeclaration) {
                AbstractTypeDeclaration atd = (AbstractTypeDeclaration)n;
                int nameEndOffset = atd.getName().getStartPosition() + atd.getName().getLength();
                int bodyStart = this.findFirstOpenBracketFromIndex(buffer, nameEndOffset);
                int bodyEnd = atd.getStartPosition() + atd.getLength() - 1;
                return bodyEnd > bodyStart && offset2 > bodyStart && offset2 < bodyEnd;
            }
            if (n instanceof AnonymousClassDeclaration) {
                AnonymousClassDeclaration acd = (AnonymousClassDeclaration)n;
                int bodyStart = this.findFirstOpenBracketFromIndex(buffer, acd.getStartPosition());
                int bodyEnd = acd.getStartPosition() + acd.getLength() - 1;
                return bodyEnd > bodyStart && offset2 > bodyStart && offset2 < bodyEnd;
            }
        }
        return false;
    }

    private int findFirstOpenBracketFromIndex(IBuffer buffer, int start) {
        int bodyStart = start;
        while (bodyStart < buffer.getLength() && buffer.getChar(bodyStart) != '{') {
            ++bodyStart;
        }
        return bodyStart;
    }

    @Override
    public int getTokenStart() {
        SimpleName name;
        if (this.isJustAfterStringLiteral) {
            return -1;
        }
        if (this.node instanceof StringLiteral) {
            return this.node.getStartPosition();
        }
        ASTNode aSTNode = this.node;
        if (aSTNode instanceof SimpleName && !Arrays.equals((name = (SimpleName)aSTNode).getIdentifier().toCharArray(), RecoveryScanner.FAKE_IDENTIFIER)) {
            return this.node.getStartPosition();
        }
        return this.offset - this.getToken().length;
    }

    @Override
    public int getTokenEnd() {
        if (this.isJustAfterStringLiteral) {
            return -1;
        }
        if (this.node instanceof SimpleName || this.node instanceof StringLiteral) {
            return this.node.getStartPosition() + this.node.getLength() - 1;
        }
        int position = this.offset;
        while (position < this.cuBuffer.getLength() && Character.isJavaIdentifierPart(this.cuBuffer.getChar(position))) {
            ++position;
        }
        return position - 1;
    }

    @Override
    public int getTokenKind() {
        if (this.isJustAfterStringLiteral) {
            return 0;
        }
        return this.node instanceof StringLiteral ? 2 : 1;
    }

    public boolean canUseDiamond(String[] parameterTypes, char[][] typeVariables) {
        char[][] expectedTypekeys = this.getExpectedTypesKeys();
        if (expectedTypekeys == null || expectedTypekeys.length == 0) {
            return true;
        }
        if (typeVariables != null) {
            String[] stringArray = parameterTypes;
            int n = parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String parameterType = stringArray[n2];
                char[][] cArray = typeVariables;
                int n3 = typeVariables.length;
                int n4 = 0;
                while (n4 < n3) {
                    char[] typeVariable = cArray[n4];
                    if (CharOperation.equals((char[])parameterType.toCharArray(), (char[])typeVariable)) {
                        return false;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return true;
    }

    public boolean canUseDiamond(String[] parameterTypes, char[] fullyQualifiedTypeName) {
        IBinding iBinding;
        IBinding guessedType = null;
        char[][] expectedTypekeys = this.getExpectedTypesKeys();
        if (expectedTypekeys == null || expectedTypekeys.length == 0) {
            return true;
        }
        Optional<IBinding> potentialMatch = this.bindingsAcquirer.get().filter(binding -> {
            char[][] cArray2 = expectedTypekeys;
            int n = expectedTypekeys.length;
            int n2 = 0;
            while (n2 < n) {
                char[] expectedTypekey = cArray2[n2];
                if (CharOperation.equals((char[])expectedTypekey, (char[])binding.getKey().toCharArray())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }).findFirst();
        if (potentialMatch.isPresent() && (iBinding = potentialMatch.get()) instanceof ITypeBinding) {
            ITypeBinding match = (ITypeBinding)iBinding;
            guessedType = match;
        }
        if (guessedType != null && !guessedType.isRecovered()) {
            guessedType = guessedType.getErasure();
            ITypeBinding[] typeVars = guessedType.getTypeParameters();
            String[] stringArray = parameterTypes;
            int n = parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String parameterType = stringArray[n2];
                ITypeBinding[] iTypeBindingArray = typeVars;
                int n3 = typeVars.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeBinding typeVar = iTypeBindingArray[n4];
                    if (CharOperation.equals((char[])parameterType.toCharArray(), (char[])typeVar.getName().toCharArray())) {
                        return false;
                    }
                    ++n4;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    private static boolean castCompatable(ITypeBinding typeBinding, String sig2) {
        String sig1 = typeBinding.getKey().replace('/', '.');
        String sig1Raw = new String(Signature.getTypeErasure(sig1.toCharArray()));
        switch (sig1) {
            case "J": {
                return sig2.equals("J") || sig2.equals("D") || sig2.equals("F");
            }
            case "I": {
                return sig2.equals("J") || sig2.equals("I") || sig2.equals("D") || sig2.equals("F");
            }
            case "B": {
                return sig2.equals("J") || sig2.equals("I") || sig2.equals("B") || sig2.equals("D") || sig2.equals("F");
            }
            case "D": 
            case "F": {
                return sig2.equals("D") || sig2.equals("F");
            }
        }
        if (sig1.equals(sig2) || sig1Raw.equals(sig2)) {
            return true;
        }
        if (typeBinding.getSuperclass() != null && DOMCompletionContext.castCompatable(typeBinding.getSuperclass(), sig2)) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = typeBinding.getInterfaces();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding superInterface = iTypeBindingArray[n2];
            if (DOMCompletionContext.castCompatable(superInterface, sig2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

