/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.plexus.PlexusContainer;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.URLConnectionCaches;
import org.eclipse.m2e.core.internal.index.filter.ArtifactFilterManager;
import org.eclipse.m2e.core.internal.launch.MavenRuntimeManagerImpl;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryManager;
import org.eclipse.m2e.core.internal.project.registry.ProjectRegistryRefreshJob;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.IWorkspaceClassifierResolverManager;
import org.eclipse.m2e.core.project.conversion.IProjectConversionManager;
import org.eclipse.m2e.core.repository.IRepositoryRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.Version;
import org.osgi.util.tracker.ServiceTracker;

public class MavenPluginActivator
extends Plugin {
    private static MavenPluginActivator plugin;
    private final Collection<PlexusContainer> toDisposeContainers = new HashSet<PlexusContainer>();
    private BundleContext bundleContext;
    private static String version;
    private final BundleListener bundleListener = event -> LifecycleMappingFactory.setBundleMetadataSources(null);
    private Map<Class<?>, ServiceTracker<?, ?>> trackers = new ConcurrentHashMap();

    static {
        version = "0.0.0";
    }

    public IMaven getMaven() {
        return this.getService(IMaven.class);
    }

    private <T> T getService(Class<T> service) {
        BundleContext context = this.getBundleContext();
        if (context == null) {
            return null;
        }
        return service.cast(this.trackers.computeIfAbsent(service, key -> {
            ServiceTracker tracker = new ServiceTracker(context, key, null);
            tracker.open();
            return tracker;
        }).getService());
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            Version bundleVersion = this.getBundle().getVersion();
            version = String.valueOf(bundleVersion.getMajor()) + "." + bundleVersion.getMinor() + "." + bundleVersion.getMicro();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        System.setProperty("maven.defaultProjectBuilder.disableGlobalModelCache", Boolean.toString(true));
        URLConnectionCaches.disable();
        this.bundleContext = context;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        context.removeBundleListener(this.bundleListener);
        this.toDisposeContainers.forEach(PlexusContainer::dispose);
        LifecycleMappingFactory.setBundleMetadataSources(null);
        plugin = null;
    }

    public static MavenPluginActivator getDefault() {
        return plugin;
    }

    public MavenModelManager getMavenModelManager() {
        return this.getService(MavenModelManager.class);
    }

    public IMavenProjectRegistry getMavenProjectManager() {
        return this.getService(IMavenProjectRegistry.class);
    }

    public ProjectRegistryManager getMavenProjectManagerImpl() {
        return this.getService(ProjectRegistryManager.class);
    }

    public MavenRuntimeManagerImpl getMavenRuntimeManager() {
        return this.getService(MavenRuntimeManagerImpl.class);
    }

    public IMavenMarkerManager getMavenMarkerManager() {
        return this.getService(IMavenMarkerManager.class);
    }

    public IMavenConfiguration getMavenConfiguration() {
        return this.getService(IMavenConfiguration.class);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public IProjectConfigurationManager getProjectConfigurationManager() {
        return this.getService(IProjectConfigurationManager.class);
    }

    public ProjectRegistryRefreshJob getProjectManagerRefreshJob() {
        return this.getService(ProjectRegistryRefreshJob.class);
    }

    public static String getVersion() {
        return version;
    }

    public static String getUserAgent() {
        Bundle m2eCore = FrameworkUtil.getBundle(MavenPluginActivator.class);
        Version osgiVersion = m2eCore.getBundleContext().getBundle("System Bundle").getVersion();
        String javaVersion = System.getProperty("java.version", "unknown");
        return "m2e/" + osgiVersion + "/" + m2eCore.getVersion() + "/" + javaVersion;
    }

    public IRepositoryRegistry getRepositoryRegistry() {
        return this.getService(IRepositoryRegistry.class);
    }

    public RepositorySystem getRepositorySystem() throws CoreException {
        return this.getMaven().lookup(RepositorySystem.class);
    }

    public ArtifactFilterManager getArifactFilterManager() {
        return this.getService(ArtifactFilterManager.class);
    }

    public IProjectConversionManager getProjectConversionManager() {
        return this.getService(IProjectConversionManager.class);
    }

    public IWorkspaceClassifierResolverManager getWorkspaceClassifierResolverManager() {
        return this.getService(IWorkspaceClassifierResolverManager.class);
    }
}

