/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimplePropertyDescriptor;

public class PostfixExpression
extends Expression {
    public static final SimplePropertyDescriptor OPERATOR_PROPERTY = new SimplePropertyDescriptor(PostfixExpression.class, "operator", Operator.class, true);
    public static final ChildPropertyDescriptor OPERAND_PROPERTY = new ChildPropertyDescriptor(PostfixExpression.class, "operand", Expression.class, true, true);
    private static final List PROPERTY_DESCRIPTORS;
    private Operator operator = Operator.INCREMENT;
    private Expression operand = null;

    static {
        ArrayList propertyList = new ArrayList(3);
        PostfixExpression.createPropertyList(PostfixExpression.class, propertyList);
        PostfixExpression.addProperty(OPERAND_PROPERTY, propertyList);
        PostfixExpression.addProperty(OPERATOR_PROPERTY, propertyList);
        PROPERTY_DESCRIPTORS = PostfixExpression.reapPropertyList(propertyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    PostfixExpression(AST ast) {
        super(ast);
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel) {
        return PostfixExpression.propertyDescriptors(apiLevel);
    }

    @Override
    final Object internalGetSetObjectProperty(SimplePropertyDescriptor property, boolean get, Object value) {
        if (property == OPERATOR_PROPERTY) {
            if (get) {
                return this.getOperator();
            }
            this.setOperator((Operator)value);
            return null;
        }
        return super.internalGetSetObjectProperty(property, get, value);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == OPERAND_PROPERTY) {
            if (get) {
                return this.getOperand();
            }
            this.setOperand((Expression)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 37;
    }

    @Override
    ASTNode clone0(AST target) {
        PostfixExpression result = new PostfixExpression(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setOperator(this.getOperator());
        result.setOperand((Expression)this.getOperand().clone(target));
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getOperand());
        }
        visitor.endVisit(this);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        if (operator == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(OPERATOR_PROPERTY);
        this.operator = operator;
        this.postValueChange(OPERATOR_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getOperand() {
        if (this.operand == null) {
            PostfixExpression postfixExpression = this;
            synchronized (postfixExpression) {
                if (this.operand == null) {
                    this.preLazyInit();
                    this.operand = new SimpleName(this.ast);
                    this.postLazyInit(this.operand, OPERAND_PROPERTY);
                }
            }
        }
        return this.operand;
    }

    public void setOperand(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.operand;
        this.preReplaceChild(oldChild, expression, OPERAND_PROPERTY);
        this.operand = expression;
        this.postReplaceChild(oldChild, expression, OPERAND_PROPERTY);
    }

    @Override
    int memSize() {
        return 48;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.operand == null ? 0 : this.getOperand().treeSize());
    }

    public static class Operator {
        private final String token;
        public static final Operator INCREMENT;
        public static final Operator DECREMENT;
        private static final Map CODES;

        static {
            Operator[] ops;
            INCREMENT = new Operator("++");
            DECREMENT = new Operator("--");
            CODES = new HashMap(20);
            Operator[] operatorArray = ops = new Operator[]{INCREMENT, DECREMENT};
            int n = ops.length;
            int n2 = 0;
            while (n2 < n) {
                Operator op = operatorArray[n2];
                CODES.put(op.toString(), op);
                ++n2;
            }
        }

        private Operator(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }

        public static Operator toOperator(String token) {
            return (Operator)CODES.get(token);
        }
    }
}

