/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationProvider;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.AbstractModule;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaElementRequestor;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import org.eclipse.jdt.internal.core.ModuleUpdater;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.SearchableEnvironmentRequestor;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.IRestrictedAccessConstructorRequestor;
import org.eclipse.jdt.internal.core.search.IRestrictedAccessTypeRequestor;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.jdt.internal.core.util.DeduplicationUtil;
import org.eclipse.jdt.internal.core.util.Util;

public class SearchableEnvironment
implements IModuleAwareNameEnvironment,
IJavaSearchConstants {
    public NameLookup nameLookup;
    protected ICompilationUnit unitToSkip;
    protected org.eclipse.jdt.core.ICompilationUnit[] workingCopies;
    protected WorkingCopyOwner owner;
    protected JavaProject project;
    protected IJavaSearchScope searchScope;
    protected boolean checkAccessRestrictions;
    private Map<String, IPackageFragmentRoot[]> knownModuleLocations;
    private final boolean excludeTestCode;
    private ModuleUpdater moduleUpdater;
    private Map<IPackageFragmentRoot, IModuleDescription> rootToModule;
    private long timeSpentInGetModulesDeclaringPackage;
    private long timeSpentInFindTypes;
    private List<IPackageFragmentRoot> unnamedModulePackageFragmentRoots;

    @Deprecated
    public SearchableEnvironment(JavaProject project, org.eclipse.jdt.core.ICompilationUnit[] workingCopies) throws JavaModelException {
        this(project, workingCopies, false);
    }

    public SearchableEnvironment(JavaProject project, org.eclipse.jdt.core.ICompilationUnit[] workingCopies, boolean excludeTestCode) throws JavaModelException {
        this.project = project;
        this.excludeTestCode = excludeTestCode;
        this.checkAccessRestrictions = !"ignore".equals(project.getOption("org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) || !"ignore".equals(project.getOption("org.eclipse.jdt.core.compiler.problem.discouragedReference", true));
        this.workingCopies = workingCopies;
        this.nameLookup = project.newNameLookup(workingCopies, excludeTestCode);
        boolean java9plus = JavaCore.callReadOnly(() -> CompilerOptions.versionToJdkLevel((String)project.getOption("org.eclipse.jdt.core.compiler.compliance", true)) >= 0x350000L);
        if (java9plus) {
            IPackageFragmentRoot[] packageFragmentRoots;
            IClasspathEntry[] expandedClasspath;
            this.knownModuleLocations = new HashMap<String, IPackageFragmentRoot[]>();
            this.moduleUpdater = new ModuleUpdater(project);
            if (!excludeTestCode && Arrays.stream(expandedClasspath = project.getExpandedClasspath()).anyMatch(IClasspathEntry::isTest)) {
                this.moduleUpdater.addReadUnnamedForNonEmptyClasspath(project, expandedClasspath);
            }
            IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (!excludeTestCode || !entry.isTest()) {
                    this.moduleUpdater.computeModuleUpdates(entry);
                }
                ++n2;
            }
            this.unnamedModulePackageFragmentRoots = new ArrayList<IPackageFragmentRoot>();
            IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots = project.getAllPackageFragmentRoots();
            int n3 = packageFragmentRoots.length;
            n = 0;
            while (n < n3) {
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n];
                IModuleDescription moduleDescription = packageFragmentRoot.getModuleDescription();
                if (moduleDescription == null) {
                    this.unnamedModulePackageFragmentRoots.add(packageFragmentRoot);
                }
                ++n;
            }
        }
    }

    @Deprecated
    public SearchableEnvironment(JavaProject project, WorkingCopyOwner owner) throws JavaModelException {
        this(project, owner, false);
    }

    public SearchableEnvironment(JavaProject project, WorkingCopyOwner owner, boolean excludeTestCode) throws JavaModelException {
        this(project, owner == null ? null : JavaModelManager.getJavaModelManager().getWorkingCopies(owner, true), excludeTestCode);
        this.owner = owner;
    }

    private static int convertSearchFilterToModelFilter(int searchFilter) {
        switch (searchFilter) {
            case 5: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 16;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 6;
            }
        }
        return 0x100001E;
    }

    protected NameEnvironmentAnswer find(String typeName, String packageName, IPackageFragmentRoot[] moduleContext) {
        block9: {
            String source;
            if (packageName == null) {
                packageName = "";
            }
            if (this.owner != null && (source = this.owner.findSource(typeName, packageName)) != null) {
                IPackageFragmentRoot moduleElement = moduleContext != null && moduleContext.length > 0 ? moduleContext[0] : null;
                BasicCompilationUnit cu = new BasicCompilationUnit(source.toCharArray(), CharOperation.splitOn((char)'.', (char[])packageName.toCharArray()), typeName + Util.defaultJavaExtension(), moduleElement);
                return new NameEnvironmentAnswer((ICompilationUnit)cu, null);
            }
            NameLookup.Answer answer = this.nameLookup.findType(typeName, packageName, false, 0x100001E, this.checkAccessRestrictions, moduleContext);
            if (answer != null) {
                if (answer.type instanceof BinaryType) {
                    return this.createAnswer(answer, packageName, typeName, (BinaryType)answer.type);
                }
                try {
                    SourceTypeElementInfo sourceType;
                    SourceTypeElementInfo topLevelType = sourceType = (SourceTypeElementInfo)((SourceType)answer.type).getElementInfo();
                    while (topLevelType.getEnclosingType() != null) {
                        topLevelType = topLevelType.getEnclosingType();
                    }
                    IType[] types = sourceType.getHandle().getCompilationUnit().getTypes();
                    ISourceType[] sourceTypes = new ISourceType[types.length];
                    sourceTypes[0] = sourceType;
                    int length = types.length;
                    int i = 0;
                    int index = 1;
                    while (i < length) {
                        ISourceType otherType = (ISourceType)((JavaElement)((Object)types[i])).getElementInfo();
                        if (!otherType.equals(topLevelType) && index < length) {
                            sourceTypes[index++] = otherType;
                        }
                        ++i;
                    }
                    char[] moduleName = answer.module != null ? answer.module.getElementName().toCharArray() : null;
                    return new NameEnvironmentAnswer(sourceTypes, answer.restriction, this.getExternalAnnotationPath(answer.entry), moduleName);
                }
                catch (JavaModelException jme) {
                    if (!jme.isDoesNotExist() || !String.valueOf(TypeConstants.PACKAGE_INFO_NAME).equals(typeName)) break block9;
                    return new NameEnvironmentAnswer((ICompilationUnit)answer.type.getParent(), answer.restriction);
                }
            }
        }
        return null;
    }

    private String getExternalAnnotationPath(IClasspathEntry entry) {
        if (entry == null) {
            return null;
        }
        IPath path = entry.getExternalAnnotationPath(this.project.getProject(), true);
        if (path == null) {
            return null;
        }
        return path.toOSString();
    }

    private NameEnvironmentAnswer createAnswer(NameLookup.Answer lookupAnswer, String packageName, String typeName, BinaryType binaryType) {
        char[] moduleName = lookupAnswer.module != null ? lookupAnswer.module.getElementName().toCharArray() : null;
        try {
            IBinaryType iBinaryType = binaryType.getElementInfo();
            if (iBinaryType.getExternalAnnotationStatus() == BinaryTypeBinding.ExternalAnnotationStatus.NOT_EEA_CONFIGURED && "enabled".equals(this.project.getOption("org.eclipse.jdt.core.builder.annotationPath.allLocations", true))) {
                String soughtName = typeName + ".eea";
                boolean isAnnotated = false;
                IPackageFragment[] packageFragments = this.nameLookup.findPackageFragments(packageName, false);
                if (packageFragments != null) {
                    String packageNameSlash = packageName.replace('.', '/');
                    IPackageFragment[] iPackageFragmentArray = packageFragments;
                    int n = packageFragments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragment fragment = iPackageFragmentArray[n2];
                        if (fragment.exists()) {
                            Object[] objectArray = fragment.getNonJavaResources();
                            int n3 = objectArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Object rc = objectArray[n4];
                                if (rc instanceof IStorage && soughtName.equals(((IStorage)rc).getName())) {
                                    if (isAnnotated) break;
                                    try {
                                        iBinaryType = new ExternalAnnotationDecorator(iBinaryType, new ExternalAnnotationProvider(((IStorage)rc).getContents(), packageNameSlash + "/" + typeName));
                                        isAnnotated = true;
                                        break;
                                    }
                                    catch (IOException | CoreException throwable) {
                                        // empty catch block
                                    }
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                    if (!isAnnotated) {
                        iBinaryType = new ExternalAnnotationDecorator(iBinaryType, null);
                    }
                }
            }
            return new NameEnvironmentAnswer(iBinaryType, lookupAnswer.restriction, moduleName);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public void findModules(char[] prefix, ISearchRequestor requestor, IJavaProject javaProject) {
        this.nameLookup.seekModule(prefix, true, new SearchableEnvironmentRequestor(requestor));
    }

    public void findPackages(char[] prefix, ISearchRequestor requestor) {
        this.nameLookup.seekPackageFragments(new String(prefix), true, new SearchableEnvironmentRequestor(requestor));
    }

    public void findPackages(char[] prefix, ISearchRequestor requestor, IPackageFragmentRoot[] moduleContext, boolean followRequires) {
        this.nameLookup.seekPackageFragments(new String(prefix), true, new SearchableEnvironmentRequestor(requestor), moduleContext);
        if (followRequires && this.knownModuleLocations != null) {
            try {
                boolean isMatchAllPrefix = CharOperation.equals((char[])CharOperation.ALL_PREFIX, (char[])prefix);
                HashSet<IModuleDescription> modDescs = new HashSet<IModuleDescription>();
                IPackageFragmentRoot[] iPackageFragmentRootArray = moduleContext;
                int n = moduleContext.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    IModuleDescription desc = root.getJavaProject().getModuleDescription();
                    if (desc instanceof AbstractModule) {
                        modDescs.add(desc);
                    }
                    ++n2;
                }
                for (IModuleDescription md : modDescs) {
                    IModule.IModuleReference[] reqModules = ((AbstractModule)md).getRequiredModules();
                    char[] modName = md.getElementName().toCharArray();
                    IModule.IModuleReference[] iModuleReferenceArray = reqModules;
                    int n3 = reqModules.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IModule.IModuleReference moduleReference = iModuleReferenceArray[n4];
                        this.findPackagesFromRequires(prefix, isMatchAllPrefix, requestor, moduleReference, modName);
                        ++n4;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    private void findPackagesFromRequires(char[] prefix, boolean isMatchAllPrefix, ISearchRequestor requestor, IModule.IModuleReference moduleReference, char[] clientModuleName) {
        IPackageFragmentRoot[] fragmentRoots = this.findModuleContext(moduleReference.name());
        if (fragmentRoots == null) {
            return;
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = fragmentRoots;
        int n = fragmentRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            IJavaProject requiredProject = root.getJavaProject();
            try {
                IModuleDescription module = requiredProject.getModuleDescription();
                if (module instanceof AbstractModule) {
                    AbstractModule requiredModule = (AbstractModule)module;
                    IModule.IPackageExport[] iPackageExportArray = requiredModule.getExportedPackages();
                    int n3 = iPackageExportArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IModule.IPackageExport packageExport = iPackageExportArray[n4];
                        if (!packageExport.isQualified() || CharOperation.containsEqual((char[][])packageExport.targets(), (char[])clientModuleName)) {
                            char[] exportName = packageExport.name();
                            if (isMatchAllPrefix || CharOperation.prefixEquals((char[])prefix, (char[])exportName)) {
                                requestor.acceptPackage(exportName);
                            }
                        }
                        ++n4;
                    }
                    iPackageExportArray = requiredModule.getRequiredModules();
                    n3 = iPackageExportArray.length;
                    n4 = 0;
                    while (n4 < n3) {
                        IModule.IPackageExport ref = iPackageExportArray[n4];
                        if (ref.isTransitive()) {
                            this.findPackagesFromRequires(prefix, isMatchAllPrefix, requestor, (IModule.IModuleReference)ref, clientModuleName);
                        }
                        ++n4;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public void findExactTypes(char[] name, final boolean findMembers, int searchFor, final ISearchRequestor storage) {
        try {
            String excludePath;
            if (this.unitToSkip != null) {
                if (!(this.unitToSkip instanceof IJavaElement)) {
                    this.findExactTypes(new String(name), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
                    return;
                }
                excludePath = ((IJavaElement)this.unitToSkip).getPath().toString();
            } else {
                excludePath = null;
            }
            IProgressMonitor progressMonitor = new IProgressMonitor(){
                boolean isCanceled = false;

                public void beginTask(String n, int totalWork) {
                }

                public void done() {
                }

                public void internalWorked(double work) {
                }

                public boolean isCanceled() {
                    return this.isCanceled;
                }

                public void setCanceled(boolean value) {
                    this.isCanceled = value;
                }

                public void setTaskName(String n) {
                }

                public void subTask(String n) {
                }

                public void worked(int work) {
                }
            };
            IRestrictedAccessTypeRequestor typeRequestor = new IRestrictedAccessTypeRequestor(){

                @Override
                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path, AccessRestriction access) {
                    if (excludePath != null && excludePath.equals(path)) {
                        return;
                    }
                    if (!findMembers && enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                        return;
                    }
                    storage.acceptType(packageName, simpleTypeName, enclosingTypeNames, modifiers, access);
                }
            };
            try {
                new BasicSearchEngine(this.workingCopies).searchAllTypeNames(null, 0, name, 0, searchFor, this.getSearchScope(), typeRequestor, 2, progressMonitor);
            }
            catch (OperationCanceledException e) {
                this.findExactTypes(new String(name), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
            }
        }
        catch (JavaModelException e) {
            this.findExactTypes(new String(name), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
        }
    }

    private void findExactTypes(String name, ISearchRequestor storage, int type) {
        SearchableEnvironmentRequestor requestor = new SearchableEnvironmentRequestor(storage, this.unitToSkip, this.project, this.nameLookup);
        this.nameLookup.seekTypes(name, null, false, type, requestor);
    }

    public NameEnvironmentAnswer findTypeInModules(char[][] compoundTypeName, ModuleBinding module) {
        char[] nameForLookup = module.nameForLookup();
        NameEnvironmentAnswer answer = this.findType(compoundTypeName, nameForLookup);
        if (answer != null) {
            return answer;
        }
        if (IModuleAwareNameEnvironment.LookupStrategy.get((char[])nameForLookup) == IModuleAwareNameEnvironment.LookupStrategy.Named) {
            ModuleBinding[] moduleBindingArray = module.getAllRequiredModules();
            int n = moduleBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModuleBinding required = moduleBindingArray[n2];
                answer = this.findType(compoundTypeName, required.nameForLookup());
                if (answer != null) {
                    return answer;
                }
                ++n2;
            }
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] compoundTypeName, char[] moduleName) {
        if (compoundTypeName == null) {
            return null;
        }
        boolean isNamedStrategy = IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName) == IModuleAwareNameEnvironment.LookupStrategy.Named;
        IPackageFragmentRoot[] moduleLocations = isNamedStrategy ? this.findModuleContext(moduleName) : null;
        int length = compoundTypeName.length;
        if (length <= 1) {
            if (length == 0) {
                return null;
            }
            return this.find(new String(compoundTypeName[0]), null, moduleLocations);
        }
        int lengthM1 = length - 1;
        char[][] packageName = new char[lengthM1][];
        System.arraycopy(compoundTypeName, 0, packageName, 0, lengthM1);
        return this.find(DeduplicationUtil.toString(compoundTypeName[lengthM1]), CharOperation.toString((char[][])packageName), moduleLocations);
    }

    public NameEnvironmentAnswer findType(char[] name, char[][] packageName, char[] moduleName) {
        if (name == null) {
            return null;
        }
        boolean isNamedStrategy = IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName) == IModuleAwareNameEnvironment.LookupStrategy.Named;
        IPackageFragmentRoot[] moduleLocations = isNamedStrategy ? this.findModuleContext(moduleName) : null;
        return this.find(DeduplicationUtil.toString(name), packageName == null || packageName.length == 0 ? null : CharOperation.toString((char[][])packageName), moduleLocations);
    }

    public void findTypes(char[] prefix, boolean findMembers, boolean camelCaseMatch, int searchFor, ISearchRequestor storage) {
        this.findTypes(prefix, findMembers, camelCaseMatch ? 129 : 1, searchFor, storage, null);
    }

    public void findTypes(char[] prefix, boolean findMembers, int matchRule, int searchFor, ISearchRequestor storage, IProgressMonitor monitor) {
        this.findTypes(prefix, findMembers, matchRule, searchFor, true, storage, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public void findTypes(char[] prefix, final boolean findMembers, int matchRule, int searchFor, boolean resolveDocumentName, final ISearchRequestor storage, IProgressMonitor monitor) {
        block20: {
            start = -1L;
            if (NameLookup.VERBOSE) {
                start = System.currentTimeMillis();
            }
            camelCaseMatch = (matchRule & 128) != 0;
            try {
                if (this.unitToSkip == null) ** GOTO lbl13
                if (!(this.unitToSkip instanceof IJavaElement)) {
                    this.findTypes(new String(prefix), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
                    return;
                }
                try {
                    block21: {
                        excludePath = ((IJavaElement)this.unitToSkip).getPath().toString();
                        break block21;
lbl13:
                        // 1 sources

                        excludePath = null;
                    }
                    lastDotIndex = CharOperation.lastIndexOf((char)'.', (char[])prefix);
                    if (lastDotIndex < 0) {
                        qualification = null;
                        simpleName = camelCaseMatch ? prefix : CharOperation.toLowerCase((char[])prefix);
                    } else {
                        qualification = CharOperation.subarray((char[])prefix, (int)0, (int)lastDotIndex);
                        simpleName = camelCaseMatch != false ? CharOperation.subarray((char[])prefix, (int)(lastDotIndex + 1), (int)prefix.length) : CharOperation.toLowerCase((char[])CharOperation.subarray((char[])prefix, (int)(lastDotIndex + 1), (int)prefix.length));
                    }
                    progressMonitor = new IProgressMonitor(){
                        boolean isCanceled = false;

                        public void beginTask(String name, int totalWork) {
                        }

                        public void done() {
                        }

                        public void internalWorked(double work) {
                        }

                        public boolean isCanceled() {
                            return this.isCanceled;
                        }

                        public void setCanceled(boolean value) {
                            this.isCanceled = value;
                        }

                        public void setTaskName(String name) {
                        }

                        public void subTask(String name) {
                        }

                        public void worked(int work) {
                        }
                    };
                    typeRequestor = new IRestrictedAccessTypeRequestor(){

                        @Override
                        public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path, AccessRestriction access) {
                            if (excludePath != null && excludePath.equals(path)) {
                                return;
                            }
                            if (!findMembers && enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                                return;
                            }
                            storage.acceptType(packageName, simpleTypeName, enclosingTypeNames, modifiers, access);
                        }
                    };
                    if (monitor != null) {
                        indexManager = JavaModelManager.getIndexManager();
                        if (indexManager.awaitingJobsCount() == 0) {
                            new BasicSearchEngine(this.workingCopies).searchAllTypeNames(qualification, 0, simpleName, matchRule, searchFor, this.getSearchScope(), resolveDocumentName, typeRequestor, 1, progressMonitor);
                            break block20;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException var18_19) {
                            // empty catch block
                        }
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        if (indexManager.awaitingJobsCount() == 0) {
                            new BasicSearchEngine(this.workingCopies).searchAllTypeNames(qualification, 0, simpleName, matchRule, searchFor, this.getSearchScope(), resolveDocumentName, typeRequestor, 1, progressMonitor);
                        } else {
                            this.findTypes(new String(prefix), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
                        }
                        break block20;
                    }
                    try {
                        new BasicSearchEngine(this.workingCopies).searchAllTypeNames(qualification, 0, simpleName, matchRule, searchFor, this.getSearchScope(), resolveDocumentName, typeRequestor, 2, progressMonitor);
                    }
                    catch (OperationCanceledException e) {
                        this.findTypes(new String(prefix), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
                    }
                }
                catch (JavaModelException e) {
                    this.findTypes(new String(prefix), storage, SearchableEnvironment.convertSearchFilterToModelFilter(searchFor));
                }
            }
            finally {
                if (NameLookup.VERBOSE) {
                    this.timeSpentInFindTypes += System.currentTimeMillis() - start;
                }
            }
        }
    }

    public void findConstructorDeclarations(char[] prefix, int matchRule, boolean resolveDocumentName, final ISearchRequestor storage, IProgressMonitor monitor) {
        try {
            char[] simpleName;
            char[] qualification;
            boolean camelCaseMatch;
            final String excludePath = this.unitToSkip != null && this.unitToSkip instanceof IJavaElement ? ((IJavaElement)this.unitToSkip).getPath().toString() : null;
            int lastDotIndex = CharOperation.lastIndexOf((char)'.', (char[])prefix);
            boolean bl = camelCaseMatch = (matchRule & 0x80) != 0;
            if (lastDotIndex < 0) {
                qualification = null;
                simpleName = camelCaseMatch ? prefix : CharOperation.toLowerCase((char[])prefix);
            } else {
                qualification = CharOperation.subarray((char[])prefix, (int)0, (int)lastDotIndex);
                simpleName = camelCaseMatch ? CharOperation.subarray((char[])prefix, (int)(lastDotIndex + 1), (int)prefix.length) : CharOperation.toLowerCase((char[])CharOperation.subarray((char[])prefix, (int)(lastDotIndex + 1), (int)prefix.length));
            }
            IProgressMonitor progressMonitor = new IProgressMonitor(){
                boolean isCanceled = false;

                public void beginTask(String name, int totalWork) {
                }

                public void done() {
                }

                public void internalWorked(double work) {
                }

                public boolean isCanceled() {
                    return this.isCanceled;
                }

                public void setCanceled(boolean value) {
                    this.isCanceled = value;
                }

                public void setTaskName(String name) {
                }

                public void subTask(String name) {
                }

                public void worked(int work) {
                }
            };
            IRestrictedAccessConstructorRequestor constructorRequestor = new IRestrictedAccessConstructorRequestor(){

                @Override
                public void acceptConstructor(int modifiers, char[] simpleTypeName, int parameterCount, char[] signature, char[][] parameterTypes, char[][] parameterNames, int typeModifiers, char[] packageName, int extraFlags, String path, AccessRestriction access) {
                    if (excludePath != null && excludePath.equals(path)) {
                        return;
                    }
                    storage.acceptConstructor(modifiers, simpleTypeName, parameterCount, signature, parameterTypes, parameterNames, typeModifiers, packageName, extraFlags, path, access);
                }
            };
            if (monitor != null) {
                IndexManager indexManager = JavaModelManager.getIndexManager();
                indexManager.performConcurrentJob(new IJob(){

                    @Override
                    public boolean belongsTo(String jobFamily) {
                        return true;
                    }

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public void ensureReadyToRun() {
                    }

                    @Override
                    public boolean execute(IProgressMonitor progress) {
                        return progress == null || !progress.isCanceled();
                    }

                    @Override
                    public String getJobFamily() {
                        return "";
                    }
                }, 3, monitor);
                new BasicSearchEngine(this.workingCopies).searchAllConstructorDeclarations(qualification, simpleName, matchRule, this.getSearchScope(), resolveDocumentName, constructorRequestor, 1, progressMonitor);
            } else {
                try {
                    new BasicSearchEngine(this.workingCopies).searchAllConstructorDeclarations(qualification, simpleName, matchRule, this.getSearchScope(), resolveDocumentName, constructorRequestor, 2, progressMonitor);
                }
                catch (OperationCanceledException operationCanceledException) {}
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    private void findTypes(String prefix, ISearchRequestor storage, int type) {
        SearchableEnvironmentRequestor requestor = new SearchableEnvironmentRequestor(storage, this.unitToSkip, this.project, this.nameLookup);
        int index = prefix.lastIndexOf(46);
        if (index == -1) {
            this.nameLookup.seekTypes(prefix, null, true, type, requestor);
        } else {
            String packageName = prefix.substring(0, index);
            JavaElementRequestor elementRequestor = new JavaElementRequestor();
            this.nameLookup.seekPackageFragments(packageName, false, elementRequestor);
            IPackageFragment[] fragments = elementRequestor.getPackageFragments();
            if (fragments != null) {
                String className = prefix.substring(index + 1);
                IPackageFragment[] iPackageFragmentArray = fragments;
                int n = fragments.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragment fragment = iPackageFragmentArray[n2];
                    if (fragment != null) {
                        this.nameLookup.seekTypes(className, fragment, true, type, requestor);
                    }
                    ++n2;
                }
            }
        }
    }

    private IJavaSearchScope getSearchScope() {
        if (this.searchScope == null) {
            this.searchScope = this.checkAccessRestrictions ? BasicSearchEngine.createJavaSearchScope(this.excludeTestCode, new IJavaElement[]{this.project}) : BasicSearchEngine.createJavaSearchScope(this.excludeTestCode, this.nameLookup.packageFragmentRoots);
        }
        return this.searchScope;
    }

    /*
     * Unable to fully structure code
     */
    public char[][] getModulesDeclaringPackage(char[][] packageName, char[] moduleName) {
        start = -1L;
        if (NameLookup.VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            pkgName = (String[])Arrays.stream(packageName).map((Function<char[], String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(char[] ), ([C)Ljava/lang/String;)()).toArray((IntFunction<String[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$3(int ), (I)[Ljava/lang/String;)());
            strategy = IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName);
            switch (SearchableEnvironment.$SWITCH_TABLE$org$eclipse$jdt$internal$compiler$env$IModuleAwareNameEnvironment$LookupStrategy()[strategy.ordinal()]) {
                case 1: {
                    if (this.knownModuleLocations != null && (moduleContext = this.findModuleContext(moduleName)) != null && this.nameLookup.isPackage(pkgName, moduleContext)) {
                        var18_8 = new char[][]{moduleName};
                        return var18_8;
                    }
                    return null;
                }
                case 3: 
                case 4: {
                    if (this.knownModuleLocations == null) {
                        if (this.owner != null && this.owner.isPackage(pkgName) || this.nameLookup.isPackage(pkgName)) {
                            var18_9 = new char[][]{ModuleBinding.UNNAMED};
                            return var18_9;
                        }
                        return null;
                    }
                }
                case 2: {
                    names = CharOperation.NO_CHAR_CHAR;
                    matchingRoots = this.nameLookup.findPackageFragementRoots(pkgName);
                    if (matchingRoots == null) ** GOTO lbl43
                    containsUnnamed = false;
                    var13_13 = matchingRoots;
                    var12_14 = matchingRoots.length;
                    var11_15 = 0;
                    while (var11_15 < var12_14) {
                        packageRoot = var13_13[var11_15];
                        singleton = new IPackageFragmentRoot[]{packageRoot};
                        if (!strategy.matches((Object)singleton, (Predicate<IPackageFragmentRoot[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$4(org.eclipse.jdt.core.IPackageFragmentRoot[] ), ([Lorg/eclipse/jdt/core/IPackageFragmentRoot;)Z)((SearchableEnvironment)this)) || !this.nameLookup.isPackage(pkgName, singleton)) ** GOTO lbl39
                        moduleDescription = this.getModuleDescription(singleton);
                        if (moduleDescription == null) ** GOTO lbl35
                        aName = moduleDescription.getElementName().toCharArray();
                        ** GOTO lbl38
lbl35:
                        // 1 sources

                        if (containsUnnamed) ** GOTO lbl39
                        containsUnnamed = true;
                        aName = ModuleBinding.UNNAMED;
lbl38:
                        // 2 sources

                        names = CharOperation.arrayConcat((char[][])names, (char[])aName);
lbl39:
                        // 3 sources

                        ++var11_15;
                    }
                    if (!containsUnnamed && this.hasSubPackageInUnnamedModule(pkgName)) {
                        names = CharOperation.arrayConcat((char[][])names, (char[])ModuleBinding.UNNAMED);
                    }
lbl43:
                    // 4 sources

                    var18_10 = names == CharOperation.NO_CHAR_CHAR ? null : names;
                    return var18_10;
                }
            }
            throw new IllegalArgumentException("Unexpected LookupStrategy " + String.valueOf(strategy));
        }
        finally {
            if (NameLookup.VERBOSE) {
                this.timeSpentInGetModulesDeclaringPackage += System.currentTimeMillis() - start;
            }
        }
    }

    public boolean hasCompilationUnit(char[][] pkgName, char[] moduleName, boolean checkCUs) {
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName);
        switch (strategy) {
            case Named: {
                IPackageFragmentRoot[] moduleContext;
                return this.knownModuleLocations != null && (moduleContext = this.findModuleContext(moduleName)) != null && this.nameLookup.hasCompilationUnit(pkgName, moduleContext);
            }
            case Any: 
            case Unnamed: {
                if (this.knownModuleLocations == null && this.nameLookup.hasCompilationUnit(pkgName, null)) {
                    return true;
                }
            }
            case AnyNamed: {
                String[] splittedName = Util.toStrings(pkgName);
                IPackageFragmentRoot[] packageRoots = this.nameLookup.findPackageFragementRoots(splittedName);
                if (packageRoots != null) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = packageRoots;
                    int n = packageRoots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot packageRoot = iPackageFragmentRootArray[n2];
                        IPackageFragmentRoot[] singleton = new IPackageFragmentRoot[]{packageRoot};
                        if (strategy.matches((Object)singleton, locs -> locs[0] instanceof JrtPackageFragmentRoot || this.getModuleDescription((IPackageFragmentRoot[])locs) != null) && this.nameLookup.hasCompilationUnit(pkgName, singleton)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unexpected LookupStrategy " + String.valueOf(strategy));
    }

    private IModuleDescription getModuleDescription(IPackageFragmentRoot[] roots) {
        if (this.rootToModule == null) {
            this.rootToModule = new HashMap<IPackageFragmentRoot, IModuleDescription>();
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            IModuleDescription moduleDescription = NameLookup.getModuleDescription(this.project, root, this.rootToModule, this.nameLookup.rootToResolvedEntries::get);
            if (moduleDescription != null) {
                return moduleDescription;
            }
            ++n2;
        }
        return null;
    }

    private IPackageFragmentRoot[] findModuleContext(char[] moduleName) {
        NameLookup.Answer moduleAnswer;
        IPackageFragmentRoot[] moduleContext = null;
        if (this.knownModuleLocations != null && moduleName != null && moduleName.length > 0 && (moduleContext = this.knownModuleLocations.get(String.valueOf(moduleName))) == null && (moduleAnswer = this.nameLookup.findModule(moduleName)) != null) {
            IProject currentProject = moduleAnswer.module.getJavaProject().getProject();
            IJavaElement current = moduleAnswer.module.getParent();
            block8: while (moduleContext == null && current != null) {
                switch (current.getElementType()) {
                    case 3: {
                        if (!((IPackageFragmentRoot)current).isExternal() && !(current instanceof JarPackageFragmentRoot)) {
                            current = current.getJavaProject();
                        } else {
                            moduleContext = new IPackageFragmentRoot[]{(IPackageFragmentRoot)current};
                            break;
                        }
                    }
                    case 2: {
                        try {
                            moduleContext = SearchableEnvironment.getOwnedPackageFragmentRoots((IJavaProject)current);
                        }
                        catch (JavaModelException javaModelException) {}
                        continue block8;
                    }
                    default: {
                        current = current.getParent();
                        if (current == null) continue block8;
                        try {
                            IJavaProject otherJavaProject;
                            IProject otherProject;
                            IResource resource = current.getUnderlyingResource();
                            if (resource == null || (otherProject = resource.getProject()) == null || otherProject.equals((Object)currentProject) || !(otherJavaProject = JavaCore.create(otherProject)).exists()) continue block8;
                            moduleContext = this.getRootsForOutputLocation(otherJavaProject, resource);
                            break;
                        }
                        catch (JavaModelException e) {
                            Util.log((Throwable)((Object)e), "Failed to find package fragment root for " + String.valueOf(current));
                        }
                    }
                }
            }
            this.knownModuleLocations.put(String.valueOf(moduleName), moduleContext);
        }
        return moduleContext;
    }

    protected String toStringChar(char[] name) {
        return "[" + new String(name) + "]";
    }

    protected String toStringCharChar(char[][] names) {
        StringBuilder result = new StringBuilder();
        char[][] cArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            char[] name = cArray[n2];
            result.append(this.toStringChar(name));
            ++n2;
        }
        return result.toString();
    }

    public void cleanup() {
    }

    public IModule getModule(char[] name) {
        NameLookup.Answer answer = this.nameLookup.findModule(name);
        IModule module = null;
        if (answer != null) {
            module = NameLookup.getModuleDescriptionInfo(answer.module);
        }
        return module;
    }

    public char[][] getAllAutomaticModules() {
        return CharOperation.NO_CHAR_CHAR;
    }

    public void applyModuleUpdates(IUpdatableModule module, IUpdatableModule.UpdateKind kind) {
        if (this.moduleUpdater != null) {
            this.moduleUpdater.applyModuleUpdates(module, kind);
        }
    }

    private IPackageFragmentRoot[] getRootsForOutputLocation(IJavaProject otherJavaProject, IResource outputLocation) throws JavaModelException {
        IClasspathEntry classpathEntry;
        int n;
        int n2;
        IClasspathEntry[] iClasspathEntryArray;
        IPath outputPath = outputLocation.getFullPath();
        ArrayList<IPackageFragmentRoot> result = new ArrayList<IPackageFragmentRoot>();
        if (outputPath.equals((Object)otherJavaProject.getOutputLocation())) {
            iClasspathEntryArray = otherJavaProject.getRawClasspath();
            n2 = iClasspathEntryArray.length;
            n = 0;
            while (n < n2) {
                classpathEntry = iClasspathEntryArray[n];
                if (classpathEntry.getOutputLocation() == null) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = otherJavaProject.findPackageFragmentRoots(classpathEntry);
                    int n3 = iPackageFragmentRootArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                        IResource rootResource = root.getResource();
                        if (rootResource != null && rootResource.getProject().equals((Object)otherJavaProject.getProject())) {
                            result.add(root);
                        }
                        ++n4;
                    }
                }
                ++n;
            }
        }
        if (!result.isEmpty()) {
            return result.toArray(new IPackageFragmentRoot[result.size()]);
        }
        iClasspathEntryArray = otherJavaProject.getRawClasspath();
        n2 = iClasspathEntryArray.length;
        n = 0;
        while (n < n2) {
            classpathEntry = iClasspathEntryArray[n];
            if (outputPath.equals((Object)classpathEntry.getOutputLocation())) {
                return otherJavaProject.findPackageFragmentRoots(classpathEntry);
            }
            ++n;
        }
        return null;
    }

    public static IPackageFragmentRoot[] getOwnedPackageFragmentRoots(IJavaProject javaProject) throws JavaModelException {
        IPackageFragmentRoot[] allRoots = javaProject.getPackageFragmentRoots();
        IPackageFragmentRoot[] sourceRoots = Arrays.copyOf(allRoots, allRoots.length);
        int count = 0;
        IPackageFragmentRoot[] iPackageFragmentRootArray = allRoots;
        int n = allRoots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (root.getKind() != 2 || !(root instanceof JarPackageFragmentRoot) && (resource = root.getResource()) != null && resource.getProject().equals((Object)javaProject.getProject())) {
                sourceRoots[count++] = root;
            }
            ++n2;
        }
        if (count < allRoots.length) {
            return Arrays.copyOf(sourceRoots, count);
        }
        return sourceRoots;
    }

    public char[][] listPackages(char[] moduleName) {
        switch (IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName)) {
            case Named: {
                IPackageFragmentRoot[] packageRoots = this.findModuleContext(moduleName);
                HashSet<String> packages = new HashSet<String>();
                if (packageRoots != null) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = packageRoots;
                    int n2 = packageRoots.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        IPackageFragmentRoot packageRoot = iPackageFragmentRootArray[n3];
                        try {
                            IJavaElement[] iJavaElementArray = packageRoot.getChildren();
                            int n4 = iJavaElementArray.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                IJavaElement javaElement = iJavaElementArray[n5];
                                if (javaElement instanceof IPackageFragment && !((IPackageFragment)javaElement).isDefaultPackage()) {
                                    packages.add(javaElement.getElementName());
                                }
                                ++n5;
                            }
                        }
                        catch (JavaModelException e) {
                            Util.log((Throwable)((Object)e), "Failed to retrieve packages from " + String.valueOf(packageRoot));
                        }
                        ++n3;
                    }
                }
                return (char[][])packages.stream().map(String::toCharArray).toArray(n -> new char[n][]);
            }
        }
        throw new UnsupportedOperationException("can list packages only of a named module");
    }

    public void printTimeSpent() {
        if (!NameLookup.VERBOSE) {
            return;
        }
        JavaModelManager.trace(" TIME SPENT SearchableEnvironment");
        JavaModelManager.trace(" -> getModulesDeclaringPackage..." + this.timeSpentInGetModulesDeclaringPackage + "ms");
        JavaModelManager.trace(" -> findTypes...................." + this.timeSpentInFindTypes + "ms");
        this.nameLookup.printTimeSpent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasSubPackageInUnnamedModule(String[] pkgName) {
        List<IPackageFragmentRoot> packageFragmentRoots = this.unnamedModulePackageFragmentRoots;
        if (packageFragmentRoots != null) {
            String name = String.join((CharSequence)".", pkgName);
            for (IPackageFragmentRoot packageFragmentRoot : packageFragmentRoots) {
                try {
                    IJavaElement[] children;
                    IJavaElement[] iJavaElementArray = children = packageFragmentRoot.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaElement child = iJavaElementArray[n2];
                        String childName = child.getElementName();
                        if (childName.startsWith(name)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    Util.log((Throwable)((Object)e), "Failed to retrieve children for " + String.valueOf(packageFragmentRoot));
                }
            }
        }
        return false;
    }

    private static /* synthetic */ String[] lambda$3(int n) {
        return new String[n];
    }

    private /* synthetic */ boolean lambda$4(IPackageFragmentRoot[] locs) {
        return locs[0] instanceof JrtPackageFragmentRoot || this.getModuleDescription(locs) != null;
    }
}

