/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.ls.core.internal.BaseJDTLanguageServer;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JDTLanguageServer;
import org.eclipse.jdt.ls.core.internal.handlers.ProgressReporterManager;
import org.osgi.framework.BundleException;

public class LanguageServerApplication
implements IApplication {
    private volatile boolean shutdown;
    private long parentProcessId;
    private final Object waitLock = new Object();
    private InputStream in;
    private PrintStream out;
    private PrintStream err;
    private ProgressReporterManager progressReporterManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object start(IApplicationContext context) throws Exception {
        LanguageServerApplication.prepareWorkspace();
        this.prepareStreams();
        JavaLanguageServerPlugin.startLanguageServer(this);
        BaseJDTLanguageServer baseJDTLanguageServer = JavaLanguageServerPlugin.getInstance().getProtocol();
        if (baseJDTLanguageServer instanceof JDTLanguageServer) {
            JDTLanguageServer server = (JDTLanguageServer)baseJDTLanguageServer;
            this.progressReporterManager = server.getProgressReporterManager();
            if (this.progressReporterManager != null) {
                Job.getJobManager().setProgressProvider((ProgressProvider)this.progressReporterManager);
            }
        }
        Object object = this.waitLock;
        synchronized (object) {
            while (true) {
                if (this.shutdown) {
                    return IApplication.EXIT_OK;
                }
                try {
                    context.applicationRunning();
                    JavaLanguageServerPlugin.logInfo("Main thread is waiting");
                    this.waitLock.wait();
                }
                catch (InterruptedException e) {
                    JavaLanguageServerPlugin.logException(e.getMessage(), e);
                }
            }
        }
    }

    private static void prepareWorkspace() throws CoreException {
        try {
            Platform.getBundle((String)"org.eclipse.core.resources").start(1);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription description = workspace.getDescription();
            description.setAutoBuilding(false);
            workspace.setDescription(description);
        }
        catch (BundleException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        this.shutdown = true;
        JavaLanguageServerPlugin.logInfo("Shutdown received... waking up main thread");
        Object object = this.waitLock;
        synchronized (object) {
            this.waitLock.notifyAll();
        }
    }

    public void setParentProcessId(long pid) {
        this.parentProcessId = pid;
    }

    public long getParentProcessId() {
        return this.parentProcessId;
    }

    private void prepareStreams() {
        boolean isDebug = Boolean.getBoolean("jdt.ls.debug");
        this.in = System.in;
        this.out = System.out;
        this.err = System.err;
        System.setIn(new ByteArrayInputStream(new byte[0]));
        if (isDebug) {
            String id = "jdt.ls-" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            File workspaceFile = root.getRawLocation().makeAbsolute().toFile();
            File rootFile = new File(workspaceFile, ".metadata");
            rootFile.mkdirs();
            File outFile = new File(rootFile, ".out-" + id + ".log");
            try {
                FileOutputStream stdFileOut = new FileOutputStream(outFile);
                System.setOut(new PrintStream(stdFileOut));
                File errFile = new File(rootFile, ".error-" + id + ".log");
                FileOutputStream stdFileErr = new FileOutputStream(errFile);
                System.setErr(new PrintStream(stdFileErr));
            }
            catch (FileNotFoundException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        } else {
            System.setOut(new PrintStream(new ByteArrayOutputStream()));
            System.setErr(new PrintStream(new ByteArrayOutputStream()));
        }
    }

    public InputStream getIn() {
        if (this.in == null) {
            this.prepareStreams();
        }
        return this.in;
    }

    public PrintStream getOut() {
        if (this.out == null) {
            this.prepareStreams();
        }
        return this.out;
    }

    public PrintStream getErr() {
        if (this.err == null) {
            this.prepareStreams();
        }
        return this.err;
    }
}

