/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.template.java;

import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.ls.core.internal.corext.template.java.PostfixTemplateEngine;
import org.eclipse.jface.text.IDocument;

public class PostfixCompletionProposalComputer {
    private PostfixTemplateEngine postfixCompletionTemplateEngine;

    public PostfixTemplateEngine computeCompletionEngine(CompletionContext jdtContext, IDocument document, int offset) {
        if (jdtContext != null && jdtContext.isExtended()) {
            if (this.postfixCompletionTemplateEngine == null) {
                this.postfixCompletionTemplateEngine = new PostfixTemplateEngine();
            }
            this.updateTemplateEngine(jdtContext);
            return this.postfixCompletionTemplateEngine;
        }
        return null;
    }

    private void updateTemplateEngine(CompletionContext jdtContext) {
        IJavaElement enclosingElement = jdtContext.getEnclosingElement();
        if (enclosingElement == null) {
            return;
        }
        int tokenLength = jdtContext.getToken() != null ? jdtContext.getToken().length : 0;
        final int invOffset = jdtContext.getOffset() - tokenLength - 1;
        ICompilationUnit cu = (ICompilationUnit)enclosingElement.getAncestor(5);
        CompilationUnit cuRoot = SharedASTProviderCore.getAST((ITypeRoot)cu, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_NO, null);
        if (cuRoot == null) {
            cuRoot = (CompilationUnit)PostfixCompletionProposalComputer.createPartialParser(cu, invOffset).createAST(null);
        }
        if (enclosingElement instanceof IMember) {
            ISourceRange sr;
            try {
                sr = ((IMember)enclosingElement).getSourceRange();
                if (sr == null) {
                    return;
                }
            }
            catch (JavaModelException e) {
                return;
            }
            ASTNode completionNode = NodeFinder.perform((ASTNode)cuRoot, (ISourceRange)sr);
            if (completionNode == null) {
                return;
            }
            final ASTNode[] bestNode = new ASTNode[]{completionNode};
            completionNode.accept(new ASTVisitor(){

                public boolean visit(StringLiteral node) {
                    int start = node.getStartPosition();
                    if (invOffset > start && start >= bestNode[0].getStartPosition()) {
                        bestNode[0] = node;
                    }
                    return true;
                }

                public boolean visit(ExpressionStatement node) {
                    int start = node.getStartPosition();
                    if (invOffset > start && start >= bestNode[0].getStartPosition()) {
                        bestNode[0] = node;
                    }
                    return true;
                }

                public boolean visit(SimpleName node) {
                    int start = node.getStartPosition();
                    if (invOffset > start && start >= bestNode[0].getStartPosition()) {
                        bestNode[0] = node;
                    }
                    return true;
                }

                public boolean visit(QualifiedName node) {
                    int start = node.getStartPosition();
                    if (invOffset > start && start >= bestNode[0].getStartPosition()) {
                        bestNode[0] = node;
                    }
                    return true;
                }

                public boolean visit(BooleanLiteral node) {
                    int start = node.getStartPosition();
                    if (invOffset > start && start >= bestNode[0].getStartPosition()) {
                        bestNode[0] = node;
                    }
                    return true;
                }

                public boolean visit(Javadoc node) {
                    int start = node.getStartPosition();
                    if (invOffset > start && start >= bestNode[0].getStartPosition()) {
                        bestNode[0] = node;
                    }
                    return false;
                }

                public boolean visit(MethodInvocation node) {
                    return this.visit((Expression)node);
                }

                public boolean visit(SuperMethodInvocation node) {
                    return this.visit((Expression)node);
                }

                public boolean visit(ClassInstanceCreation node) {
                    return this.visit((Expression)node);
                }

                public boolean visit(Expression node) {
                    if ((node.getFlags() & 8) == 0) {
                        int start = node.getStartPosition();
                        int end = start + node.getLength() - 1;
                        if (invOffset > start && invOffset == end + 1) {
                            bestNode[0] = node;
                            return false;
                        }
                    }
                    return true;
                }
            });
            completionNode = bestNode[0];
            ASTNode completionNodeParent = this.findBestMatchingParentNode(completionNode);
            this.postfixCompletionTemplateEngine.setASTNodes(completionNode, completionNodeParent);
            this.postfixCompletionTemplateEngine.setContext(jdtContext);
        }
    }

    private ASTNode findBestMatchingParentNode(ASTNode node) {
        ASTNode completionNodeGrandParent;
        ASTNode result = node.getParent();
        if (result instanceof InfixExpression) {
            completionNodeGrandParent = result.getParent();
            int safeGuard = 0;
            while (completionNodeGrandParent instanceof ParenthesizedExpression && safeGuard++ < 64) {
                result = completionNodeGrandParent;
                completionNodeGrandParent = result.getParent();
            }
        }
        if (node instanceof SimpleName && result instanceof SimpleType && (completionNodeGrandParent = result.getParent()) instanceof ClassInstanceCreation) {
            result = completionNodeGrandParent;
        }
        return result;
    }

    private static ASTParser createPartialParser(ICompilationUnit cu, int position) {
        ASTParser parser = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
        parser.setKind(8);
        parser.setProject(cu.getJavaProject());
        parser.setSource(cu);
        parser.setFocalPosition(position);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        parser.setStatementsRecovery(true);
        return parser;
    }
}

