/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import java.util.Map;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyEclipseBug;
import org.codehaus.jdt.groovy.internal.compiler.ast.ImmutableException;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JDTAnnotationNode
extends AnnotationNode {
    private AnnotationBinding annotationBinding;
    private volatile boolean membersInitialized;
    private JDTResolver resolver;

    public JDTAnnotationNode(AnnotationBinding annotationBinding, JDTResolver resolver) {
        super(new JDTClassNode(annotationBinding.getAnnotationType(), resolver));
        this.annotationBinding = annotationBinding;
        this.resolver = resolver;
    }

    @Override
    public void addMember(String name, Expression value) {
        throw new ImmutableException();
    }

    @Override
    public void setMember(String name, Expression value) {
        throw new ImmutableException();
    }

    @Override
    public Expression getMember(String name) {
        this.ensureMembersInitialized();
        return super.getMember(name);
    }

    @Override
    public Map<String, Expression> getMembers() {
        this.ensureMembersInitialized();
        return super.getMembers();
    }

    @Override
    public boolean hasClassRetention() {
        return 0L != (this.annotationBinding.getAnnotationType().tagBits & 0x200000000000L) || !this.hasRuntimeRetention() && !this.hasSourceRetention();
    }

    @Override
    public boolean hasRuntimeRetention() {
        return 0L != (this.annotationBinding.getAnnotationType().tagBits & 0x300000000000L);
    }

    @Override
    public boolean hasSourceRetention() {
        return 0L != (this.annotationBinding.getAnnotationType().tagBits & 0x100000000000L);
    }

    private void ensureMembersInitialized() {
        ElementValuePair[] evpairs;
        if (this.membersInitialized) {
            return;
        }
        this.membersInitialized = true;
        ElementValuePair[] elementValuePairArray = evpairs = this.annotationBinding.getElementValuePairs();
        int n = evpairs.length;
        int n2 = 0;
        while (n2 < n) {
            ElementValuePair evpair = elementValuePairArray[n2];
            char[] name = evpair.getName();
            MethodBinding mb = evpair.binding;
            Expression valueExpression = null;
            if (mb == null) {
                if (evpair.value instanceof StringConstant) {
                    String v = ((StringConstant)evpair.value).stringValue();
                    valueExpression = new ConstantExpression(v);
                } else {
                    valueExpression = ConstantExpression.NULL;
                }
            } else {
                valueExpression = this.createExpressionFor(mb.returnType, evpair.value);
            }
            super.addMember(new String(name), valueExpression);
            ++n2;
        }
    }

    private Expression createExpressionFor(TypeBinding b, Object value) {
        if (b.isArrayType()) {
            ListExpression listExpression = new ListExpression();
            if (value.getClass().isArray()) {
                Object[] objectArray = (Object[])value;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object v = objectArray[n2];
                    if (v != null) {
                        listExpression.addExpression(this.createExpressionFor(b.leafComponentType(), v));
                    }
                    ++n2;
                }
            } else {
                listExpression.addExpression(this.createExpressionFor(b.leafComponentType(), value));
            }
            return listExpression;
        }
        char[] sig = b.signature();
        if (CharOperation.equals(sig, ConstantPool.JavaLangStringSignature)) {
            return new ConstantExpression(((Constant)value).stringValue());
        }
        if (b.isClass()) {
            return new ClassExpression(this.resolver.convertToClassNode((TypeBinding)value));
        }
        if (b.isAnnotationType()) {
            return new AnnotationConstantExpression(this.resolver.convertToAnnotationNode((AnnotationBinding)value));
        }
        if (b.isEnum()) {
            ClassNode enumType = this.resolver.convertToClassNode(b);
            String fieldName = String.valueOf(((FieldBinding)value).name);
            return new PropertyExpression((Expression)new ClassExpression(enumType), fieldName);
        }
        if (b.isPrimitiveType()) {
            assert (sig.length == 1);
            switch (sig[0]) {
                case 'Z': {
                    return new ConstantExpression(((Constant)value).booleanValue(), true);
                }
                case 'B': {
                    return new ConstantExpression(((Constant)value).byteValue(), true);
                }
                case 'C': {
                    return new ConstantExpression(Character.valueOf(((Constant)value).charValue()), true);
                }
                case 'D': {
                    return new ConstantExpression(((Constant)value).doubleValue(), true);
                }
                case 'F': {
                    return new ConstantExpression(Float.valueOf(((Constant)value).floatValue()), true);
                }
                case 'I': {
                    return new ConstantExpression(((Constant)value).intValue(), true);
                }
                case 'J': {
                    return new ConstantExpression(((Constant)value).longValue(), true);
                }
                case 'S': {
                    return new ConstantExpression(((Constant)value).shortValue(), true);
                }
            }
        }
        throw new GroovyEclipseBug("Problem in JDTAnnotatioNode.createExpressionFor(binding=" + b + " value=" + value + ")");
    }
}

