/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuard;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Boolean_Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Operation_Altguard
extends AltGuard {
    private static final String BOOLEANEXPECTED = "A value or expression of type boolean was expected";
    private static final String FULLNAMEPART1 = ".expression";
    private static final String FULLNAMEPART2 = ".statement";
    private static final String FULLNAMEPART3 = ".block";
    private final Value expression;
    private final Statement statement;

    public Operation_Altguard(Value expression, Statement statement, StatementBlock statementblock) {
        super(AltGuard.altguard_type.AG_OP, statementblock);
        this.expression = expression;
        this.statement = statement;
        if (expression != null) {
            expression.setFullNameParent(this);
        }
        if (statement != null) {
            statement.setFullNameParent(this);
        }
        if (statementblock != null) {
            statementblock.setFullNameParent(this);
            statementblock.setOwnerIsAltguard();
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.expression == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.statement == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.statementblock == child) {
            return builder.append(FULLNAMEPART3);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.expression != null) {
            this.expression.setMyScope(scope);
        }
        if (this.statement != null) {
            this.statement.setMyScope(scope);
        }
        if (this.statementblock != null) {
            this.statementblock.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.expression != null) {
            this.expression.setCodeSection(codeSection);
        }
        if (this.statement != null) {
            this.statement.setCodeSection(codeSection);
        }
        if (this.statementblock != null) {
            this.statementblock.setCodeSection(codeSection);
        }
    }

    public Statement getGuardStatement() {
        return this.statement;
    }

    @Override
    public IValue getGuardExpression() {
        return this.expression;
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        if (this.statement != null) {
            this.statement.setMyStatementBlock(statementBlock, index);
        }
        if (this.statementblock != null) {
            this.statementblock.setMyStatementBlock(statementBlock, index);
        }
    }

    @Override
    public void setMyDefinition(Definition definition) {
        if (this.statement != null) {
            this.statement.setMyDefinition(definition);
        }
        if (this.statementblock != null) {
            this.statementblock.setMyDefinition(definition);
        }
    }

    @Override
    public void setMyAltguards(AltGuards altGuards) {
        if (this.statementblock != null) {
            this.statementblock.setMyAltguards(altGuards);
        }
    }

    @Override
    public StatementBlock.ReturnStatus_type hasReturn(CompilationTimeStamp timestamp) {
        if (this.statementblock != null) {
            return this.statementblock.hasReturn(timestamp);
        }
        return StatementBlock.ReturnStatus_type.RS_NO;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        if (this.expression != null) {
            IValue last = this.expression.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
            IType.Type_type temporalType = last.getExpressionReturntype(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
            if (!last.getIsErroneous(timestamp) && !IType.Type_type.TYPE_BOOL.equals((Object)temporalType)) {
                last.getLocation().reportSemanticError(BOOLEANEXPECTED);
                this.expression.setIsErroneous(true);
            }
            if (this.expression.getMyGovernor() == null) {
                this.expression.setMyGovernor(new Boolean_Type());
            }
        }
        if (this.statement != null) {
            this.statement.check(timestamp);
        }
        if (this.statementblock != null) {
            this.statementblock.check(timestamp);
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void checkAllowedInterleave() {
        if (this.statementblock != null) {
            this.statementblock.checkAllowedInterleave();
        }
    }

    @Override
    public void postCheck() {
        if (this.statement != null) {
            this.statement.postCheck();
        }
        if (this.statementblock != null) {
            this.statementblock.postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            if (this.statementblock != null && reparser.envelopsDamage(this.statementblock.getLocation())) {
                this.statementblock.updateSyntax(reparser, true);
                if (this.expression != null) {
                    this.expression.updateSyntax(reparser, false);
                    reparser.updateLocation(this.expression.getLocation());
                }
                if (this.statement != null) {
                    this.statement.updateSyntax(reparser, false);
                    reparser.updateLocation(this.statement.getLocation());
                }
                reparser.updateLocation(this.statementblock.getLocation());
                return;
            }
        }
        if (this.expression != null) {
            this.expression.updateSyntax(reparser, false);
            reparser.updateLocation(this.expression.getLocation());
        }
        if (this.statement != null) {
            this.statement.updateSyntax(reparser, false);
            reparser.updateLocation(this.statement.getLocation());
        }
        if (this.statementblock != null) {
            this.statementblock.updateSyntax(reparser, false);
            reparser.updateLocation(this.statementblock.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.expression != null) {
            this.expression.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.statement != null) {
            this.statement.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.statementblock != null) {
            this.statementblock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.expression != null && !this.expression.accept(v)) {
            return false;
        }
        if (this.statement != null && !this.statement.accept(v)) {
            return false;
        }
        return this.statementblock == null || this.statementblock.accept(v);
    }
}

