/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.definitions.RunsOnScope;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.UniversalCharstring_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Charstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.UniversalCharstring_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public class Setencode_Statement
extends Statement {
    private static final String OPERANDERROR1 = "The type argument has no encoding rules defined";
    private static final String FULLNAMEPART1 = ".type";
    private static final String FULLNAMEPART2 = ".encoding";
    private static final String STATEMENT_NAME = "setencode";
    private Type type;
    private Value encoding;

    public Setencode_Statement(Type type, Value value) {
        this.type = type;
        this.encoding = value;
        if (type != null) {
            type.setFullNameParent(this);
        }
        if (value != null) {
            value.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_SETENCODE;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.type == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.encoding == child) {
            return builder.append(FULLNAMEPART2);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
        if (this.encoding != null) {
            this.encoding.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.encoding != null) {
            this.encoding.setCodeSection(codeSection);
        }
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        RunsOnScope runs_on_scope;
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        boolean typeError = false;
        this.type.check(timestamp);
        Type codingTableType = (Type)this.type.getTypeWithCodingTable(timestamp, false);
        if (codingTableType == null) {
            this.type.getLocation().reportSemanticError(OPERANDERROR1);
            typeError = true;
        } else if (codingTableType.getCodingTable().size() == 1) {
            this.type.getLocation().reportSemanticWarning("The type argument has only one encoding rule defined. The 'setencode' statement will be ignored");
        }
        if (this.encoding != null) {
            Value encodingString = this.encoding;
            IValue lastValue = encodingString.setLoweridToReference(timestamp);
            UniversalCharstring_Type tempType = new UniversalCharstring_Type();
            tempType.checkThisValue(timestamp, encodingString, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false, false, false, false, false));
            if (!(typeError || encodingString.getIsErroneous(timestamp) || encodingString.isUnfoldable(timestamp))) {
                lastValue = lastValue.getValueRefdLast(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, null);
                boolean errorFound = false;
                if (IValue.Value_type.UNIVERSALCHARSTRING_VALUE.equals((Object)lastValue.getValuetype())) {
                    errorFound = ((UniversalCharstring_Value)lastValue).checkDynamicEncodingString(timestamp, this.type);
                } else if (IValue.Value_type.CHARSTRING_VALUE.equals((Object)lastValue.getValuetype())) {
                    errorFound = ((Charstring_Value)lastValue).checkDynamicEncodingString(timestamp, this.type);
                }
                if (errorFound) {
                    encodingString.getLocation().reportSemanticError(MessageFormat.format("The encoding string does not match any encodings of type `{0}''", this.type.getTypename()));
                }
            }
        }
        if ((runs_on_scope = this.myStatementBlock.getScopeRunsOn()) == null) {
            this.getLocation().reportSemanticError("'self.setencode' must be in a definition with a runs-on clause");
        } else if (typeError || codingTableType.getCodingTable().size() >= 2) {
            // empty if block
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.encoding != null) {
            this.encoding.updateSyntax(reparser, false);
            reparser.updateLocation(this.encoding.getLocation());
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.type != null && !this.type.accept(v)) {
            return false;
        }
        return this.encoding == null || this.encoding.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        if (this.type.getTypeWithCodingTable(CompilationTimeStamp.getBaseTimestamp(), false).getCodingTable().size() == 1) {
            return;
        }
        ExpressionStruct expression = new ExpressionStruct();
        this.encoding.generateCodeExpression(aData, expression, true);
        if (expression.preamble != null) {
            source.append((CharSequence)expression.preamble);
        }
        source.append(MessageFormat.format("{0}_default_coding.operator_assign( {1} );\n", this.type.getGenNameDefaultCoding(aData, source, this.getMyScope()), expression.expression));
        if (expression.postamble != null) {
            source.append((CharSequence)expression.postamble);
        }
    }
}

