/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.parsers.Interval;
import org.eclipse.titan.designer.editors.GlobalIntervalHandler;
import org.eclipse.titan.designer.editors.Pair;

public abstract class GeneralPairMatcher
implements ICharacterPairMatcher {
    protected Pair[] pairs;
    protected IDocument document;
    protected IDocumentPartitioner partitioner;
    protected int offset;
    protected int startPos;
    protected int endPos;
    protected int anchor;

    protected abstract String getPartitioning();

    public final void clear() {
        this.offset = 0;
        this.endPos = 0;
        this.startPos = 0;
        this.anchor = 0;
    }

    public final void dispose() {
        this.clear();
        this.document = null;
    }

    public final int getAnchor() {
        return this.anchor;
    }

    public IRegion match(IDocument iDocument, int i) {
        this.offset = i - 1;
        if (i < 0) {
            return null;
        }
        this.document = iDocument;
        this.partitioner = null;
        if (this.document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)this.document;
            this.partitioner = extension3.getDocumentPartitioner(this.getPartitioning());
        } else {
            this.partitioner = this.document.getDocumentPartitioner();
        }
        if (this.document != null && !this.isComment(this.offset) && this.matchPairs()) {
            return new Region(this.startPos, this.endPos - this.startPos + 1);
        }
        return null;
    }

    public final boolean matchPairs() {
        if (this.offset >= 0 && this.matchPairsAtOffset()) {
            return true;
        }
        if (this.offset >= this.document.getLength() - 1) {
            return false;
        }
        ++this.offset;
        return this.matchPairsAtOffset();
    }

    private final boolean matchPairsAtOffset() {
        char currBracket;
        try {
            currBracket = this.document.getChar(this.offset);
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        Interval interval = GlobalIntervalHandler.getInterval(this.document);
        for (int i = 0; i < this.pairs.length; ++i) {
            int temp;
            if (this.pairs[i].end == currBracket) {
                int temp2;
                this.endPos = this.offset;
                this.anchor = 0;
                if (interval != null && (temp2 = interval.getPairLocation(this.offset)) != -1) {
                    this.startPos = temp2;
                    return true;
                }
                return this.findStartingBracket(this.pairs[i]);
            }
            if (this.pairs[i].start != currBracket) continue;
            this.startPos = this.offset;
            this.anchor = 1;
            if (interval != null && (temp = interval.getPairLocation(this.offset)) != -1) {
                this.endPos = temp;
                return true;
            }
            return this.findEndingBracket(this.pairs[i]);
        }
        return false;
    }

    protected final boolean findStartingBracket(Pair pair) {
        try {
            int currPosition;
            String theDoc = this.document.get(0, this.offset);
            int currLevel = 1;
            for (currPosition = theDoc.length() - 1; currLevel > 0 && currPosition > 0; --currPosition) {
                if (this.isComment(currPosition)) {
                    currPosition = this.getRegionOffset(currPosition);
                    continue;
                }
                if ('\"' == theDoc.charAt(currPosition)) {
                    currPosition = this.getStringStart(theDoc, currPosition);
                    continue;
                }
                if (this.isComment(currPosition)) continue;
                if (theDoc.charAt(currPosition) == pair.end) {
                    ++currLevel;
                    continue;
                }
                if (theDoc.charAt(currPosition) != pair.start) continue;
                --currLevel;
            }
            this.startPos = currPosition + 1;
            return currLevel <= 0;
        }
        catch (BadLocationException ble) {
            return false;
        }
    }

    protected final boolean findEndingBracket(Pair pair) {
        int currPosition;
        String theDoc = this.document.get();
        int currLevel = 1;
        for (currPosition = this.startPos + 1; currLevel > 0 && currPosition < theDoc.length(); ++currPosition) {
            if (this.isComment(currPosition)) {
                currPosition = this.getRegionEnd(currPosition);
                continue;
            }
            if ('\"' == theDoc.charAt(currPosition)) {
                currPosition = this.getStringEnd(theDoc, currPosition);
                continue;
            }
            if (this.isComment(currPosition)) continue;
            if (theDoc.charAt(currPosition) == pair.end) {
                --currLevel;
                continue;
            }
            if (theDoc.charAt(currPosition) != pair.start) continue;
            ++currLevel;
        }
        if (currLevel > 0) {
            return false;
        }
        this.endPos = currPosition - 1;
        return true;
    }

    protected final boolean isComment(int offset) {
        return false;
    }

    protected final int getRegionEnd(int offset) {
        if (this.partitioner == null) {
            return offset;
        }
        ITypedRegion partition = this.partitioner.getPartition(offset);
        return partition.getOffset() + partition.getLength() - 1;
    }

    protected final int getRegionOffset(int offset) {
        if (this.partitioner == null) {
            return offset;
        }
        ITypedRegion partition = this.partitioner.getPartition(offset);
        return partition.getOffset();
    }

    protected final int getStringEnd(String theDoc, int currentPosition) {
        int innerOffset;
        for (innerOffset = currentPosition + 1; innerOffset < theDoc.length(); ++innerOffset) {
            char tempChar = theDoc.charAt(innerOffset);
            if ('\\' == tempChar) {
                ++innerOffset;
                continue;
            }
            if ('\"' == tempChar) break;
        }
        return innerOffset;
    }

    protected final int getStringStart(String theDoc, int currentPosition) {
        int innerOffset;
        for (innerOffset = currentPosition - 1; innerOffset > 0; --innerOffset) {
            char tempChar = theDoc.charAt(innerOffset);
            if ('\"' != tempChar) continue;
            if (innerOffset <= 0 || '\\' != theDoc.charAt(innerOffset - 1)) break;
            --innerOffset;
        }
        return innerOffset;
    }
}

