/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Module_Param_Length_Restriction;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TtcnError;

public abstract class Restricted_Length_Template
extends Base_Template {
    public length_restriction_type_t length_restriction_type = length_restriction_type_t.NO_LENGTH_RESTRICTION;
    protected int single_length;
    protected int range_length_min_length;
    protected int range_length_max_length;
    protected boolean range_length_max_length_set;

    public Restricted_Length_Template() {
    }

    public Restricted_Length_Template(Base_Template.template_sel other_value) {
        super(other_value);
    }

    @Override
    protected void set_selection(Base_Template.template_sel other_value) {
        this.template_selection = other_value;
        this.is_ifPresent = false;
        this.length_restriction_type = length_restriction_type_t.NO_LENGTH_RESTRICTION;
    }

    protected void set_selection(Restricted_Length_Template other_value) {
        this.template_selection = other_value.template_selection;
        this.is_ifPresent = other_value.is_ifPresent;
        this.length_restriction_type = other_value.length_restriction_type;
        this.single_length = other_value.single_length;
        this.range_length_min_length = other_value.range_length_min_length;
        this.range_length_max_length = other_value.range_length_max_length;
        this.range_length_max_length_set = other_value.range_length_max_length_set;
    }

    public boolean match_length(int value_length) {
        switch (this.length_restriction_type) {
            case NO_LENGTH_RESTRICTION: {
                return true;
            }
            case SINGLE_LENGTH_RESTRICTION: {
                return value_length == this.single_length;
            }
            case RANGE_LENGTH_RESTRICTION: {
                return value_length >= this.range_length_min_length && (!this.range_length_max_length_set || value_length <= this.range_length_max_length);
            }
        }
        throw new TtcnError("Internal error: Matching with a template that has invalid length restriction type.");
    }

    protected int check_section_is_single(int min_size, boolean has_any_or_none, String operation_name, String type_name_prefix, String type_name) {
        if (has_any_or_none) {
            switch (this.length_restriction_type) {
                case NO_LENGTH_RESTRICTION: {
                    throw new TtcnError(MessageFormat.format("Performing {0}of() operation on {1} {2} with no exact {3}.", operation_name, type_name_prefix, type_name, operation_name));
                }
                case SINGLE_LENGTH_RESTRICTION: {
                    if (this.single_length >= min_size) {
                        return this.single_length;
                    }
                    throw new TtcnError(MessageFormat.format("Performing {0}of() operation on an invalid {1}. The minimum {2} ({3}) contradicts the length restriction ({4}).", operation_name, type_name, operation_name, min_size, this.single_length));
                }
                case RANGE_LENGTH_RESTRICTION: {
                    boolean has_invalid_restriction;
                    if (this.match_length(min_size)) {
                        if (this.range_length_max_length_set && min_size == this.range_length_max_length) {
                            return min_size;
                        }
                        has_invalid_restriction = false;
                    } else {
                        boolean bl = has_invalid_restriction = min_size > this.range_length_min_length;
                    }
                    if (has_invalid_restriction) {
                        if (this.range_length_max_length_set) {
                            throw new TtcnError(MessageFormat.format("Performing {0}of() operation on an invalid {1}. The minimum {2} ({3}) contradicts the length restriction ({4}..{5}).", operation_name, type_name, operation_name, min_size, this.range_length_min_length, this.range_length_max_length));
                        }
                        throw new TtcnError(MessageFormat.format("Performing {0}of() operation on an invalid {1}. The minimum {2} ({3}) contradicts the length restriction ({4}..infinity).", operation_name, type_name, operation_name, min_size, this.range_length_min_length));
                    }
                    throw new TtcnError(MessageFormat.format("Performing {0}of() operation on {1} {2} with no exact {3}.", operation_name, type_name_prefix, type_name, operation_name));
                }
            }
            throw new TtcnError("Internal error: Template has invalid length restriction type.");
        }
        switch (this.length_restriction_type) {
            case NO_LENGTH_RESTRICTION: {
                return min_size;
            }
            case SINGLE_LENGTH_RESTRICTION: {
                if (this.single_length == min_size) {
                    return min_size;
                }
                throw new TtcnError(MessageFormat.format("Performing {0}of() operation on an invalid {1}. The {2} ({3}) contradicts the length restriction ({4}).", operation_name, type_name, operation_name, min_size, this.single_length));
            }
            case RANGE_LENGTH_RESTRICTION: {
                if (!this.match_length(min_size)) {
                    if (this.range_length_max_length_set) {
                        throw new TtcnError(MessageFormat.format("Performing {0}of() operation on an invalid {1}. The {2} ({3}) contradicts the length restriction ({4}..{5}).", operation_name, type_name, operation_name, min_size, this.range_length_min_length, this.range_length_max_length));
                    }
                    throw new TtcnError(MessageFormat.format("Performing {0}of() operation on an invalid {1}. The {2} ({3}) contradicts the length restriction ({4}..infinity).", operation_name, type_name, operation_name, min_size, this.range_length_min_length));
                }
                return min_size;
            }
        }
        throw new TtcnError("Internal error: Template has invalid length restriction type.");
    }

    protected void log_restricted() {
        switch (this.length_restriction_type) {
            case SINGLE_LENGTH_RESTRICTION: {
                TTCN_Logger.log_event(MessageFormat.format(" length ({0})", this.single_length), new Object[0]);
                break;
            }
            case NO_LENGTH_RESTRICTION: {
                break;
            }
            case RANGE_LENGTH_RESTRICTION: {
                TTCN_Logger.log_event(MessageFormat.format(" length ({0} .. ", this.range_length_min_length), new Object[0]);
                if (this.range_length_max_length_set) {
                    TTCN_Logger.log_event(MessageFormat.format("{0})", this.range_length_max_length), new Object[0]);
                    break;
                }
                TTCN_Logger.log_event_str("infinity)");
                break;
            }
            default: {
                TTCN_Logger.log_event_str("<unknown length restriction>");
            }
        }
    }

    protected void log_match_length(int value_length) {
        if (this.length_restriction_type != length_restriction_type_t.NO_LENGTH_RESTRICTION) {
            if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT == TTCN_Logger.get_matching_verbosity()) {
                if (!this.match_length(value_length)) {
                    TTCN_Logger.print_logmatch_buffer();
                    this.log_restricted();
                    TTCN_Logger.log_event(MessageFormat.format(" with {0} ", value_length), new Object[0]);
                }
            } else {
                this.log_restricted();
                TTCN_Logger.log_event(MessageFormat.format(" with {0} ", value_length), new Object[0]);
                if (this.match_length(value_length)) {
                    TTCN_Logger.log_event_str("matched");
                } else {
                    TTCN_Logger.log_event_str("unmatched");
                }
            }
        }
    }

    protected void encode_text_restricted(Text_Buf text_buf) {
        this.encode_text_base(text_buf);
        text_buf.push_int(this.length_restriction_type.ordinal());
        switch (this.length_restriction_type) {
            case SINGLE_LENGTH_RESTRICTION: {
                text_buf.push_int(this.single_length);
                break;
            }
            case NO_LENGTH_RESTRICTION: {
                break;
            }
            case RANGE_LENGTH_RESTRICTION: {
                text_buf.push_int(this.range_length_min_length);
                text_buf.push_int(this.range_length_max_length_set ? 1 : 0);
                if (!this.range_length_max_length_set) break;
                text_buf.push_int(this.range_length_max_length);
                break;
            }
            default: {
                throw new TtcnError("Text encoder: encoding an unknown/unsupported length restriction type in a template.");
            }
        }
    }

    protected void decode_text_restricted(Text_Buf text_buf) {
        this.decode_text_base(text_buf);
        this.length_restriction_type = length_restriction_type_t.values()[text_buf.pull_int().get_int()];
        switch (this.length_restriction_type) {
            case SINGLE_LENGTH_RESTRICTION: {
                this.single_length = text_buf.pull_int().get_int();
                break;
            }
            case NO_LENGTH_RESTRICTION: {
                break;
            }
            case RANGE_LENGTH_RESTRICTION: {
                this.range_length_min_length = text_buf.pull_int().get_int();
                boolean bl = this.range_length_max_length_set = text_buf.pull_int().get_int() != 0;
                if (!this.range_length_max_length_set) break;
                this.range_length_max_length = text_buf.pull_int().get_int();
                break;
            }
            default: {
                throw new TtcnError("Text decoder: an unknown/unsupported length restriction type was received for a template.");
            }
        }
    }

    protected void set_length_range(Param_Types.Module_Parameter param) {
        Module_Param_Length_Restriction length_range = param.get_length_restriction();
        if (length_range == null) {
            this.length_restriction_type = length_restriction_type_t.NO_LENGTH_RESTRICTION;
            return;
        }
        if (length_range.is_single()) {
            this.length_restriction_type = length_restriction_type_t.SINGLE_LENGTH_RESTRICTION;
            this.single_length = length_range.get_min();
        } else {
            this.length_restriction_type = length_restriction_type_t.RANGE_LENGTH_RESTRICTION;
            this.range_length_min_length = length_range.get_min();
            this.range_length_max_length_set = length_range.get_has_max();
            if (this.range_length_max_length_set) {
                this.range_length_max_length = length_range.get_max();
            }
        }
    }

    protected Module_Param_Length_Restriction get_length_range() {
        if (this.length_restriction_type == length_restriction_type_t.NO_LENGTH_RESTRICTION) {
            return null;
        }
        Module_Param_Length_Restriction mp_res = new Module_Param_Length_Restriction();
        if (this.length_restriction_type == length_restriction_type_t.SINGLE_LENGTH_RESTRICTION) {
            mp_res.set_single(this.single_length);
        } else {
            mp_res.set_min(this.range_length_min_length);
            if (this.range_length_max_length_set) {
                mp_res.set_max(this.range_length_max_length);
            }
        }
        return mp_res;
    }

    public void set_single_length(int single_length) {
        this.length_restriction_type = length_restriction_type_t.SINGLE_LENGTH_RESTRICTION;
        this.single_length = single_length;
    }

    public void set_single_length(TitanInteger single_length) {
        single_length.must_bound("Using an unbound integer value as length restriction.");
        this.set_single_length(single_length.get_int());
    }

    public void set_min_length(int min_length) {
        if (min_length < 0) {
            throw new TtcnError(MessageFormat.format("The lower limit for the length is negative ({0}) in a template with length restriction.", min_length));
        }
        this.length_restriction_type = length_restriction_type_t.RANGE_LENGTH_RESTRICTION;
        this.range_length_min_length = min_length;
        this.range_length_max_length_set = false;
    }

    public void set_min_length(TitanInteger min_length) {
        min_length.must_bound("Using an unbound integer value as lower length restriction.");
        this.set_min_length(min_length.get_int());
    }

    public void set_max_length(int max_length) {
        if (this.length_restriction_type != length_restriction_type_t.RANGE_LENGTH_RESTRICTION) {
            throw new TtcnError("Internal error: Setting a maximum length for a template the length restriction of which is not a range.");
        }
        if (max_length < 0) {
            throw new TtcnError(MessageFormat.format("The upper limit for the length is negative ({0}) in a template with length restriction.", max_length));
        }
        if (this.range_length_min_length > max_length) {
            throw new TtcnError(MessageFormat.format("The upper limit for the length ({0}) is smaller than the lower limit ({1}) in a template with length restriction.", max_length, this.range_length_min_length));
        }
        this.range_length_max_length = max_length;
        this.range_length_max_length_set = true;
    }

    public void set_max_length(TitanInteger max_length) {
        max_length.must_bound("Using an unbound integer value as upper length restriction.");
        this.set_max_length(max_length.get_int());
    }

    @Override
    public boolean is_omit() {
        return this.template_selection == Base_Template.template_sel.OMIT_VALUE && !this.is_ifPresent && this.length_restriction_type == length_restriction_type_t.NO_LENGTH_RESTRICTION;
    }

    @Override
    public boolean is_any_or_omit() {
        return this.template_selection == Base_Template.template_sel.ANY_OR_OMIT && !this.is_ifPresent && this.length_restriction_type == length_restriction_type_t.NO_LENGTH_RESTRICTION;
    }

    public static enum length_restriction_type_t {
        NO_LENGTH_RESTRICTION,
        SINGLE_LENGTH_RESTRICTION,
        RANGE_LENGTH_RESTRICTION;

    }
}

