/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.util.ArrayList;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TtcnError;

public final class TTCN_EncDec_ErrorContext {
    private static ThreadLocal<ArrayList<TTCN_EncDec_ErrorContext>> errors = new ThreadLocal<ArrayList<TTCN_EncDec_ErrorContext>>(){

        @Override
        protected ArrayList<TTCN_EncDec_ErrorContext> initialValue() {
            return new ArrayList<TTCN_EncDec_ErrorContext>();
        }
    };
    private String format;
    private Object[] arguments;

    public TTCN_EncDec_ErrorContext() {
        errors.get().add(this);
    }

    public TTCN_EncDec_ErrorContext(String fmt, Object ... args) {
        this.format = fmt;
        this.arguments = args;
        errors.get().add(this);
    }

    public void leave_context() {
        ArrayList<TTCN_EncDec_ErrorContext> localErrors = errors.get();
        TTCN_EncDec_ErrorContext temp = localErrors.get(localErrors.size() - 1);
        if (temp != this) {
            throw new TtcnError(" Internal error: TTCN_EncDec_ErrorContext.leaveContext()");
        }
        localErrors.remove(localErrors.size() - 1);
    }

    public static void reset_all_contexts() {
        errors.get().clear();
    }

    public void set_msg(String fmt, Object ... args) {
        this.format = fmt;
        this.arguments = args;
    }

    public static void error(TTCN_EncDec.error_type p_et, String fmt, Object ... args) {
        StringBuilder err_msg = new StringBuilder();
        ArrayList<TTCN_EncDec_ErrorContext> localErrors = errors.get();
        for (int i = 0; i < localErrors.size(); ++i) {
            TTCN_EncDec_ErrorContext temp = localErrors.get(i);
            if (temp.format == null) continue;
            if (temp.arguments == null) {
                err_msg.append(temp.format);
                continue;
            }
            err_msg.append(String.format(temp.format, temp.arguments));
        }
        err_msg.append(String.format(fmt, args));
        TTCN_EncDec.error(p_et, err_msg.toString());
    }

    public static void error_internal(String fmt, Object ... args) {
        StringBuilder err_msg = new StringBuilder("Internal error: ");
        ArrayList<TTCN_EncDec_ErrorContext> localErrors = errors.get();
        for (int i = 0; i < localErrors.size(); ++i) {
            TTCN_EncDec_ErrorContext temp = localErrors.get(i);
            err_msg.append(String.format(temp.format, temp.arguments)).append(' ');
        }
        err_msg.append(String.format(fmt, args));
        TTCN_EncDec.error(TTCN_EncDec.error_type.ET_INTERNAL, err_msg.toString());
        throw new TtcnError(TTCN_EncDec.get_error_str());
    }

    public void warning(String fmt, Object ... args) {
        StringBuilder warn_msg = new StringBuilder();
        ArrayList<TTCN_EncDec_ErrorContext> localErrors = errors.get();
        for (int i = 0; i < localErrors.size(); ++i) {
            TTCN_EncDec_ErrorContext temp = localErrors.get(i);
            warn_msg.append(String.format(temp.format, temp.arguments)).append(' ');
        }
        warn_msg.append(String.format(fmt, args));
        TtcnError.TtcnWarning(warn_msg.toString());
    }
}

