/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.semicolon;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definitions;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuard;
import org.eclipse.titan.designer.AST.TTCN3.statements.Alt_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.DoWhile_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.For_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.If_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.TryCatch_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Unknown_Applied_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Unknown_Instance_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Unknown_Start_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Unknown_Stop_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.While_Statement;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.PortTypeBody;

class SemicolonVisitor
extends ASTVisitor {
    private final Set<Location> locations = new HashSet<Location>();

    SemicolonVisitor() {
    }

    public Set<Location> getLocations() {
        this.locations.remove(NULL_Location.INSTANCE);
        return this.locations;
    }

    public int visit(IVisitableNode node) {
        if (this.isGoodType(node)) {
            this.locations.add(((Statement)node).getLocation());
            return 3;
        }
        if (node instanceof AltGuard) {
            this.locations.add(((AltGuard)node).getLocation());
            return 3;
        }
        if (node instanceof ComponentTypeBody) {
            ComponentTypeBody cmp = (ComponentTypeBody)node;
            for (Definition i : cmp.getDefinitions()) {
                this.locations.add(i.getLocation());
            }
            return 3;
        }
        if (node instanceof Definition) {
            this.locations.add(((Definition)node).getLocation());
            return 3;
        }
        if (node instanceof PortTypeBody) {
            Definitions def;
            FormalParameterList param;
            PortTypeBody port = (PortTypeBody)node;
            FormalParameterList unparam = port.getUnmapParameters();
            if (unparam != null) {
                this.locations.add(unparam.getLocation());
            }
            if ((param = port.getMapParameters()) != null) {
                this.locations.add(param.getLocation());
            }
            if ((def = port.getVariableDefinitions()) != null) {
                this.locations.add(def.getLocation());
            }
            return 3;
        }
        return 3;
    }

    private boolean isGoodType(IVisitableNode node) {
        return node instanceof Statement && !(node instanceof If_Statement) && !(node instanceof TryCatch_Statement) && !(node instanceof For_Statement) && !(node instanceof While_Statement) && !(node instanceof DoWhile_Statement) && !(node instanceof Alt_Statement) && !(node instanceof Unknown_Applied_Statement) && !(node instanceof Unknown_Instance_Statement) && !(node instanceof Unknown_Start_Statement) && !(node instanceof Unknown_Stop_Statement);
    }
}

