/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.internal.importexport.RemoteImportExportPlugin;
import org.eclipse.rse.internal.importexport.files.IRemoteFileImportDescriptionWriter;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportData;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RemoteFileImportDescriptionWriter
implements IRemoteFileImportDescriptionWriter {
    protected OutputStream fOutputStream;

    public RemoteFileImportDescriptionWriter(OutputStream outputStream) {
        Assert.isNotNull((Object)outputStream);
        this.fOutputStream = new BufferedOutputStream(outputStream);
    }

    public void write(RemoteFileImportData importData) throws CoreException {
        try {
            this.writeXML(importData);
        }
        catch (IOException ex) {
            String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
            throw new CoreException((IStatus)new Status(4, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, message, (Throwable)ex));
        }
    }

    public void writeXML(RemoteFileImportData importData) throws IOException {
        Assert.isNotNull((Object)importData);
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        try {
            docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
        Document document = docBuilder.newDocument();
        Element xmlFileDesc = document.createElement("rimpfd");
        document.appendChild(xmlFileDesc);
        this.xmlWriteDestinationLocation(importData, document, xmlFileDesc);
        this.xmlWriteOptions(importData, document, xmlFileDesc);
        this.xmlWriteSourceLocation(importData, document, xmlFileDesc);
        this.xmlWriteSelectedElements(importData, document, xmlFileDesc);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(this.fOutputStream);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    private void xmlWriteDestinationLocation(RemoteFileImportData importData, Document document, Element xmlFileDesc) throws DOMException {
        Element destination = document.createElement("destination");
        xmlFileDesc.appendChild(destination);
        destination.setAttribute("path", importData.getContainerPath().toString());
    }

    private void xmlWriteOptions(RemoteFileImportData importData, Document document, Element xmlFileDesc) throws DOMException {
        Element options = document.createElement("options");
        xmlFileDesc.appendChild(options);
        options.setAttribute("overWriteExistingFiles", "" + importData.isOverWriteExistingFiles());
        options.setAttribute("createDirectoryStructure", "" + importData.isCreateDirectoryStructure());
        options.setAttribute("createSelectedOnly", "" + importData.isCreateSelectionOnly());
        options.setAttribute("saveSettings", "" + importData.isSaveSettings());
        options.setAttribute("descriptionFilePath", importData.getDescriptionFilePath());
    }

    private void xmlWriteSourceLocation(RemoteFileImportData importData, Document document, Element xmlFileDesc) throws DOMException {
        Element source = document.createElement("source");
        xmlFileDesc.appendChild(source);
        UniFilePlus sourceResource = (UniFilePlus)importData.getSource();
        source.setAttribute("path", sourceResource.getCanonicalPath());
    }

    private void xmlWriteSelectedElements(RemoteFileImportData exportData, Document document, Element xmlFileDesc) throws DOMException {
        Element selectedElements = document.createElement("selectedElements");
        xmlFileDesc.appendChild(selectedElements);
        List elements = exportData.getElements();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof UniFilePlus)) continue;
            this.add((UniFilePlus)element, selectedElements, document);
        }
    }

    private void add(UniFilePlus resource, Element parent, Document document) {
        Element element = null;
        if (resource.isFile()) {
            element = document.createElement("file");
        } else if (resource.isDirectory()) {
            element = document.createElement("folder");
        }
        if (element != null) {
            parent.appendChild(element);
            element.setAttribute("path", resource.getAbsolutePath());
        }
    }

    public void close() throws CoreException {
        if (this.fOutputStream != null) {
            try {
                this.fOutputStream.close();
            }
            catch (IOException ex) {
                String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
                throw new CoreException((IStatus)new Status(4, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, message, (Throwable)ex));
            }
        }
    }

    public IStatus getStatus() {
        return new Status(0, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, "", null);
    }
}

