#!/bin/sh
###############################################################################
# Copyright (c) 2008 Wind River Systems, Inc. and others.
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Eclipse Public License v1.0
# which accompanies this distribution, and is available at
# http://www.eclipse.org/legal/epl-v10.html
#
# Contributors:
# Martin Oberhuber (Wind River) - initial API and implementation
###############################################################################
#
# Mirror and pack200 Ganymede to an archived update site.
# Before running, configure PATH, ECLIPSE, mirrorURL below for your Platform.
# Run in a directory with at least 1GB of free disk space.
# This directory MUST NOT be in the system PATH.
# Tested on Linux with Ganymede M5.  See
# http://wiki.eclipse.org/Platform-releng-faq#How_can_I_run_the_update_manager_from_a_command_line_to_mirror_a_remote_site.3F
#
curdir=`pwd`
cd `dirname $0`
mydir=`pwd`
cd "${curdir}"

##if false ; then ##<mirroring>
mkdir ganymede
mkdir ganymede.jars
export PATH=/opt/JDKs/i386/jdk1.5.0_14/bin:$PATH
which java
ECLIPSE=/opt/eclipse-3.4m5-gtk/eclipse
LAUNCHER=`ls $ECLIPSE/plugins/org.eclipse.equinox.launcher_*.jar | sort | tail -1`
java -jar $LAUNCHER \
    -application org.eclipse.update.core.standaloneUpdate \
    -command mirror \
    -from http://download.eclipse.org/releases/ganymede \
    -to "${curdir}/ganymede" \
    -mirrorURL http://dsdp.eclipse.org/releases/ganymede \
    -ignoreMissingPlugins true
echo "---> Total size (JARs only)"
du -k ganymede
#exit
#workaround to downgrade pack200 effort to -E4
# See https://bugs.eclipse.org/bugs/show_bug.cgi?id=154069
if [ ! -f ${mydir}/pack200 ]; then
  echo '#!/bin/sh' > ${mydir}/pack200
  echo 'pack200 -E4 $*' >> ${mydir}/pack200
  chmod a+x ${mydir}/pack200
fi
java -Dorg.eclipse.update.jarprocessor.pack200=$mydir \
    -jar $LAUNCHER -application org.eclipse.update.core.siteOptimizer \
    -jarProcessor -outputDir "${curdir}/ganymede" -processAll -pack "${curdir}/ganymede"
java -jar $LAUNCHER -application org.eclipse.update.core.siteOptimizer \
    -digestBuilder -digestOutputDir="${curdir}/ganymede" -siteXML="${curdir}/ganymede/site.xml"
echo "---> Total size (JARs and .pack.gz)"
du -k ganymede
mkdir ganymede.jars/features
mkdir ganymede.jars/plugins
#features need to remain in unpacked form for UM to use
mv ganymede/features/*.jar.pack.gz ganymede.jars/features
mv ganymede/plugins/*.jar ganymede.jars/plugins
#revert to .jar instead of .jar.pack.gz for selected plugins
for x in com.ibm.icu org.eclipse.ocl.doc org.eclipse.rap.ui.intro org.eclipse.uml2.doc ; do
  rm ganymede/plugins/${x}*.jar.pack.gz
  mv ganymede.jars/plugins/${x}*.jar ganymede/plugins/
done
##fi ##</mirroring>
#fix pack200 and digest settings
sed -e 's,<site>,<site pack200="true" digestURL=".">,g' "${curdir}/ganymede/site.xml" > xx
if diff xx "${curdir}/ganymede/site.xml" ; then
  echo "site.xml already ok, no need to patch"
  rm xx
else
  echo "patching site.xml for pack200 and digestURL"
  mv -f xx "${curdir}/ganymede/site.xml"
fi
#fix digest: see https://bugs.eclipse.org/bugs/show_bug.cgi?id=221993
unzip "${curdir}/ganymede/digest.zip" > /dev/null
sed -e 's,"search," search,g' digest.xml > xx
if diff xx digest.xml > /dev/null ; then
  echo "digest.zip already ok, no need to patch"
  rm xx
else
  echo "patching invalid digest.zip"
  mv -f xx digest.xml
  rm "${curdir}/ganymede/digest.zip"
  zip "${curdir}/ganymede/digest.zip" digest.xml
fi
rm digest.xml

echo "---> Total size (.pack.gz only except 4 plugins)"
du -k ganymede
cd ganymede
DATE=`date +'%Y%m%d'`
#zip -r ../ganymede_${DATE}.zip .
cd ..
