/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.dialogs;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.files.ui.view.SystemRemoteFileSelectionInputProvider;
import org.eclipse.rse.internal.subsystems.files.core.SystemFileResources;
import org.eclipse.rse.ui.SystemActionViewerFilter;
import org.eclipse.rse.ui.dialogs.SystemRemoteResourceDialog;
import org.eclipse.rse.ui.view.ISystemResourceSelectionInputProvider;
import org.eclipse.rse.ui.view.ISystemTree;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SystemRemoteFileDialog
extends SystemRemoteResourceDialog {
    public SystemRemoteFileDialog(Shell shell, String title, IHost defaultConnection) {
        super(shell, title, (ISystemResourceSelectionInputProvider)new SystemRemoteFileSelectionInputProvider(defaultConnection));
    }

    public SystemRemoteFileDialog(Shell shell, String title) {
        super(shell, title, (ISystemResourceSelectionInputProvider)new SystemRemoteFileSelectionInputProvider());
    }

    public SystemRemoteFileDialog(Shell shell) {
        super(shell, SystemFileResources.RESID_SELECTFILE_TITLE, (ISystemResourceSelectionInputProvider)new SystemRemoteFileSelectionInputProvider());
    }

    public String getVerbiage() {
        return SystemFileResources.RESID_SELECTFILE_VERBIAGE;
    }

    public String getTreeTip() {
        return SystemFileResources.RESID_SELECTFILE_SELECT_TOOLTIP;
    }

    public SystemActionViewerFilter getViewerFilter() {
        return null;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getSystemTree().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SystemRemoteFileDialog.this.handleDoubleClick(event);
            }
        });
        return control;
    }

    protected void handleDoubleClick(DoubleClickEvent event) {
        ISystemTree tree = this.getSystemTree();
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if (element == null) {
            return;
        }
        if (this.isPageComplete() && !tree.isExpandable(element)) {
            this.setReturnCode(0);
            if (this.processOK()) {
                this.okPressed = true;
                this.close();
            }
        }
    }
}

