/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests.core;

import java.util.Properties;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.tests.core.connection.IRSEConnectionProperties;
import org.eclipse.rse.tests.core.connection.RSEBaseConnectionTestCase;

public class HostCopyTest
extends RSEBaseConnectionTestCase {
    private IHost host = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.createHosts();
    }

    protected void tearDown() throws Exception {
        this.deleteHosts();
        super.tearDown();
    }

    public void testCopy() {
        if (this.isTestDisabled()) {
            return;
        }
        String setName = "Test Property Set Level 1";
        String propertyName = "Test Property Level 1";
        String propertyValue = "Level 1";
        IPropertySet ps = this.host.createPropertySet(setName);
        HostCopyTest.assertNotNull((String)("Failed to create property set " + setName), (Object)ps);
        IProperty p = ps.addProperty(propertyName, propertyValue);
        HostCopyTest.assertNotNull((String)("Failed to create property " + propertyName), (Object)p);
        HostCopyTest.assertEquals((String)("Failed to set value for property " + propertyName), (String)propertyValue, (String)p.getValue());
        String setName2 = "Test Property Set Level 2";
        String propertyName2 = "Test Property Level 2";
        String propertyValue2 = "Level 2";
        ps = ps.createPropertySet(setName2);
        HostCopyTest.assertNotNull((String)("Failed to create property set " + setName2), (Object)ps);
        p = ps.addProperty(propertyName2, propertyValue2);
        HostCopyTest.assertNotNull((String)("Failed to create property " + propertyName2), (Object)p);
        HostCopyTest.assertEquals((String)("Failed to set value for property " + propertyName2), (String)propertyValue2, (String)p.getValue());
        String name = this.host.getAliasName();
        String copyName = String.valueOf(name) + "Copy";
        IHost copy = this.getConnectionManager().copyConnection(this.host, copyName);
        HostCopyTest.assertNotNull((String)("Failed to copy connection " + name), (Object)copy);
        ps = copy.getPropertySet(setName);
        HostCopyTest.assertNotNull((String)("Failed to copy property set " + setName), (Object)ps);
        p = ps.getProperty(propertyName);
        HostCopyTest.assertNotNull((String)("Failed to copy property " + propertyName), (Object)p);
        HostCopyTest.assertEquals((String)("Failed to copy value for property " + propertyName), (String)propertyValue, (String)p.getValue());
        ps = ps.getPropertySet(setName2);
        HostCopyTest.assertNotNull((String)("Failed to copy property set " + setName2), (Object)ps);
        p = ps.getProperty(propertyName2);
        HostCopyTest.assertNotNull((String)("Failed to copy property " + propertyName2), (Object)p);
        HostCopyTest.assertEquals((String)("Failed to copy value for property " + propertyName2), (String)propertyValue2, (String)p.getValue());
        this.getConnectionManager().removeConnection("TestProfile", copyName);
        this.host.removePropertySet(setName);
    }

    private void createHosts() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("profile_name", "TestProfile");
        properties.setProperty("address", "localhost");
        properties.setProperty("system_type_id", "org.eclipse.rse.systemtype.unix");
        properties.setProperty("userid", "userid");
        properties.setProperty("password", "password");
        IRSEConnectionProperties props = this.getConnectionManager().loadConnectionProperties(properties, false);
        String hostName = "TestHost";
        properties.setProperty("name", hostName);
        this.host = this.getConnectionManager().findOrCreateConnection(props);
        HostCopyTest.assertNotNull((String)("Failed to create connection " + props.getProperty("name")), (Object)this.host);
    }

    private void deleteHosts() {
        RSECorePlugin.getTheSystemRegistry().deleteHost(this.host);
    }
}

