/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.tests.framework.scripting;

import java.net.URL;
import java.text.MessageFormat;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.rse.internal.tests.framework.scripting.ConsoleContext;
import org.eclipse.rse.internal.tests.framework.scripting.ScriptTestCase;
import org.eclipse.rse.tests.framework.DelegatingTestSuiteHolder;
import org.osgi.framework.Bundle;

public class ScriptTestSuiteHolder
extends DelegatingTestSuiteHolder {
    private TestSuite suite;

    public TestSuite getTestSuite() {
        if (this.suite == null) {
            String folderName = this.getStringValue("folder");
            if (folderName != null) {
                String scriptName;
                if (!folderName.endsWith("/")) {
                    folderName = String.valueOf(folderName) + "/";
                }
                if ((scriptName = this.getStringValue("script")) == null) {
                    scriptName = "script.txt";
                }
                Bundle bundle = this.getBundle();
                URL resourceLocation = bundle.getEntry(folderName);
                ConsoleContext context = new ConsoleContext(System.out, resourceLocation);
                URL scriptLocation = context.getResourceURL(scriptName);
                ScriptTestCase test = new ScriptTestCase(context, scriptLocation);
                String title = MessageFormat.format("Script from folder {0}", folderName);
                this.suite = new TestSuite(title);
                this.suite.addTest((Test)test);
            } else {
                this.suite = new TestSuite("ERROR: Missing folder argument");
            }
        }
        return this.suite;
    }
}

