/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.serial;

import gnu.io.CommPortOwnershipListener;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.serial.SerialConnector;
import org.eclipse.tm.internal.terminal.serial.SerialMessages;

public class SerialPortHandler
implements SerialPortEventListener,
CommPortOwnershipListener {
    private final ITerminalControl fControl;
    private final SerialConnector fConn;
    protected byte[] bytes = new byte[2048];

    public SerialPortHandler(SerialConnector conn, ITerminalControl control) {
        this.fControl = control;
        this.fConn = conn;
    }

    public void onSerialDataAvailable(Object data) {
        try {
            while (this.fConn.getInputStream() != null && this.fConn.getInputStream().available() > 0) {
                int nBytes = this.fConn.getInputStream().read(this.bytes);
                this.fControl.getRemoteToTerminalOutputStream().write(this.bytes, 0, nBytes);
            }
        }
        catch (IOException ex) {
            this.fControl.displayTextInTerminal(ex.getMessage());
        }
        catch (Exception exception) {
            Logger.logException((Exception)exception);
        }
    }

    public void onSerialOwnershipRequested(Object data) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] elems = e.getStackTrace();
            final String requester = elems[elems.length - 4].getClassName();
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    SerialPortHandler.this.fConn.disconnect();
                    String req = requester;
                    String myPackage = this.getClass().getPackage().getName();
                    if (req.startsWith(myPackage)) {
                        req = SerialMessages.ANOTHER_TERMINAL;
                    }
                    SerialPortHandler.this.fControl.displayTextInTerminal(NLS.bind((String)SerialMessages.OWNERSHIP_GRANTED, (Object)req));
                }
            });
            this.fConn.disconnect();
            return;
        }
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 1: {
                this.onSerialDataAvailable(null);
            }
        }
    }

    public void ownershipChange(int nType) {
        switch (nType) {
            case 3: {
                this.onSerialOwnershipRequested(null);
            }
        }
    }
}

