/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.local;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.tm.internal.terminal.local.ILocalTerminalSettings;
import org.eclipse.tm.internal.terminal.local.LocalTerminalUtilities;
import org.eclipse.tm.internal.terminal.local.process.LocalTerminalProcess;

public class LocalTerminalOutputStream
extends OutputStream {
    private static final String NOTHING = "";
    private static final String CRLF = "\r\n";
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char CTRL_C = '\u0003';
    private static final int TERMINAL_SENDS_CR = 0;
    private static final int TERMINAL_SENDS_CRLF = 1;
    private static final int PROGRAM_EXPECTS_LF = 0;
    private static final int PROGRAM_EXPECTS_CRLF = 1;
    private static final int PROGRAM_EXPECTS_CR = 2;
    private static final int NO_CHANGE = 0;
    private static final int CHANGE_CR_TO_LF = 1;
    private static final int INSERT_LF_AFTER_CR = 2;
    private static final int REMOVE_CR = 3;
    private static final int REMOVE_LF = 4;
    private static final int[][] CRLF_REPLACEMENT;
    private final boolean sendSIGINTOnCtrlC;
    private IStreamsProxy streamsProxy;
    private IProcess process;
    private int replacement;

    static {
        int[][] nArrayArray = new int[2][];
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 3;
        nArray2[2] = 4;
        nArrayArray[1] = nArray2;
        CRLF_REPLACEMENT = nArrayArray;
    }

    public LocalTerminalOutputStream(IProcess process, ILocalTerminalSettings settings) {
        this.process = process;
        this.streamsProxy = process.getStreamsProxy();
        this.sendSIGINTOnCtrlC = LocalTerminalUtilities.getCtrlC(settings);
        boolean localEcho = LocalTerminalUtilities.getLocalEcho(settings);
        int terminalSends = localEcho ? 1 : 0;
        String lineSeparator = LocalTerminalUtilities.getLineSeparator(settings);
        int programExpects = lineSeparator == null ? ("\r".equals(lineSeparator = System.getProperty("line.separator")) ? 2 : ("\n".equals(lineSeparator) ? 0 : 1)) : (lineSeparator.equals("\\n") ? 0 : (lineSeparator.equals("\\r") ? 2 : 1));
        this.replacement = CRLF_REPLACEMENT[terminalSends][programExpects];
    }

    public void write(int data) throws IOException {
        this.write(new byte[]{(byte)data}, 0, 1);
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        String text = new String(data, offset, length);
        if (this.replacement == 1) {
            text = text.replace('\r', '\n');
        } else if (this.replacement == 2) {
            text = text.replaceAll("\\r", CRLF);
        } else if (this.replacement == 3) {
            text = text.replaceAll("\\r", NOTHING);
        } else if (this.replacement == 4) {
            text = text.replaceAll("\\n", NOTHING);
        }
        int positionOfCtrlC = -1;
        while (this.sendSIGINTOnCtrlC && (positionOfCtrlC = text.indexOf(3)) != -1) {
            this.streamsProxy.write(text.substring(0, positionOfCtrlC + 1));
            if (this.process instanceof LocalTerminalProcess) {
                ((LocalTerminalProcess)this.process).interrupt();
            }
            text = text.substring(positionOfCtrlC + 1);
        }
        if (text.length() > 0) {
            this.streamsProxy.write(text);
        }
    }
}

