/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.contribution.visualiser;

import org.eclipse.contribution.visualiser.VisualiserUpdateJob;
import org.eclipse.contribution.visualiser.core.ProviderManager;
import org.eclipse.contribution.visualiser.internal.preference.VisualiserPreferences;
import org.eclipse.contribution.visualiser.views.Menu;
import org.eclipse.contribution.visualiser.views.Visualiser;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class VisualiserPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.contribution.visualiser";
    public static int LOGLEVEL = 0;
    public static Visualiser visualiser;
    public static Menu menu;
    private static VisualiserPlugin plugin;

    public VisualiserPlugin() {
        plugin = this;
    }

    public static ProviderManager getProviderManager() {
        return ProviderManager.getProviderManager();
    }

    public static void refresh() {
        if (visualiser != null && visualiser.getSite() != null) {
            if (visualiser.getSite().getPage().isPartVisible((IWorkbenchPart)visualiser)) {
                VisualiserUpdateJob.getInstance().schedule();
            } else {
                visualiser.setNeedsUpdating();
            }
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return VisualiserPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static VisualiserPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void setVisualiser(Visualiser visualiser) {
        VisualiserPlugin.visualiser = visualiser;
        VisualiserPlugin.visualiser.setVisContentProvider(ProviderManager.getContentProvider());
        VisualiserPlugin.visualiser.setVisMarkupProvider(ProviderManager.getMarkupProvider());
        ProviderManager.getContentProvider().activate();
        if (menu != null) {
            VisualiserPlugin.refresh();
        }
    }

    public void removeVisualiser() {
        visualiser = null;
    }

    public void setMenu(Menu menu) {
        VisualiserPlugin.menu = menu;
        VisualiserPlugin.menu.setVisMarkupProvider(ProviderManager.getMarkupProvider());
        ProviderManager.getMarkupProvider().activate();
        if (visualiser != null) {
            VisualiserPlugin.refresh();
        }
    }

    public void removeMenu() {
        menu = null;
    }

    public static void log(int logLevel, String message) {
        if (logLevel <= LOGLEVEL) {
            System.err.println(message);
            VisualiserPlugin.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, 0, message, null));
        }
    }

    public static void logException(Throwable e) {
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PLUGIN_ID, 0, message, e);
        }
        VisualiserPlugin.getDefault().getLog().log(status);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ProviderManager.initialise();
        VisualiserPreferences.initDefaults();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }
}

