/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.search;

import org.aspectj.org.eclipse.jdt.core.IClasspathEntry;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IJavaModel;
import org.aspectj.org.eclipse.jdt.core.IJavaProject;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.search.IJavaSearchScope;
import org.aspectj.org.eclipse.jdt.core.search.SearchPattern;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.aspectj.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.JavaModelManager;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.aspectj.org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.core.runtime.IPath;

public class IndexSelector {
    IJavaSearchScope searchScope;
    SearchPattern pattern;
    IPath[] indexLocations;

    public IndexSelector(IJavaSearchScope searchScope, SearchPattern pattern) {
        this.searchScope = searchScope;
        this.pattern = pattern;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IJavaElement focus, boolean isPolymorphicSearch, IPath projectOrJarPath) {
        try {
            IJavaModel model;
            IJavaProject project;
            IClasspathEntry[] focusEntries = null;
            if (isPolymorphicSearch) {
                JavaProject focusProject = focus instanceof JarPackageFragmentRoot ? (JavaProject)focus.getParent() : (JavaProject)focus;
                focusEntries = focusProject.getExpandedClasspath();
            }
            if ((project = IndexSelector.getJavaProject(projectOrJarPath, model = focus.getJavaModel())) != null) {
                return IndexSelector.canSeeFocus(focus, (JavaProject)project, focusEntries);
            }
            IJavaProject[] allProjects = model.getJavaProjects();
            int i = 0;
            int length = allProjects.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                JavaProject otherProject = (JavaProject)allProjects[i];
                IClasspathEntry entry = otherProject.getClasspathEntryFor(projectOrJarPath);
                if (entry != null && entry.getEntryKind() == 1 && IndexSelector.canSeeFocus(focus, otherProject, focusEntries)) {
                    return true;
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean canSeeFocus(IJavaElement focus, JavaProject javaProject, IClasspathEntry[] focusEntriesForPolymorphicSearch) {
        try {
            int i;
            IPath focusPath;
            if (focus.equals(javaProject)) {
                return true;
            }
            if (focusEntriesForPolymorphicSearch != null) {
                IPath projectPath = javaProject.getProject().getFullPath();
                int i2 = 0;
                int length = focusEntriesForPolymorphicSearch.length;
                while (i2 < length) {
                    IClasspathEntry entry = focusEntriesForPolymorphicSearch[i2];
                    if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)projectPath)) {
                        return true;
                    }
                    ++i2;
                }
            }
            if (focus instanceof JarPackageFragmentRoot) {
                focusPath = focus.getPath();
                IClasspathEntry[] entries = javaProject.getExpandedClasspath();
                i = 0;
                int length = entries.length;
                while (i < length) {
                    IClasspathEntry entry = entries[i];
                    if (entry.getEntryKind() == 1 && entry.getPath().equals((Object)focusPath)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            focusPath = ((JavaProject)focus).getProject().getFullPath();
            IClasspathEntry[] entries = javaProject.getExpandedClasspath();
            i = 0;
            int length = entries.length;
            while (i < length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)focusPath)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initializeIndexLocations() {
        projectsAndJars = this.searchScope.enclosingProjectsAndJars();
        manager = JavaModelManager.getJavaModelManager().getIndexManager();
        locations = new SimpleSet();
        focus = MatchLocator.projectOrJarFocus(this.pattern);
        if (focus == null) {
            i = 0;
            while (i < projectsAndJars.length) {
                locations.add(manager.computeIndexLocation(projectsAndJars[i]));
                ++i;
            }
        } else {
            try {
                length = projectsAndJars.length;
                projectsCanSeeFocus = new JavaProject[length];
                visitedProjects = new SimpleSet(length);
                projectIndex = 0;
                jarsToCheck = new SimpleSet(length);
                focusEntries = null;
                if (this.pattern instanceof MethodPattern) {
                    focusProject = focus instanceof JarPackageFragmentRoot != false ? (JavaProject)focus.getParent() : (JavaProject)focus;
                    focusEntries = focusProject.getExpandedClasspath();
                }
                model = JavaModelManager.getJavaModelManager().getJavaModel();
                i = 0;
                while (i < length) {
                    path = projectsAndJars[i];
                    project = (JavaProject)IndexSelector.getJavaProject(path, model);
                    if (project != null) {
                        visitedProjects.add(project);
                        if (IndexSelector.canSeeFocus(focus, project, focusEntries)) {
                            locations.add(manager.computeIndexLocation(path));
                            projectsCanSeeFocus[projectIndex++] = project;
                        }
                    } else {
                        jarsToCheck.add(path);
                    }
                    ++i;
                }
                i = 0;
                while (i < projectIndex && jarsToCheck.elementSize > 0) {
                    entries = projectsCanSeeFocus[i].getResolvedClasspath();
                    j = entries.length;
                    while (--j >= 0) {
                        entry = entries[j];
                        if (entry.getEntryKind() != 1 || !jarsToCheck.includes(path = entry.getPath())) continue;
                        locations.add(manager.computeIndexLocation(entry.getPath()));
                        jarsToCheck.remove(path);
                    }
                    ++i;
                }
                if (jarsToCheck.elementSize <= 0) ** GOTO lbl76
                allProjects = model.getJavaProjects();
                i = 0;
                l = allProjects.length;
                while (i < l && jarsToCheck.elementSize > 0) {
                    project = (JavaProject)allProjects[i];
                    if (!visitedProjects.includes(project)) {
                        entries = project.getResolvedClasspath();
                        j = entries.length;
                        while (--j >= 0) {
                            entry = entries[j];
                            if (entry.getEntryKind() != 1 || !jarsToCheck.includes(path = entry.getPath())) continue;
                            locations.add(manager.computeIndexLocation(entry.getPath()));
                            jarsToCheck.remove(path);
                        }
                    }
                    ++i;
                }
            }
            catch (JavaModelException length) {
                // empty catch block
            }
        }
lbl76:
        // 4 sources

        this.indexLocations = new IPath[locations.elementSize];
        values = locations.values;
        count = 0;
        i = values.length;
        while (--i >= 0) {
            if (values[i] == null) continue;
            this.indexLocations[count++] = (IPath)values[i];
        }
    }

    public IPath[] getIndexLocations() {
        if (this.indexLocations == null) {
            this.initializeIndexLocations();
        }
        return this.indexLocations;
    }

    private static IJavaProject getJavaProject(IPath path, IJavaModel model) {
        IJavaProject project = model.getJavaProject(path.lastSegment());
        if (project.exists()) {
            return project;
        }
        return null;
    }
}

