/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.buildpath;

import org.eclipse.ajdt.core.AspectJCorePreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AJBuildPathAction {
    protected IFile jarFile;
    protected String fileName;
    protected IClasspathEntry cpEntry;
    protected IProject project;

    private static IFile getCandidate(IAdaptable element) throws JavaModelException {
        IResource resource = (IResource)element.getAdapter(IResource.class);
        if (!(resource instanceof IFile) || !ArchiveFileFilter.isArchivePath((IPath)resource.getFullPath(), (boolean)true)) {
            return null;
        }
        IJavaProject project = JavaCore.create((IProject)resource.getProject());
        if (project != null && project.exists() && project.findPackageFragmentRoot(resource.getFullPath()) == null) {
            return (IFile)resource;
        }
        return null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    protected static IFile getJARFile(IStructuredSelection selection) throws JavaModelException {
        IFile file;
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof IAdaptable && (file = AJBuildPathAction.getCandidate((IAdaptable)element)) != null) {
            return file;
        }
        return null;
    }

    protected boolean checkIfAddingOutjar(IProject project) {
        String inpath = this.jarFile.getFullPath().toPortableString();
        String outJar = AspectJCorePreferences.getProjectOutJar((IProject)project);
        return outJar.length() > 0 && inpath.indexOf(outJar) != -1;
    }

    protected boolean shouldAskForClasspathRestrictions(IClasspathEntry entry) {
        return entry.getEntryKind() == 5;
    }

    protected String askForClasspathRestrictions(IClasspathEntry entry, String jarName, String pathKind) {
        String message = "Do you want to add a restriction to the " + pathKind + "?\n" + "Currently, you are adding " + entry.getPath() + " to the " + pathKind + ".\n" + "By adding a restriction, you can restrict elements on the " + pathKind + "\n" + "in this entry to those whose names match the restriction path\n\n" + "You may add a comma separated list of entries.";
        InputDialog dialog = new InputDialog(null, "Add Classpath restriction?", message, jarName, (IInputValidator)new JarListValidator());
        int res = dialog.open();
        if (res == 0) {
            return dialog.getValue();
        }
        return null;
    }

    private class JarListValidator
    implements IInputValidator {
        private JarListValidator() {
        }

        public String isValid(String newText) {
            if (newText.length() == 0) {
                return null;
            }
            String[] splits = newText.split(",");
            int i = 0;
            while (i < splits.length) {
                String val = splits[i];
                if ((val = val.trim()).length() == 0) {
                    return "Invalid jar fragment name";
                }
                char[] array = val.toCharArray();
                int j = 0;
                while (j < array.length) {
                    if (!Character.isUnicodeIdentifierPart(array[j]) && array[j] != '.' && array[j] != '-') {
                        return "'" + array[j] + "' not allowed.";
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }
    }
}

