/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.ast.AjMethodDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AtAspectJAnnotationFactory;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.InterSuperFixerVisitor;
import org.aspectj.ajdt.internal.compiler.ast.SuperFixerVisitor;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeScope;
import org.aspectj.ajdt.internal.core.builder.EclipseSourceContext;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.bridge.context.ContextToken;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.Shadow;

public abstract class InterTypeDeclaration
extends AjMethodDeclaration {
    protected TypeReference onType;
    protected ReferenceBinding onTypeBinding;
    protected ResolvedTypeMunger munger;
    public int declaredModifiers;
    protected char[] declaredSelector;
    protected List typeVariableAliases;
    protected InterTypeScope interTypeScope;
    private boolean scopeSetup = false;
    private static final short ACC_ANNOTATION = 8192;
    private static final short ACC_ENUM = 16384;

    public InterTypeDeclaration(CompilationResult result, TypeReference onType) {
        super(result);
        this.setOnType(onType);
        this.modifiers = 9;
    }

    public void setOnType(TypeReference onType) {
        this.onType = onType;
        this.determineTypeVariableAliases();
    }

    public void setDeclaredModifiers(int modifiers) {
        this.declaredModifiers = modifiers;
    }

    public void setSelector(char[] selector) {
        this.declaredSelector = selector;
        this.selector = CharOperation.concat(selector, Integer.toHexString(this.sourceStart).toCharArray());
        this.selector = CharOperation.concat(this.getPrefix(), this.selector);
    }

    protected abstract char[] getPrefix();

    public void addAtAspectJAnnotations() {
        if (this.munger == null) {
            return;
        }
        Annotation ann = AtAspectJAnnotationFactory.createITDAnnotation(this.munger.getSignature().getDeclaringType().getName().toCharArray(), this.declaredModifiers, this.declaredSelector, this.declarationSourceStart);
        AtAspectJAnnotationFactory.addAnnotation(this, ann, this.scope);
    }

    public boolean isTargetAnnotation(ClassScope classScope, String kind) {
        if ((this.onTypeBinding.getAccessFlags() & 0x2000) != 0) {
            classScope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "can't make inter-type " + kind + " declarations on annotation types.");
            this.ignoreFurtherInvestigation = true;
            return true;
        }
        return false;
    }

    public boolean isTargetEnum(ClassScope classScope, String kind) {
        if ((this.onTypeBinding.getAccessFlags() & 0x4000) != 0) {
            classScope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "can't make inter-type " + kind + " declarations on enum types.");
            this.ignoreFurtherInvestigation = true;
            return true;
        }
        return false;
    }

    public void resolve(ClassScope upperScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (!this.scopeSetup) {
            this.interTypeScope = new InterTypeScope(upperScope, this.onTypeBinding, this.typeVariableAliases);
            this.scope.parent = this.interTypeScope;
            this.scope.isStatic = Modifier.isStatic(this.declaredModifiers);
            this.scopeSetup = true;
        }
        this.fixSuperCallsForInterfaceContext(upperScope);
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        super.resolve((ClassScope)this.scope.parent);
        this.fixSuperCallsInBody();
    }

    private void fixSuperCallsForInterfaceContext(ClassScope scope) {
        if (this.onTypeBinding.isInterface()) {
            ContextToken tok = CompilationAndWeavingContext.enteringPhase((int)20, (Object)this.selector);
            InterSuperFixerVisitor v = new InterSuperFixerVisitor(this, EclipseFactory.fromScopeLookupEnvironment(scope), scope);
            this.traverse((ASTVisitor)v, scope);
            CompilationAndWeavingContext.leavingPhase((ContextToken)tok);
        }
    }

    public abstract EclipseTypeMunger build(ClassScope var1);

    public void fixSuperCallsInBody() {
        ContextToken tok = CompilationAndWeavingContext.enteringPhase((int)19, (Object)this.selector);
        SuperFixerVisitor v = new SuperFixerVisitor(this, this.onTypeBinding);
        this.traverse((ASTVisitor)v, (ClassScope)null);
        this.munger.setSuperMethodsCalled(v.superMethodsCalled);
        CompilationAndWeavingContext.leavingPhase((ContextToken)tok);
    }

    protected void resolveOnType(ClassScope classScope) {
        this.checkSpec();
        if (this.onType == null) {
            return;
        }
        if (this.onType instanceof ParameterizedSingleTypeReference || this.onType instanceof ParameterizedQualifiedTypeReference) {
            this.resolveTypeParametersForITDOnGenericType(classScope);
        } else {
            ParameterizedTypeBinding ptb;
            this.onTypeBinding = (ReferenceBinding)this.onType.getTypeBindingPublic(classScope);
            if (!this.onTypeBinding.isValidBinding()) {
                classScope.problemReporter().invalidType(this.onType, this.onTypeBinding);
                this.ignoreFurtherInvestigation = true;
            }
            if (this.onTypeBinding.isParameterizedType() && (ptb = (ParameterizedTypeBinding)this.onTypeBinding).isNestedType() && (ptb.typeVariables() == null || ptb.typeVariables().length == 0) && ptb.enclosingType().isRawType()) {
                this.onTypeBinding = ptb.type;
            }
        }
    }

    private void resolveTypeParametersForITDOnGenericType(ClassScope classScope) {
        int aliasCount;
        long pos;
        TypeReference pref;
        if (this.onType instanceof ParameterizedSingleTypeReference) {
            pref = (ParameterizedSingleTypeReference)this.onType;
            pos = (long)pref.sourceStart << 32 | (long)pref.sourceEnd;
            this.onType = new SingleTypeReference(pref.token, pos);
        } else {
            pref = (ParameterizedQualifiedTypeReference)this.onType;
            pos = (long)pref.sourceStart << 32 | (long)pref.sourceEnd;
            this.onType = new QualifiedTypeReference(((QualifiedTypeReference)pref).tokens, new long[]{pos});
        }
        this.onTypeBinding = (ReferenceBinding)this.onType.getTypeBindingPublic(classScope);
        if (!this.onTypeBinding.isValidBinding()) {
            classScope.problemReporter().invalidType(this.onType, this.onTypeBinding);
            this.ignoreFurtherInvestigation = true;
        }
        if (this.onTypeBinding.isRawType()) {
            this.onTypeBinding = ((RawTypeBinding)this.onTypeBinding).type;
        }
        int n = aliasCount = this.typeVariableAliases == null ? 0 : this.typeVariableAliases.size();
        if (aliasCount != 0 && !this.onTypeBinding.isGenericType()) {
            this.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "Type parameters can not be specified in the ITD target type - the target type " + this.onTypeBinding.debugName() + " is not generic.");
            this.ignoreFurtherInvestigation = true;
            return;
        }
        if (aliasCount > 0 && this.onTypeBinding.typeVariables().length != aliasCount) {
            this.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "Incorrect number of type parameters supplied.  The generic type " + this.onTypeBinding.debugName() + " has " + this.onTypeBinding.typeVariables().length + " type parameters, not " + aliasCount + ".");
            this.ignoreFurtherInvestigation = true;
            return;
        }
        if (aliasCount > 0) {
            for (int i = 0; i < aliasCount; ++i) {
                String array_element = (String)this.typeVariableAliases.get(i);
                SingleTypeReference str = new SingleTypeReference(array_element.toCharArray(), 0L);
                TypeBinding tb = str.getTypeBindingPublic(classScope);
                if (tb == null || tb instanceof ProblemReferenceBinding) continue;
                this.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "Intertype declarations can only be made on the generic type, not on a parameterized type. The name '" + array_element + "' cannot be used as a type parameter, since it refers to a real type.");
                this.ignoreFurtherInvestigation = true;
                return;
            }
        }
    }

    protected void checkSpec() {
        if (Modifier.isProtected(this.declaredModifiers)) {
            this.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "protected inter-type declarations are not allowed");
            this.ignoreFurtherInvestigation = true;
        }
    }

    protected List makeEffectiveSignatureAttribute(ResolvedMember sig, Shadow.Kind kind, boolean weaveBody) {
        ArrayList<EclipseAttributeAdapter> l = new ArrayList<EclipseAttributeAdapter>(1);
        l.add(new EclipseAttributeAdapter((AjAttribute)new AjAttribute.EffectiveSignatureAttribute(sig, kind, weaveBody)));
        return l;
    }

    protected void setMunger(ResolvedTypeMunger munger) {
        munger.getSignature().setPosition(this.sourceStart, this.sourceEnd);
        munger.getSignature().setSourceContext((ISourceContext)new EclipseSourceContext(this.compilationResult));
        this.munger = munger;
    }

    protected int generateInfoAttributes(ClassFile classFile) {
        Shadow.Kind kind = this.getShadowKindForBody();
        List l = kind != null ? this.makeEffectiveSignatureAttribute(this.munger.getSignature(), kind, true) : new ArrayList(0);
        this.addDeclarationStartLineAttribute(l, classFile);
        return classFile.generateMethodInfoAttribute(this.binding, false, l);
    }

    protected abstract Shadow.Kind getShadowKindForBody();

    public ResolvedMember getSignature() {
        if (this.munger == null) {
            return null;
        }
        return this.munger.getSignature();
    }

    public char[] getDeclaredSelector() {
        return this.declaredSelector;
    }

    public TypeReference getOnType() {
        return this.onType;
    }

    public void determineTypeVariableAliases() {
        block3: {
            block4: {
                if (this.onType == null) break block3;
                if (!(this.onType instanceof ParameterizedSingleTypeReference)) break block4;
                ParameterizedSingleTypeReference paramRef = (ParameterizedSingleTypeReference)this.onType;
                TypeReference[] rb = paramRef.typeArguments;
                this.typeVariableAliases = new ArrayList();
                for (int i = 0; i < rb.length; ++i) {
                    this.typeVariableAliases.add(CharOperation.toString(rb[i].getTypeName()));
                }
                break block3;
            }
            if (!(this.onType instanceof ParameterizedQualifiedTypeReference)) break block3;
            ParameterizedQualifiedTypeReference paramRef = (ParameterizedQualifiedTypeReference)this.onType;
            this.typeVariableAliases = new ArrayList();
            for (int j = 0; j < paramRef.typeArguments.length; ++j) {
                TypeReference[] rb = paramRef.typeArguments[j];
                for (int i = 0; rb != null && i < rb.length; ++i) {
                    this.typeVariableAliases.add(CharOperation.toString(rb[i].getTypeName()));
                }
            }
        }
    }

    public void ensureScopeSetup() {
        TypeReference pref;
        if (this.scopeSetup) {
            return;
        }
        MethodScope scope = this.scope;
        TypeReference ot = this.onType;
        TypeBinding rb = null;
        if (ot instanceof ParameterizedQualifiedTypeReference) {
            pref = (ParameterizedQualifiedTypeReference)ot;
            if (pref.typeArguments != null && pref.typeArguments.length != 0) {
                boolean usingNonTypeVariableInITD = false;
                for (int i = 0; i < pref.typeArguments.length; ++i) {
                    TypeReference[] refs = pref.typeArguments[i];
                    for (int j = 0; refs != null && j < refs.length; ++j) {
                        TypeBinding tb = refs[j].getTypeBindingPublic(scope.parent);
                        if (tb.isTypeVariable() || tb instanceof ProblemReferenceBinding) continue;
                        usingNonTypeVariableInITD = true;
                    }
                }
                if (usingNonTypeVariableInITD) {
                    scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "Cannot make inter-type declarations on parameterized types");
                    this.arguments = null;
                    this.returnType = new SingleTypeReference(TypeConstants.VOID, 0L);
                    this.ignoreFurtherInvestigation = true;
                    ReferenceBinding closestMatch = null;
                    rb = new ProblemReferenceBinding(ot.getParameterizedTypeName(), closestMatch, 0);
                    this.onType = null;
                }
            }
        }
        if (ot instanceof ParameterizedSingleTypeReference) {
            pref = (ParameterizedSingleTypeReference)ot;
            long pos = (long)pref.sourceStart << 32 | (long)pref.sourceEnd;
            ot = new SingleTypeReference(((SingleTypeReference)pref).token, pos);
        } else if (ot instanceof ParameterizedQualifiedTypeReference) {
            pref = (ParameterizedQualifiedTypeReference)ot;
            long pos = (long)pref.sourceStart << 32 | (long)pref.sourceEnd;
            ot = new QualifiedTypeReference(pref.tokens, new long[]{pos});
        }
        if (rb == null) {
            rb = (ReferenceBinding)ot.getTypeBindingPublic(scope.parent);
        }
        if (rb.isRawType() && rb.isMemberType()) {
            rb = ((RawTypeBinding)rb).type;
        }
        if (rb instanceof TypeVariableBinding) {
            scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "Cannot make inter-type declarations on type variables, use an interface and declare parents");
            this.arguments = null;
            this.returnType = new SingleTypeReference(TypeConstants.VOID, 0L);
            this.ignoreFurtherInvestigation = true;
            ReferenceBinding closestMatch = null;
            if (((TypeVariableBinding)rb).firstBound != null) {
                closestMatch = ((TypeVariableBinding)rb).firstBound.enclosingType();
            }
            rb = new ProblemReferenceBinding(((ReferenceBinding)rb).compoundName, closestMatch, 0);
        }
        if (rb instanceof ProblemReferenceBinding) {
            return;
        }
        this.interTypeScope = new InterTypeScope(scope.parent, (ReferenceBinding)rb, this.typeVariableAliases);
        scope.isStatic = this.typeVariableAliases != null ? false : Modifier.isStatic(this.declaredModifiers);
        scope.parent = this.interTypeScope;
        this.scopeSetup = true;
    }
}

