/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.exports;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.internal.core.exports.FeatureExportOperation;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public abstract class FeatureBasedExportOperation
extends FeatureExportOperation {
    protected String fFeatureLocation;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    public FeatureBasedExportOperation(FeatureExportInfo info, String name) {
        super(info, name);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus run(IProgressMonitor monitor) {
        try {
            this.createDestination();
            monitor.beginTask("Exporting...", 33);
            featureID = "org.eclipse.pde.container.feature";
            this.fFeatureLocation = String.valueOf(this.fBuildTempLocation) + File.separator + featureID;
            config = new String[][]{{TargetPlatform.getOS(), TargetPlatform.getWS(), TargetPlatform.getOSArch(), TargetPlatform.getNL()}};
            this.createFeature(featureID, this.fFeatureLocation, config, false);
            this.createBuildPropertiesFile(this.fFeatureLocation);
            if (this.fInfo.useJarFormat) {
                this.createPostProcessingFiles();
            }
            status = this.testBuildWorkspaceBeforeExport((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            this.doExport(featureID, null, this.fFeatureLocation, config, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
            if (monitor.isCanceled()) {
                var6_5 = Status.CANCEL_STATUS;
                return var6_5;
            }
            var6_6 = status;
            return var6_6;
        }
        catch (IOException var11_24) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(var11_24, (Object)this, FeatureBasedExportOperation.ajc$tjp_3, (JoinPoint.StaticPart)FeatureBasedExportOperation.ajc$tjp_1);
            v0 = var11_24;
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(var12_25, (Object)this, FeatureBasedExportOperation.ajc$tjp_4, (JoinPoint.StaticPart)FeatureBasedExportOperation.ajc$tjp_1);
            e = var12_25;
            var6_7 = new Status(4, "org.eclipse.pde.core", PDECoreMessages.FeatureBasedExportOperation_ProblemDuringExport, e);
            return var6_7;
        }
        {
            catch (CoreException var15_28) {
                // empty catch block
            }
            {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(var15_28, (Object)this, FeatureBasedExportOperation.ajc$tjp_7, (JoinPoint.StaticPart)FeatureBasedExportOperation.ajc$tjp_1);
                e = var15_28;
                return e.getStatus();
            }
        }
        {
            catch (InvocationTargetException var18_31) {
                // empty catch block
            }
            {
                UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(var18_31, (Object)this, FeatureBasedExportOperation.ajc$tjp_10, (JoinPoint.StaticPart)FeatureBasedExportOperation.ajc$tjp_1);
                e = var18_31;
                return new Status(4, "org.eclipse.pde.core", PDECoreMessages.FeatureBasedExportOperation_ProblemDuringExport, e.getTargetException());
            }
        }
        finally {
            i = 0;
            ** while (i < this.fInfo.items.length)
        }
lbl-1000:
        // 1 sources

        {
            if (this.fInfo.items[i] instanceof IModel) {
                try {
                    this.deleteBuildFiles(this.fInfo.items[i]);
                }
                catch (CoreException var13_26) {
                    UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(var13_26, (Object)this, FeatureBasedExportOperation.ajc$tjp_5, (JoinPoint.StaticPart)FeatureBasedExportOperation.ajc$tjp_1);
                    e = var13_26;
                    PDECore.log((Throwable)e);
                }
            }
            ++i;
            continue;
        }
lbl48:
        // 1 sources

        this.cleanup(null, (IProgressMonitor)new SubProgressMonitor(monitor, 3));
        monitor.done();
        return var6_7;
    }

    protected abstract void createPostProcessingFiles();

    protected String[] getPaths() {
        String[] paths = super.getPaths();
        String[] all = new String[paths.length + 1];
        all[0] = String.valueOf(this.fFeatureLocation) + File.separator + "feature.xml";
        System.arraycopy(paths, 0, all, 1, paths.length);
        return all;
    }

    private void createBuildPropertiesFile(String featureLocation) {
        File file = new File(featureLocation);
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        Properties prop = new Properties();
        prop.put("pde", "marker");
        if (this.fInfo.exportSource && this.fInfo.exportSourceBundle) {
            prop.put("individualSourceBundles", "true");
            Hashtable<String, String> environment = new Hashtable<String, String>(4);
            ((Dictionary)environment).put("osgi.os", TargetPlatform.getOS());
            ((Dictionary)environment).put("osgi.ws", TargetPlatform.getWS());
            ((Dictionary)environment).put("osgi.arch", TargetPlatform.getOSArch());
            ((Dictionary)environment).put("osgi.nl", TargetPlatform.getNL());
            int i = 0;
            while (i < this.fInfo.items.length) {
                if (this.fInfo.items[i] instanceof IFeatureModel) {
                    IFeature feature = ((IFeatureModel)this.fInfo.items[i]).getFeature();
                    prop.put("generate.feature@" + feature.getId() + ".source", feature.getId());
                } else {
                    BundleDescription bundle = null;
                    if (this.fInfo.items[i] instanceof IPluginModelBase) {
                        bundle = ((IPluginModelBase)this.fInfo.items[i]).getBundleDescription();
                    }
                    if (bundle == null && this.fInfo.items[i] instanceof BundleDescription) {
                        bundle = (BundleDescription)this.fInfo.items[i];
                    }
                    if (bundle != null && this.shouldAddPlugin(bundle, environment)) {
                        prop.put("generate.plugin@" + bundle.getSymbolicName() + ".source", bundle.getSymbolicName());
                    }
                }
                ++i;
            }
        }
        this.save(new File(file, "build.properties"), prop, "Marker File");
    }

    static {
        Factory factory = new Factory("FeatureBasedExportOperation.java", Class.forName("org.eclipse.ajdt.internal.core.exports.FeatureBasedExportOperation"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.exports.FeatureBasedExportOperation", "org.eclipse.core.runtime.CoreException:", "e:"), 68);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.eclipse.ajdt.internal.core.exports.FeatureBasedExportOperation", "org.eclipse.core.runtime.IProgressMonitor:", "monitor:", "", "org.eclipse.core.runtime.IStatus"), 39);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.exports.FeatureBasedExportOperation", "java.lang.reflect.InvocationTargetException:", "e:"), 61);
        ajc$tjp_11 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.exports.FeatureBasedExportOperation", "org.eclipse.core.runtime.CoreException:", "e:"), 68);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.exports.FeatureBasedExportOperation", "org.eclipse.core.runtime.CoreException:", "e:"), 68);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.exports.FeatureBasedExportOperation", "org.eclipse.core.runtime.CoreException:", "e:"), 68);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.exports.FeatureBasedExportOperation", "java.io.IOException:", "e:"), 57);
        ajc$tjp_4 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.exports.FeatureBasedExportOperation", "java.io.IOException:", "e:"), 57);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.exports.FeatureBasedExportOperation", "org.eclipse.core.runtime.CoreException:", "e:"), 68);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.exports.FeatureBasedExportOperation", "org.eclipse.core.runtime.CoreException:", "e:"), 59);
        ajc$tjp_7 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.exports.FeatureBasedExportOperation", "org.eclipse.core.runtime.CoreException:", "e:"), 59);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.exports.FeatureBasedExportOperation", "org.eclipse.core.runtime.CoreException:", "e:"), 68);
        ajc$tjp_9 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.exports.FeatureBasedExportOperation", "java.lang.reflect.InvocationTargetException:", "e:"), 61);
    }
}

