/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.ui.ajde;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.AJLog;
import org.eclipse.ajdt.core.AspectJPlugin;
import org.eclipse.ajdt.core.builder.IAJCompilerMonitor;
import org.eclipse.ajdt.internal.ui.ajde.UIMessageHandler;
import org.eclipse.ajdt.internal.ui.ras.UIFFDC;
import org.eclipse.ajdt.internal.ui.text.UIMessages;
import org.eclipse.ajdt.ui.AspectJUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class UIBuildProgressMonitor
implements IAJCompilerMonitor {
    private UIMessageHandler messageHandler = null;
    private int currentAjdeProgress;
    public static boolean isLocalBuild;
    private IProject project;
    private boolean linked;
    private IProgressMonitor monitor = null;
    private boolean reportedCompiledMessages;
    private boolean reportedWovenMessages;
    private boolean buildWasCancelled = false;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;

    static {
        Factory factory = new Factory("UIBuildProgressMonitor.java", Class.forName("org.eclipse.ajdt.internal.ui.ajde.UIBuildProgressMonitor"));
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.ui.ajde.UIBuildProgressMonitor", "org.eclipse.core.runtime.CoreException:", "<missing>:"), 323);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "prepare", "org.eclipse.ajdt.internal.ui.ajde.UIBuildProgressMonitor", "org.eclipse.core.runtime.IProgressMonitor:", "eclipseMonitor:", "", "void"), 315);
        isLocalBuild = false;
    }

    public UIBuildProgressMonitor(IProject project) {
        this.project = project;
    }

    public synchronized void finish(boolean wasFullBuild) {
        AJLog.log((int)1, (String)("AJDE Callback: finish. Was full build: " + wasFullBuild));
        this.getMessageHandler().setLastBuildType(wasFullBuild);
        if (AspectJUIPlugin.getDefault().getDisplay().isDisposed()) {
            AJLog.log((String)"Not finishing with bpm, display is disposed!");
        } else {
            AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (UIBuildProgressMonitor.this.monitor != null) {
                        if (UIBuildProgressMonitor.this.monitor != null) {
                            UIBuildProgressMonitor.this.monitor.worked(100);
                        }
                        if (UIBuildProgressMonitor.this.monitor != null) {
                            UIBuildProgressMonitor.this.monitor.done();
                        }
                        UIBuildProgressMonitor.this.monitor = null;
                    }
                }
            });
        }
    }

    private UIMessageHandler getMessageHandler() {
        if (this.messageHandler == null) {
            this.messageHandler = (UIMessageHandler)AspectJPlugin.getDefault().getCompilerFactory().getCompilerForProject(this.project).getMessageHandler();
        }
        return this.messageHandler;
    }

    public boolean isCancelRequested() {
        this.buildWasCancelled = this.monitor != null ? this.monitor.isCanceled() : false;
        return this.buildWasCancelled;
    }

    public void setProgress(double percentDone) {
        if (percentDone >= (double)this.currentAjdeProgress) {
            this.incrementProgressBarVal("setProgress() delegating to ");
        }
    }

    private void incrementProgressBarVal(String caller) {
        ++this.currentAjdeProgress;
        if (this.monitor != null) {
            AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (UIBuildProgressMonitor.this.monitor != null) {
                        UIBuildProgressMonitor.this.monitor.worked(1);
                    }
                }
            });
        }
    }

    public void setProgressText(String text) {
        if (!this.reportedCompiledMessages && text.startsWith("compiled: ")) {
            this.reportedCompiledMessages = true;
            AJLog.logEnd((int)1, (String)"Time to first compiled message");
        }
        if (!this.reportedWovenMessages && text.startsWith("woven ")) {
            this.reportedWovenMessages = true;
            AJLog.logEnd((int)1, (String)"Time to first woven message");
        }
        if (text.startsWith("compiling source files")) {
            this.getMessageHandler().clearProblems();
        }
        if (text.startsWith("compiled: ") || text.startsWith("woven ")) {
            Path resourcePath = null;
            if (text.startsWith("compiled: ")) {
                resourcePath = new Path(text.substring(10));
            } else {
                int fromLoc = text.indexOf("from ");
                int endLoc = text.lastIndexOf(")");
                if (fromLoc != -1 && endLoc > fromLoc) {
                    resourcePath = new Path(text.substring(fromLoc + 5, endLoc));
                }
            }
            IWorkspaceRoot workspaceRoot = AspectJPlugin.getWorkspace().getRoot();
            if (this.linked) {
                IFile[] files = workspaceRoot.findFilesForLocation((IPath)resourcePath);
                int i = 0;
                while (i < files.length) {
                    if (files[i].getProject().equals((Object)this.project)) {
                        this.getMessageHandler().addAffectedResource((IResource)files[i]);
                    }
                    ++i;
                }
            } else {
                IFile file = this.project.getFile(resourcePath.makeRelativeTo(this.project.getLocation()));
                if (file == null) {
                    AJLog.log((int)1, (String)("Processing progress message: Can't find eclipse resource for file with path " + text));
                } else {
                    this.getMessageHandler().addAffectedResource((IResource)file);
                }
            }
        }
        final String amendedText = this.removePrefix(text);
        AJLog.log((int)4, (String)("AJC: " + text));
        if (this.monitor != null) {
            AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (UIBuildProgressMonitor.this.monitor != null) {
                        UIBuildProgressMonitor.this.monitor.subTask(amendedText);
                    }
                }
            });
        }
    }

    private String removePrefix(String msg) {
        int loc;
        String ret = msg;
        IProject p = this.project;
        if (p == null || p.getLocation() == null) {
            AJLog.log((String)("Could not find project location, " + p));
            return ret;
        }
        String projectLocation = String.valueOf(p.getLocation().toOSString()) + "\\";
        if (msg.indexOf(projectLocation) != -1) {
            ret = String.valueOf(msg.substring(0, msg.indexOf(projectLocation))) + msg.substring(msg.indexOf(projectLocation) + projectLocation.length());
        } else if (msg.indexOf(projectLocation = projectLocation.replace('\\', '/')) != -1) {
            ret = String.valueOf(msg.substring(0, msg.indexOf(projectLocation))) + msg.substring(msg.indexOf(projectLocation) + projectLocation.length());
        }
        if (ret.startsWith("might need to weave")) {
            ret = UIMessages.CompilerMonitor_weaving;
        }
        if (ret.startsWith("directory classpath entry does not exist: null")) {
            ret = "";
        }
        if (ret.startsWith("woven") && ret.indexOf("(from") != -1 && (loc = ret.indexOf("(from")) != -1) {
            String fromPiece = ret.substring(loc);
            int lastSlash = fromPiece.lastIndexOf("/");
            if (lastSlash == -1) {
                lastSlash = fromPiece.lastIndexOf("\\");
            }
            if (lastSlash != -1) {
                fromPiece = fromPiece.substring(lastSlash + 1);
                ret = String.valueOf(ret.substring(0, loc)) + " (" + fromPiece;
            } else {
                int space = fromPiece.indexOf(" ");
                if (space != -1) {
                    ret = String.valueOf(ret.substring(0, loc)) + " (" + fromPiece.substring(space + 1);
                }
            }
        }
        return ret;
    }

    public void begin() {
        this.currentAjdeProgress = 0;
        if (this.monitor != null) {
            AspectJUIPlugin.getDefault().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (UIBuildProgressMonitor.this.monitor != null && isLocalBuild) {
                        UIBuildProgressMonitor.this.monitor.setTaskName(NLS.bind((String)UIMessages.CompilerMonitor_building_Project, (Object)UIBuildProgressMonitor.this.project.getName()));
                    }
                }
            });
        }
    }

    public void prepare(IProgressMonitor eclipseMonitor) {
        this.buildWasCancelled = false;
        this.linked = false;
        IResource[] res = null;
        try {
            res = this.project.members();
        }
        catch (CoreException coreException) {
            UIFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(coreException, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
        }
        int i = 0;
        while (!this.linked && i < res.length) {
            if (res[i].getType() == 2) {
                this.linked = res[i].isLinked();
                if (this.linked) break;
            }
            ++i;
        }
        this.monitor = eclipseMonitor;
        if (this.monitor != null) {
            this.monitor.beginTask(UIMessages.ajCompilation, 100);
        }
        AJLog.logStart((String)"Time to first compiled message");
        AJLog.logStart((String)"Time to first woven message");
        this.reportedCompiledMessages = false;
        this.reportedWovenMessages = false;
    }

    public boolean buildWasCancelled() {
        return this.buildWasCancelled;
    }
}

